/*
 * Decompiled with CFR 0.152.
 */
package websocket;

import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.json.JSONArray;
import org.json.JSONObject;
import print.PrintPreview;
import print.WorkSheetView;
import util.FF;
import util.HardInfo;
import util.Tools;

public class Server
extends WebSocketServer {
    public static JSONArray emptyJSONArray = new JSONArray();
    public static Hashtable<String, PrintPreview> printPreviewTaskList = new Hashtable();

    public Server(int port) throws UnknownHostException {
        super(new InetSocketAddress(port));
    }

    public Server(InetSocketAddress address) {
        super(address);
    }

    @Override
    public void onOpen(WebSocket conn, ClientHandshake handshake) {
        System.out.println(conn.getRemoteSocketAddress().getAddress().getHostAddress() + " entered the room!");
    }

    @Override
    public void onClose(WebSocket conn, int code, String reason, boolean remote) {
        System.out.println(conn + " has left the room!");
    }

    @Override
    public void onMessage(WebSocket conn, String message) {
        JSONObject cmd = new JSONObject(message);
        String action = cmd.getString("action", "");
        FF.log("\u6536\u5230\u6d88\u606f\uff1a" + action);
        if (action.equals("getPrintServiceNameList")) {
            Server.getPrintServiceNameList(conn);
        }
        if (action.equals("getClientCode")) {
            Server.getClientCode(conn);
        }
        if (action.equals("preview")) {
            Server.printPreview(conn, cmd, true);
        }
        if (action.equals("print")) {
            Server.printPreview(conn, cmd, false);
        }
        if (action.equals("onePage")) {
            Server.setOnePageCommand(conn, cmd, cmd.getJSONArray("pageCommand", emptyJSONArray).toString());
        }
    }

    @Override
    public void onMessage(WebSocket conn, ByteBuffer message) {
        this.broadcast(message.array());
        System.out.println(conn + ": " + message);
    }

    public static void getPrintServiceNameList(WebSocket conn) {
        JSONArray serviceList = new JSONArray();
        PrinterJob pj = PrinterJob.getPrinterJob();
        PrintService[] services = PrinterJob.lookupPrintServices();
        for (int i = 0; i < services.length; ++i) {
            String s = services[i].getName();
            serviceList.put(s);
        }
        JSONObject ret = new JSONObject();
        ret.put("action", "getPrintServiceNameList");
        ret.put("data", serviceList);
        conn.send(ret.toString());
    }

    public static void getClientCode(WebSocket conn) {
        String macAddress = HardInfo.getMACAddress();
        String t = FF.MD5(macAddress);
        t = FF.EncryptString(t);
        JSONObject ret = new JSONObject();
        ret.put("action", "getClientCode");
        ret.put("data", t);
        conn.send(ret.toString());
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        String in;
        int port = 7999;
        try {
            port = Integer.parseInt(args[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Server s = new Server(port);
        s.start();
        System.out.println("Server started on port: " + s.getPort());
        BufferedReader sysin = new BufferedReader(new InputStreamReader(System.in));
        do {
            in = sysin.readLine();
            s.broadcast(in);
        } while (!in.equals("exit"));
        s.stop(1000);
    }

    @Override
    public void onError(WebSocket conn, Exception ex) {
        ex.printStackTrace();
        if (conn != null) {
            // empty if block
        }
    }

    @Override
    public void onStart() {
        System.out.println("Server started!");
        this.setConnectionLostTimeout(0);
        this.setConnectionLostTimeout(100);
    }

    public static void setOnePageCommand(WebSocket conn, JSONObject onePage, String cmds) {
        String id = onePage.getString("id", "");
        int pageIndex = onePage.getInt("pageIndex", 0);
        PrintPreview pp = printPreviewTaskList.get(id);
        if (pp == null) {
            return;
        }
        pp.View.setPageCommandSource(pageIndex, cmds);
        pp.printPreviewPane.getPageComponent(pageIndex).repaint();
        if (pageIndex == pp.View.getPageCount() - 1) {
            conn.send(new JSONObject().put("action", "printover").toString());
        }
    }

    public static boolean printPreview(WebSocket conn, JSONObject param, boolean needPreview) {
        JSONObject paper = param.getJSONObject("pageConfig", new JSONObject());
        String id = param.getString("id", "");
        JSONObject printOption = param.getJSONObject("printOption", new JSONObject());
        int pageCount = param.getInt("pageCount", 0);
        String printServiceName = printOption.getString("deviceName", "");
        PrintService[] services = PrinterJob.lookupPrintServices();
        if (services.length == 0) {
            Tools.ShowInfo(null, "\u8bf7\u5b89\u88c5\u6253\u5370\u673a\uff08\u5982\u679c\u4ec5\u505a\u9884\u89c8\uff0c\u90a3\u4e48\u8bf7\u968f\u610f\u5b89\u88c5\u4e00\u4e2a\u6253\u5370\u673a\u9a71\u52a8\u7a0b\u5e8f\uff09");
            return false;
        }
        PrintService service = Tools.findPrintService(services, printServiceName);
        PrintPreview pp = new PrintPreview(new WorkSheetView(id, pageCount), needPreview, conn);
        printPreviewTaskList.put(id, pp);
        PrinterJob pj = PrinterJob.getPrinterJob();
        PageFormat page = Tools.createPageFormat(pj, paper);
        String sheetName = printOption.getString("sheetName", "");
        HashPrintRequestAttributeSet config = Tools.createHashPrintRequestAttributeSet(printOption, sheetName, pageCount);
        pj.setPrintable(pp, page);
        pp.setPrintParameter(service, page, config);
        try {
            pj.setPrintService(service);
            pp.run(page);
        }
        catch (Exception pe) {
            pe.printStackTrace();
        }
        return true;
    }
}

