/*
 * Decompiled with CFR 0.152.
 */
package print;

import gdi.CMD;
import gdi.GraphicsLogic;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import main.MainForm;
import org.ehcache.Cache;
import org.json.JSONArray;
import util.FF;
import util.Tools;
import websocket.Server;

public class WorkSheetView
extends GraphicsLogic {
    boolean useFileCache = false;
    Vector<String> pages = new Vector();
    int pageCount;
    volatile boolean allPageOK = false;
    String tempPath;
    String ID;

    public WorkSheetView(String id, int pageCount_) {
        this.pageCount = pageCount_;
        for (int i = 0; i < this.pageCount; ++i) {
            this.pages.add("");
        }
        this.ID = id;
        this.tempPath = MainForm.homePath + "/printCache/" + this.ID;
        FF.log("\u4e34\u65f6\u76ee\u5f55 " + this.tempPath);
        FF.MkDirs(this.tempPath);
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCommandSource(int pageIndex, String source) {
        String pageID = "" + pageIndex;
        if (this.useFileCache) {
            FF.log("\u6536\u5230\u7b2c" + pageIndex + "\u9875\u6570\u636e,\u5927\u5c0f\u4e3a\uff1a" + source.length());
            FF.SaveToFile(this.tempPath + "/" + pageID + ".json", source, false);
        } else {
            MainForm.cache.put((Object)(this.ID + "." + pageID), (Object)source);
        }
        this.pages.set(pageIndex, pageID);
        if (pageIndex == this.getPageCount() - 1) {
            this.allPageOK = true;
        }
    }

    public String getPageCommandSource(String pageID) {
        if (this.useFileCache) {
            return FF.ReadFile(this.tempPath + "/" + pageID + ".json");
        }
        return (String)MainForm.cache.get((Object)(this.ID + "." + pageID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Server.printPreviewTaskList.remove(this.ID);
        if (this.useFileCache) {
            FF.DelTree(this.tempPath);
            return;
        }
        try {
            Cache<String, String> cache = MainForm.cache;
            Iterator it = cache.iterator();
            ArrayList<String> keys = new ArrayList<String>();
            while (it.hasNext()) {
                String key = (String)((Cache.Entry)it.next()).getKey();
                if (!key.startsWith(this.ID)) continue;
                keys.add(key);
            }
            int n = keys.size();
            for (int i = 0; i < n; ++i) {
                MainForm.cache.remove(keys.get(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onPrint(boolean isPreview, Graphics2D g, int pageIndex) {
        String pageID = this.pages.get(pageIndex);
        if (isPreview) {
            if (pageID.equals("")) {
                Tools.DrawString(g, new Rectangle(50, 100, 300, 40), "\u51c6\u5907\u4e2d..", 0, null, Color.black, "\u5b8b\u4f53", 20, false, false, false, 1, 0, false);
                return;
            }
        } else {
            while (pageID.equals("")) {
                FF.sleep(100);
                pageID = this.pages.get(pageIndex);
            }
        }
        String source = this.getPageCommandSource(pageID);
        JSONArray onePage = new JSONArray(source);
        HashMap<Integer, Integer> cmdCount = new HashMap<Integer, Integer>();
        for (int ci = 0; ci < onePage.length(); ++ci) {
            JSONArray cmd = onePage.getJSONArray(ci);
            int command = cmd.getInt(0);
            if (cmdCount.containsKey(command)) {
                cmdCount.put(command, (Integer)cmdCount.get(command) + 1);
            } else {
                cmdCount.put(command, 1);
            }
            if (command == CMD.translate) {
                this.translate(g, cmd);
                continue;
            }
            if (command == CMD.scale) {
                this.scale(g, cmd);
                continue;
            }
            if (command == CMD.setStrokeColor) {
                this.setStrokeColor(g, cmd);
                continue;
            }
            if (command == CMD.setFillColor) {
                this.setFillColor(g, cmd);
                continue;
            }
            if (command == CMD.setColor) {
                this.setColor(g, cmd);
                continue;
            }
            if (command == CMD.stroke) {
                this.stroke(g, cmd);
                continue;
            }
            if (command == CMD.setClip) {
                this.setClip(g, cmd);
                continue;
            }
            if (command == CMD.moveTo) {
                this.moveTo(g, cmd);
                continue;
            }
            if (command == CMD.lineTo) {
                this.lineTo(g, cmd);
                continue;
            }
            if (command == CMD.drawImage) {
                this.drawImage(g, cmd);
                continue;
            }
            if (command == CMD.drawStringSingleRow) {
                this.drawStringSingleRow(g, cmd);
                continue;
            }
            if (command == CMD.drawStringWordwrap) {
                this.drawStringWordwrap(g, cmd);
                continue;
            }
            if (command == CMD.drawRect) {
                this.drawRect(g, cmd);
                continue;
            }
            if (command == CMD.fillRect) {
                this.fillRect(g, cmd);
                continue;
            }
            if (command == CMD.clearRect) {
                this.clearRect(g, cmd);
                continue;
            }
            if (command == CMD.setLineWidth) {
                this.setLineWidth(g, cmd);
                continue;
            }
            if (command == CMD.setLineDash) {
                this.setLineDash(g, cmd);
                continue;
            }
            if (command == CMD.contextRestore) {
                this.contextRestore(g, cmd);
                continue;
            }
            if (command != CMD.contextSave) continue;
            this.contextSave(g, cmd);
        }
        Iterator it = cmdCount.keySet().iterator();
        while (it.hasNext()) {
            int cmd = (Integer)it.next();
            System.out.println("CMD:" + cmd + "  COUNT: " + cmdCount.get(cmd));
        }
    }
}

