/*
 * Decompiled with CFR 0.152.
 */
package print;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import javax.print.PrintService;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.json.JSONObject;
import util.Tools;

public class PrintSetupDialog
extends JDialog {
    public static String ISO_A4 = "A4     210*297\u6beb\u7c73";
    public static String USER_CUSTOM_SIZE = "\u81ea\u5b9a\u4e49\u5927\u5c0f";
    public static String PORTRAIT = "\u6a2a\u5411";
    public static String LANDSCAPE = "\u7eb5\u5411";
    PrintService[] services = null;
    private JLabel st1;
    private JComboBox cbo_service;
    private JCheckBox jcb_preview;
    private JLabel jLabel20;
    private JLabel jLabel17;
    private JLabel jLabel16;
    private JTextField sle_copy;
    private JLabel jLabel15;
    private JRadioButton rb_h;
    private JTabbedPane jTabbedPane1;
    private JPanel jPanel2;
    private JPanel jPanel1;
    private ButtonGroup buttonGroup1;
    private JButton cb_cancel;
    private JButton cb_ok;
    private JLabel jLabel19;
    private JTextField sle_end;
    private JLabel jLabel18;
    private JTextField sle_start;
    private JRadioButton rb_range;
    private JRadioButton rb_all;
    private JRadioButton rb_v;
    private JLabel jLabel14;
    private JLabel jLabel13;
    private JTextField sle_top;
    private JLabel jLabel12;
    private JLabel jLabel11;
    private JTextField sle_bottom;
    private JLabel jLabel10;
    private JTextField sle_left;
    private JLabel jLabel9;
    private JLabel jLabel8;
    private JTextField sle_right;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel jLabel6;
    private JLabel jLabel4;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JTextField sle_height;
    private JTextField sle_width;
    private JLabel st2;
    private JComboBox cbo_paper;
    private JLabel jLabel1;
    private ComboBoxModel cbo_serviceModel;
    private boolean isOnOK = false;
    private JSONObject currentPrintSetting = new JSONObject();

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            Tools.initAllFontSon9();
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Frame frame = new Frame();
                PrintSetupDialog inst = new PrintSetupDialog(frame, "", null, "");
                inst.showDialog();
            }
        });
    }

    public PrintSetupDialog(Frame frame, String serviceName, PrintService[] services, String pageSetup) {
        super(frame, true);
        this.services = services;
        this.initGUI();
        this.loadSetup(serviceName, pageSetup);
    }

    public boolean showDialog() {
        Tools.MoveToScreenCenter(this);
        this.setVisible(true);
        return this.isOnOK;
    }

    public JSONObject getPrintConfig() {
        return this.currentPrintSetting;
    }

    private void initGUI() {
        try {
            this.getContentPane().setLayout(null);
            this.setTitle("\u9875\u9762\u53ca\u6253\u5370\u8bbe\u7f6e");
            this.setResizable(false);
            this.setModal(true);
            this.cb_ok = new JButton();
            this.getContentPane().add(this.cb_ok);
            this.cb_ok.setText("\u786e\u5b9a");
            this.cb_ok.setBounds(278, 256, 142, 29);
            this.cb_ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PrintSetupDialog.this.cb_okActionPerformed(evt);
                }
            });
            this.cb_cancel = new JButton();
            this.getContentPane().add(this.cb_cancel);
            this.getContentPane().add(this.getJTabbedPane1());
            this.cb_cancel.setText("\u53d6\u6d88");
            this.cb_cancel.setBounds(438, 256, 71, 29);
            this.cb_cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PrintSetupDialog.this.cb_cancelActionPerformed(evt);
                }
            });
            this.setSize(530, 343);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.setBounds(10, 130, 557, 194);
            this.jPanel1.setLayout(null);
            this.jPanel1.setPreferredSize(new Dimension(437, 290));
            this.jLabel1 = new JLabel();
            this.jPanel1.add(this.jLabel1);
            this.jLabel1.setText("\u7eb8\u5f20\u5927\u5c0f\uff1a");
            this.jLabel1.setBounds(11, 29, 62, 21);
            DefaultComboBoxModel<String> jComboBox1Model = new DefaultComboBoxModel<String>(new String[]{ISO_A4, USER_CUSTOM_SIZE});
            this.cbo_paper = new JComboBox();
            this.jPanel1.add(this.cbo_paper);
            this.cbo_paper.setModel(jComboBox1Model);
            this.cbo_paper.setBounds(77, 28, 345, 23);
            this.cbo_paper.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PrintSetupDialog.this.cbo_paperActionPerformed(evt);
                }
            });
            this.st2 = new JLabel();
            this.jPanel1.add(this.st2);
            this.st2.setText("\u5bbd  \u5ea6\uff1a");
            this.st2.setBounds(75, 62, 53, 17);
            this.sle_width = new JTextField();
            this.jPanel1.add(this.sle_width);
            this.sle_width.setBounds(131, 61, 59, 20);
            this.jLabel3 = new JLabel();
            this.jPanel1.add(this.jLabel3);
            this.jLabel3.setText("\u6beb\u7c73");
            this.jLabel3.setBounds(197, 62, 41, 17);
            this.jLabel2 = new JLabel();
            this.jPanel1.add(this.jLabel2);
            this.jLabel2.setText("\u9ad8  \u5ea6\uff1a");
            this.jLabel2.setBounds(276, 62, 49, 17);
            this.sle_height = new JTextField();
            this.jPanel1.add(this.sle_height);
            this.sle_height.setBounds(325, 61, 59, 20);
            this.jLabel4 = new JLabel();
            this.jPanel1.add(this.jLabel4);
            this.jLabel4.setText("\u6beb\u7c73");
            this.jLabel4.setBounds(396, 62, 41, 17);
            this.rb_h = new JRadioButton();
            this.jPanel1.add(this.rb_h);
            this.rb_h.setText("\u6a2a\u5411");
            this.rb_h.setBounds(126, 173, 69, 21);
            this.rb_h.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PrintSetupDialog.this.rb_v.setSelected(false);
                }
            });
            this.rb_v = new JRadioButton();
            this.jPanel1.add(this.rb_v);
            this.rb_v.setText("\u7eb5\u5411");
            this.rb_v.setBounds(71, 173, 53, 21);
            this.rb_v.setSelected(true);
            this.rb_v.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PrintSetupDialog.this.rb_h.setSelected(false);
                }
            });
            this.jLabel14 = new JLabel();
            this.jPanel1.add(this.jLabel14);
            this.jLabel14.setText("\u6253\u5370\u65b9\u5411\uff1a");
            this.jLabel14.setBounds(10, 173, 63, 21);
            this.jLabel13 = new JLabel();
            this.jPanel1.add(this.jLabel13);
            this.jLabel13.setText("\u4e0a\u8fb9\u8ddd\uff1a");
            this.jLabel13.setBounds(75, 132, 53, 21);
            this.sle_top = new JTextField();
            this.jPanel1.add(this.sle_top);
            this.sle_top.setBounds(130, 133, 59, 20);
            this.jLabel12 = new JLabel();
            this.jPanel1.add(this.jLabel12);
            this.jLabel12.setText("\u6beb\u7c73");
            this.jLabel12.setBounds(197, 134, 41, 17);
            this.jLabel11 = new JLabel();
            this.jPanel1.add(this.jLabel11);
            this.jLabel11.setText("\u4e0b\u8fb9\u8ddd\uff1a");
            this.jLabel11.setBounds(276, 134, 49, 17);
            this.sle_bottom = new JTextField();
            this.jPanel1.add(this.sle_bottom);
            this.sle_bottom.setBounds(325, 133, 59, 20);
            this.jLabel10 = new JLabel();
            this.jPanel1.add(this.jLabel10);
            this.jLabel10.setText("\u6beb\u7c73");
            this.jLabel10.setBounds(396, 134, 41, 17);
            this.sle_left = new JTextField();
            this.jPanel1.add(this.sle_left);
            this.sle_left.setBounds(130, 106, 59, 20);
            this.jLabel9 = new JLabel();
            this.jPanel1.add(this.jLabel9);
            this.jLabel9.setText("\u6beb\u7c73");
            this.jLabel9.setBounds(197, 107, 41, 17);
            this.jLabel8 = new JLabel();
            this.jPanel1.add(this.jLabel8);
            this.jLabel8.setText("\u53f3\u8fb9\u8ddd\uff1a");
            this.jLabel8.setBounds(276, 107, 49, 17);
            this.sle_right = new JTextField();
            this.jPanel1.add(this.sle_right);
            this.sle_right.setBounds(325, 106, 59, 20);
            this.jLabel7 = new JLabel();
            this.jPanel1.add(this.jLabel7);
            this.jLabel7.setText("\u6beb\u7c73");
            this.jLabel7.setBounds(396, 107, 41, 17);
            this.jLabel6 = new JLabel();
            this.jPanel1.add(this.jLabel6);
            this.jLabel6.setText("\u5de6\u8fb9\u8ddd\uff1a");
            this.jLabel6.setBounds(75, 105, 53, 21);
            this.jLabel5 = new JLabel();
            this.jPanel1.add(this.jLabel5);
            this.jLabel5.setText("\u8bbe\u7f6e\u8fb9\u8ddd\uff1a");
            this.jLabel5.setBounds(10, 105, 65, 21);
        }
        return this.jPanel1;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jPanel2 = new JPanel();
            this.jPanel2.setBounds(10, 5, 597, 119);
            this.jPanel2.setLayout(null);
            this.jPanel2.setPreferredSize(new Dimension(500, 196));
            this.jLabel19 = new JLabel();
            this.jPanel2.add(this.jLabel19);
            this.jLabel19.setText("\u9875");
            this.jLabel19.setBounds(295, 139, 40, 21);
            this.sle_end = new JTextField();
            this.jPanel2.add(this.sle_end);
            this.sle_end.setBounds(247, 140, 38, 20);
            this.jLabel18 = new JLabel();
            this.jPanel2.add(this.jLabel18);
            this.jLabel18.setText("\u9875\u5230\u7b2c");
            this.jLabel18.setBounds(204, 140, 40, 21);
            this.sle_start = new JTextField();
            this.jPanel2.add(this.sle_start);
            this.sle_start.setBounds(160, 140, 38, 20);
            this.rb_range = new JRadioButton();
            this.jPanel2.add(this.rb_range);
            this.rb_range.setText("\u4ec5\u6253\u5370\u7b2c");
            this.rb_range.setBounds(82, 139, 77, 21);
            this.rb_range.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PrintSetupDialog.this.rb_range_onclick();
                }
            });
            this.rb_all = new JRadioButton();
            this.jPanel2.add(this.rb_all);
            this.rb_all.setText("\u5168\u90e8");
            this.rb_all.setBounds(82, 112, 63, 21);
            this.rb_all.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PrintSetupDialog.this.rb_all_onclick();
                }
            });
            this.rb_all.setSelected(true);
            this.jLabel17 = new JLabel();
            this.jPanel2.add(this.jLabel17);
            this.jLabel17.setText("\u6253\u5370\u8303\u56f4\uff1a");
            this.jLabel17.setBounds(10, 112, 69, 21);
            this.jLabel16 = new JLabel();
            this.jPanel2.add(this.jLabel16);
            this.jLabel16.setText("\u4efd");
            this.jLabel16.setBounds(131, 73, 41, 17);
            this.sle_copy = new JTextField();
            this.jPanel2.add(this.sle_copy);
            this.sle_copy.setBounds(85, 71, 42, 20);
            this.jLabel15 = new JLabel();
            this.jPanel2.add(this.jLabel15);
            this.jLabel15.setText("\u6253\u5370\u4efd\u6570\uff1a");
            this.jLabel15.setBounds(10, 71, 69, 21);
            this.cbo_serviceModel = this.getServiceMode();
            this.cbo_service = new JComboBox();
            this.jPanel2.add(this.cbo_service);
            this.cbo_service.setModel(this.cbo_serviceModel);
            this.cbo_service.setBounds(84, 27, 396, 23);
            this.st1 = new JLabel();
            this.jPanel2.add(this.st1);
            this.jPanel2.add(this.getJLabel20());
            this.jPanel2.add(this.getJcb_preview());
            this.st1.setText("\u6253 \u5370 \u673a\uff1a");
            this.st1.setBounds(12, 28, 69, 21);
        }
        return this.jPanel2;
    }

    private JTabbedPane getJTabbedPane1() {
        if (this.jTabbedPane1 == null) {
            this.jTabbedPane1 = new JTabbedPane();
            this.jTabbedPane1.setBounds(10, 5, 499, 245);
            this.jTabbedPane1.addTab("\u6253\u5370\u8bbe\u7f6e", null, this.getJPanel2(), null);
            this.jTabbedPane1.addTab("\u9875\u9762\u8bbe\u7f6e", null, this.getJPanel1(), null);
        }
        return this.jTabbedPane1;
    }

    public DefaultComboBoxModel getServiceMode() {
        ArrayList<String> service = new ArrayList<String>();
        PrinterJob pj = PrinterJob.getPrinterJob();
        if (this.services == null) {
            this.services = PrinterJob.lookupPrintServices();
        }
        for (int i = 0; i < this.services.length; ++i) {
            String s = this.services[i].getName();
            service.add(s);
        }
        return new DefaultComboBoxModel<Object>(service.toArray());
    }

    public void loadSetup(String serviceName, String pageSetup) {
        this.cbo_serviceModel.setSelectedItem(serviceName);
        this.sle_copy.setText("1");
        this.sle_start.setText("1");
        this.sle_end.setText("9999");
        this.rb_all.setSelected(true);
        this.rb_all_onclick();
        JSONObject js = new JSONObject(pageSetup);
        this.cbo_paper.setSelectedItem(js.getString("paper", ISO_A4));
        this.cbo_paperActionPerformed(null);
        if (((String)this.cbo_paper.getSelectedItem()).equals(USER_CUSTOM_SIZE)) {
            this.sle_width.setText("" + js.getInt("width", 210));
            this.sle_height.setText("" + js.getInt("height", 210));
        }
        this.sle_left.setText("" + js.getDouble("left", 25.4));
        this.sle_right.setText("" + js.getDouble("right", 25.4));
        this.sle_top.setText("" + js.getDouble("top", 25.4));
        this.sle_bottom.setText("" + js.getDouble("bottom", 25.4));
        this.rb_v.setSelected(js.getString("orientation", LANDSCAPE).equals(LANDSCAPE));
        this.rb_h.setSelected(!this.rb_v.isSelected());
        this.getJcb_preview().setSelected(js.getInt("needpreview", 0) == 1);
    }

    private void rb_range_onclick() {
        this.sle_start.setEnabled(true);
        this.sle_end.setEnabled(true);
        this.rb_all.setSelected(false);
    }

    private void rb_all_onclick() {
        this.sle_start.setEnabled(false);
        this.sle_end.setEnabled(false);
        this.rb_range.setSelected(false);
    }

    private String getNumber(String s, String tip) throws Exception {
        try {
            Double d = new Double(s);
        }
        catch (Exception e) {
            throw new Exception(tip);
        }
        return s;
    }

    private String getInteger(String s, String tip) throws Exception {
        try {
            Integer n = new Integer(s);
        }
        catch (Exception e) {
            throw new Exception(tip);
        }
        return s;
    }

    private void cb_cancelActionPerformed(ActionEvent evt) {
        this.currentPrintSetting = new JSONObject();
        this.isOnOK = false;
        this.dispose();
    }

    private void cb_okActionPerformed(ActionEvent evt) {
        try {
            this.currentPrintSetting = new JSONObject();
            this.currentPrintSetting.put("service", this.cbo_service.getSelectedItem().toString());
            this.currentPrintSetting.put("copy", this.getInteger(this.sle_copy.getText(), "\u6253\u5370\u4efd\u6570"));
            this.currentPrintSetting.put("range", this.rb_all.isSelected() ? "all" : "selected");
            this.currentPrintSetting.put("start", this.getInteger(this.sle_start.getText(), "\u5f00\u59cb\u9875\u7801"));
            this.currentPrintSetting.put("end", this.getInteger(this.sle_end.getText(), "\u7ed3\u675f\u9875\u7801"));
            this.currentPrintSetting.put("paper", this.cbo_paper.getSelectedItem().toString());
            this.currentPrintSetting.put("width", this.getNumber(this.sle_width.getText(), "\u7eb8\u5f20\u5bbd\u5ea6"));
            this.currentPrintSetting.put("height", this.getNumber(this.sle_height.getText(), "\u7eb8\u5f20\u9ad8\u5ea6"));
            this.currentPrintSetting.put("left", this.getNumber(this.sle_left.getText(), "\u5de6\u8fb9\u8ddd"));
            this.currentPrintSetting.put("right", this.getNumber(this.sle_right.getText(), "\u53f3\u8fb9\u8ddd"));
            this.currentPrintSetting.put("top", this.getNumber(this.sle_top.getText(), "\u4e0a\u8fb9\u8ddd"));
            this.currentPrintSetting.put("bottom", this.getNumber(this.sle_bottom.getText(), "\u4e0b\u8fb9\u8ddd"));
            this.currentPrintSetting.put("orientation", this.rb_v.isSelected() ? LANDSCAPE : PORTRAIT);
            this.currentPrintSetting.put("needpreview", this.getJcb_preview().isSelected() ? "1" : "0");
            this.isOnOK = true;
            this.dispose();
        }
        catch (Exception e) {
            Tools.ShowInfo(this, e.getMessage() + "\u4e0d\u662f\u5408\u6cd5\u7684\u6570\u5b57");
            return;
        }
    }

    private void cbo_paperActionPerformed(ActionEvent evt) {
        String paper = (String)this.cbo_paper.getSelectedItem();
        if (paper.equals(ISO_A4)) {
            this.sle_width.setText("210");
            this.sle_height.setText("297");
            this.sle_width.setEnabled(false);
            this.sle_height.setEnabled(false);
        }
        if (paper.equals(USER_CUSTOM_SIZE)) {
            this.sle_width.setEnabled(true);
            this.sle_height.setEnabled(true);
        }
    }

    private JLabel getJLabel20() {
        if (this.jLabel20 == null) {
            this.jLabel20 = new JLabel();
            this.jLabel20.setText("\u6253\u5370\u9884\u89c8\uff1a");
            this.jLabel20.setBounds(10, 160, 60, 40);
        }
        return this.jLabel20;
    }

    private JCheckBox getJcb_preview() {
        if (this.jcb_preview == null) {
            this.jcb_preview = new JCheckBox();
            this.jcb_preview.setText("\u6253\u5370\u524d\u5148\u9884\u89c8");
            this.jcb_preview.setBounds(82, 169, 97, 23);
        }
        return this.jcb_preview;
    }
}

