/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.ComponentOrientation;
import java.text.Collator;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Locale;
import javax.swing.UIManager;
import sos.preview.FitLayout;
import sos.preview.JPrintPreviewPaneUtilities;

public class FitLayoutFormat
extends Format {
    private Collator collator;
    private Locale locale;

    public FitLayoutFormat() {
        this(Locale.getDefault());
    }

    public FitLayoutFormat(Locale locale1) {
        this.locale = locale1;
        this.collator = Collator.getInstance(locale1);
        this.collator.setStrength(1);
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer stringbuffer, FieldPosition fieldposition) {
        if (!(obj instanceof FitLayout)) {
            throw new IllegalArgumentException("Cannot format object.");
        }
        FitLayout fitlayout = (FitLayout)obj;
        int i = fitlayout.getAxis();
        ComponentOrientation componentorientation = ComponentOrientation.getOrientation(this.locale);
        boolean flag = i == 0 || i == 3 && !componentorientation.isHorizontal() || i == 2 && componentorientation.isHorizontal();
        String s = flag ? UIManager.getString("fit_width_layout_name") : UIManager.getString("fit_height_layout_name");
        stringbuffer.append(s);
        return stringbuffer;
    }

    public static FitLayoutFormat getInstance() {
        return new FitLayoutFormat();
    }

    public static FitLayoutFormat getInstance(Locale locale1) {
        return new FitLayoutFormat(locale1);
    }

    @Override
    public Object parseObject(String s, ParsePosition parseposition) {
        String s1 = UIManager.getString("fit_width_layout_name");
        String s2 = UIManager.getString("fit_height_layout_name");
        if (s1 != null && this.collator.compare(s1, s) == 0) {
            parseposition.setIndex(s.length());
            return this.createLayout(0);
        }
        if (s2 != null && this.collator.compare(s2, s) == 0) {
            parseposition.setIndex(s.length());
            return this.createLayout(1);
        }
        return null;
    }

    private FitLayout createLayout(int i) {
        int j = UIManager.getInt(JPrintPreviewPaneUtilities.HORIZONTAL_ALIGNMENT);
        int k = UIManager.getInt(JPrintPreviewPaneUtilities.VERTICAL_ALIGNMENT);
        int l = UIManager.getInt(JPrintPreviewPaneUtilities.HORIZONTAL_SPACING);
        int i1 = UIManager.getInt(JPrintPreviewPaneUtilities.VERTICAL_SPACING);
        int j1 = UIManager.getInt(JPrintPreviewPaneUtilities.LEFT_MARGIN);
        int k1 = UIManager.getInt(JPrintPreviewPaneUtilities.RIGHT_MARGIN);
        int l1 = UIManager.getInt(JPrintPreviewPaneUtilities.TOP_MARGIN);
        int i2 = UIManager.getInt(JPrintPreviewPaneUtilities.BOTTOM_MARGIN);
        ComponentOrientation componentorientation = ComponentOrientation.getOrientation(this.locale);
        int j2 = componentorientation.isHorizontal() ? i1 : l;
        return new FitLayout(i, j, k, j2, j1, k1, l1, i2);
    }
}

