/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import javax.swing.UIManager;
import sos.preview.JPrintPreviewPaneUtilities;
import sos.preview.ZoomLayout;

public class ZoomLayoutFormat
extends Format {
    private NumberFormat format;

    public ZoomLayoutFormat() {
        this(NumberFormat.getPercentInstance());
    }

    public ZoomLayoutFormat(NumberFormat numberformat) {
        this.format = numberformat;
    }

    public ZoomLayoutFormat(Locale locale) {
        this(NumberFormat.getPercentInstance(locale));
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer stringbuffer, FieldPosition fieldposition) {
        if (!(obj instanceof ZoomLayout)) {
            throw new IllegalArgumentException("Cannot format object.");
        }
        ZoomLayout zoomlayout = (ZoomLayout)obj;
        double d = zoomlayout.getScale();
        stringbuffer.append(this.format.format(d));
        return stringbuffer;
    }

    public static Locale[] getAvailableLocales() {
        return NumberFormat.getAvailableLocales();
    }

    public static ZoomLayoutFormat getInstance() {
        return new ZoomLayoutFormat();
    }

    public static ZoomLayoutFormat getInstance(Locale locale) {
        return new ZoomLayoutFormat(NumberFormat.getPercentInstance(locale));
    }

    @Override
    public Object parseObject(String s, ParsePosition parseposition) {
        try {
            Number number = this.format.parse(s);
            double d = number.doubleValue();
            int i = UIManager.getInt(JPrintPreviewPaneUtilities.HORIZONTAL_ALIGNMENT);
            int j = UIManager.getInt(JPrintPreviewPaneUtilities.VERTICAL_ALIGNMENT);
            int k = UIManager.getInt(JPrintPreviewPaneUtilities.HORIZONTAL_SPACING);
            int l = UIManager.getInt(JPrintPreviewPaneUtilities.VERTICAL_SPACING);
            int i1 = UIManager.getInt(JPrintPreviewPaneUtilities.LEFT_MARGIN);
            int j1 = UIManager.getInt(JPrintPreviewPaneUtilities.RIGHT_MARGIN);
            int k1 = UIManager.getInt(JPrintPreviewPaneUtilities.TOP_MARGIN);
            int l1 = UIManager.getInt(JPrintPreviewPaneUtilities.BOTTOM_MARGIN);
            parseposition.setIndex(s.length());
            return new ZoomLayout(d, i, j, k, l, i1, j1, k1, l1);
        }
        catch (ParseException parseexception) {
            return null;
        }
    }
}

