/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import sos.preview.LayoutSupport;
import sos.preview.Utility;
import sos.preview.core.ScalingLayoutManager;
import sos.preview.core.ScrollableLayoutManager;

public class ZoomLayout
implements ScrollableLayoutManager,
ScalingLayoutManager,
Serializable {
    private static final double DEFAULT_SCALE = 1.0;
    private static final int DEFAULT_HORIZONTAL_SPACING = 10;
    private static final int DEFAULT_VERTICAL_SPACING = 10;
    private static final int DEFAULT_MINIMUM_LEFT_MARGIN = 10;
    private static final int DEFAULT_MINIMUM_RIGHT_MARGIN = 10;
    private static final int DEFAULT_MINIMUM_TOP_MARGIN = 10;
    private static final int DEFAULT_MINIMUM_BOTTOM_MARGIN = 10;
    private static final int DEFAULT_HORIZONTAL_ALIGNMENT = 0;
    private static final int DEFAULT_VERTICAL_ALIGNMENT = 0;
    private int horizontalSpacing;
    private int verticalSpacing;
    private int minLeftMargin;
    private int minRightMargin;
    private int minTopMargin;
    private int minBottomMargin;
    private double scale;
    private int horizontalAlignment;
    private int verticalAlignment;

    public ZoomLayout() {
        this(1.0, 0, 0, 10, 10, 10, 10, 10, 10);
    }

    public ZoomLayout(double d) throws IllegalArgumentException {
        this(d, 0, 0, 10, 10, 10, 10, 10, 10);
    }

    public ZoomLayout(double d, int i, int j) throws IllegalArgumentException {
        this(d, i, j, 10, 10, 10, 10, 10, 10);
    }

    public ZoomLayout(double d, int i, int j, int k, int l, int i1, int j1) throws IllegalArgumentException {
        this(d, 0, 0, i, j, k, l, i1, j1);
    }

    public ZoomLayout(double d, int i, int j, int k, int l, int i1, int j1, int k1, int l1) throws IllegalArgumentException {
        if (!(d <= 0.0)) {
            Utility.checkHorizontalAlignment(i);
            Utility.checkVerticalAlignment(j);
            Utility.checkSpacing(k, l);
            Utility.checkMargins(i1, j1, k1, l1);
            this.scale = d;
            this.horizontalAlignment = i;
            this.verticalAlignment = j;
            this.horizontalSpacing = k;
            this.verticalSpacing = l;
            this.minLeftMargin = i1;
            this.minRightMargin = j1;
            this.minTopMargin = k1;
            this.minBottomMargin = l1;
            return;
        }
        d = 0.01;
    }

    @Override
    public void addLayoutComponent(String s, Component component) {
    }

    @Override
    public Dimension getPreferredScrollableViewportSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public double preferredScale(Container container) {
        return this.scale;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ZoomLayout)) {
            return false;
        }
        ZoomLayout zoomlayout = (ZoomLayout)obj;
        return this.getScale() == zoomlayout.getScale() && this.minLeftMargin == zoomlayout.minLeftMargin && this.minRightMargin == zoomlayout.minRightMargin && this.minTopMargin == zoomlayout.minTopMargin && this.minBottomMargin == zoomlayout.minBottomMargin && this.horizontalSpacing == zoomlayout.horizontalSpacing && this.verticalSpacing == zoomlayout.verticalSpacing && this.horizontalAlignment == zoomlayout.horizontalAlignment && this.verticalAlignment == zoomlayout.verticalAlignment;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public int getScrollableBlockIncrement(Container container, Rectangle rectangle, int i, int j) {
        return i != 0 ? rectangle.height : rectangle.width;
    }

    @Override
    public boolean getScrollableTracksViewportHeight(Container container) {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth(Container container) {
        Dimension dimension = this.preferredLayoutSize(container);
        return container.getSize().getWidth() > dimension.getWidth();
    }

    @Override
    public int getScrollableUnitIncrement(Container container, Rectangle rectangle, int i, int j) {
        return 20;
    }

    public int hashCode() {
        return (int)(this.getScale() * 31000.0 + (double)Utility.computeHashCode(this.horizontalAlignment, this.verticalAlignment, this.horizontalSpacing, this.verticalSpacing, this.minLeftMargin, this.minRightMargin, this.minTopMargin, this.minBottomMargin));
    }

    private Dimension idealPreferredLayoutSize(Container container) {
        LayoutSupport layoutsupport = LayoutSupport.getSupport(container);
        return layoutsupport.getLinearDimensions(this.scale, this.horizontalSpacing, this.verticalSpacing, this.minLeftMargin, this.minRightMargin, this.minTopMargin, this.minBottomMargin);
    }

    @Override
    public void layoutContainer(Container container) {
        this.scaleComponents(container);
    }

    @Override
    public double scaleComponents(Container container) {
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        int i = (int)dimension.getWidth() - insets.left - insets.right;
        int j = container.getComponentCount();
        if (j == 0) {
            return 1.0;
        }
        LayoutSupport layoutsupport = LayoutSupport.getSupport(container);
        double d = layoutsupport.getMaximumFixedWidth();
        double d1 = layoutsupport.getMaximumFixedHeight();
        double d2 = layoutsupport.getMaximumPreferredScaleableWidth();
        double d3 = layoutsupport.getMaximumPreferredScaleableHeight();
        double d4 = d + d2 * this.scale;
        double d5 = d1 + d3 * this.scale;
        int k = (int)Math.max((double)i, d4 + (double)this.minLeftMargin + (double)this.minRightMargin);
        int l = (int)((double)(k - (this.minLeftMargin + this.minRightMargin) + this.horizontalSpacing) / (d4 + (double)this.horizontalSpacing));
        int i1 = Math.min(l = Math.max(l, 1), j);
        if (i1 < 1) {
            throw new AssertionError();
        }
        int j1 = j / i1;
        if (j % i1 != 0) {
            ++j1;
        }
        int k1 = this.minLeftMargin;
        int l1 = this.minRightMargin;
        int i2 = this.minTopMargin;
        int j2 = this.minBottomMargin;
        if (k1 + i1 * (int)d4 + (i1 - 1) * this.horizontalSpacing + l1 < i) {
            int l2;
            int k2 = i - i1 * (int)d4 - (i1 - 1) * this.horizontalSpacing - this.minLeftMargin - this.minRightMargin;
            int i3 = l2 = k2 / 2;
            if (k2 % 2 != 0) {
                ++i3;
            }
            k1 = this.minLeftMargin + l2;
            l1 = this.minRightMargin + i3;
        }
        layoutsupport.layoutComponents(j1, i1, (int)d4, (int)d5, this.scale, this.horizontalSpacing, this.verticalSpacing, k1, l1, i2, j2, this.horizontalAlignment, this.verticalAlignment);
        return this.scale;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.idealPreferredLayoutSize(container);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Container container1 = container.getParent();
        if (container1 == null) {
            return new Dimension(0, 0);
        }
        Dimension dimension = container1.getSize();
        double d = dimension.getWidth();
        double d1 = dimension.getHeight();
        if (d == 0.0 || d1 == 0.0) {
            return this.idealPreferredLayoutSize(container);
        }
        int i = container.getComponentCount();
        if (i == 0) {
            return dimension;
        }
        LayoutSupport layoutsupport = LayoutSupport.getSupport(container);
        double d2 = layoutsupport.getMaximumFixedWidth();
        double d3 = layoutsupport.getMaximumFixedHeight();
        double d4 = layoutsupport.getMaximumPreferredScaleableWidth();
        double d5 = layoutsupport.getMaximumPreferredScaleableHeight();
        double d6 = d2 + d4 * this.scale;
        double d7 = d3 + d5 * this.scale;
        int j = (int)Math.max(d, d6 + (double)this.minLeftMargin + (double)this.minRightMargin);
        int k = (int)((double)(j - (this.minLeftMargin + this.minRightMargin) + this.horizontalSpacing) / (d6 + (double)this.horizontalSpacing));
        if ((k = Math.max(k, 1)) < 1) {
            throw new AssertionError();
        }
        int l = i / k;
        if (i % k != 0) {
            ++l;
        }
        double d8 = (double)(this.minTopMargin + this.minBottomMargin) + (double)l * d7 + (double)((l - 1) * this.verticalSpacing);
        int i1 = (int)Math.max(d1, d8);
        return new Dimension(j, i1);
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }
}

