/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.PageRanges;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import netscape.javascript.JSObject;
import org.json.JSONObject;

public class Tools {
    static final String IDC_WE = "WE.gif";
    static final String IDC_NS = "NS.gif";
    static final String IDC_ARROW = "DEFAULT";
    static final String IDC_SYS_WE = "SYS_WE";
    static final String IDC_SYS_NS = "SYS_NS";
    static final String IDC_MOVE = "MOVE.gif";
    static final String IDC_EXCHANGE = "EXCHANGE.gif";
    static HashMap m_FontMap = new HashMap();
    static HashMap m_StrokeMap = new HashMap();
    static HashMap m_CursorMap = new HashMap();
    static HashMap m_ImgMap = new HashMap();

    public static void DrawString(Graphics2D g, Rectangle rc, String s, int bkMode, Color bkcolor, Color textcolor, String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline, int hAlign, int vAlign) {
        Tools.DrawString(g, rc, s, bkMode, bkcolor, textcolor, FontName, FontSize, FontBold, FontItalic, FontUnderline, hAlign, vAlign, null);
    }

    public static void drawAsHTML(Graphics2D g, Rectangle rc, String s) {
        if (s.trim().equals("")) {
            return;
        }
        JTextPane textPane = new JTextPane();
        HTMLEditorKit editorKit = new HTMLEditorKit(){

            @Override
            protected HTMLEditorKit.Parser getParser() {
                try {
                    Class<?> c = Class.forName("javax.swing.text.html.parser.ParserDelegator");
                    HTMLEditorKit.Parser defaultParser = (HTMLEditorKit.Parser)c.newInstance();
                    return defaultParser;
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        };
        HTMLDocument document = (HTMLDocument)editorKit.createDefaultDocument();
        textPane = new JTextPane(document);
        textPane.setContentType("text/html");
        textPane.setBounds(rc);
        textPane.setText(s);
        BufferedImage img = new BufferedImage(textPane.getWidth(), textPane.getHeight(), 1);
        Graphics tg = img.getGraphics();
        textPane.paint(tg);
        g.drawImage(img, null, rc.x, rc.y);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        textPane = null;
        document = null;
        editorKit = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DrawString(Graphics2D g, Rectangle rc, String s, int bkMode, Color bkcolor, Color textcolor, String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline, int hAlign, int vAlign, Color highLightColor) {
        g.setColor(bkcolor);
        if (bkMode != 0) {
            g.fillRect(rc.x, rc.y, rc.width, rc.height);
        }
        if (s.length() == 0) {
            return;
        }
        g.setColor(textcolor);
        Shape oc = g.getClip();
        try {
            Tools.clip(g, rc);
            Font font = Tools.GetFont(FontName, FontSize, FontBold, FontItalic, FontUnderline);
            FontRenderContext frc = g.getFontRenderContext();
            TextLayout layout = new TextLayout(s, font, frc);
            float drawPosY = rc.y;
            switch (vAlign) {
                case 1: {
                    drawPosY += (float)rc.height - layout.getDescent() - layout.getLeading();
                    break;
                }
                case 2: {
                    drawPosY += layout.getAscent() + ((float)rc.height - layout.getAscent() - layout.getDescent() - layout.getLeading()) / 2.0f;
                    break;
                }
                default: {
                    drawPosY += layout.getAscent();
                }
            }
            float drawPosX = rc.x;
            switch (hAlign) {
                case 1: {
                    drawPosX = (float)(rc.x + rc.width) - layout.getAdvance();
                    break;
                }
                case 2: {
                    drawPosX = (float)rc.x + ((float)rc.width - layout.getAdvance()) / 2.0f;
                    break;
                }
                default: {
                    drawPosX = rc.x;
                }
            }
            if (highLightColor != null) {
                g.setColor(highLightColor);
                layout.draw(g, drawPosX - 1.0f, drawPosY - 1.0f);
                layout.draw(g, drawPosX + 1.0f, drawPosY - 1.0f);
                layout.draw(g, drawPosX - 1.0f, drawPosY + 1.0f);
                layout.draw(g, drawPosX + 1.0f, drawPosY + 1.0f);
            }
            g.setColor(textcolor);
            layout.draw(g, drawPosX, drawPosY);
        }
        catch (Exception exception) {
        }
        finally {
            Tools.setClip(g, oc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DrawCheckBoxOrRadioButtonString(Component pwnd, Graphics2D g, Rectangle rc, String s, int bkMode, Color bkcolor, Color textcolor, String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline, int hAlign, int vAlign, boolean checkOn, boolean drawFocus, boolean isCheckBox) {
        int checkBoxSize = 18;
        g.setColor(bkcolor);
        if (bkMode != 0) {
            g.fillRect(rc.x, rc.y, rc.width, rc.height);
        }
        if (s.length() == 0) {
            return;
        }
        g.setColor(textcolor);
        Shape oc = g.getClip();
        try {
            Tools.clip(g, rc);
            Font font = Tools.GetFont(FontName, FontSize, FontBold, FontItalic, FontUnderline);
            FontRenderContext frc = g.getFontRenderContext();
            TextLayout layout = new TextLayout(s, font, frc);
            float drawPosY = rc.y;
            switch (vAlign) {
                case 1: {
                    drawPosY += (float)rc.height - layout.getDescent() - layout.getLeading();
                    break;
                }
                case 2: {
                    drawPosY += layout.getAscent() + ((float)rc.height - layout.getAscent() - layout.getDescent() - layout.getLeading()) / 2.0f;
                    break;
                }
                default: {
                    drawPosY += layout.getAscent();
                }
            }
            float drawPosX = rc.x;
            switch (hAlign) {
                case 1: {
                    drawPosX = (float)(rc.x + rc.width) - layout.getAdvance();
                    drawPosX -= (float)checkBoxSize;
                    float checkBoxX = rc.x + rc.width - checkBoxSize;
                    break;
                }
                case 2: {
                    drawPosX = (float)rc.x + ((float)rc.width - layout.getAdvance()) / 2.0f;
                    float checkBoxX = (drawPosX += (float)(checkBoxSize / 2)) - (float)checkBoxSize;
                    break;
                }
                default: {
                    drawPosX = rc.x;
                    drawPosX += (float)checkBoxSize;
                    float checkBoxX = rc.x;
                }
            }
            layout.draw(g, drawPosX, drawPosY);
            float checkBoxY = drawPosY - 10.0f;
            Image img = Tools.getBuffredImageFromURL(pwnd, "excel/edit/res/" + (isCheckBox ? "checkbox" : "radio") + "_" + (checkOn ? "on" : "off") + ".gif");
            g.drawImage(img, (int)(checkBoxX += 2.0f), (int)checkBoxY, pwnd);
            if (drawFocus) {
                Stroke oldStroke = g.getStroke();
                float[] dash = new float[]{1.0f};
                g.setStroke(Tools.getStroke(1.0f, 0, 0, 10.0f, dash, 1.0f));
                g.setColor(new Color(217, 147, 0));
                g.drawRect(rc.x + 1, rc.y + 1, rc.width - 2, rc.height - 2);
                g.setStroke(oldStroke);
            }
        }
        catch (Exception exception) {
        }
        finally {
            Tools.setClip(g, oc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DrawString(Graphics2D g, Rectangle rc, String s, int bkMode, Color bkcolor, Color textcolor, String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline, int hAlign, int vAlign, boolean MultiLine) {
        if (s == null) {
            return;
        }
        if (s.trim().equals("")) {
            return;
        }
        if (rc.width <= 0 || rc.height <= 0) {
            return;
        }
        if (!MultiLine && s.indexOf("\n") < 0 && s.indexOf("\\n") < 0) {
            Tools.DrawString(g, rc, s, bkMode, bkcolor, textcolor, FontName, FontSize, FontBold, FontItalic, FontUnderline, hAlign, vAlign);
            return;
        }
        if (s.indexOf("\n") >= 0 || s.indexOf("\\n") >= 0) {
            Tools.DrawStringAcceptReturn(g, rc, s, bkMode, bkcolor, textcolor, FontName, FontSize, FontBold, FontItalic, FontUnderline, hAlign, vAlign);
            return;
        }
        g.setColor(bkcolor);
        if (bkMode != 0) {
            g.fillRect(rc.x, rc.y, rc.width, rc.height);
        }
        g.setColor(textcolor);
        Dimension size = rc.getSize();
        Shape oc = g.getClip();
        try {
            Tools.clip(g, rc);
            HashMap<TextAttribute, Object> map = new HashMap<TextAttribute, Object>();
            map.put(TextAttribute.FAMILY, FontName);
            map.put(TextAttribute.SIZE, new Float(FontSize));
            if (FontUnderline) {
                map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
            }
            if (FontBold) {
                map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
            if (FontItalic) {
                map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
            AttributedString ss = new AttributedString(s, map);
            AttributedCharacterIterator text = ss.getIterator();
            FontRenderContext frc = g.getFontRenderContext();
            int paragraphStart = text.getBeginIndex();
            int paragraphEnd = text.getEndIndex();
            LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(text, frc);
            float formatWidth = size.width;
            float drawPosY = rc.y;
            if (MultiLine && vAlign != 0) {
                double gg = 0.0;
                lineMeasurer.setPosition(paragraphStart);
                while (lineMeasurer.getPosition() < paragraphEnd) {
                    TextLayout layout = lineMeasurer.nextLayout(formatWidth);
                    gg += (double)(layout.getDescent() + layout.getLeading() + layout.getAscent());
                }
                if (gg < (double)rc.height) {
                    if (vAlign == 2) {
                        drawPosY = (float)((double)drawPosY + ((double)rc.height - gg) / 2.0);
                    }
                    if (vAlign == 1) {
                        drawPosY = (float)((double)drawPosY + ((double)rc.height - gg));
                    }
                }
            }
            lineMeasurer.setPosition(paragraphStart);
            while (lineMeasurer.getPosition() < paragraphEnd) {
                TextLayout layout = lineMeasurer.nextLayout(formatWidth);
                switch (vAlign) {
                    case 1: {
                        if (!MultiLine) {
                            drawPosY += (float)rc.height - layout.getDescent() - layout.getLeading();
                            break;
                        }
                    }
                    case 2: {
                        if (!MultiLine) {
                            drawPosY += layout.getAscent() + ((float)rc.height - layout.getAscent() - layout.getDescent() - layout.getLeading()) / 2.0f;
                            break;
                        }
                    }
                    default: {
                        drawPosY += layout.getAscent();
                    }
                }
                float drawPosX = rc.x;
                switch (hAlign) {
                    case 1: {
                        drawPosX = (float)rc.x + formatWidth - layout.getAdvance();
                        break;
                    }
                    case 2: {
                        drawPosX = (float)rc.x + (formatWidth - layout.getAdvance()) / 2.0f;
                        break;
                    }
                    default: {
                        drawPosX = rc.x;
                    }
                }
                layout.draw(g, drawPosX, drawPosY);
                drawPosY += layout.getDescent() + layout.getLeading();
                if (drawPosY >= (float)(rc.y + rc.height)) {
                } else if (MultiLine) continue;
                break;
            }
        }
        catch (Exception exception) {
        }
        finally {
            Tools.setClip(g, oc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DrawStringAcceptReturn(Graphics2D g, Rectangle rc, String s, int bkMode, Color bkcolor, Color textcolor, String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline, int hAlign, int vAlign) {
        if (s == null) {
            return;
        }
        if (s.trim().equals("")) {
            return;
        }
        if (rc.width <= 0 || rc.height <= 0) {
            return;
        }
        if ((s = s.replaceAll("\\\\n", "\r\n")).indexOf("\n") < 0) {
            Tools.DrawString(g, rc, s, bkMode, bkcolor, textcolor, FontName, FontSize, FontBold, FontItalic, FontUnderline, hAlign, vAlign, true);
            return;
        }
        g.setColor(bkcolor);
        if (bkMode != 0) {
            g.fillRect(rc.x, rc.y, rc.width, rc.height);
        }
        g.setColor(textcolor);
        Shape oc = g.getClip();
        try {
            Tools.clip(g, rc);
            float textHeight = Tools.MultiLineTextHeight(g, rc.width, s, FontName, FontSize, FontBold, FontItalic, FontUnderline);
            HashMap<TextAttribute, Object> map = new HashMap<TextAttribute, Object>();
            map.put(TextAttribute.FAMILY, FontName);
            map.put(TextAttribute.SIZE, new Float(FontSize));
            if (FontUnderline) {
                map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
            }
            if (FontBold) {
                map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
            if (FontItalic) {
                map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
            AttributedString ss = new AttributedString(s, map);
            AttributedCharacterIterator styledText = ss.getIterator();
            FontRenderContext frc = g.getFontRenderContext();
            float leftMargin = 0.0f;
            ArrayList<Integer> tabLocations = new ArrayList<Integer>();
            boolean i = false;
            char c = styledText.first();
            while (c != '\uffff') {
                if (c == '\n') {
                    tabLocations.add(new Integer(styledText.getIndex()));
                }
                c = styledText.next();
            }
            tabLocations.add(new Integer(styledText.getEndIndex() - 1));
            int tabCount = tabLocations.size();
            LineBreakMeasurer measurer = new LineBreakMeasurer(styledText, frc);
            int currentTab = 0;
            float verticalPos = 0.0f;
            switch (vAlign) {
                case 1: {
                    verticalPos = (float)(rc.y + rc.height) - textHeight;
                    break;
                }
                case 2: {
                    verticalPos = (float)rc.y + ((float)rc.height - textHeight) / 2.0f;
                    break;
                }
                default: {
                    verticalPos = rc.y;
                }
            }
            while (measurer.getPosition() < styledText.getEndIndex()) {
                TextLayout layout;
                boolean lineContainsText = false;
                float maxAscent = 0.0f;
                float maxDescent = 0.0f;
                float horizontalPos = leftMargin;
                Vector<TextLayout> layouts = new Vector<TextLayout>(1);
                Vector<Float> penPositions = new Vector<Float>(1);
                float wrappingWidth = rc.width;
                int n = (Integer)tabLocations.get(currentTab) + 1;
                if (lineContainsText) {
                    // empty if block
                }
                if ((layout = measurer.nextLayout(wrappingWidth, n, false)) != null) {
                    layouts.addElement(layout);
                    penPositions.addElement(new Float(horizontalPos));
                    horizontalPos += layout.getAdvance();
                    maxAscent = Math.max(maxAscent, layout.getAscent());
                    maxDescent = Math.max(maxDescent, layout.getDescent() + layout.getLeading());
                }
                if (measurer.getPosition() == (Integer)tabLocations.get(currentTab) + 1) {
                    ++currentTab;
                }
                verticalPos += maxAscent;
                Enumeration layoutEnum = layouts.elements();
                Enumeration positionEnum = penPositions.elements();
                while (layoutEnum.hasMoreElements()) {
                    TextLayout nextLayout = (TextLayout)layoutEnum.nextElement();
                    float horizPos = 0.0f;
                    switch (hAlign) {
                        case 1: {
                            horizPos = (float)(rc.x + rc.width) - nextLayout.getAdvance();
                            break;
                        }
                        case 2: {
                            horizPos = (float)rc.x + ((float)rc.width - nextLayout.getAdvance()) / 2.0f;
                            break;
                        }
                        default: {
                            horizPos = (float)rc.x + 0.0f;
                        }
                    }
                    nextLayout.draw(g, horizPos, verticalPos);
                }
                verticalPos += maxDescent;
            }
        }
        catch (Exception exception) {
        }
        finally {
            Tools.setClip(g, oc);
        }
    }

    public static float MultiLineTextHeight(Graphics2D g, int width, String s, String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline) {
        if (s == null) {
            return 0.0f;
        }
        if (s.trim().equals("")) {
            return 0.0f;
        }
        if (width <= 0) {
            return 0.0f;
        }
        HashMap<TextAttribute, Object> map = new HashMap<TextAttribute, Object>();
        map.put(TextAttribute.FAMILY, FontName);
        map.put(TextAttribute.SIZE, new Float(FontSize));
        if (FontUnderline) {
            map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        }
        if (FontBold) {
            map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (FontItalic) {
            map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        AttributedString ss = new AttributedString(s, map);
        AttributedCharacterIterator styledText = ss.getIterator();
        FontRenderContext frc = g.getFontRenderContext();
        ArrayList<Integer> tabLocations = new ArrayList<Integer>();
        boolean i = false;
        char c = styledText.first();
        while (c != '\uffff') {
            if (c == '\n') {
                tabLocations.add(new Integer(styledText.getIndex()));
            }
            c = styledText.next();
        }
        tabLocations.add(new Integer(styledText.getEndIndex() - 1));
        int tabCount = tabLocations.size();
        LineBreakMeasurer measurer = new LineBreakMeasurer(styledText, frc);
        int currentTab = 0;
        float verticalPos = 0.0f;
        while (measurer.getPosition() < styledText.getEndIndex()) {
            TextLayout layout;
            boolean lineContainsText = false;
            float maxAscent = 0.0f;
            float maxDescent = 0.0f;
            float horizontalPos = 0.0f;
            Vector<TextLayout> layouts = new Vector<TextLayout>(1);
            Vector<Float> penPositions = new Vector<Float>(1);
            float wrappingWidth = width;
            int n = (Integer)tabLocations.get(currentTab) + 1;
            if (lineContainsText) {
                // empty if block
            }
            if ((layout = measurer.nextLayout(wrappingWidth, n, false)) != null) {
                layouts.addElement(layout);
                penPositions.addElement(new Float(horizontalPos));
                horizontalPos += layout.getAdvance();
                maxAscent = Math.max(maxAscent, layout.getAscent());
                maxDescent = Math.max(maxDescent, layout.getDescent() + layout.getLeading());
            }
            if (measurer.getPosition() == (Integer)tabLocations.get(currentTab) + 1) {
                ++currentTab;
            }
            verticalPos += maxAscent;
            Enumeration layoutEnum = layouts.elements();
            Enumeration positionEnum = penPositions.elements();
            while (layoutEnum.hasMoreElements()) {
                TextLayout nextLayout = (TextLayout)layoutEnum.nextElement();
                Float f = new Float(0.0f);
            }
            verticalPos += maxDescent;
        }
        return verticalPos;
    }

    public static Font GetFont(String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline) {
        String key = FontName + String.valueOf(FontSize) + String.valueOf(FontBold) + String.valueOf(FontItalic) + String.valueOf(FontUnderline);
        if (m_FontMap.containsKey(key)) {
            return (Font)m_FontMap.get(key);
        }
        HashMap<TextAttribute, Object> map = new HashMap<TextAttribute, Object>();
        map.put(TextAttribute.FAMILY, FontName);
        map.put(TextAttribute.SIZE, new Float(FontSize));
        if (FontUnderline) {
            map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        }
        if (FontBold) {
            map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (FontItalic) {
            map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        Font font = new Font(map);
        m_FontMap.put(key, font);
        return font;
    }

    public static Rectangle LeftPartOfRectangle(Rectangle rc) {
        return new Rectangle(rc.x, rc.y, rc.width / 4, rc.height);
    }

    public static Rectangle TopPartOfRectangle(Rectangle rc) {
        return new Rectangle(rc.x + rc.width / 4, rc.y, rc.width / 2, rc.height / 4);
    }

    public static Rectangle RightPartOfRectangle(Rectangle rc) {
        return new Rectangle(rc.x + rc.width * 3 / 4, rc.y, rc.width / 4, rc.height);
    }

    public static Rectangle BottomPartOfRectangle(Rectangle rc) {
        return new Rectangle(rc.x + rc.width / 4, rc.y + rc.height * 3 / 4, rc.width / 2, rc.height / 4);
    }

    public static Rectangle MiddlePartOfRectangle(Rectangle rc) {
        return new Rectangle(rc.x + rc.width / 4, rc.y + rc.height / 4, rc.width / 2, rc.height / 2);
    }

    public static Container GetRootContainer(Container op) {
        Container ct;
        for (ct = op; ct != null; ct = ct.getParent()) {
            if (ct.getParent() != null) continue;
            return ct;
        }
        return ct;
    }

    public static Applet ContainedByApplet(Component op) {
        for (Component ct = op; ct != null; ct = ct.getParent()) {
            if (!(ct instanceof Applet)) continue;
            return (Applet)ct;
        }
        return null;
    }

    public static int RecursionAdd(int n) {
        if (n <= 0) {
            return 0;
        }
        return n + Tools.RecursionAdd(n - 1);
    }

    public static Cursor GetCursor(Component obj, String curName, Point hotPoint) {
        if (m_CursorMap.containsKey(curName)) {
            return (Cursor)m_CursorMap.get(curName);
        }
        Cursor cur = null;
        if (curName == IDC_ARROW) {
            cur = new Cursor(0);
        }
        if (curName == IDC_SYS_WE) {
            cur = new Cursor(10);
        }
        if (curName == IDC_SYS_NS) {
            cur = new Cursor(8);
        }
        if (cur == null) {
            Applet ContainedByApplet = Tools.ContainedByApplet(obj);
            Image img = null;
            Toolkit tk = Toolkit.getDefaultToolkit();
            URL url = obj.getClass().getClassLoader().getResource("excel/res/" + curName);
            if (curName.equals("sort.gif")) {
                Tools.log(url.toString());
                Tools.log(" ContainedByApplet is null :" + (ContainedByApplet == null));
            }
            if (ContainedByApplet != null && !url.toString().startsWith("file:/") && !url.toString().startsWith("jar:file:/")) {
                try {
                    img = ContainedByApplet.getImage(url);
                }
                catch (Exception e) {
                    img = null;
                }
                if (img == null) {
                    return new Cursor(0);
                }
                MediaTracker tracker = new MediaTracker(ContainedByApplet);
                tracker.addImage(img, 0);
                cur = tk.createCustomCursor(img, hotPoint, curName);
            } else {
                img = tk.getImage(url);
                if (img == null) {
                    return new Cursor(0);
                }
                cur = tk.createCustomCursor(img, hotPoint, curName);
            }
        }
        if (cur == null) {
            return new Cursor(0);
        }
        m_CursorMap.put(curName, cur);
        return cur;
    }

    public static Image getBuffredImageFromURL(Component Wnd, String imgURL) {
        if (!m_ImgMap.containsKey(imgURL)) {
            m_ImgMap.put(imgURL, Tools.GetImageFromURL(Wnd, imgURL));
        }
        return (Image)m_ImgMap.get(imgURL);
    }

    public static Image GetImageFromURL(Component Wnd, String imgURL) {
        MediaTracker tracker;
        Applet ContainedByApplet = Tools.ContainedByApplet(Wnd);
        Image img = null;
        URL url = null;
        Toolkit tk = Toolkit.getDefaultToolkit();
        try {
            url = Wnd.getClass().getClassLoader().getResource(imgURL);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (url == null) {
                url = new URL(imgURL);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (url == null) {
            try {
                url = Wnd.getClass().getClassLoader().getResource("excel/res/notexists.gif");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!(ContainedByApplet == null || url.toString().startsWith("file:/") || url.toString().startsWith("jar:file:/") || url.toString().startsWith("jar:http:/"))) {
            try {
                img = ContainedByApplet.getImage(url);
                tracker = new MediaTracker(ContainedByApplet);
            }
            catch (Exception e) {
                img = tk.getImage(url);
                tracker = new MediaTracker(Wnd);
            }
        } else {
            img = tk.getImage(url);
            tracker = new MediaTracker(Wnd);
        }
        tracker.addImage(img, 0);
        try {
            tracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return img;
    }

    public static Rectangle getStringBounds(Graphics2D g, String str, String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline) {
        Rectangle ret = new Rectangle(0, 0, 0, 0);
        Font font = Tools.GetFont(FontName, FontSize, FontBold, FontItalic, FontUnderline);
        if (g == null) {
            return ret;
        }
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout layout = new TextLayout(str, font, frc);
        ret.width = (int)layout.getAdvance();
        ret.height = (int)layout.getAscent();
        return ret;
    }

    public static void Delay(int mm) {
        try {
            Thread.sleep(mm);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void ShowInfo(Component parentComponent, String info) {
        JOptionPane.showMessageDialog(parentComponent, info, "\u63d0\u793a", 2);
    }

    public static Point GetAbsolutePoint(Component obj, Point p) {
        if (obj == null) {
            return p;
        }
        Point ret = (Point)p.clone();
        SwingUtilities.convertPointToScreen(ret, obj);
        return ret;
    }

    public static String Color2Hex(Color c) {
        String r = "00" + Integer.toString(c.getRed(), 16);
        r = r.substring(r.length() - 2, r.length());
        String g = "00" + Integer.toString(c.getGreen(), 16);
        g = g.substring(g.length() - 2, g.length());
        String b = "00" + Integer.toString(c.getBlue(), 16);
        b = b.substring(b.length() - 2, b.length());
        return "#" + r + g + b;
    }

    public static Color Hex2Color(String c) {
        try {
            Color color = Color.decode(c);
            return color;
        }
        catch (Exception e) {
            return Color.BLACK;
        }
    }

    public static void MoveToScreenCenter(Component jf) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        jf.setLocation((d.width - jf.getWidth()) / 2, (d.height - jf.getHeight()) / 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] ReadFile(String filename) {
        byte[] ret = null;
        BufferedInputStream bis = null;
        ByteArrayOutputStream bos = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(filename));
            bos = new ByteArrayOutputStream();
            int once = 1024;
            byte[] buffer = new byte[once];
            int actually = 0;
            while ((actually = bis.read(buffer)) > 0) {
                bos.write(buffer, 0, actually);
            }
            bos.flush();
            bis.close();
            ret = bos.toByteArray();
            bos.close();
        }
        catch (Exception e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    public static void clip(Graphics2D g, Shape shape) throws Exception {
        g.clip(shape);
    }

    public static void clip(Graphics2D g, Shape shape, boolean union) {
        if (!union) {
            g.setClip(null);
        }
        g.clip(shape);
    }

    public static void setClip(Graphics2D g, Shape shape) {
        g.setClip(shape);
    }

    public static void initAllFontSon9() {
        try {
            UIDefaults table = UIManager.getLookAndFeelDefaults();
            Font f1 = new Font("SimSun", 0, 12);
            Font f2 = new Font("SimSun", 1, 12);
            Tools.initFontDefaults(table, f1, f2, f1, f1, f1, f1, f1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void initFontDefaults(UIDefaults table, Object controlFont, Object controlBoldFont, Object fixedControlFont, Object menuFont, Object messageFont, Object toolTipFont, Object windowFont) {
        Object[] defaults = new Object[]{"Button.font", controlFont, "CheckBox.font", controlFont, "ColorChooser.font", controlFont, "ComboBox.font", controlFont, "EditorPane.font", controlFont, "FormattedTextField.font", controlFont, "Label.font", controlFont, "List.font", controlFont, "Panel.font", controlFont, "PasswordField.font", controlFont, "ProgressBar.font", controlFont, "RadioButton.font", controlFont, "ScrollPane.font", controlFont, "Spinner.font", controlFont, "TabbedPane.font", controlFont, "Table.font", controlFont, "TableHeader.font", controlFont, "TextField.font", controlFont, "TextPane.font", controlFont, "ToolBar.font", controlFont, "ToggleButton.font", controlFont, "Tree.font", controlFont, "Viewport.font", controlFont, "InternalFrame.titleFont", windowFont, "OptionPane.font", messageFont, "OptionPane.messageFont", messageFont, "OptionPane.buttonFont", messageFont, "Spinner.font", fixedControlFont, "TextArea.font", fixedControlFont, "TitledBorder.font", controlBoldFont, "ToolTip.font", toolTipFont};
        table.putDefaults(defaults);
        if (menuFont != null) {
            Object[] menuDefaults = new Object[]{"CheckBoxMenuItem.font", menuFont, "CheckBoxMenuItem.acceleratorFont", menuFont, "Menu.font", menuFont, "Menu.acceleratorFont", menuFont, "MenuBar.font", menuFont, "MenuItem.font", menuFont, "MenuItem.acceleratorFont", menuFont, "PopupMenu.font", menuFont, "RadioButtonMenuItem.font", menuFont, "RadioButtonMenuItem.acceleratorFont", menuFont};
            table.putDefaults(menuDefaults);
        }
    }

    public static Object webEval(String s, Applet applet) {
        try {
            JSObject win = JSObject.getWindow((Applet)applet);
            Object ret = win.call("eval", s);
            return ret;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = Tools.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static BufferedImage grayImage(Image img) {
        BufferedImage srcImg = Tools.toBufferedImage(img);
        int iw = srcImg.getWidth();
        int ih = srcImg.getHeight();
        Graphics2D srcG = srcImg.createGraphics();
        RenderingHints rhs = srcG.getRenderingHints();
        ColorSpace cs = ColorSpace.getInstance(1003);
        ColorConvertOp theOp = new ColorConvertOp(cs, rhs);
        BufferedImage dstImg = new BufferedImage(iw, ih, 1);
        theOp.filter(srcImg, dstImg);
        return dstImg;
    }

    public static String getStringFromClipboard() {
        try {
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable clipT = clip.getContents(null);
            if (clipT != null && clipT.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return (String)clipT.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static byte[] getImageFromClipboard() {
        Clipboard sysc = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable cc = sysc.getContents(null);
        if (cc != null) {
            byte[] imgData = null;
            try {
                DataFlavor[] df = cc.getTransferDataFlavors();
                for (int i = 0; i < df.length; ++i) {
                    Object obj;
                    List list;
                    String type = df[i].getMimeType();
                    if (!type.equals("application/x-java-file-list; class=java.util.List") || (list = (List)(obj = cc.getTransferData(df[i]))).size() == 0) continue;
                    for (int n = 0; n < list.size(); ++n) {
                        String name = list.get(n).toString();
                        try {
                            BufferedImage imga = ImageIO.read(new File(name));
                            if (imga == null) continue;
                            imgData = Tools.ReadFile(name);
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (imgData != null) break;
                }
                if (imgData == null && cc.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                    Image imga = (Image)cc.getTransferData(DataFlavor.imageFlavor);
                    BufferedImage img = new BufferedImage(imga.getWidth(null), imga.getHeight(null), 1);
                    Graphics2D graphics = (Graphics2D)img.getGraphics();
                    graphics.drawImage(imga, null, null);
                    ByteArrayOutputStream bo = new ByteArrayOutputStream();
                    BufferedOutputStream bos = new BufferedOutputStream(bo);
                    ImageIO.write((RenderedImage)img, "png", bos);
                    bos.flush();
                    bos.close();
                    byte[] ret = bo.toByteArray();
                    imgData = ret;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return imgData;
        }
        return null;
    }

    public static void requestInputFocus(JComponent comp) {
        comp.requestFocus();
        final JComponent comp_ = comp;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                comp_.requestFocus();
            }
        });
    }

    public static Dialog getDialogContainsComponent(Component component) {
        for (Container comp = component.getParent(); comp != null; comp = comp.getParent()) {
            if (!(comp instanceof Dialog)) continue;
            return (Dialog)comp;
        }
        return null;
    }

    public static void log(String info) {
        System.out.print("zexcel log:");
        System.out.println(info);
    }

    public static void log(int info) {
        System.out.println(info);
    }

    public static void log(boolean info) {
        System.out.println(info);
    }

    public static Stroke getStroke(float width, int cap, int join) {
        String key = width + "-" + cap + "-" + join;
        if (!m_StrokeMap.containsKey(key)) {
            m_StrokeMap.put(key, new BasicStroke(width, cap, join));
        }
        return (Stroke)m_StrokeMap.get(key);
    }

    public static Stroke getStroke(float width, int cap, int join, float miterlimit, float[] dash, float dash_phase) {
        StringBuffer key = new StringBuffer();
        key.append(width).append("-").append(cap).append("-").append(join).append("-").append(miterlimit);
        for (int i = 0; i < dash.length; ++i) {
            key.append("-");
            key.append(dash[i]);
        }
        if (!m_StrokeMap.containsKey(key)) {
            m_StrokeMap.put(key, new BasicStroke(width, cap, join, miterlimit, dash, dash_phase));
        }
        return (Stroke)m_StrokeMap.get(key);
    }

    public static PrintService findPrintService(PrintService[] services, String serviceName) {
        boolean selectedService = false;
        if (services.length == 0) {
            return null;
        }
        for (int i = 0; i < services.length; ++i) {
            if (!serviceName.equals(services[i].getName())) continue;
            return services[i];
        }
        return services[0];
    }

    public static PageFormat createPageFormat(PrinterJob pj, JSONObject pageConfig) {
        PageFormat page = pj.defaultPage();
        double paperWidth = pageConfig.getDouble("pageWidth", Tools.mm2pixel(210.0));
        double paperHeight = pageConfig.getDouble("pageHeight", Tools.mm2pixel(297.0));
        double left = pageConfig.getDouble("leftMargin", Tools.mm2pixel(25.4));
        double right = pageConfig.getDouble("rightMargin", Tools.mm2pixel(25.4));
        double top = pageConfig.getDouble("topMargin", Tools.mm2pixel(25.4));
        double bottom = pageConfig.getDouble("bottomMargin", Tools.mm2pixel(25.4));
        int orientation = pageConfig.getInt("printDir", 1);
        if (orientation == 1) {
            page.setOrientation(1);
        } else {
            page.setOrientation(0);
        }
        int pageHeaderHeight = pageConfig.getJSONObject("pageHeaderConfig", null).getInt("height", 0);
        int pageFooterHeight = pageConfig.getJSONObject("pageFooterConfig", null).getInt("height", 0);
        Paper paper = new Paper();
        paper.setSize(paperWidth, paperHeight);
        paper.setImageableArea(left, top - (double)pageHeaderHeight, paperWidth - left - right, paperHeight - top - bottom + (double)pageHeaderHeight + (double)pageFooterHeight);
        page.setPaper(paper);
        return page;
    }

    public static HashPrintRequestAttributeSet createHashPrintRequestAttributeSet(JSONObject printOption, String sheetName, int pageCount) {
        HashPrintRequestAttributeSet ret = new HashPrintRequestAttributeSet();
        ret.add(new Copies(printOption.getInt("copy", 1)));
        int fromPage = printOption.getInt("fromPage", 1);
        int toPage = printOption.getInt("toPage", 9999);
        int pageRange = printOption.getInt("pageRange", 3);
        StringBuffer sb = new StringBuffer(1024);
        if (pageRange == 3) {
            ret.add(new PageRanges(Math.min(pageCount, fromPage) + "-" + Math.min(pageCount, toPage)));
        } else {
            int y = pageRange == 2 ? 0 : 1;
            for (int i = Math.min(pageCount, fromPage); i <= Math.min(pageCount, toPage); ++i) {
                if (i % 2 != y) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append("" + i);
            }
            if (sb.length() == 0) {
                sb.append("9999");
            }
            ret.add(new PageRanges(sb.toString()));
        }
        ret.add(new JobName("\u6253\u5370\uff1a" + sheetName, null));
        return ret;
    }

    public static double mm2pixel(double mm) {
        return mm / 25.4 * 72.0;
    }

    public static int String2Int(String s) {
        try {
            return new Integer(s);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static boolean confirm(Component parentComponent, String msg) {
        int result = JOptionPane.showConfirmDialog(parentComponent, msg, "\u8bf7\u9009\u62e9", 0);
        return result == 0;
    }

    public static boolean stringMatch(Object v, String text, String key, boolean caseSensitive, boolean fullMatch) {
        if (v == null) {
            return false;
        }
        if (text.equals("")) {
            return false;
        }
        if (fullMatch) {
            if (caseSensitive) {
                return key.equals(text);
            }
            return key.equalsIgnoreCase(text);
        }
        if (caseSensitive) {
            return text.indexOf(key) >= 0;
        }
        return text.toLowerCase().indexOf(key.toLowerCase()) >= 0;
    }
}

