/*
 * Decompiled with CFR 0.152.
 */
package gdi;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.json.JSONArray;
import util.Base64Coder;
import util.FF;
import util.Tools;

public class GraphicsLogic {
    public int lastX;
    public int lastY;
    Color lastFillColor = Color.white;
    float alpha = 1.0f;
    public int lineWidth = 1;
    public Stroke oldStroke;
    public Color oldColor;

    public void setStrokeColor(Graphics2D g, JSONArray cmd) {
        Color c = this.str2color(cmd.getString(1));
        if (c == null) {
            c = Color.white;
        }
        g.setColor(c);
    }

    public void stroke(Graphics2D g, JSONArray cmd) {
    }

    public void setClip(Graphics2D g, JSONArray cmd) {
        int x = cmd.getInt(1);
        int y = cmd.getInt(2);
        int width = cmd.getInt(3);
        int height = cmd.getInt(4);
        Tools.setClip(g, new Rectangle(x, y, width, height));
    }

    public void setFillColor(Graphics2D g, JSONArray cmd) {
        Color c;
        this.lastFillColor = c = this.str2color(cmd.getString(1));
        g.setColor(c);
    }

    public void setColor(Graphics2D g, JSONArray cmd) {
        this.setStrokeColor(g, cmd);
        this.setFillColor(g, cmd);
    }

    public void setLineCap(Graphics2D g, JSONArray cmd) {
        String c = cmd.getString(1);
    }

    public void moveTo(Graphics2D g, JSONArray cmd) {
        int x = cmd.getInt(1);
        int y = cmd.getInt(2);
        this.lastX = x;
        this.lastY = y;
    }

    public void scale(Graphics2D g, JSONArray cmd) {
        double xScale = cmd.getDouble(1);
        double yScale = cmd.getDouble(2);
        g.scale(xScale, yScale);
    }

    public void translate(Graphics2D g, JSONArray cmd) {
        int x = cmd.getInt(1);
        int y = cmd.getInt(2);
        g.translate(x, y);
    }

    public void lineTo(Graphics2D g, JSONArray cmd) {
        int x = cmd.getInt(1);
        int y = cmd.getInt(2);
        g.drawLine(this.lastX, this.lastY, x, y);
        this.lastX = x;
        this.lastY = y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawImage(Graphics2D g, JSONArray cmd) {
        String imgSource = cmd.getString(1);
        int x = cmd.getInt(2);
        int y = cmd.getInt(3);
        int w = cmd.getInt(4);
        int h = cmd.getInt(5);
        int x2 = cmd.getInt(6);
        int y2 = cmd.getInt(7);
        int w2 = cmd.getInt(8);
        int h2 = cmd.getInt(9);
        String origin = cmd.getString(10);
        int p = imgSource.indexOf("base64,");
        if (p >= 0) {
            String t = imgSource.substring(p + 7);
            char[] cs = t.toCharArray();
            byte[] b = Base64Coder.decode(cs);
            try {
                BufferedImage img = ImageIO.read(new ByteArrayInputStream(b));
                g.drawImage(img, x2, y2, w2, h2, null);
            }
            catch (Exception img) {}
        } else {
            if (imgSource.indexOf("://") < 0) {
                imgSource = origin + imgSource;
            }
            BufferedInputStream bis = null;
            URL url = null;
            try {
                url = new URL(imgSource);
                DataInputStream dataInputStream = new DataInputStream(url.openStream());
                bis = new BufferedInputStream(dataInputStream);
                BufferedImage preImage = ImageIO.read(bis);
                g.drawImage(preImage, x2, y2, w2, h2, null);
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public Color str2color(String s) {
        try {
            this.alpha = 1.0f;
            if (s.equals("")) {
                return Color.black;
            }
            if (s.equals("")) {
                return Color.white;
            }
            if (s.indexOf("color") > 0) {
                boolean bl = true;
            }
            if (s.startsWith("#")) {
                return Color.decode(s);
            }
            int p = s.indexOf("[");
            if (p >= 0 && (p = (s = s.substring(p + 1)).indexOf("]")) > 0) {
                s = s.substring(0, p);
            }
            if ((p = s.indexOf("(")) >= 0 && (p = (s = s.substring(p + 1)).indexOf(")")) > 0) {
                s = s.substring(0, p);
            }
            if (s.equals("b,l,a,c")) {
                return Color.black;
            }
            if (s.equals("#,0,0,0")) {
                return Color.black;
            }
            if (s.equals("#,c,0,0")) {
                return Color.black;
            }
            if (s.equals("#,0,0,c")) {
                return Color.black;
            }
            String[] c = (s = FF.replaceAll(s, "\"", "")).split(",");
            if (c.length >= 3) {
                int r = Integer.valueOf(c[0].trim());
                int g = Integer.valueOf(c[1].trim());
                int b = Integer.valueOf(c[2].trim());
                if (c.length == 4) {
                    this.alpha = Float.valueOf(c[3].trim()).floatValue();
                    if (this.alpha == 0.0f) {
                        return null;
                    }
                }
                return new Color(r, g, b);
            }
            return Color.black;
        }
        catch (Exception e) {
            return Color.black;
        }
    }

    public void setLineWidth(Graphics2D g, JSONArray cmd) {
        int width;
        this.lineWidth = width = cmd.getInt(1);
        g.setStroke(Tools.getStroke(width, 2, 2));
    }

    public void setLineDash(Graphics2D g, JSONArray cmd) {
        int dash = cmd.getInt(1);
        g.setStroke(Tools.getStroke(this.lineWidth, 0, 0, 10.0f, new float[]{dash}, 1.0f));
    }

    public void contextSave(Graphics2D g, JSONArray cmd) {
        this.oldStroke = g.getStroke();
        this.oldColor = g.getColor();
    }

    public void contextRestore(Graphics2D g, JSONArray cmd) {
        g.setStroke(this.oldStroke);
        g.setColor(this.oldColor);
    }

    public void drawRect(Graphics2D g, JSONArray cmd) {
        int x = cmd.getInt(1);
        int y = cmd.getInt(2);
        int width = cmd.getInt(3);
        int height = cmd.getInt(4);
        g.drawRect(x, y, width, height);
    }

    public void clearRect(Graphics2D g, JSONArray cmd) {
        int x = cmd.getInt(1);
        int y = cmd.getInt(2);
        int width = cmd.getInt(3);
        int height = cmd.getInt(4);
        Color oldColor = g.getColor();
        g.setColor(Color.white);
        g.drawRect(x, y, width, height);
        g.setColor(oldColor);
    }

    public void fillRect(Graphics2D g, JSONArray cmd) {
        if (this.lastFillColor == null) {
            return;
        }
        int x = cmd.getInt(1);
        int y = cmd.getInt(2);
        int width = cmd.getInt(3);
        int height = cmd.getInt(4);
        if (this.alpha > 0.0f && this.alpha != 1.0f) {
            AlphaComposite ac5 = AlphaComposite.getInstance(3, this.alpha);
            Composite oldAlpha = g.getComposite();
            g.setComposite(ac5);
            g.setColor(this.lastFillColor);
            g.fillRect(x, y, width, height);
            g.setComposite(oldAlpha);
        } else {
            Color nc = this.pureColor(this.lastFillColor);
            g.setColor(nc);
            g.fillRect(x, y, width, height);
        }
    }

    public Color pureColor(Color c) {
        int b;
        int g;
        int threshold = 128;
        int r = (int)((double)c.getRed() * 0.3);
        int rgb = r + (g = (int)((double)c.getGreen() * 0.59)) + (b = (int)((double)c.getBlue() * 0.11));
        if (rgb > threshold) {
            return Color.white;
        }
        return Color.black;
    }

    public void drawStringSingleRow(Graphics2D g, JSONArray cmd) {
        int x = cmd.getInt(1);
        int y = cmd.getInt(2);
        int width = cmd.getInt(3);
        int height = cmd.getInt(4);
        Rectangle rc = new Rectangle(x, y, width, height);
        String s = cmd.getString(5);
        int bkMode = cmd.getInt(6);
        Color bkcolor = this.str2color(cmd.getString(7));
        Color textColor = this.str2color(cmd.getString(8));
        String FontName = cmd.getString(9);
        int FontSize = cmd.getInt(10);
        boolean FontBold = cmd.getBoolean(11);
        boolean FontItalic = cmd.getBoolean(12);
        boolean FontUnderline = cmd.getBoolean(13);
        int hAlign = cmd.getInt(14);
        int vAlign = cmd.getInt(15);
        boolean MultiLine = false;
        Tools.DrawString(g, rc, s, bkMode, bkcolor, textColor, FontName, FontSize, FontBold, FontItalic, FontUnderline, hAlign, vAlign, MultiLine);
    }

    public void drawStringWordwrap(Graphics2D g, JSONArray cmd) {
        int x = cmd.getInt(1);
        int y = cmd.getInt(2);
        int width = cmd.getInt(3);
        int height = cmd.getInt(4);
        Rectangle rc = new Rectangle(x, y, width, height);
        String s = cmd.getString(5);
        int bkMode = cmd.getInt(6);
        Color bkcolor = this.str2color(cmd.getString(7));
        Color textColor = this.str2color(cmd.getString(8));
        String FontName = cmd.getString(9);
        int FontSize = cmd.getInt(10);
        boolean FontBold = cmd.getBoolean(11);
        boolean FontItalic = cmd.getBoolean(12);
        boolean FontUnderline = cmd.getBoolean(13);
        int hAlign = cmd.getInt(14);
        int vAlign = cmd.getInt(15);
        boolean MultiLine = true;
        Tools.DrawString(g, rc, s, bkMode, bkcolor, textColor, FontName, FontSize, FontBold, FontItalic, FontUnderline, hAlign, vAlign, MultiLine);
    }
}

