/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.serializer.dom3;

import com.sun.org.apache.xml.internal.serializer.DOM3Serializer;
import com.sun.org.apache.xml.internal.serializer.Encodings;
import com.sun.org.apache.xml.internal.serializer.OutputPropertiesFactory;
import com.sun.org.apache.xml.internal.serializer.Serializer;
import com.sun.org.apache.xml.internal.serializer.ToXMLStream;
import com.sun.org.apache.xml.internal.serializer.dom3.DOMErrorImpl;
import com.sun.org.apache.xml.internal.serializer.dom3.DOMStringListImpl;
import com.sun.org.apache.xml.internal.serializer.utils.SystemIDResolver;
import com.sun.org.apache.xml.internal.serializer.utils.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSException;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.w3c.dom.ls.LSSerializerFilter;

public final class LSSerializerImpl
implements DOMConfiguration,
LSSerializer {
    private Serializer fXMLSerializer = null;
    protected int fFeatures = 0;
    private DOM3Serializer fDOMSerializer = null;
    private LSSerializerFilter fSerializerFilter = null;
    private Node fVisitedNode = null;
    private String fEndOfLine = "\n";
    private DOMErrorHandler fDOMErrorHandler = null;
    private Properties fDOMConfigProperties = null;
    private String fEncoding;
    private static final int CANONICAL = 1;
    private static final int CDATA = 2;
    private static final int CHARNORMALIZE = 4;
    private static final int COMMENTS = 8;
    private static final int DTNORMALIZE = 16;
    private static final int ELEM_CONTENT_WHITESPACE = 32;
    private static final int ENTITIES = 64;
    private static final int INFOSET = 128;
    private static final int NAMESPACES = 256;
    private static final int NAMESPACEDECLS = 512;
    private static final int NORMALIZECHARS = 1024;
    private static final int SPLITCDATA = 2048;
    private static final int VALIDATE = 4096;
    private static final int SCHEMAVALIDATE = 8192;
    private static final int WELLFORMED = 16384;
    private static final int DISCARDDEFAULT = 32768;
    private static final int PRETTY_PRINT = 65536;
    private static final int IGNORE_CHAR_DENORMALIZE = 131072;
    private static final int XMLDECL = 262144;
    private String[] fRecognizedParameters = new String[]{"canonical-form", "cdata-sections", "check-character-normalization", "comments", "datatype-normalization", "element-content-whitespace", "entities", "infoset", "namespaces", "namespace-declarations", "split-cdata-sections", "validate", "validate-if-schema", "well-formed", "discard-default-content", "format-pretty-print", "ignore-unknown-character-denormalizations", "xml-declaration", "error-handler"};

    public LSSerializerImpl() {
        this.fFeatures |= 2;
        this.fFeatures |= 8;
        this.fFeatures |= 0x20;
        this.fFeatures |= 0x40;
        this.fFeatures |= 0x100;
        this.fFeatures |= 0x200;
        this.fFeatures |= 0x800;
        this.fFeatures |= 0x4000;
        this.fFeatures |= 0x8000;
        this.fFeatures |= 0x40000;
        this.fDOMConfigProperties = new Properties();
        this.initializeSerializerProps();
        Properties properties = OutputPropertiesFactory.getDefaultMethodProperties("xml");
        this.fXMLSerializer = new ToXMLStream();
        this.fXMLSerializer.setOutputFormat(properties);
        this.fXMLSerializer.setOutputFormat(this.fDOMConfigProperties);
    }

    public void initializeSerializerProps() {
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}canonical-form", "default:no");
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}cdata-sections", "default:yes");
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}check-character-normalization", "default:no");
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}comments", "default:yes");
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}datatype-normalization", "default:no");
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}element-content-whitespace", "default:yes");
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}entities", "default:yes");
        if ((this.fFeatures & 0x80) != 0) {
            this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}namespaces", "default:yes");
            this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}namespace-declarations", "default:yes");
            this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}comments", "default:yes");
            this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}element-content-whitespace", "default:yes");
            this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}well-formed", "default:yes");
            this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}entities", "default:no");
            this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}cdata-sections", "default:no");
            this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}validate-if-schema", "default:no");
            this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}datatype-normalization", "default:no");
        }
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}namespaces", "default:yes");
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}namespace-declarations", "default:yes");
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}split-cdata-sections", "default:yes");
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}validate", "default:no");
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}validate-if-schema", "default:no");
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}well-formed", "default:yes");
        this.fDOMConfigProperties.setProperty("indent", "default:no");
        this.fDOMConfigProperties.setProperty("{http://xml.apache.org/xalan}indent-amount", Integer.toString(4));
        this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}discard-default-content", "default:yes");
        this.fDOMConfigProperties.setProperty("omit-xml-declaration", "no");
    }

    @Override
    public boolean canSetParameter(String string, Object object) {
        if (object instanceof Boolean) {
            if (string.equalsIgnoreCase("cdata-sections") || string.equalsIgnoreCase("comments") || string.equalsIgnoreCase("entities") || string.equalsIgnoreCase("infoset") || string.equalsIgnoreCase("element-content-whitespace") || string.equalsIgnoreCase("namespaces") || string.equalsIgnoreCase("namespace-declarations") || string.equalsIgnoreCase("split-cdata-sections") || string.equalsIgnoreCase("well-formed") || string.equalsIgnoreCase("discard-default-content") || string.equalsIgnoreCase("format-pretty-print") || string.equalsIgnoreCase("xml-declaration")) {
                return true;
            }
            if (string.equalsIgnoreCase("canonical-form") || string.equalsIgnoreCase("check-character-normalization") || string.equalsIgnoreCase("datatype-normalization") || string.equalsIgnoreCase("validate-if-schema") || string.equalsIgnoreCase("validate")) {
                return (Boolean)object == false;
            }
            if (string.equalsIgnoreCase("ignore-unknown-character-denormalizations")) {
                return (Boolean)object;
            }
        } else if (string.equalsIgnoreCase("error-handler") && object == null || object instanceof DOMErrorHandler) {
            return true;
        }
        return false;
    }

    @Override
    public Object getParameter(String string) throws DOMException {
        if (string.equalsIgnoreCase("normalize-characters")) {
            return null;
        }
        if (string.equalsIgnoreCase("comments")) {
            return (this.fFeatures & 8) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("cdata-sections")) {
            return (this.fFeatures & 2) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("entities")) {
            return (this.fFeatures & 0x40) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("namespaces")) {
            return (this.fFeatures & 0x100) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("namespace-declarations")) {
            return (this.fFeatures & 0x200) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("split-cdata-sections")) {
            return (this.fFeatures & 0x800) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("well-formed")) {
            return (this.fFeatures & 0x4000) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("discard-default-content")) {
            return (this.fFeatures & 0x8000) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("format-pretty-print")) {
            return (this.fFeatures & 0x10000) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("xml-declaration")) {
            return (this.fFeatures & 0x40000) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("element-content-whitespace")) {
            return (this.fFeatures & 0x20) != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("ignore-unknown-character-denormalizations")) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase("canonical-form") || string.equalsIgnoreCase("check-character-normalization") || string.equalsIgnoreCase("datatype-normalization") || string.equalsIgnoreCase("validate") || string.equalsIgnoreCase("validate-if-schema")) {
            return Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("infoset")) {
            if ((this.fFeatures & 0x40) == 0 && (this.fFeatures & 2) == 0 && (this.fFeatures & 0x20) != 0 && (this.fFeatures & 0x100) != 0 && (this.fFeatures & 0x200) != 0 && (this.fFeatures & 0x4000) != 0 && (this.fFeatures & 8) != 0) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("error-handler")) {
            return this.fDOMErrorHandler;
        }
        if (string.equalsIgnoreCase("schema-location") || string.equalsIgnoreCase("schema-type")) {
            return null;
        }
        String string2 = Utils.messages.createMessage("FEATURE_NOT_FOUND", new Object[]{string});
        throw new DOMException(8, string2);
    }

    @Override
    public DOMStringList getParameterNames() {
        return new DOMStringListImpl(this.fRecognizedParameters);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setParameter(String string, Object object) throws DOMException {
        if (object instanceof Boolean) {
            boolean bl = (Boolean)object;
            if (string.equalsIgnoreCase("comments")) {
                int n = this.fFeatures = bl ? this.fFeatures | 8 : this.fFeatures & 0xFFFFFFF7;
                if (bl) {
                    this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}comments", "explicit:yes");
                    return;
                }
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}comments", "explicit:no");
                return;
            }
            if (string.equalsIgnoreCase("cdata-sections")) {
                int n = this.fFeatures = bl ? this.fFeatures | 2 : this.fFeatures & 0xFFFFFFFD;
                if (bl) {
                    this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}cdata-sections", "explicit:yes");
                    return;
                }
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}cdata-sections", "explicit:no");
                return;
            }
            if (string.equalsIgnoreCase("entities")) {
                int n = this.fFeatures = bl ? this.fFeatures | 0x40 : this.fFeatures & 0xFFFFFFBF;
                if (bl) {
                    this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}entities", "explicit:yes");
                    return;
                }
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}entities", "explicit:no");
                return;
            }
            if (string.equalsIgnoreCase("namespaces")) {
                int n = this.fFeatures = bl ? this.fFeatures | 0x100 : this.fFeatures & 0xFFFFFEFF;
                if (bl) {
                    this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}namespaces", "explicit:yes");
                    return;
                }
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}namespaces", "explicit:no");
                return;
            }
            if (string.equalsIgnoreCase("namespace-declarations")) {
                int n = this.fFeatures = bl ? this.fFeatures | 0x200 : this.fFeatures & 0xFFFFFDFF;
                if (bl) {
                    this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}namespace-declarations", "explicit:yes");
                    return;
                }
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}namespace-declarations", "explicit:no");
                return;
            }
            if (string.equalsIgnoreCase("split-cdata-sections")) {
                int n = this.fFeatures = bl ? this.fFeatures | 0x800 : this.fFeatures & 0xFFFFF7FF;
                if (bl) {
                    this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}split-cdata-sections", "explicit:yes");
                    return;
                }
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}split-cdata-sections", "explicit:no");
                return;
            }
            if (string.equalsIgnoreCase("well-formed")) {
                int n = this.fFeatures = bl ? this.fFeatures | 0x4000 : this.fFeatures & 0xFFFFBFFF;
                if (bl) {
                    this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}well-formed", "explicit:yes");
                    return;
                }
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}well-formed", "explicit:no");
                return;
            }
            if (string.equalsIgnoreCase("discard-default-content")) {
                int n = this.fFeatures = bl ? this.fFeatures | 0x8000 : this.fFeatures & 0xFFFF7FFF;
                if (bl) {
                    this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}discard-default-content", "explicit:yes");
                    return;
                }
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}discard-default-content", "explicit:no");
                return;
            }
            if (string.equalsIgnoreCase("format-pretty-print")) {
                int n = this.fFeatures = bl ? this.fFeatures | 0x10000 : this.fFeatures & 0xFFFEFFFF;
                if (bl) {
                    this.fDOMConfigProperties.setProperty("indent", "explicit:yes");
                    this.fDOMConfigProperties.setProperty("{http://xml.apache.org/xalan}indent-amount", Integer.toString(4));
                    return;
                }
                this.fDOMConfigProperties.setProperty("indent", "explicit:no");
                return;
            }
            if (string.equalsIgnoreCase("xml-declaration")) {
                int n = this.fFeatures = bl ? this.fFeatures | 0x40000 : this.fFeatures & 0xFFFBFFFF;
                if (bl) {
                    this.fDOMConfigProperties.setProperty("omit-xml-declaration", "no");
                    return;
                }
                this.fDOMConfigProperties.setProperty("omit-xml-declaration", "yes");
                return;
            }
            if (string.equalsIgnoreCase("element-content-whitespace")) {
                int n = this.fFeatures = bl ? this.fFeatures | 0x20 : this.fFeatures & 0xFFFFFFDF;
                if (bl) {
                    this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}element-content-whitespace", "explicit:yes");
                    return;
                }
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}element-content-whitespace", "explicit:no");
                return;
            }
            if (string.equalsIgnoreCase("ignore-unknown-character-denormalizations")) {
                if (!bl) {
                    String string2 = Utils.messages.createMessage("FEATURE_NOT_SUPPORTED", new Object[]{string});
                    throw new DOMException(9, string2);
                }
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}ignore-unknown-character-denormalizations", "explicit:yes");
                return;
            }
            if (string.equalsIgnoreCase("canonical-form") || string.equalsIgnoreCase("validate-if-schema") || string.equalsIgnoreCase("validate") || string.equalsIgnoreCase("check-character-normalization") || string.equalsIgnoreCase("datatype-normalization")) {
                if (bl) {
                    String string3 = Utils.messages.createMessage("FEATURE_NOT_SUPPORTED", new Object[]{string});
                    throw new DOMException(9, string3);
                }
                if (string.equalsIgnoreCase("canonical-form")) {
                    this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}canonical-form", "explicit:no");
                    return;
                }
                if (string.equalsIgnoreCase("validate-if-schema")) {
                    this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}validate-if-schema", "explicit:no");
                    return;
                }
                if (string.equalsIgnoreCase("validate")) {
                    this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}validate", "explicit:no");
                    return;
                }
                if (string.equalsIgnoreCase("validate-if-schema")) {
                    this.fDOMConfigProperties.setProperty("check-character-normalizationcheck-character-normalization", "explicit:no");
                    return;
                }
                if (!string.equalsIgnoreCase("datatype-normalization")) return;
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}datatype-normalization", "explicit:no");
                return;
            }
            if (string.equalsIgnoreCase("infoset")) {
                if (!bl) return;
                this.fFeatures &= 0xFFFFFFBF;
                this.fFeatures &= 0xFFFFFFFD;
                this.fFeatures &= 0xFFFFDFFF;
                this.fFeatures &= 0xFFFFFFEF;
                this.fFeatures |= 0x100;
                this.fFeatures |= 0x200;
                this.fFeatures |= 0x4000;
                this.fFeatures |= 0x20;
                this.fFeatures |= 8;
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}namespaces", "explicit:yes");
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}namespace-declarations", "explicit:yes");
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}comments", "explicit:yes");
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}element-content-whitespace", "explicit:yes");
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}well-formed", "explicit:yes");
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}entities", "explicit:no");
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}cdata-sections", "explicit:no");
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}validate-if-schema", "explicit:no");
                this.fDOMConfigProperties.setProperty("{http://www.w3.org/TR/DOM-Level-3-LS}datatype-normalization", "explicit:no");
                return;
            }
            if (!string.equalsIgnoreCase("normalize-characters")) return;
            String string4 = Utils.messages.createMessage("FEATURE_NOT_SUPPORTED", new Object[]{string});
            throw new DOMException(9, string4);
        }
        if (string.equalsIgnoreCase("error-handler")) {
            if (object != null && !(object instanceof DOMErrorHandler)) {
                String string5 = Utils.messages.createMessage("TYPE_MISMATCH_ERR", new Object[]{string});
                throw new DOMException(17, string5);
            }
            this.fDOMErrorHandler = (DOMErrorHandler)object;
            return;
        }
        if (string.equalsIgnoreCase("schema-location") || string.equalsIgnoreCase("schema-type") || string.equalsIgnoreCase("normalize-characters") && object != null) {
            String string6 = Utils.messages.createMessage("FEATURE_NOT_SUPPORTED", new Object[]{string});
            throw new DOMException(9, string6);
        }
        String string7 = Utils.messages.createMessage("FEATURE_NOT_FOUND", new Object[]{string});
        throw new DOMException(8, string7);
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return this;
    }

    @Override
    public LSSerializerFilter getFilter() {
        return this.fSerializerFilter;
    }

    @Override
    public String getNewLine() {
        return this.fEndOfLine;
    }

    @Override
    public void setFilter(LSSerializerFilter lSSerializerFilter) {
        this.fSerializerFilter = lSSerializerFilter;
    }

    @Override
    public void setNewLine(String string) {
        this.fEndOfLine = string != null ? string : this.fEndOfLine;
    }

    @Override
    public boolean write(Node node, LSOutput lSOutput) throws LSException {
        Object object;
        if (lSOutput == null) {
            String string = Utils.messages.createMessage("no-output-specified", null);
            if (this.fDOMErrorHandler != null) {
                this.fDOMErrorHandler.handleError(new DOMErrorImpl(3, string, "no-output-specified"));
            }
            throw new LSException(82, string);
        }
        if (node == null) {
            return false;
        }
        Serializer serializer = this.fXMLSerializer;
        serializer.reset();
        if (node != this.fVisitedNode) {
            object = this.getXMLVersion(node);
            this.fEncoding = lSOutput.getEncoding();
            if (this.fEncoding == null) {
                this.fEncoding = this.getInputEncoding(node);
                String string = this.fEncoding != null ? this.fEncoding : (this.fEncoding = this.getXMLEncoding(node) == null ? "UTF-8" : this.getXMLEncoding(node));
            }
            if (!Encodings.isRecognizedEncoding(this.fEncoding)) {
                String string = Utils.messages.createMessage("unsupported-encoding", null);
                if (this.fDOMErrorHandler != null) {
                    this.fDOMErrorHandler.handleError(new DOMErrorImpl(3, string, "unsupported-encoding"));
                }
                throw new LSException(82, string);
            }
            serializer.getOutputFormat().setProperty("version", (String)object);
            this.fDOMConfigProperties.setProperty("{http://xml.apache.org/xerces-2j}xml-version", (String)object);
            this.fDOMConfigProperties.setProperty("encoding", this.fEncoding);
            if ((node.getNodeType() != 9 || node.getNodeType() != 1 || node.getNodeType() != 6) && (this.fFeatures & 0x40000) != 0) {
                this.fDOMConfigProperties.setProperty("omit-xml-declaration", "default:no");
            }
            this.fVisitedNode = node;
        }
        this.fXMLSerializer.setOutputFormat(this.fDOMConfigProperties);
        try {
            object = lSOutput.getCharacterStream();
            if (object == null) {
                OutputStream outputStream = lSOutput.getByteStream();
                if (outputStream == null) {
                    String string = lSOutput.getSystemId();
                    if (string == null) {
                        String string2 = Utils.messages.createMessage("no-output-specified", null);
                        if (this.fDOMErrorHandler != null) {
                            this.fDOMErrorHandler.handleError(new DOMErrorImpl(3, string2, "no-output-specified"));
                        }
                        throw new LSException(82, string2);
                    }
                    String string3 = SystemIDResolver.getAbsoluteURI(string);
                    URL uRL = new URL(string3);
                    OutputStream outputStream2 = null;
                    String string4 = uRL.getProtocol();
                    String string5 = uRL.getHost();
                    if (string4.equalsIgnoreCase("file") && (string5 == null || string5.length() == 0 || string5.equals("localhost"))) {
                        outputStream2 = new FileOutputStream(new File(uRL.getPath()));
                    } else {
                        URLConnection uRLConnection = uRL.openConnection();
                        uRLConnection.setDoInput(false);
                        uRLConnection.setDoOutput(true);
                        uRLConnection.setUseCaches(false);
                        uRLConnection.setAllowUserInteraction(false);
                        if (uRLConnection instanceof HttpURLConnection) {
                            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                            httpURLConnection.setRequestMethod("PUT");
                        }
                        outputStream2 = uRLConnection.getOutputStream();
                    }
                    serializer.setWriter(new OutputStreamWriter(outputStream2));
                } else {
                    serializer.setWriter(new OutputStreamWriter(outputStream, this.fEncoding));
                }
            } else {
                serializer.setWriter((Writer)object);
            }
            if (this.fDOMSerializer == null) {
                this.fDOMSerializer = (DOM3Serializer)serializer.asDOM3Serializer();
            }
            if (this.fDOMErrorHandler != null) {
                this.fDOMSerializer.setErrorHandler(this.fDOMErrorHandler);
            }
            if (this.fSerializerFilter != null) {
                this.fDOMSerializer.setNodeFilter(this.fSerializerFilter);
            }
            this.fDOMSerializer.setNewLine(this.fEndOfLine);
            this.fDOMSerializer.serializeDOM3(node);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = Utils.messages.createMessage("unsupported-encoding", null);
            if (this.fDOMErrorHandler != null) {
                this.fDOMErrorHandler.handleError(new DOMErrorImpl(3, string, "unsupported-encoding", unsupportedEncodingException));
            }
            throw new LSException(82, unsupportedEncodingException.getMessage());
        }
        catch (LSException lSException) {
            throw lSException;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw new LSException(82, runtimeException != null ? runtimeException.getMessage() : "NULL Exception");
        }
        catch (Exception exception) {
            if (this.fDOMErrorHandler != null) {
                this.fDOMErrorHandler.handleError(new DOMErrorImpl(3, exception.getMessage(), null, exception));
            }
            exception.printStackTrace();
            throw new LSException(82, exception.toString());
        }
        return true;
    }

    @Override
    public String writeToString(Node node) throws DOMException, LSException {
        Object object;
        if (node == null) {
            return null;
        }
        Serializer serializer = this.fXMLSerializer;
        serializer.reset();
        if (node != this.fVisitedNode) {
            object = this.getXMLVersion(node);
            serializer.getOutputFormat().setProperty("version", (String)object);
            this.fDOMConfigProperties.setProperty("{http://xml.apache.org/xerces-2j}xml-version", (String)object);
            this.fDOMConfigProperties.setProperty("encoding", "UTF-16");
            if ((node.getNodeType() != 9 || node.getNodeType() != 1 || node.getNodeType() != 6) && (this.fFeatures & 0x40000) != 0) {
                this.fDOMConfigProperties.setProperty("omit-xml-declaration", "default:no");
            }
            this.fVisitedNode = node;
        }
        this.fXMLSerializer.setOutputFormat(this.fDOMConfigProperties);
        object = new StringWriter();
        try {
            serializer.setWriter((Writer)object);
            if (this.fDOMSerializer == null) {
                this.fDOMSerializer = (DOM3Serializer)serializer.asDOM3Serializer();
            }
            if (this.fDOMErrorHandler != null) {
                this.fDOMSerializer.setErrorHandler(this.fDOMErrorHandler);
            }
            if (this.fSerializerFilter != null) {
                this.fDOMSerializer.setNodeFilter(this.fSerializerFilter);
            }
            this.fDOMSerializer.setNewLine(this.fEndOfLine);
            this.fDOMSerializer.serializeDOM3(node);
        }
        catch (LSException lSException) {
            throw lSException;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw new LSException(82, runtimeException.toString());
        }
        catch (Exception exception) {
            if (this.fDOMErrorHandler != null) {
                this.fDOMErrorHandler.handleError(new DOMErrorImpl(3, exception.getMessage(), null, exception));
            }
            exception.printStackTrace();
            throw new LSException(82, exception.toString());
        }
        return ((StringWriter)object).toString();
    }

    @Override
    public boolean writeToURI(Node node, String string) throws LSException {
        String string2;
        if (node == null) {
            return false;
        }
        Serializer serializer = this.fXMLSerializer;
        serializer.reset();
        if (node != this.fVisitedNode) {
            string2 = this.getXMLVersion(node);
            this.fEncoding = this.getInputEncoding(node);
            if (this.fEncoding == null) {
                this.fEncoding = this.fEncoding != null ? this.fEncoding : (this.getXMLEncoding(node) == null ? "UTF-8" : this.getXMLEncoding(node));
            }
            serializer.getOutputFormat().setProperty("version", string2);
            this.fDOMConfigProperties.setProperty("{http://xml.apache.org/xerces-2j}xml-version", string2);
            this.fDOMConfigProperties.setProperty("encoding", this.fEncoding);
            if ((node.getNodeType() != 9 || node.getNodeType() != 1 || node.getNodeType() != 6) && (this.fFeatures & 0x40000) != 0) {
                this.fDOMConfigProperties.setProperty("omit-xml-declaration", "default:no");
            }
            this.fVisitedNode = node;
        }
        this.fXMLSerializer.setOutputFormat(this.fDOMConfigProperties);
        try {
            if (string == null) {
                string2 = Utils.messages.createMessage("no-output-specified", null);
                if (this.fDOMErrorHandler != null) {
                    this.fDOMErrorHandler.handleError(new DOMErrorImpl(3, string2, "no-output-specified"));
                }
                throw new LSException(82, string2);
            }
            string2 = SystemIDResolver.getAbsoluteURI(string);
            URL uRL = new URL(string2);
            OutputStream outputStream = null;
            String string3 = uRL.getProtocol();
            String string4 = uRL.getHost();
            if (string3.equalsIgnoreCase("file") && (string4 == null || string4.length() == 0 || string4.equals("localhost"))) {
                outputStream = new FileOutputStream(new File(uRL.getPath()));
            } else {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setDoInput(false);
                uRLConnection.setDoOutput(true);
                uRLConnection.setUseCaches(false);
                uRLConnection.setAllowUserInteraction(false);
                if (uRLConnection instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setRequestMethod("PUT");
                }
                outputStream = uRLConnection.getOutputStream();
            }
            serializer.setWriter(new OutputStreamWriter(outputStream, this.fEncoding));
            if (this.fDOMSerializer == null) {
                this.fDOMSerializer = (DOM3Serializer)serializer.asDOM3Serializer();
            }
            if (this.fDOMErrorHandler != null) {
                this.fDOMSerializer.setErrorHandler(this.fDOMErrorHandler);
            }
            if (this.fSerializerFilter != null) {
                this.fDOMSerializer.setNodeFilter(this.fSerializerFilter);
            }
            this.fDOMSerializer.setNewLine(this.fEndOfLine);
            this.fDOMSerializer.serializeDOM3(node);
        }
        catch (LSException lSException) {
            throw lSException;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw new LSException(82, runtimeException.toString());
        }
        catch (Exception exception) {
            if (this.fDOMErrorHandler != null) {
                this.fDOMErrorHandler.handleError(new DOMErrorImpl(3, exception.getMessage(), null, exception));
            }
            exception.printStackTrace();
            throw new LSException(82, exception.toString());
        }
        return true;
    }

    protected String getXMLVersion(Node node) {
        Document document = null;
        if (node != null && (document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument()) != null && document.getImplementation().hasFeature("Core", "3.0")) {
            try {
                return document.getXmlVersion();
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
        return "1.0";
    }

    protected String getXMLEncoding(Node node) {
        Document document = null;
        if (node != null && (document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument()) != null && document.getImplementation().hasFeature("Core", "3.0")) {
            return document.getXmlEncoding();
        }
        return "UTF-8";
    }

    protected String getInputEncoding(Node node) {
        Document document = null;
        if (node != null && (document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument()) != null && document.getImplementation().hasFeature("Core", "3.0")) {
            return document.getInputEncoding();
        }
        return null;
    }

    public DOMErrorHandler getErrorHandler() {
        return this.fDOMErrorHandler;
    }
}

