/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ClassParser;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.util.AttributeHTML;
import com.sun.org.apache.bcel.internal.util.CodeHTML;
import com.sun.org.apache.bcel.internal.util.ConstantHTML;
import com.sun.org.apache.bcel.internal.util.MethodHTML;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;

public class Class2HTML {
    private final JavaClass java_class;
    private final String dir;
    private static String class_package;
    private static String class_name;
    private static ConstantPool constant_pool;
    private static final Set<String> basic_types;

    public Class2HTML(JavaClass javaClass, String string) throws IOException {
        Method[] methodArray = javaClass.getMethods();
        this.java_class = javaClass;
        this.dir = string;
        class_name = javaClass.getClassName();
        constant_pool = javaClass.getConstantPool();
        int n = class_name.lastIndexOf(46);
        class_package = n > -1 ? class_name.substring(0, n) : "";
        ConstantHTML constantHTML = new ConstantHTML(string, class_name, class_package, methodArray, constant_pool);
        AttributeHTML attributeHTML = new AttributeHTML(string, class_name, constant_pool, constantHTML);
        new MethodHTML(string, class_name, methodArray, javaClass.getFields(), constantHTML, attributeHTML);
        this.writeMainHTML(attributeHTML);
        new CodeHTML(string, class_name, methodArray, constant_pool, constantHTML);
        attributeHTML.close();
    }

    public static void main(String[] stringArray) throws IOException {
        int n;
        String[] stringArray2 = new String[stringArray.length];
        int n2 = 0;
        ClassParser classParser = null;
        JavaClass javaClass = null;
        String string = null;
        char c = File.separatorChar;
        String string2 = "." + c;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].charAt(0) == '-') {
                if (stringArray[n].equals("-d")) {
                    boolean bl;
                    File file;
                    if (!(string2 = stringArray[++n]).endsWith("" + c)) {
                        string2 = string2 + c;
                    }
                    if ((file = new File(string2)).isDirectory() || (bl = file.mkdirs()) || file.isDirectory()) continue;
                    System.out.println("Tried to create the directory " + string2 + " but failed");
                    continue;
                }
                if (stringArray[n].equals("-zip")) {
                    string = stringArray[++n];
                    continue;
                }
                System.out.println("Unknown option " + stringArray[n]);
                continue;
            }
            stringArray2[n2++] = stringArray[n];
        }
        if (n2 == 0) {
            System.err.println("Class2HTML: No input files specified.");
        } else {
            for (n = 0; n < n2; ++n) {
                System.out.print("Processing " + stringArray2[n] + "...");
                classParser = string == null ? new ClassParser(stringArray2[n]) : new ClassParser(string, stringArray2[n]);
                javaClass = classParser.parse();
                new Class2HTML(javaClass, string2);
                System.out.println("Done.");
            }
        }
    }

    static String referenceClass(int n) {
        String string = constant_pool.getConstantString(n, (byte)7);
        string = Utility.compactClassName(string);
        string = Utility.compactClassName(string, class_package + ".", true);
        return "<A HREF=\"" + class_name + "_cp.html#cp" + n + "\" TARGET=ConstantPool>" + string + "</A>";
    }

    static String referenceType(String string) {
        String string2 = Utility.compactClassName(string);
        string2 = Utility.compactClassName(string2, class_package + ".", true);
        int n = string.indexOf(91);
        String string3 = string;
        if (n > -1) {
            string3 = string.substring(0, n);
        }
        if (basic_types.contains(string3)) {
            return "<FONT COLOR=\"#00FF00\">" + string + "</FONT>";
        }
        return "<A HREF=\"" + string3 + ".html\" TARGET=_top>" + string2 + "</A>";
    }

    static String toHTML(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block6;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block6;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block6;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private void writeMainHTML(AttributeHTML attributeHTML) throws IOException {
        try (Attribute[] attributeArray = new PrintWriter(new FileOutputStream(this.dir + class_name + ".html"));){
            attributeArray.println("<HTML>\n<HEAD><TITLE>Documentation for " + class_name + "</TITLE></HEAD>\n<FRAMESET BORDER=1 cols=\"30%,*\">\n<FRAMESET BORDER=1 rows=\"80%,*\">\n<FRAME NAME=\"ConstantPool\" SRC=\"" + class_name + "_cp.html\"\n MARGINWIDTH=\"0\" MARGINHEIGHT=\"0\" FRAMEBORDER=\"1\" SCROLLING=\"AUTO\">\n<FRAME NAME=\"Attributes\" SRC=\"" + class_name + "_attributes.html\"\n MARGINWIDTH=\"0\" MARGINHEIGHT=\"0\" FRAMEBORDER=\"1\" SCROLLING=\"AUTO\">\n</FRAMESET>\n<FRAMESET BORDER=1 rows=\"80%,*\">\n<FRAME NAME=\"Code\" SRC=\"" + class_name + "_code.html\"\n MARGINWIDTH=0 MARGINHEIGHT=0 FRAMEBORDER=1 SCROLLING=\"AUTO\">\n<FRAME NAME=\"Methods\" SRC=\"" + class_name + "_methods.html\"\n MARGINWIDTH=0 MARGINHEIGHT=0 FRAMEBORDER=1 SCROLLING=\"AUTO\">\n</FRAMESET></FRAMESET></HTML>");
        }
        attributeArray = this.java_class.getAttributes();
        for (int i = 0; i < attributeArray.length; ++i) {
            attributeHTML.writeAttribute(attributeArray[i], "class" + i);
        }
    }

    static {
        basic_types = new HashSet<String>();
        basic_types.add("int");
        basic_types.add("short");
        basic_types.add("boolean");
        basic_types.add("void");
        basic_types.add("char");
        basic_types.add("byte");
        basic_types.add("long");
        basic_types.add("double");
        basic_types.add("float");
    }
}

