/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.AnnotationEntry;
import com.sun.org.apache.bcel.internal.classfile.Annotations;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.Code;
import com.sun.org.apache.bcel.internal.classfile.CodeException;
import com.sun.org.apache.bcel.internal.classfile.ExceptionTable;
import com.sun.org.apache.bcel.internal.classfile.LineNumber;
import com.sun.org.apache.bcel.internal.classfile.LineNumberTable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTypeTable;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.classfile.ParameterAnnotationEntry;
import com.sun.org.apache.bcel.internal.classfile.ParameterAnnotations;
import com.sun.org.apache.bcel.internal.classfile.RuntimeVisibleParameterAnnotations;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.generic.AnnotationEntryGen;
import com.sun.org.apache.bcel.internal.generic.BranchInstruction;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.CodeExceptionGen;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.FieldGenOrMethodGen;
import com.sun.org.apache.bcel.internal.generic.IINC;
import com.sun.org.apache.bcel.internal.generic.IfInstruction;
import com.sun.org.apache.bcel.internal.generic.IndexedInstruction;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.bcel.internal.generic.InstructionTargeter;
import com.sun.org.apache.bcel.internal.generic.LineNumberGen;
import com.sun.org.apache.bcel.internal.generic.LocalVariableGen;
import com.sun.org.apache.bcel.internal.generic.LocalVariableInstruction;
import com.sun.org.apache.bcel.internal.generic.MethodObserver;
import com.sun.org.apache.bcel.internal.generic.NOP;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import com.sun.org.apache.bcel.internal.generic.RET;
import com.sun.org.apache.bcel.internal.generic.Select;
import com.sun.org.apache.bcel.internal.generic.TargetLostException;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.generic.TypedInstruction;
import com.sun.org.apache.bcel.internal.util.BCELComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class MethodGen
extends FieldGenOrMethodGen {
    private String class_name;
    private Type[] arg_types;
    private String[] arg_names;
    private int max_locals;
    private int max_stack;
    private InstructionList il;
    private boolean strip_attributes;
    private LocalVariableTypeTable local_variable_type_table = null;
    private final List<LocalVariableGen> variable_vec = new ArrayList<LocalVariableGen>();
    private final List<LineNumberGen> line_number_vec = new ArrayList<LineNumberGen>();
    private final List<CodeExceptionGen> exception_vec = new ArrayList<CodeExceptionGen>();
    private final List<String> throws_vec = new ArrayList<String>();
    private final List<Attribute> code_attrs_vec = new ArrayList<Attribute>();
    private List<AnnotationEntryGen>[] param_annotations;
    private boolean hasParameterAnnotations = false;
    private boolean haveUnpackedParameterAnnotations = false;
    private static BCELComparator bcelComparator = new BCELComparator(){

        @Override
        public boolean equals(Object object, Object object2) {
            MethodGen methodGen = (MethodGen)object;
            MethodGen methodGen2 = (MethodGen)object2;
            return methodGen.getName().equals(methodGen2.getName()) && methodGen.getSignature().equals(methodGen2.getSignature());
        }

        @Override
        public int hashCode(Object object) {
            MethodGen methodGen = (MethodGen)object;
            return methodGen.getSignature().hashCode() ^ methodGen.getName().hashCode();
        }
    };
    private List<MethodObserver> observers;

    public MethodGen(int n, Type type, Type[] typeArray, String[] stringArray, String string, String string2, InstructionList instructionList, ConstantPoolGen constantPoolGen) {
        super(n);
        this.setType(type);
        this.setArgumentTypes(typeArray);
        this.setArgumentNames(stringArray);
        this.setName(string);
        this.setClassName(string2);
        this.setInstructionList(instructionList);
        this.setConstantPool(constantPoolGen);
        boolean bl = this.isAbstract() || this.isNative();
        InstructionHandle instructionHandle = null;
        InstructionHandle instructionHandle2 = null;
        if (!bl) {
            instructionHandle = instructionList.getStart();
            if (!this.isStatic() && string2 != null) {
                this.addLocalVariable("this", ObjectType.getInstance(string2), instructionHandle, instructionHandle2);
            }
        }
        if (typeArray != null) {
            int n2 = typeArray.length;
            for (Type type2 : typeArray) {
                if (Type.VOID != type2) continue;
                throw new ClassGenException("'void' is an illegal argument type for a method");
            }
            if (stringArray != null) {
                if (n2 != stringArray.length) {
                    throw new ClassGenException("Mismatch in argument array lengths: " + n2 + " vs. " + stringArray.length);
                }
            } else {
                stringArray = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    stringArray[i] = "arg" + i;
                }
                this.setArgumentNames(stringArray);
            }
            if (!bl) {
                for (int i = 0; i < n2; ++i) {
                    this.addLocalVariable(stringArray[i], typeArray[i], instructionHandle, instructionHandle2);
                }
            }
        }
    }

    public MethodGen(Method method, String string, ConstantPoolGen constantPoolGen) {
        this(method.getAccessFlags(), Type.getReturnType(method.getSignature()), Type.getArgumentTypes(method.getSignature()), null, method.getName(), string, (method.getAccessFlags() & 0x500) == 0 ? new InstructionList(method.getCode().getCode()) : null, constantPoolGen);
        Attribute[] attributeArray;
        for (Attribute attribute : attributeArray = method.getAttributes()) {
            int n;
            Object[] objectArray;
            Object object;
            Object object2 = attribute;
            if (object2 instanceof Code) {
                Object object3;
                Object[] objectArray2;
                object = (String[])object2;
                this.setMaxStack(((Code)object).getMaxStack());
                this.setMaxLocals(((Code)object).getMaxLocals());
                objectArray = ((Code)object).getExceptionTable();
                if (objectArray != null) {
                    objectArray2 = objectArray;
                    int n2 = objectArray2.length;
                    for (n = 0; n < n2; ++n) {
                        InstructionHandle instructionHandle;
                        Object object4 = objectArray2[n];
                        int n3 = ((CodeException)object4).getCatchType();
                        object3 = null;
                        if (n3 > 0) {
                            String string2 = method.getConstantPool().getConstantString(n3, (byte)7);
                            object3 = ObjectType.getInstance(string2);
                        }
                        int n4 = ((CodeException)object4).getEndPC();
                        int n5 = method.getCode().getCode().length;
                        if (n5 == n4) {
                            instructionHandle = this.il.getEnd();
                        } else {
                            instructionHandle = this.il.findHandle(n4);
                            instructionHandle = instructionHandle.getPrev();
                        }
                        this.addExceptionHandler(this.il.findHandle(((CodeException)object4).getStartPC()), instructionHandle, this.il.findHandle(((CodeException)object4).getHandlerPC()), (ObjectType)object3);
                    }
                }
                Object[] objectArray3 = objectArray2 = ((Code)object).getAttributes();
                n = objectArray3.length;
                for (int i = 0; i < n; ++i) {
                    Object object5 = objectArray3[i];
                    object2 = object5;
                    if (object2 instanceof LineNumberTable) {
                        for (LineNumber lineNumber : object3 = ((LineNumberTable)object2).getLineNumberTable()) {
                            InstructionHandle instructionHandle = this.il.findHandle(lineNumber.getStartPC());
                            if (instructionHandle == null) continue;
                            this.addLineNumber(instructionHandle, lineNumber.getLineNumber());
                        }
                        continue;
                    }
                    if (object2 instanceof LocalVariableTable) {
                        this.updateLocalVariableTable((LocalVariableTable)object2);
                        continue;
                    }
                    if (object2 instanceof LocalVariableTypeTable) {
                        this.local_variable_type_table = (LocalVariableTypeTable)((Attribute)object2).copy(constantPoolGen.getConstantPool());
                        continue;
                    }
                    this.addCodeAttribute((Attribute)object2);
                }
                continue;
            }
            if (object2 instanceof ExceptionTable) {
                object = ((ExceptionTable)object2).getExceptionNames();
                objectArray = object;
                int n6 = objectArray.length;
                for (int i = 0; i < n6; ++i) {
                    Object object6 = objectArray[i];
                    this.addException((String)object6);
                }
                continue;
            }
            if (object2 instanceof Annotations) {
                object = (Annotations)object2;
                Object[] objectArray4 = objectArray = ((Annotations)object).getAnnotationEntries();
                int n7 = objectArray4.length;
                for (n = 0; n < n7; ++n) {
                    Object object7 = objectArray4[n];
                    this.addAnnotationEntry(new AnnotationEntryGen((AnnotationEntry)object7, constantPoolGen, false));
                }
                continue;
            }
            this.addAttribute((Attribute)object2);
        }
    }

    public LocalVariableGen addLocalVariable(String string, Type type, int n, InstructionHandle instructionHandle, InstructionHandle instructionHandle2, int n2) {
        byte by = type.getType();
        if (by != 16) {
            LocalVariableGen localVariableGen;
            int n3;
            int n4 = type.getSize();
            if (n + n4 > this.max_locals) {
                this.max_locals = n + n4;
            }
            if ((n3 = this.variable_vec.indexOf(localVariableGen = new LocalVariableGen(n, string, type, instructionHandle, instructionHandle2, n2))) >= 0) {
                this.variable_vec.set(n3, localVariableGen);
            } else {
                this.variable_vec.add(localVariableGen);
            }
            return localVariableGen;
        }
        throw new IllegalArgumentException("Can not use " + type + " as type for local variable");
    }

    public LocalVariableGen addLocalVariable(String string, Type type, int n, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        return this.addLocalVariable(string, type, n, instructionHandle, instructionHandle2, n);
    }

    public LocalVariableGen addLocalVariable(String string, Type type, InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        return this.addLocalVariable(string, type, this.max_locals, instructionHandle, instructionHandle2);
    }

    public void removeLocalVariable(LocalVariableGen localVariableGen) {
        this.variable_vec.remove(localVariableGen);
    }

    public void removeLocalVariables() {
        this.variable_vec.clear();
    }

    public LocalVariableGen[] getLocalVariables() {
        int n = this.variable_vec.size();
        LocalVariableGen[] localVariableGenArray = new LocalVariableGen[n];
        this.variable_vec.toArray(localVariableGenArray);
        for (int i = 0; i < n; ++i) {
            if (localVariableGenArray[i].getStart() == null && this.il != null) {
                localVariableGenArray[i].setStart(this.il.getStart());
            }
            if (localVariableGenArray[i].getEnd() != null || this.il == null) continue;
            localVariableGenArray[i].setEnd(this.il.getEnd());
        }
        if (n > 1) {
            Arrays.sort(localVariableGenArray, new Comparator<LocalVariableGen>(){

                @Override
                public int compare(LocalVariableGen localVariableGen, LocalVariableGen localVariableGen2) {
                    return localVariableGen.getIndex() - localVariableGen2.getIndex();
                }
            });
        }
        return localVariableGenArray;
    }

    public LocalVariableTable getLocalVariableTable(ConstantPoolGen constantPoolGen) {
        LocalVariableGen[] localVariableGenArray = this.getLocalVariables();
        int n = localVariableGenArray.length;
        LocalVariable[] localVariableArray = new LocalVariable[n];
        for (int i = 0; i < n; ++i) {
            localVariableArray[i] = localVariableGenArray[i].getLocalVariable(constantPoolGen);
        }
        return new LocalVariableTable(constantPoolGen.addUtf8("LocalVariableTable"), 2 + localVariableArray.length * 10, localVariableArray, constantPoolGen.getConstantPool());
    }

    public LocalVariableTypeTable getLocalVariableTypeTable() {
        return this.local_variable_type_table;
    }

    public LineNumberGen addLineNumber(InstructionHandle instructionHandle, int n) {
        LineNumberGen lineNumberGen = new LineNumberGen(instructionHandle, n);
        this.line_number_vec.add(lineNumberGen);
        return lineNumberGen;
    }

    public void removeLineNumber(LineNumberGen lineNumberGen) {
        this.line_number_vec.remove(lineNumberGen);
    }

    public void removeLineNumbers() {
        this.line_number_vec.clear();
    }

    public LineNumberGen[] getLineNumbers() {
        LineNumberGen[] lineNumberGenArray = new LineNumberGen[this.line_number_vec.size()];
        this.line_number_vec.toArray(lineNumberGenArray);
        return lineNumberGenArray;
    }

    public LineNumberTable getLineNumberTable(ConstantPoolGen constantPoolGen) {
        int n = this.line_number_vec.size();
        LineNumber[] lineNumberArray = new LineNumber[n];
        for (int i = 0; i < n; ++i) {
            lineNumberArray[i] = this.line_number_vec.get(i).getLineNumber();
        }
        return new LineNumberTable(constantPoolGen.addUtf8("LineNumberTable"), 2 + lineNumberArray.length * 4, lineNumberArray, constantPoolGen.getConstantPool());
    }

    public CodeExceptionGen addExceptionHandler(InstructionHandle instructionHandle, InstructionHandle instructionHandle2, InstructionHandle instructionHandle3, ObjectType objectType) {
        if (instructionHandle == null || instructionHandle2 == null || instructionHandle3 == null) {
            throw new ClassGenException("Exception handler target is null instruction");
        }
        CodeExceptionGen codeExceptionGen = new CodeExceptionGen(instructionHandle, instructionHandle2, instructionHandle3, objectType);
        this.exception_vec.add(codeExceptionGen);
        return codeExceptionGen;
    }

    public void removeExceptionHandler(CodeExceptionGen codeExceptionGen) {
        this.exception_vec.remove(codeExceptionGen);
    }

    public void removeExceptionHandlers() {
        this.exception_vec.clear();
    }

    public CodeExceptionGen[] getExceptionHandlers() {
        CodeExceptionGen[] codeExceptionGenArray = new CodeExceptionGen[this.exception_vec.size()];
        this.exception_vec.toArray(codeExceptionGenArray);
        return codeExceptionGenArray;
    }

    private CodeException[] getCodeExceptions() {
        int n = this.exception_vec.size();
        CodeException[] codeExceptionArray = new CodeException[n];
        for (int i = 0; i < n; ++i) {
            CodeExceptionGen codeExceptionGen = this.exception_vec.get(i);
            codeExceptionArray[i] = codeExceptionGen.getCodeException(super.getConstantPool());
        }
        return codeExceptionArray;
    }

    public void addException(String string) {
        this.throws_vec.add(string);
    }

    public void removeException(String string) {
        this.throws_vec.remove(string);
    }

    public void removeExceptions() {
        this.throws_vec.clear();
    }

    public String[] getExceptions() {
        String[] stringArray = new String[this.throws_vec.size()];
        this.throws_vec.toArray(stringArray);
        return stringArray;
    }

    private ExceptionTable getExceptionTable(ConstantPoolGen constantPoolGen) {
        int n = this.throws_vec.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = constantPoolGen.addClass(this.throws_vec.get(i));
        }
        return new ExceptionTable(constantPoolGen.addUtf8("Exceptions"), 2 + 2 * n, nArray, constantPoolGen.getConstantPool());
    }

    public void addCodeAttribute(Attribute attribute) {
        this.code_attrs_vec.add(attribute);
    }

    public void removeLocalVariableTypeTable() {
        this.local_variable_type_table = null;
    }

    public void removeCodeAttribute(Attribute attribute) {
        this.code_attrs_vec.remove(attribute);
    }

    public void removeCodeAttributes() {
        this.local_variable_type_table = null;
        this.code_attrs_vec.clear();
    }

    public Attribute[] getCodeAttributes() {
        Attribute[] attributeArray = new Attribute[this.code_attrs_vec.size()];
        this.code_attrs_vec.toArray(attributeArray);
        return attributeArray;
    }

    public void addAnnotationsAsAttribute(ConstantPoolGen constantPoolGen) {
        Attribute[] attributeArray;
        for (Attribute attribute : attributeArray = AnnotationEntryGen.getAnnotationAttributes(constantPoolGen, super.getAnnotationEntries())) {
            this.addAttribute(attribute);
        }
    }

    public void addParameterAnnotationsAsAttribute(ConstantPoolGen constantPoolGen) {
        if (!this.hasParameterAnnotations) {
            return;
        }
        Attribute[] attributeArray = AnnotationEntryGen.getParameterAnnotationAttributes(constantPoolGen, this.param_annotations);
        if (attributeArray != null) {
            for (Attribute attribute : attributeArray) {
                this.addAttribute(attribute);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Method getMethod() {
        void var13_19;
        String string = this.getSignature();
        ConstantPoolGen constantPoolGen = super.getConstantPool();
        int n = constantPoolGen.addUtf8(super.getName());
        int n2 = constantPoolGen.addUtf8(string);
        byte[] byArray = null;
        if (this.il != null) {
            byArray = this.il.getByteCode();
        }
        LineNumberTable lineNumberTable = null;
        LocalVariableTable localVariableTable = null;
        if (this.variable_vec.size() > 0 && !this.strip_attributes) {
            this.updateLocalVariableTable(this.getLocalVariableTable(constantPoolGen));
            localVariableTable = this.getLocalVariableTable(constantPoolGen);
            this.addCodeAttribute(localVariableTable);
        }
        if (this.local_variable_type_table != null) {
            if (localVariableTable != null) {
                this.adjustLocalVariableTypeTable(localVariableTable);
            }
            this.addCodeAttribute(this.local_variable_type_table);
        }
        if (this.line_number_vec.size() > 0 && !this.strip_attributes) {
            lineNumberTable = this.getLineNumberTable(constantPoolGen);
            this.addCodeAttribute(lineNumberTable);
        }
        Attribute[] attributeArray = this.getCodeAttributes();
        int n3 = 0;
        for (Attribute object2 : attributeArray) {
            n3 += object2.getLength() + 6;
        }
        Cloneable[] cloneableArray = this.getCodeExceptions();
        int n4 = cloneableArray.length * 8;
        Code code = null;
        if (this.il != null && !this.isAbstract() && !this.isNative()) {
            Attribute[] attributeArray2;
            for (Attribute attribute : attributeArray2 = this.getAttributes()) {
                if (!(attribute instanceof Code)) continue;
                this.removeAttribute(attribute);
            }
            code = new Code(constantPoolGen.addUtf8("Code"), 8 + byArray.length + 2 + n4 + 2 + n3, this.max_stack, this.max_locals, byArray, (CodeException[])cloneableArray, attributeArray, constantPoolGen.getConstantPool());
            this.addAttribute(code);
        }
        this.addAnnotationsAsAttribute(constantPoolGen);
        this.addParameterAnnotationsAsAttribute(constantPoolGen);
        Object var13_17 = null;
        if (this.throws_vec.size() > 0) {
            ExceptionTable exceptionTable = this.getExceptionTable(constantPoolGen);
            this.addAttribute(exceptionTable);
        }
        Method method = new Method(super.getAccessFlags(), n, n2, this.getAttributes(), constantPoolGen.getConstantPool());
        if (localVariableTable != null) {
            this.removeCodeAttribute(localVariableTable);
        }
        if (this.local_variable_type_table != null) {
            this.removeCodeAttribute(this.local_variable_type_table);
        }
        if (lineNumberTable != null) {
            this.removeCodeAttribute(lineNumberTable);
        }
        if (code != null) {
            this.removeAttribute(code);
        }
        if (var13_19 != null) {
            this.removeAttribute((Attribute)var13_19);
        }
        return method;
    }

    private void updateLocalVariableTable(LocalVariableTable localVariableTable) {
        LocalVariable[] localVariableArray = localVariableTable.getLocalVariableTable();
        this.removeLocalVariables();
        for (LocalVariable localVariable : localVariableArray) {
            InstructionHandle instructionHandle = this.il.findHandle(localVariable.getStartPC());
            InstructionHandle instructionHandle2 = this.il.findHandle(localVariable.getStartPC() + localVariable.getLength());
            if (null == instructionHandle) {
                instructionHandle = this.il.getStart();
            }
            this.addLocalVariable(localVariable.getName(), Type.getType(localVariable.getSignature()), localVariable.getIndex(), instructionHandle, instructionHandle2, localVariable.getOrigIndex());
        }
    }

    private void adjustLocalVariableTypeTable(LocalVariableTable localVariableTable) {
        LocalVariable[] localVariableArray;
        LocalVariable[] localVariableArray2 = localVariableTable.getLocalVariableTable();
        block0: for (LocalVariable localVariable : localVariableArray = this.local_variable_type_table.getLocalVariableTypeTable()) {
            for (LocalVariable localVariable2 : localVariableArray2) {
                if (!localVariable.getName().equals(localVariable2.getName()) || localVariable.getIndex() != localVariable2.getOrigIndex()) continue;
                localVariable.setLength(localVariable2.getLength());
                localVariable.setStartPC(localVariable2.getStartPC());
                localVariable.setIndex(localVariable2.getIndex());
                continue block0;
            }
        }
    }

    public void removeNOPs() {
        if (this.il != null) {
            InstructionHandle instructionHandle = this.il.getStart();
            while (instructionHandle != null) {
                InstructionHandle instructionHandle2 = instructionHandle.getNext();
                if (instructionHandle2 != null && instructionHandle.getInstruction() instanceof NOP) {
                    try {
                        this.il.delete(instructionHandle);
                    }
                    catch (TargetLostException targetLostException) {
                        for (InstructionHandle instructionHandle3 : targetLostException.getTargets()) {
                            for (InstructionTargeter instructionTargeter : instructionHandle3.getTargeters()) {
                                instructionTargeter.updateTarget(instructionHandle3, instructionHandle2);
                            }
                        }
                    }
                }
                instructionHandle = instructionHandle2;
            }
        }
    }

    public void setMaxLocals(int n) {
        this.max_locals = n;
    }

    public int getMaxLocals() {
        return this.max_locals;
    }

    public void setMaxStack(int n) {
        this.max_stack = n;
    }

    public int getMaxStack() {
        return this.max_stack;
    }

    public String getClassName() {
        return this.class_name;
    }

    public void setClassName(String string) {
        this.class_name = string;
    }

    public void setReturnType(Type type) {
        this.setType(type);
    }

    public Type getReturnType() {
        return this.getType();
    }

    public void setArgumentTypes(Type[] typeArray) {
        this.arg_types = typeArray;
    }

    public Type[] getArgumentTypes() {
        return (Type[])this.arg_types.clone();
    }

    public void setArgumentType(int n, Type type) {
        this.arg_types[n] = type;
    }

    public Type getArgumentType(int n) {
        return this.arg_types[n];
    }

    public void setArgumentNames(String[] stringArray) {
        this.arg_names = stringArray;
    }

    public String[] getArgumentNames() {
        return (String[])this.arg_names.clone();
    }

    public void setArgumentName(int n, String string) {
        this.arg_names[n] = string;
    }

    public String getArgumentName(int n) {
        return this.arg_names[n];
    }

    public InstructionList getInstructionList() {
        return this.il;
    }

    public void setInstructionList(InstructionList instructionList) {
        this.il = instructionList;
    }

    @Override
    public String getSignature() {
        return Type.getMethodSignature(super.getType(), this.arg_types);
    }

    public void setMaxStack() {
        this.max_stack = this.il != null ? MethodGen.getMaxStack(super.getConstantPool(), this.il, this.getExceptionHandlers()) : 0;
    }

    public void setMaxLocals() {
        if (this.il != null) {
            int n;
            Object object;
            int n2;
            int n3 = n2 = this.isStatic() ? 0 : 1;
            if (this.arg_types != null) {
                object = this.arg_types;
                int n4 = ((Type[])object).length;
                for (n = 0; n < n4; ++n) {
                    Object object2 = object[n];
                    n2 += ((Type)object2).getSize();
                }
            }
            for (object = this.il.getStart(); object != null; object = ((InstructionHandle)object).getNext()) {
                Instruction instruction = ((InstructionHandle)object).getInstruction();
                if (!(instruction instanceof LocalVariableInstruction) && !(instruction instanceof RET) && !(instruction instanceof IINC) || (n = ((IndexedInstruction)((Object)instruction)).getIndex() + ((TypedInstruction)((Object)instruction)).getType(super.getConstantPool()).getSize()) <= n2) continue;
                n2 = n;
            }
            this.max_locals = n2;
        } else {
            this.max_locals = 0;
        }
    }

    public void stripAttributes(boolean bl) {
        this.strip_attributes = bl;
    }

    public static int getMaxStack(ConstantPoolGen constantPoolGen, InstructionList instructionList, CodeExceptionGen[] codeExceptionGenArray) {
        BranchStack branchStack = new BranchStack();
        for (CodeExceptionGen cloneable : codeExceptionGenArray) {
            InstructionHandle instructionHandle = cloneable.getHandlerPC();
            if (instructionHandle == null) continue;
            branchStack.push(instructionHandle, 1);
        }
        int n = 0;
        int n2 = 0;
        InstructionHandle instructionHandle = instructionList.getStart();
        while (instructionHandle != null) {
            Object object;
            Instruction instruction = instructionHandle.getInstruction();
            short s = instruction.getOpcode();
            int n3 = instruction.produceStack(constantPoolGen) - instruction.consumeStack(constantPoolGen);
            if ((n += n3) > n2) {
                n2 = n;
            }
            if (instruction instanceof BranchInstruction) {
                object = (BranchInstruction)instruction;
                if (instruction instanceof Select) {
                    InstructionHandle[] instructionHandleArray;
                    Select select = (Select)object;
                    for (InstructionHandle instructionHandle2 : instructionHandleArray = select.getTargets()) {
                        branchStack.push(instructionHandle2, n);
                    }
                    instructionHandle = null;
                } else if (!(object instanceof IfInstruction)) {
                    if (s == 168 || s == 201) {
                        branchStack.push(instructionHandle.getNext(), n - 1);
                    }
                    instructionHandle = null;
                }
                branchStack.push(((BranchInstruction)object).getTarget(), n);
            } else if (s == 191 || s == 169 || s >= 172 && s <= 177) {
                instructionHandle = null;
            }
            if (instructionHandle != null) {
                instructionHandle = instructionHandle.getNext();
            }
            if (instructionHandle != null || (object = branchStack.pop()) == null) continue;
            instructionHandle = ((BranchTarget)object).target;
            n = ((BranchTarget)object).stackDepth;
        }
        return n2;
    }

    public void addObserver(MethodObserver methodObserver) {
        if (this.observers == null) {
            this.observers = new ArrayList<MethodObserver>();
        }
        this.observers.add(methodObserver);
    }

    public void removeObserver(MethodObserver methodObserver) {
        if (this.observers != null) {
            this.observers.remove(methodObserver);
        }
    }

    public void update() {
        if (this.observers != null) {
            for (MethodObserver methodObserver : this.observers) {
                methodObserver.notify(this);
            }
        }
    }

    public final String toString() {
        String string = Utility.accessToString(super.getAccessFlags());
        String string2 = Type.getMethodSignature(super.getType(), this.arg_types);
        string2 = Utility.methodSignatureToString(string2, super.getName(), string, true, this.getLocalVariableTable(super.getConstantPool()));
        StringBuilder stringBuilder = new StringBuilder(string2);
        for (Attribute attribute : this.getAttributes()) {
            if (attribute instanceof Code || attribute instanceof ExceptionTable) continue;
            stringBuilder.append(" [").append(attribute).append("]");
        }
        if (this.throws_vec.size() > 0) {
            for (String string3 : this.throws_vec) {
                stringBuilder.append("\n\t\tthrows ").append(string3);
            }
        }
        return stringBuilder.toString();
    }

    public MethodGen copy(String string, ConstantPoolGen constantPoolGen) {
        Method method = ((MethodGen)this.clone()).getMethod();
        MethodGen methodGen = new MethodGen(method, string, super.getConstantPool());
        if (super.getConstantPool() != constantPoolGen) {
            methodGen.setConstantPool(constantPoolGen);
            methodGen.getInstructionList().replaceConstantPool(super.getConstantPool(), constantPoolGen);
        }
        return methodGen;
    }

    public List<AnnotationEntryGen> getAnnotationsOnParameter(int n) {
        this.ensureExistingParameterAnnotationsUnpacked();
        if (!this.hasParameterAnnotations || n > this.arg_types.length) {
            return null;
        }
        return this.param_annotations[n];
    }

    private void ensureExistingParameterAnnotationsUnpacked() {
        if (this.haveUnpackedParameterAnnotations) {
            return;
        }
        Attribute[] attributeArray = this.getAttributes();
        Object object = null;
        Object object2 = null;
        for (Attribute attribute : attributeArray) {
            Object object3;
            if (!(attribute instanceof ParameterAnnotations)) continue;
            if (!this.hasParameterAnnotations) {
                object3 = new List[this.arg_types.length];
                this.param_annotations = object3;
                for (int i = 0; i < this.arg_types.length; ++i) {
                    this.param_annotations[i] = new ArrayList<AnnotationEntryGen>();
                }
            }
            this.hasParameterAnnotations = true;
            object3 = (ParameterAnnotations)attribute;
            if (object3 instanceof RuntimeVisibleParameterAnnotations) {
                object = object3;
            } else {
                object2 = object3;
            }
            ParameterAnnotationEntry[] parameterAnnotationEntryArray = ((ParameterAnnotations)object3).getParameterAnnotationEntries();
            for (int i = 0; i < parameterAnnotationEntryArray.length; ++i) {
                ParameterAnnotationEntry parameterAnnotationEntry = ((ParameterAnnotations)object3).getParameterAnnotationEntries()[i];
                List<AnnotationEntryGen> list = this.makeMutableVersion(parameterAnnotationEntry.getAnnotationEntries());
                this.param_annotations[i].addAll(list);
            }
        }
        if (object != null) {
            this.removeAttribute((Attribute)object);
        }
        if (object2 != null) {
            this.removeAttribute((Attribute)object2);
        }
        this.haveUnpackedParameterAnnotations = true;
    }

    private List<AnnotationEntryGen> makeMutableVersion(AnnotationEntry[] annotationEntryArray) {
        ArrayList<AnnotationEntryGen> arrayList = new ArrayList<AnnotationEntryGen>();
        for (AnnotationEntry annotationEntry : annotationEntryArray) {
            arrayList.add(new AnnotationEntryGen(annotationEntry, this.getConstantPool(), false));
        }
        return arrayList;
    }

    public void addParameterAnnotation(int n, AnnotationEntryGen annotationEntryGen) {
        Object object;
        this.ensureExistingParameterAnnotationsUnpacked();
        if (!this.hasParameterAnnotations) {
            object = new List[this.arg_types.length];
            this.param_annotations = object;
            this.hasParameterAnnotations = true;
        }
        if ((object = this.param_annotations[n]) != null) {
            object.add(annotationEntryGen);
        } else {
            ArrayList<AnnotationEntryGen> arrayList = new ArrayList<AnnotationEntryGen>();
            arrayList.add(annotationEntryGen);
            this.param_annotations[n] = arrayList;
        }
    }

    public static BCELComparator getComparator() {
        return bcelComparator;
    }

    public static void setComparator(BCELComparator bCELComparator) {
        bcelComparator = bCELComparator;
    }

    public boolean equals(Object object) {
        return bcelComparator.equals(this, object);
    }

    public int hashCode() {
        return bcelComparator.hashCode(this);
    }

    static final class BranchStack {
        private final Stack<BranchTarget> branchTargets = new Stack();
        private final Map<InstructionHandle, BranchTarget> visitedTargets = new HashMap<InstructionHandle, BranchTarget>();

        BranchStack() {
        }

        public void push(InstructionHandle instructionHandle, int n) {
            if (this.visited(instructionHandle)) {
                return;
            }
            this.branchTargets.push(this.visit(instructionHandle, n));
        }

        public BranchTarget pop() {
            if (!this.branchTargets.empty()) {
                BranchTarget branchTarget = this.branchTargets.pop();
                return branchTarget;
            }
            return null;
        }

        private BranchTarget visit(InstructionHandle instructionHandle, int n) {
            BranchTarget branchTarget = new BranchTarget(instructionHandle, n);
            this.visitedTargets.put(instructionHandle, branchTarget);
            return branchTarget;
        }

        private boolean visited(InstructionHandle instructionHandle) {
            return this.visitedTargets.get(instructionHandle) != null;
        }
    }

    static final class BranchTarget {
        final InstructionHandle target;
        final int stackDepth;

        BranchTarget(InstructionHandle instructionHandle, int n) {
            this.target = instructionHandle;
            this.stackDepth = n;
        }
    }
}

