/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class Unknown
extends Attribute {
    private byte[] bytes;
    private final String name;
    private static final Map<String, Unknown> unknown_attributes = new HashMap<String, Unknown>();

    static Unknown[] getUnknownAttributes() {
        Unknown[] unknownArray = new Unknown[unknown_attributes.size()];
        unknown_attributes.values().toArray(unknownArray);
        unknown_attributes.clear();
        return unknownArray;
    }

    public Unknown(Unknown unknown) {
        this(unknown.getNameIndex(), unknown.getLength(), unknown.getBytes(), unknown.getConstantPool());
    }

    public Unknown(int n, int n2, byte[] byArray, ConstantPool constantPool) {
        super((byte)-1, n, n2, constantPool);
        this.bytes = byArray;
        this.name = ((ConstantUtf8)constantPool.getConstant(n, (byte)1)).getBytes();
        unknown_attributes.put(this.name, this);
    }

    Unknown(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, (byte[])null, constantPool);
        if (n2 > 0) {
            this.bytes = new byte[n2];
            dataInput.readFully(this.bytes);
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitUnknown(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        if (super.getLength() > 0) {
            dataOutputStream.write(this.bytes, 0, super.getLength());
        }
    }

    public final byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final void setBytes(byte[] byArray) {
        this.bytes = byArray;
    }

    @Override
    public final String toString() {
        String string;
        if (super.getLength() == 0 || this.bytes == null) {
            return "(Unknown attribute " + this.name + ")";
        }
        if (super.getLength() > 10) {
            byte[] byArray = new byte[10];
            System.arraycopy(this.bytes, 0, byArray, 0, 10);
            string = Utility.toHexString(byArray) + "... (truncated)";
        } else {
            string = Utility.toHexString(this.bytes);
        }
        return "(Unknown attribute " + this.name + ": " + string + ")";
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        Unknown unknown = (Unknown)this.clone();
        if (this.bytes != null) {
            unknown.bytes = new byte[this.bytes.length];
            System.arraycopy(this.bytes, 0, unknown.bytes, 0, this.bytes.length);
        }
        unknown.setConstantPool(constantPool);
        return unknown;
    }
}

