/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class SourceFile
extends Attribute {
    private int sourcefile_index;

    public SourceFile(SourceFile sourceFile) {
        this(sourceFile.getNameIndex(), sourceFile.getLength(), sourceFile.getSourceFileIndex(), sourceFile.getConstantPool());
    }

    SourceFile(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, dataInput.readUnsignedShort(), constantPool);
    }

    public SourceFile(int n, int n2, int n3, ConstantPool constantPool) {
        super((byte)0, n, n2, constantPool);
        this.sourcefile_index = n3;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitSourceFile(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.sourcefile_index);
    }

    public final int getSourceFileIndex() {
        return this.sourcefile_index;
    }

    public final void setSourceFileIndex(int n) {
        this.sourcefile_index = n;
    }

    public final String getSourceFileName() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)super.getConstantPool().getConstant(this.sourcefile_index, (byte)1);
        return constantUtf8.getBytes();
    }

    @Override
    public final String toString() {
        return "SourceFile: " + this.getSourceFileName();
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        return (Attribute)this.clone();
    }
}

