/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Signature
extends Attribute {
    private int signature_index;

    public Signature(Signature signature) {
        this(signature.getNameIndex(), signature.getLength(), signature.getSignatureIndex(), signature.getConstantPool());
    }

    Signature(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, dataInput.readUnsignedShort(), constantPool);
    }

    public Signature(int n, int n2, int n3, ConstantPool constantPool) {
        super((byte)10, n, n2, constantPool);
        this.signature_index = n3;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitSignature(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.signature_index);
    }

    public final int getSignatureIndex() {
        return this.signature_index;
    }

    public final void setSignatureIndex(int n) {
        this.signature_index = n;
    }

    public final String getSignature() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)super.getConstantPool().getConstant(this.signature_index, (byte)1);
        return constantUtf8.getBytes();
    }

    private static boolean identStart(int n) {
        return n == 84 || n == 76;
    }

    private static void matchIdent(MyByteArrayInputStream myByteArrayInputStream, StringBuilder stringBuilder) {
        int n = myByteArrayInputStream.read();
        if (n == -1) {
            throw new RuntimeException("Illegal signature: " + myByteArrayInputStream.getData() + " no ident, reaching EOF");
        }
        if (!Signature.identStart(n)) {
            StringBuilder stringBuilder2 = new StringBuilder();
            int n2 = 1;
            while (Character.isJavaIdentifierPart((char)n)) {
                stringBuilder2.append((char)n);
                ++n2;
                n = myByteArrayInputStream.read();
            }
            if (n == 58) {
                myByteArrayInputStream.skip("Ljava/lang/Object".length());
                stringBuilder.append((CharSequence)stringBuilder2);
                n = myByteArrayInputStream.read();
                myByteArrayInputStream.unread();
            } else {
                for (int i = 0; i < n2; ++i) {
                    myByteArrayInputStream.unread();
                }
            }
            return;
        }
        StringBuilder stringBuilder3 = new StringBuilder();
        n = myByteArrayInputStream.read();
        do {
            stringBuilder3.append((char)n);
        } while ((n = myByteArrayInputStream.read()) != -1 && (Character.isJavaIdentifierPart((char)n) || n == 47));
        stringBuilder.append(stringBuilder3.toString().replace('/', '.'));
        if (n != -1) {
            myByteArrayInputStream.unread();
        }
    }

    private static void matchGJIdent(MyByteArrayInputStream myByteArrayInputStream, StringBuilder stringBuilder) {
        Signature.matchIdent(myByteArrayInputStream, stringBuilder);
        int n = myByteArrayInputStream.read();
        if (n == 60 || n == 40) {
            stringBuilder.append((char)n);
            Signature.matchGJIdent(myByteArrayInputStream, stringBuilder);
            while ((n = myByteArrayInputStream.read()) != 62 && n != 41) {
                if (n == -1) {
                    throw new RuntimeException("Illegal signature: " + myByteArrayInputStream.getData() + " reaching EOF");
                }
                stringBuilder.append(", ");
                myByteArrayInputStream.unread();
                Signature.matchGJIdent(myByteArrayInputStream, stringBuilder);
            }
            stringBuilder.append((char)n);
        } else {
            myByteArrayInputStream.unread();
        }
        n = myByteArrayInputStream.read();
        if (Signature.identStart(n)) {
            myByteArrayInputStream.unread();
            Signature.matchGJIdent(myByteArrayInputStream, stringBuilder);
        } else {
            if (n == 41) {
                myByteArrayInputStream.unread();
                return;
            }
            if (n != 59) {
                throw new RuntimeException("Illegal signature: " + myByteArrayInputStream.getData() + " read " + (char)n);
            }
        }
    }

    public static String translate(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Signature.matchGJIdent(new MyByteArrayInputStream(string), stringBuilder);
        return stringBuilder.toString();
    }

    public static boolean isFormalParameterList(String string) {
        return string.startsWith("<") && string.indexOf(58) > 0;
    }

    public static boolean isActualParameterList(String string) {
        return string.startsWith("L") && string.endsWith(">;");
    }

    @Override
    public final String toString() {
        String string = this.getSignature();
        return "Signature: " + string;
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        return (Attribute)this.clone();
    }

    private static final class MyByteArrayInputStream
    extends ByteArrayInputStream {
        MyByteArrayInputStream(String string) {
            super(string.getBytes());
        }

        final String getData() {
            return new String(this.buf);
        }

        final void unread() {
            if (this.pos > 0) {
                --this.pos;
            }
        }
    }
}

