/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.ElementValue;
import java.io.DataOutputStream;
import java.io.IOException;

public class ElementValuePair {
    private final ElementValue elementValue;
    private final ConstantPool constantPool;
    private final int elementNameIndex;

    public ElementValuePair(int n, ElementValue elementValue, ConstantPool constantPool) {
        this.elementValue = elementValue;
        this.elementNameIndex = n;
        this.constantPool = constantPool;
    }

    public String getNameString() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constantPool.getConstant(this.elementNameIndex, (byte)1);
        return constantUtf8.getBytes();
    }

    public final ElementValue getValue() {
        return this.elementValue;
    }

    public int getNameIndex() {
        return this.elementNameIndex;
    }

    public String toShortString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getNameString()).append("=").append(this.getValue().toShortString());
        return stringBuilder.toString();
    }

    protected void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.elementNameIndex);
        this.elementValue.dump(dataOutputStream);
    }
}

