/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.InputStreamReader;

public class HardInfo {
    private static Boolean isLinux() {
        return HardInfo.isMac() == false && HardInfo.isWindows() == false;
    }

    private static Boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.toLowerCase().startsWith("win");
    }

    private static Boolean isMac() {
        String os = System.getProperty("os.name");
        return os.toLowerCase().startsWith("mac");
    }

    private static String getMACAddressByLinux() throws Exception {
        String line;
        String[] cmd = new String[]{"ifconfig"};
        Process process = Runtime.getRuntime().exec(cmd);
        process.waitFor();
        BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        String str1 = sb.toString();
        String str2 = str1.split("ether")[1].trim();
        String result = str2.split("txqueuelen")[0].trim();
        br.close();
        return result;
    }

    private static String getIdentifierByLinux() throws Exception {
        String line;
        String[] cmd = new String[]{"fdisk", "-l"};
        Process process = Runtime.getRuntime().exec(cmd);
        process.waitFor();
        BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        String str1 = sb.toString();
        String str2 = str1.split("identifier:")[1].trim();
        String result = str2.split("Device Boot")[0].trim();
        br.close();
        return result;
    }

    private static String getMACAddressByMac() throws Exception {
        String line;
        String[] cmd = new String[]{"ifconfig"};
        Process process = Runtime.getRuntime().exec(cmd);
        process.waitFor();
        BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        String str1 = sb.toString();
        String str2 = str1.split("ether")[1].trim();
        String result = str2.split("\t")[0].trim();
        br.close();
        return result;
    }

    private static String getMACAddressByWindows() throws Exception {
        String line;
        String result = "";
        Process process = Runtime.getRuntime().exec("ipconfig /all");
        BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream(), "GBK"));
        int index = -1;
        while ((line = br.readLine()) != null) {
            index = line.toLowerCase().indexOf("\u7269\u7406\u5730\u5740");
            if (index < 0) continue;
            index = line.indexOf(":");
            if (index < 0) break;
            result = line.substring(index + 1).trim();
            break;
        }
        br.close();
        return result;
    }

    private static String getIdentifierByWindows() throws Exception {
        String line;
        String result = "";
        Process process = Runtime.getRuntime().exec("cmd /c dir C:");
        BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream(), "GBK"));
        while ((line = br.readLine()) != null) {
            if (line.indexOf("\u5377\u7684\u5e8f\u5217\u53f7\u662f ") == -1) continue;
            result = line.substring(line.indexOf("\u5377\u7684\u5e8f\u5217\u53f7\u662f ") + "\u5377\u7684\u5e8f\u5217\u53f7\u662f ".length(), line.length());
            break;
        }
        br.close();
        return result;
    }

    public static String getMACAddress() {
        try {
            if (HardInfo.isLinux().booleanValue()) {
                return HardInfo.getMACAddressByLinux();
            }
            if (HardInfo.isMac().booleanValue()) {
                return HardInfo.getMACAddressByMac();
            }
            if (HardInfo.isWindows().booleanValue()) {
                return HardInfo.getMACAddressByWindows();
            }
            return "unknown-os";
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }
}

