/*
 * Decompiled with CFR 0.152.
 */
package sos.preview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import sos.preview.MatrixLayout;

class Utility {
    private Utility() {
    }

    static void checkHorizontalAlignment(int i) {
        if (i != 2 && i != 0 && i != 4 && i != 10 && i != 11) {
            throw new IllegalArgumentException("Invalid horizontal alignment");
        }
    }

    static void checkMargins(int i, int j, int k, int l) {
        if (i < 0 || j < 0 || k < 0 || l < 0) {
            throw new IllegalArgumentException("Margins cannot be negative");
        }
    }

    static void checkNull(Object obj, String s) {
        if (obj == null) {
            throw new NullPointerException(String.valueOf(s) + " cannot be null");
        }
    }

    static void checkSpacing(int i, int j) {
        if (i < 0 || j < 0) {
            throw new IllegalArgumentException("Spacing cannot be negative");
        }
    }

    static void checkVerticalAlignment(int i) {
        if (i != 1 && i != 3 && i != 0) {
            throw new IllegalArgumentException("Invalid vertical alignment");
        }
    }

    static int computeHashCode(int i, int j, int k, int l, int i1, int j1, int k1, int l1) {
        return i * 31 + j * 31 + k * 31 + l * 31 + i1 * 31 + j1 * 31 + k1 * 31 + l1 * 31;
    }

    static void initDefault(Object obj, Object obj1) {
        Object obj2 = UIManager.get(obj);
        if (obj2 == null) {
            UIManager.put(obj, obj1);
        }
    }

    static void installDefaultBackground(Component component, Object obj) {
        Color color = component.getBackground();
        if (color == null || color instanceof UIResource) {
            Color color1 = UIManager.getColor(obj);
            component.setBackground(color1);
        }
    }

    static void installDefaultForeground(Component component, Object obj) {
        Color color = component.getForeground();
        if (color == null || color instanceof UIResource) {
            Color color1 = UIManager.getColor(obj);
            component.setForeground(color1);
        }
    }

    static boolean isOnePageLayout(LayoutManager layoutmanager) {
        if (!(layoutmanager instanceof MatrixLayout)) {
            return false;
        }
        MatrixLayout matrixlayout = (MatrixLayout)layoutmanager;
        return matrixlayout.getRowCount() == 1 && matrixlayout.getColumnCount() == 1;
    }

    static Cursor loadCursor(Object obj, String s, Point point, String s1) {
        Image image = Utility.loadImage(obj, s);
        if (image == null) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Cursor cursor = toolkit.createCustomCursor(image, point, s1);
        return cursor;
    }

    static ImageIcon loadIcon(Object obj, String s) {
        Image image = Utility.loadImage(obj, s);
        if (image == null) {
            return null;
        }
        ImageIcon imageicon = new ImageIcon(image);
        return imageicon;
    }

    static Image loadImage(Object obj, String s) {
        ClassLoader classloader = obj.getClass().getClassLoader();
        URL url = classloader.getResource(s);
        if (url == null) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.createImage(url);
        return image;
    }

    static void uninstallDefaultBackground(Component component) {
        Color color = component.getBackground();
        if (color instanceof UIResource) {
            component.setBackground(null);
        }
    }

    static void uninstallDefaultForeground(Component component) {
        Color color = component.getForeground();
        if (color instanceof UIResource) {
            component.setForeground(null);
        }
    }
}

