

/**
 * 对Date的扩展，将 Date 转化为指定格式的String
 // 月(M)、日(d)、小时(h)、分(m)、秒(s)、季度(q) 可以用 1-2 个占位符，
 // 年(y)可以用 1-4 个占位符，毫秒(S)只能用 1 个占位符(是 1-3 位的数字)
 // 例子：
 // (new Date()).Format("yyyy-MM-dd HH:mm:ss.S") ==> 2006-07-02 08:09:04.423
 // (new Date()).Format("yyyy-M-d H:m:s.S")      ==> 2006-7-2 8:9:4.18

 * @param fmt
 * @returns {*}
 * @constructor
 */
Date.prototype.Format = function (fmt) { //author: meizz
    var o = {
        "M+": this.getMonth() + 1, //月份
        "d+": this.getDate(), //日
        "H+": this.getHours(), //小时
        "m+": this.getMinutes(), //分
        "s+": this.getSeconds(), //秒
        "q+": Math.floor((this.getMonth() + 3) / 3), //季度
        "S": this.getMilliseconds() //毫秒
    };
    if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
    for (var k in o)
        if (new RegExp("(" + k + ")").test(fmt))
        {
            fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
        }
    return fmt;
}


/**
 *js中更改日期
 * y年， M月， d日， H小时， m分钟，s秒
 */
Date.prototype.add = function (part, value) {
    value *= 1;
    if (isNaN(value)) {
        value = 0;
    }
    switch (part) {
        case "y":
            this.setFullYear(this.getFullYear() + value);
            break;
        case "M":
            this.setMonth(this.getMonth() + value);
            break;
        case "d":
            this.setDate(this.getDate() + value);
            break;
        case "H":
            this.setHours(this.getHours() + value);
            break;
        case "m":
            this.setMinutes(this.getMinutes() + value);
            break;
        case "s":
            this.setSeconds(this.getSeconds() + value);
            break;
        default:

    }
    return this;
}

Date.prototype.clone=function(){
    return new Date(this.valueOf());
}

/*
 * 方法:Array.removeAt(Index)
 * 功能:删除数组元素.
 * 参数:Index删除元素的下标.
 * 返回:在原数组上修改数组
 */

Array.prototype.removeAt = function (Index) {
    if (isNaN(Index) || Index > this.length) return false;
    this.splice(Index, 1);

}

/*
 * 方法:Array.remove(obj)
 * 功能:删除数组元素.
 * 参数:要删除的对象.
 * 返回:在原数组上修改数组
 */

Array.prototype.remove = function (obj) {
    if (null == obj)
    {return;}
    for (var i = 0; i < this.length; i++)
    {
        var o = this[i];
        if (typeof o === 'object')
        {
            if (o['equals'])
            {
                if (o.equals(obj))
                {
                    this.splice(i, 1);
                    return;
                }
            }
        }

        if (this[i] == obj)
        {
            this.splice(i, 1);
            return;
        }
    }

}

/*
 * 方法:Array.Contains(obj)
 * 功能:确定某个元素是否在数组中.
 * 参数:要查找的Object对象
 * 返回:找到返回true,否则返回false;
 */
Array.prototype.contains = function (obj) {
    if (null == obj)
    {return;}
    for (var i = 0, n = 0; i < this.length; i++)
    {
        var o = this[i];
        if (o == undefined) continue;

        if (typeof o === 'object')
        {
            if (o['equals'])
            {
                if (o.equals(obj)) return true;
            }
        }

        if (this[i] == obj)
        {
            return true;
        }
    }

    return false;
}

Array.prototype.get = function (index) {
    return this[index];
}

/*
 * 方法:Array.IndexOf(obj)
 * 功能:搜索指定的Object,并返回第一个匹配项从零开始的索引
 * 参数:要查找的Object对象
 * 返回:找到返回该元素在数组中的索引,否则返回-1
 */
Array.prototype.indexOf = function (obj) {
    if (null == obj)
    {return -1;}

    for (var i = 0, n = 0; i < this.length; i++)
    {

        var o = this[i];
        if (o == null) continue;
        if (typeof o === 'object')
        {
            if (o['equals'])
            {
                if (o.equals(obj)) return i;
            }
        }

        if (this[i] == obj)
        {
            return i;
        }
    }


    return -1;
}


/*
 * 方法:Array.Clear()
 * 功能:消空数组元素.
 * 参数:无.
 * 返回:空数组
 */
Array.prototype.clear = function () {
    this.length = 0;
}


String.prototype.endsWith = function (s) {
    if (s == null || s == "" || this.length == 0 || s.length > this.length)
    {
        return false;
    }
    if (this.substring(this.length - s.length) == s)
    {
        return true;
    } else
    {
        return false;
    }
    return true;
}
String.prototype.startsWith = function (s) {
    if (s == null || s == "" || this.length == 0 || s.length > this.length)
    {
        return false;
    }
    if (this.substr(0, s.length) == s)
    {
        return true;
    } else
    {
        return false;
    }
    return true;
}
String.prototype.equalsIgnoreCase = function (s) {
    if (s == null) return false;
    if (this.length != s.length) return false;
    if (this == s) return true;
    return this.toLowerCase() == s.toLowerCase();
}

String.prototype.equals = function (s) {
    if (s == null) return false;
    return this == s;
}

String.prototype.trim = function () {
    return this.replace(/(^\s*)|(\s*$)/g, "");
}
String.prototype.ltrim = function () {
    return this.replace(/(^\s*)/g, "");
}
String.prototype.rtrim = function () {
    return this.replace(/(\s*$)/g, "");
}



//https://www.cnblogs.com/ranyonsue/p/11388281.html

Number.prototype.toFixed = function (n) {

    if (n > 20 || n < 0) {

        throw new RangeError('toFixed() digits argument must be between 0 and 20');

    }

    const number = this;

    if (isNaN(number) || number >= Math.pow(10, 21)) {

        return number.toString();

    }

    if (typeof (n) == 'undefined' || n == 0) {

        return (Math.round(number)).toString();

    }


    var bigThenZero= number>0;

    var result = number.toString();

    const arr = result.split('.');



    // 整数的情况

    if (arr.length < 2) {

        result += '.';

        for (var i = 0; i < n; i += 1) {

            result += '0';

        }

        return result;

    }



    const integer = arr[0];

    const decimal = arr[1];

    if (decimal.length == n) {

        return result;

    }

    if (decimal.length < n) {

        for (var i = 0; i < n - decimal.length; i += 1) {

            result += '0';

        }

        return result;

    }

    result = integer + '.' + decimal.substr(0, n);

    const last = decimal.substr(n, 1);



    // 四舍五入，转换为整数再处理，避免浮点数精度的损失

    if (parseInt(last, 10) >= 5) {

        const x = Math.pow(10, n);

        result = (Math.round((parseFloat(result) * x)) +  (bigThenZero?1:-1)) / x;

        result = result.toFixed(n);

    }

    return result;

}
