/**
 * @author 981258592@qq.com
 * @date 2020-04-19 11:27
 * @description
 */
var AJAX = (function () {
    var ajax = function (opt) {
        var url = opt.url
        var asyncCall = opt.asyncCall || false// 缺省是同步
        var method = (opt.type || 'GET').toUpperCase()
        var data = opt.data || null
        var success = opt.success || function () {
        }
        var failure = opt.failure || function () {
        }
        var timeout = opt.timeout || 1000 * 300
        var isTimeout = false
        var xhr = window.XMLHttpRequest ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP')
        xhr.onreadystatechange = function () {
            console.log(xhr);
            if (xhr.readyState === 4) {
                var s = xhr.status
                if (s >= 200 && s < 300 || s === 304) {
                    success(xhr.responseText)
                } else {
                    failure(xhr.responseText)
                }
            } else {
                if (isTimeout) {
                    clearTimeout(timer)
                    failure('timeout')
                }
            }
        }
        var time = false// 是否超时
        var timer = setTimeout(function () {
            isTimeout = true
            xhr.abort()// 请求中止
        }, timeout)
        // 当是get方式时，请直接拼好data ,这里不接受json对象
        if (method === 'GET' && data) {
            url += (url.indexOf('?') == -1 ? '?' : '&') + data
            data = null
        }
        xhr.withCredentials = opt.withCredentials || false
        xhr.open(method, url, asyncCall)
        if (method == 'POST') {
            xhr.setRequestHeader('Content-type', 'application/json')
        }
        // 超级大坑，如果不转换成String，那么会出现cors错误
        if (typeof (data) === 'string') {
            xhr.send(data)
        } else if (typeof (data) === 'object') {
            xhr.send(JSON.stringify(data))
        }
        return xhr
    }

    var get = function (url, data, success, dataType, asyncCall) {
        return ajax({ url: url, data: data, success: success, dataType: dataType, asyncCall: asyncCall })
    }
    var post = function (url, data, success, dataType, asyncCall) {
       return ajax({ type: 'POST', url: url, data: data, success: success, dataType: dataType, asyncCall: asyncCall })
    }
    var ret = {
        ajax: ajax,
        get: get,
        post: post
    }
    return ret
}())

function runTask (taskCode, param, callback) {
    var ret = ''
    var asyncCall = false// 缺省是同步调用
    if (!callback) {
        callback = function (data) {
            ret = data || ''
        }
    } else {
        asyncCall = true // 异步
    }
    /*
    let homeURL = 'http://47.98.250.62/gngw/' // 服务器地址
*/
    let homeURL = './' // 服务器地址
    AJAX.post(homeURL + 'runtask?rawdata=true&task=' + taskCode, param, callback, 'text', asyncCall)
    return ret
}
