/**
 * 单元格绘制事件
 *
 * 单元格由系统进行渲染，当单元格需要自定义渲染时，需要设置 cell.drawInScript =true . 当单元格由系统
 * 渲染前，本事件会触发（before参数为true) ，此时可以进行背景层的自绘。 然后系统进行渲染，最后再次
 * 调用本事件（before参数为false) ,可以自定义前景层的自绘。可以这么理解，先进行背景层的自绘，然后系统
 * 渲染会盖在之上， 最后前景层的自绘盖在最上面。
 *
 * 由于渲染操作是比较消耗资源（CPU）的操作，因此默认情况下，单元格是不允许自绘的。除非明显的设置
 *  someCell.drawInScript=true
 *
 * @param sheet  工作表
 * @param cell  单元格
 * @param innerRow   当单元格没有绑定数据库或绑定到单行数据库时，本参数无意义。如果绑定一个
 * 多行数据库，则表示该单元所绑定的字段的第 innerRow行需要绘制
 * @param g  图形设备对象，它提供绘图函数用来绘制
 * @param rect  单元格占据的矩形区域
 * @param data 当前需要绘制的数据
 *  @param str  数据转换成的字符串
 *  @param  before   ： true 表示本事件是在单元格由系统绘制完成前执行 ， false表示本事件是在单元格由系统绘制完成后执行
 *
 */
function cellPaint (sheet, cell, innerRow, g, rect, data, str , before) {

    if (cell.alias == 'XXX' &&  before) {

        //画一条对角线
        //g.moveTo( rect.x , rect.y);
        //g.lineTo( rect.x+ rect.width , rect.y + rect.height);

        //画一个圆角矩形边框
        g.setColor("green");
        g.strokeRoundRect(rect.x, rect.y, rect.width-1, rect.height-1 , 5);

    }
}
