/**
 * 当结果集需要检索时，系统自动从数据库中检索数据。有一些数据，可能有并非是直接从数据库中获取，或者需要做一些整理后
 * 再返回给前端。可以在此事件中做这样的定制
 *
 * @param dbpool 数据库连接池名称
 * @param dsname 结果集名称
 * @param sql  结果集定义SQL语句
 * @param where  字符串数组，前端传过来的检索条件，或有效的前端动态检索条件
 * @param onceRetrieveCount  每次检索的数据行数， 0 表示不分页，需要检索出所有符合条件的数据
 * @param startRowNo  符合条件的数据，从startRowNo开始返回给前端 ，此参数与onceRetrieveCount用来控制分页,
 *                                当onceRetrieveCount=0时， startRowNo也没有意义
 *
 *
 * @return   返回值是这样的一个JSON对象
 * { success:true,
 *   message:'' ,
 *   data: [ {rowData} ,{rowData} ....]  ,
 *   DBRowCount: 1000 }
 * success=true表示检索数据操作成功，
 * 返回的数据放在data中 ，data是一个数组， 每行是一个JSON对象， 其中的属性名即字段名，属性值即字段的数据
 * DBRowCount 是可选返回值，可以返回，也可以不返回。它表示按当前检索条件可以检索出的所有数据的行数，它传递给前端用于分页处理。
 *
 *  如果 success 设置成false ,则在 message中放置错误提示信息
 *
 * @example   返回值示例
 *     { success:true, message:""
 *        data: [ { name:'a', code:1},
 *                 { name:'b', code:2},
 *                  { name:'c', code:3} .....
 *        ] ,
 *
 *        DBRowCount: 1000  //可选属性，按需要返回或不返回
 *
 *     }
 *
 *
 */

//特别注意：请修改 xxxx为实际的结果集名称
function xxxxRetrieveOnServer ( dbpool, dsname , sql  , where , onceRetrieveCount , startRowNo) {
    //println(dbpool);
    //println(dsname);
    //println(dsname);
    //println(JSON.stringify(where));
    //println(onceRetrieveCount);
    //println(startRowNo);

    // 在此定制数据检索

    var pageIndex = Math.floor(startRowNo / onceRetrieveCount) + 1; //页码

    var data=[] ; //

    var ret= { success:true,
                message:"",
                data: data };

    //当不只一页数据时，请返回能得到的数据总行数 DBRowCount，它被用于前端做分页处理
    // 当计算DBRowCount 比较耗时时，在本事件中可以不返回DBRowCount
    // 当前端需要DBRowCount数据时，会异步触发 xxxxDBRowCountOnServer 事件来异步获取
    // 下面这一行，酌情处理，或删除
    ret.DBRowCount = ret.data.length ;

    return ret;

}
