/**
 * 当结果集需要分页显示时，需要知道它最多有多少行数据，用于前端计算分页
 *
 * @param dbpool 数据库连接池名称
 * @param dsname 结果集名称
 * @param sql  结果集定义SQL语句
 * @param where  字符串数组，前端传过来的检索条件，或有效的前端动态检索条件
 *
 *
 * @return   返回值是这样的一个JSON对象
 * { success:true,
 *   message:'' ,
 *   DBRowCount: 1000 }
 * success=true表示检索数据操作成功，
 * DBRowCount  表示按当前检索条件可以检索出的所有数据的行数，它传递给前端用于分页处理。
 *
 *  如果 success 设置成false ,则在 message中放置错误提示信息
 *
 * @example   返回值示例
 *     { success:true, message:""
 *        DBRowCount: 1000
 *
 *     }

 *
 */

//特别注意：请修改 xxxx为实际的结果集名称
function xxxxDBRowCountOnServer ( dbpool, dsname , sql  , where  ) {
    //println(dbpool);
    //println(dsname);
    //println(dsname);
    //println(JSON.stringify(where));


    //如果总行数无法返回或很难计算或很耗时，但又需要分页处理，请直接将DBRowCount 设置成一个较大的数，比如设置成可能的页数*每页数据条数
    // 这样至少可以大至分页，又不会因计算总行数而花太多时间
    //当页数很多时， 页数精不精确就不是很重要
    return { success:true,
                message:"",
                DBRowCount: 0 }; // 0换成实际的数据行数，

}
