/**
 * 单据点击保存，前端所有的操作被转译成3种操作:insert , delete , update ,本函数是针对要更新数据做校验：
 * 1 如果在一张单据中有多张表多行数据被修改，单据保存时针对每一行需要更新的数据执行一次本函数。有几条数据要被更新，本函数就执行几次
 *
 * @param dsname 要更新数据的表
 * @param gguid  要删除记录的gguid ，等同于主表的id
 * @param oldValue  是一个JSON对象 ，属性名即字段名， 属性值是字段在更新前的值,注意数据值都转换成了字符串
 * @param newValue  是一个JSON对象 ，属性名即字段名， 属性值是字段需要更新为的值 ,注意数据值都转换成了字符串
 * @param primaryKey   JSON对象，属性名即表的主键字段名，属性值即字段的值
 * @param where   数组 , 更新操作的Where条件， 每个数据项即表示一个where条件，多个条件最终以 and 关系串联
 * @param session  一个JSON对象，用于在整个单据保存过程中的各个事件之间传递数据。各个事件
 * 脚本虽然写在一起，但它们是按顺序在服务器上分开独立执行的，各个事件可能并不是在同一个脚本
 * 引擎中执行，如果对session做了写的操作，必须在返回值中
 * 将它返回，系统将它做为参数传递到下一个事件中
 *
 * @return   返回值是这样的一个JSON对象
 * { success:true, message:'' , value: newValue,  where: where} 表示校验通过，并且使用 where 中的条件做更新数据时的条件，多个条件是and关系
 *  使用 value 中的数据更新数据库。注意 value 中的字段对应的数据，必须是格式化后的数据，比如字符串，前后需要一对单引号括起来， 日期型数据需要转换
 *  成数据库能识别的格式。
 *
 * 如果 success 设置成false ,则在 message中放置错误提示信息，此时整个单据保存操作被立即终止
 *
 */
function updateCheckWhenBillSaveOnServer(dsname, gguid, oldValue, newValue, primaryKey, where, session) {

    //println(dsname);
    //println(gguid);
    //println(JSON.stringify(oldValue));
    //println(JSON.stringify(newValue));
    //println(JSON.stringify(primaryKey));
    //println(JSON.stringify(where));

    // 下面演示追加一个更新限制条件
    // if ( dsname=='testTable' )  where.push( "  state= 0 ") ;   表示仅允许更新 state=0的数据

    //下面演示通过修改newValue 来强制更新某个字段的数据
    //     newValue.birthday= "'2010.01.01'";  //注意双引号内还有一对单引号
    //     newValue.name= "'abc'";  //注意双引号内还有一对单引号
    //     newValue.age= "20";  //注意即使是数字型字段，也要转换成字符串格式
    //
    //


    return {
        success: true,
        message: "",
        session: session,
        value: newValue,
        where: where
    };

}
