/**
 * 单据点击保存，前端所有的操作被转译成3种操作:insert , delete , update ,
 * 在执行前，可以在本事件中预览它们。
 *
 * 如果单据涉及多个数据库连接时，针对每个连接，本事件都会执行一次。只要在任意一次执行返回值中设置success为false，
 * 整个单据保存操作就被终止
 *
 * @param dbpool 连接池
 * @param sql  是要执行的SQL语句的数组
 * @param session  一个JSON对象，用于在整个单据保存过程中的各个事件之间传递数据。本事件做为一个数据预览事件，
 * 即使在此事件中对session对象做了写操作，系统也会忽略
 *
 *
 * @return   返回值是这样的一个JSON对象
 * { success:true, message:''  } 表示没啥间见，继续执行吧
 *
 * 如果 success 设置成false ,则在 message中放置错误提示信息，此时整个单据保存操作被立即终止
 * 这么做只有一个目的：出于调试目的，只想预览一下系统将会做什么
 *
 */
function  sqlPreviewWhenBillSaveOnServer ( dbpool , sql ,session) {

    println(dbpool);
    println(JSON.stringify(sql));

    return { success:false,   //阻止操作
                message:"只想预览一下"  };

}
