/**
 * 单据点击保存，前端所有的操作被转译成3种操作:insert , delete , update ,本函数是针对新插入的数据做校验：
 * 1 针对单据保存操作中需要新插入数据库的每一行数据执行一次本函数。有几条数据需要插入，本函数就执行几次
 *
 * 2 sqlData并不一定包含所有的字段，而是仅包含有数据的字段.
 *
 * @param dsname 要插入的表
 * @param gguid  当表是单据主表时，表示主表.id 或主表.gguid ,如果是明细表，表示是明细表.gguid
 * @param sqlData 是一个JSON对象 ，属性名即字段名， 属性值是字符串化后的数据（ 字符型数据，前后由单引号括起来，日期型数据会根据不同的数据库，格式化成不同的格式）。如果修改，请保持格式不变）
 * @param session  一个JSON对象，用于在整个单据保存过程中的各个事件之间传递数据。各个事件
 * 脚本虽然写在一起，但它们是按顺序在服务器上分开独立执行的，各个事件可能并不是在同一个脚本
 * 引擎中执行，如果对session做了写的操作，必须在返回值中
 * 将它返回，系统将它做为参数传递到下一个事件中
 *
 * @return   返回值是这样的一个JSON对象
 * { success:true, message:'' , data: sqlData} 表示校验通过，并且使用sqlData中的数据插入到数据库中
 *
 * 如果 success 设置成false ,则在 message中放置错误提示信息，此时整个单据保存操作被立即终止
 *
 * @example   sqlData示例：
 *     { "no":"1234" ,  //no是数字，转换成字符后，就是简单的字符串
 *        "code": "'abcd'" ,  //  code 是字符型 ， 转换成字符串后，前后有单引号
 *        "birthday", "'2000.01.01'"     // birthday是日期型 ， 在大多数数据库中，它需要用单引号括起来
 *     }
 */
function insertCheckWhenBillSaveOnServer(dsname, gguid, sqlData, session) {

    //println(dsname);
    //println(JSON.stringify(sqlData));

    return {
        success: true,
        message: "",
        session: session,
        data: sqlData
    };

}
