/**
 * 单据点击保存，前端所有的操作被转译成3种操作:insert , delete , update ,本函数是针对要删除的数据做校验：
 * 1 如果在一张单据中有多张表删除了多行数据，单据保存时针对每一行需要删除的数据执行一次本函数。有几条数据要被删除，本函数就执行几次
 *
 * @param dsname 要删除数据的表
 * @param gguid  要删除记录的gguid ，等同于主表的id
 * @param primaryKey   JSON对象，属性名即表的主键字段名，属性值即字段的值
 * @param where   数组 , 删除操作的Where条件， 每个数据项即表示一个where条件，多个条件最终以 and 关系串联
 * @param session  一个JSON对象，用于在整个单据保存过程中的各个事件之间传递数据。各个事件
 * 脚本虽然写在一起，但它们是按顺序在服务器上分开独立执行的，各个事件可能并不是在同一个脚本
 * 引擎中执行，如果对session做了写的操作，必须在返回值中
 * 将它返回，系统将它做为参数传递到下一个事件中
 *
 *
 * @return   返回值是这样的一个JSON对象
 * { success:true, message:'' , where: where} 表示校验通过，并且使用 where 中的条件做删除数据时的条件，多个条件是and关系
 *
 * 如果 success 设置成false ,则在 message中放置错误提示信息，此时整个单据保存操作被立即终止
 *
 */
function deleteCheckWhenBillSaveOnServer(dsname, gguid, primaryKey, where, session) {

    //println(dsname);
    //println(gguid);
    //println(JSON.stringify(primaryKey));
    //println(JSON.stringify(where));

    // 下面演示追加一个删除限制条件
    // if ( dsname=='testTable' )  where.push( "  state= 0 ") ;   表示仅允许删除 state=0的数据

    //下面演示如果发现删除的是 state=1的数据，则直接终止操作
    /* if ( getIntFromSQL("select state from "+dsname+" where  id='"+ primaryKey.id+"' ")==1)
    {
        return { success:false , message:'已被锁定，禁止删除' } ;
    }*/


    return {
        success: true,
        message: "",
        session: session,
        where: where
    };

}
