/**
 * 单据点击保存，前端所有的操作被转译成3种操作:insert , delete , update ,
 * 在执行这些语句前，可以在本事件中，串接一些操作。
 *
 * @param gguid  要删除记录的gguid ，等同于主表的id
 * @param session  一个JSON对象，用于在整个单据保存过程中的各个事件之间传递数据。各个事件
 * 脚本虽然写在一起，但它们是按顺序在服务器上分开独立执行的，各个事件可能并不是在同一个脚本
 * 引擎中执行，如果对session做了写的操作，必须在返回值中
 * 将它返回，系统将它做为参数传递到下一个事件中。本事件做为单据保存的最初触发的事件，session是一个没有属性的对象
 *
 *
 * @return   返回值是这样的一个JSON对象
 * { success:true,
 *    message:'' ,
 *    sql: { "default" : [ sql1, sql2 ...] ,
 *            "dbpool2": [sql1, sql2 ...]
 *         }
 * }
 *   success=true 表示继续执行后续的操作 ， 并且在执行单据保存前，先执行一些SQL语句。sql定义的规则：
 *   { 连接池名称1: [ SQL数组] , 连接池名称2: [ SQL数组] ....  }
 *
 *
 * 如果 success 设置成false ,则在 message中放置错误提示信息，此时整个单据保存操作被立即终止
 *
 */
function beforeBillSaveOnServer(gguid,session) {


    return {
        success: true,
        message: "",
        session: session,
        sql: {"default": []}
    };

}
