/**
 * 单据点击保存，前端所有的操作被转译成3种操作:insert , delete , update ,
 *  并且可以在  beforeBillSaveOnServer 中返回一些SQL语句，可以在afterBillSaveOnServer中返回一些SQL语句
 *
 * 系统分别在需要的数据库连接中执行这些语句 ， 当所有语句执行成功后，事件被提交。一些细节如下 ：
 *
 * 1 如果单据中的表，属于不同的数据库连接，那么所有的SQL语句会以连接为单位，对语句进行批量执行
 * 2 这些语句的执行顺序是：对同一个数据库连接中的语句， 先执行 beforeBillSaveOnServer 中返回的SQL语句，再执行单据操作转译得到的SQL语句，
 *   再执行 afterBillSaveOnServer 中返回的SQL语句， 当多个（或一个）数据库连接执行完这些语句，且没有错误时，所有的数据库连接做提交，否则全部回滚
 * 3 不要在 beforeBillSaveOnServer 或 afterBillSaveOnServer 中直接执行数据库操作，而是返回SQL语句，让系统批量执行它们，并控制好事务
 * 4 当执行成功后，系统再执行事件函数  afterBillSaveSuccessfulOnServer 。 此事件中可以执行任意操作，它与单据保存事件结束后才被触发执行，
 *   与单据保存并不在一个事务中。
 *
 *
 * @param gguid  要删除记录的gguid ，等同于主表的id
 * @param session  一个JSON对象，用于在整个单据保存过程中的各个事件之间传递数据。本事件做为单据保存的最后一个事件，session对象在使用后将被丢弃
 *
 *
 * @return 本函数不需要返回值
 *
 */
function afterBillSaveSuccessfulOnServer ( gguid ,session ) {


}
