/**
 * 单据点击删除，服务端会将单据相关数据整理成一组delete语句 （语句1) ，
 *  并且可以在 beforeBillDeleteOnServer中返回一些SQL语句 (语句2），还可以在afterBillDeleteOnServer中返回一些SQL语句(语句3）
 *
 *   注意：本事件在服务端执行，不要试图访问任何前端UI信息
 *
 * 系统分别在需要的数据库连接中按 语句2，语句1 ，语句3 的顺序执行这些语句 ， 当所有语句执行成功后，事件被提交。一些细节如下 ：
 *
 * 1 如果单据中的表，属于不同的数据库连接，那么所有的SQL语句会以连接为单位，分别对语句进行批量执行
 * 2 这些语句的执行顺序是：对同一个数据库连接中的语句， 先执行beforeBillDeleteOnServer 中返回的SQL语句，再执行单据删除操作转译得到的SQL语句，
 *   再执行afterBillDeleteOnServer中返回的SQL语句， 当多个（或一个）数据库连接执行完这些语句，且没有错误时，所有的数据库连接做提交，否则全部回滚
 * 3 不要在 beforeBillDeleteOnServer或afterBillDeleteOnServer中直接执行数据库操作，而是返回SQL语句，让系统在事务中执行它们
 * 4 当执行成功后，系统再执行事件函数  afterBillDeleteSuccessfulOnServer 。 此事件中可以执行任意操作，它在单据删除事件结束后才被触发执行，
 *   与单据删除并不在一个事务中。
 *
 *
 * @param gguid  已删除记录的gguid ，等同于主表的id
 * @param session  一个JSON对象，用于在整个单据删除过程中的各个事件之间传递数据。各个事件
 * 脚本虽然写在一起，但它们是按顺序在服务器上分开独立执行的，各个事件可能并不是在同一个脚本
 * 引擎中执行，本事件估入脑单据删除的最后一个后端事件，session对象在使用后被丢弃。
 *
 * @return 本函数不需要返回值
 *
 */
function afterBillDeleteSuccessfulOnServer ( gguid , session ) {


}
