/**
 * 点击删除单据，在执行单据删除语句后（但尚未提交），系统在服务端触发本事件
 *
 *  可以在本事件中，注入一些操作，返回一组SQL，这此SQL与单据删除操作将在一个事务中执行。
 *
 * @notice 注意：本事件在服务端执行，不要试图访问任何前端UI信息。不要直接执行对数据库的写操作，如果需要
 * 请在返回值中返回这些语句，让系统把它们与单据删除并在一个事务中执行。
 *
 * @param gguid  要删除单据主记录的gguid ，等同于主表的id
 * @param session  一个JSON对象，用于在整个单据删除过程中的各个事件之间传递数据。各个事件
 * 脚本虽然写在一起，但它们是按顺序在服务器上分开独立执行的，各个事件可能并不是在同一个脚本
 * 引擎中执行，如果对session做了写的操作，必须在返回值中
 * 将它返回，系统将它做为参数传递到下一个事件中
 *
 * @return   返回值是这样的一个JSON对象
 * { success:true,
 *    message:'' ,
 *    sql: { "default" : [ sql1, sql2 ...] ,
 *            "dbpool2": [sql1, sql2 ...]
 *         }
 * }
 *   success=true 表示继续允许执行删除单据操作 ， 并且在执行单据删除后，执行一些SQL语句。sql定义的规则：
 *   { 连接池名称1: [ SQL数组] , 连接池名称2: [ SQL数组] ....  }
 *
 *
 * 如果 success 设置成false ,则在 message中放置错误提示信息，此时整个单据删除操作被立即终止
 *
 */
function afterBillDeleteOnServer(gguid, session) {


    return {
        success: true,
        message: "",
        session: session,
        sql: {"default": []}
    };

}

