/**
 * 当对某笔单据数据做修改后，列表模板中需要刷新这笔单据的数据，默认情况下系统用 " id='"+id+"' " 这样的条件
 * 从数据库中检索数据。如果列表模板中的结果集的SQL定义比较复杂，上述默认的条件可能无法检索出数据，此时
 * 可以在本事件中，返回正确的检索条件
 *
 *  注意：本函数仅在单据列表模板中使用，当编辑界面保存数据后，触发本事件
 * @param id  需要刷新检索的数据的ID
 * @returns {String} 返回一个字符串，系统使用它做where条件，来刷新检索ID={id}的数据
 */
function refreshRetrieveWhereDefine( id ) {

    return    `  id ='${id}' `;
    // return " id='"+ id+"'  " ;  // 本句等效于上面
}



