/**
*   判断某人（通常是当前操作人员）是否允许删除 ID=id的附件
*
*  @param：dbpool ： 附件信息保存在哪个数据库连接池中
 * @param：logTable：附件信息保存在哪个数据库表中
 * @param：id： 附件的ID，
 * @param：session：可以将一些需要的信息写入此对象中，它将传递给 afterAttachmentDeleteOnServer 事件
 *
 *  @return   返回值是这样的一个JSON对象
 * { success:true,
 *    message:'' ,
 *    reallyDeleteFile: true ,
 *    session:session
 * }
 *   success=true 表示继续允许执行删除附件操作 ，
 *   reallyDeleteFile =true 表示删除上传日志记录的同时，真的把文件也删除，false表示仅删除上传日志记录，文件保留不删除
 *
 * 如果 success 设置成false ,则在 message中放置错误提示信息，此时整个附件删除操作被立即终止
 *
* */
function  doesSomeonePermitToDeleteAttachment(dbpool , logTable , id ,session)
{
    var userid=currentUserId();



    return {
        success: true,
        message: "",
        reallyDeleteFile:false,
        session: session
    };


}