/**
 * 删除附件后，系统在服务端触发本事件
 *
 *  可以在本事件中，做一些附件删除后的操作
 *
 * @notice 注意：本事件在服务端执行，不要试图访问任何前端UI信息。
 *
 * @param data  删除的附件信息
 * @param session  一个JSON对象，用于在整个附件删除过程中的各个事件之间传递数据。各个事件
 * 脚本虽然写在一起，但它们是按顺序在服务器上分开独立执行的，各个事件可能并不是在同一个脚本
 * 引擎中执行，如果对session做了写的操作，必须在返回值中
 * 将它返回，系统将它做为参数传递到下一个事件中
 *
 * @return   无需返回值
 *
 */
function afterAttachmentDeleteOnServer(  data ,session  ) {

    println( JSON.stringify(  data));

}

