<%@ page import="wiseoa.util.FF" %>

<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="ss" uri="http://jun.zeng.com" %>
<%@include file="nocache.jsp" %>
<%@include file="rightverify.jsp" %>
<%

    String id = FF.getStringFromRequest(request, "id", "");
   

    response.setHeader("Pragma", "No-cache");
    response.setHeader("Cache-Control", "no-cache");
    response.setHeader("Expires", "0");

    String docHome = "";
    FF.pageContextSetAttribute(pageContext, "docHome", docHome);

        /*

        theme： https://editor.bitwiser.in/


         自定义提示
         https://microsoft.github.io/monaco-editor/playground.html#extending-language-services-completion-provider-example 官方提供的自定义提示示例

         自定义快捷键
         https://microsoft.github.io/monaco-editor/playground.html#interacting-with-the-editor-listening-to-key-events
         https://microsoft.github.io/monaco-editor/playground.html#interacting-with-the-editor-adding-a-command-to-an-editor-instance

         //在左边栏上加标记
         https://microsoft.github.io/monaco-editor/playground.html#interacting-with-the-editor-rendering-glyphs-in-the-margin

//自定义 theme
https://microsoft.github.io/monaco-editor/playground.html#customizing-the-appearence-tokens-and-colors


https://blog.csdn.net/prog_6103/article/details/89452217


          */
%>

<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <link rel="stylesheet" data-name="vs/editor/editor.main" href="ui/monaco-editor/min/vs/editor/editor.main.css">
</head>
<!-- 三段式布局-->
<style type="text/css">
    html, body {
        width: 100%;
        height: 100%;
        margin: 0;
        overflow: hidden
    }

    #Container {
        position: relative;
        width: 100%;
        height: 100%;
    }

    #Header {
        position: absolute;
        left: 0;
        top: 0;
        width: 100%;
        height: 32px;
        background-color: #dbdaef;
        border-bottom: 1px solid lightgrey;
    }

    #Content {
        position: absolute;
        width: 100%;
        left: 0;
        top: 33px;
        height: auto;
        bottom: 32px;
        background-color: white
    }

    #Footer {
        position: absolute;
        width: 100%;
        left: 0;
        height: 32px;
        bottom: 0;
        background-color: #efefef;
        border-top: 1px solid lightgrey;
    }

    .errorInfo {
        background-color: #ff9933;
        color: white
    }
</style>

<style>
    .breakpoints {
        background: red;
        background: radial-gradient(circle at 3px 3px, #ff999e, red);
        width: 10px !important;
        height: 10px !important;
        left: 36px !important;
        top: 4px;
        border-radius: 5px;
    }


    #outlineContainer1 {
        position: fixed;
        right: 0;
        top: 50px;
        width: 300px;
        height: 100%;
        display: none;
        font-size: 13px;
        background-color: red;
    }

    #outlineContainer .group{

        font-size: 14px;


        padding:10px;
        background-color: lightgrey;
    }

    #outlineContainer .func{

        font-size: 12px;
        line-height:20px;
        padding:10px;


    }
    #outlineContainer  .func .funcCaption{

        color:darkgreen;


    }


</style>



<script src="formEngine/js/core/jquery.min.1.10.2.js?ver=<ss:ver>formEngine/js/core/jquery.min.1.10.2.js</ss:ver>"></script>
<script src="formEngine/js/core/domutil.js?ver=<ss:ver>formEngine/js/core/domutil.js</ss:ver>"></script>
<script src="formEngine/js/core/jst.js?ver=<ss:ver>formEngine/js/core/jst.js</ss:ver>"></script>
<script src="formEngine/js/core/zrpc.js?ver=<ss:ver>formEngine/js/core/zrpc.js</ss:ver>"></script>

<link rel="stylesheet" href="formEngine/css/bootstrap.min.css?ver=<ss:ver>formEngine/css/bootstrap.min.css</ss:ver>">

<!-- 自动消失的提示信息  如果把下面两行，放在后面位置，则不能正常显示信息，原因不明-->
<link rel="stylesheet" href="formEngine/ui/toastr/toastr.css?ver=<ss:ver>formEngine/ui/toastr/toastr.css</ss:ver>">
<script src="formEngine/ui/toastr/toastr.min.js?ver=<ss:ver>formEngine/ui/toastr/toastr.min.js</ss:ver>"></script>


<!-- 简易css无需脚本菜单（单层弹出菜单） -->
<link type="text/css" href="ui/menu/simplemenu.css?ver=<ss:ver>ui/menu/simplemenu.css</ss:ver>" rel="stylesheet"/>
<!-- css字体 -->
<link rel="stylesheet" href="formEngine/css/font-awesome.css?ver=<ss:ver>formEngine/css/font-awesome.css</ss:ver>">

<!-- 语法树分析  -->
<script src="ui/orion/esprima.js?ver=<ss:ver>ui/orion/esprima.js</ss:ver>"></script>



<script>var require = {paths: {'vs': 'ui/monaco-editor/min/vs'}};</script>
<script src="ui/monaco-editor/min/vs/loader.js"></script>
<script src="ui/monaco-editor/min/vs/editor/editor.main.nls.js"></script>
<script src="ui/monaco-editor/min/vs/editor/editor.main.js"></script>
<script src="ui/monaco-editor/min/vs/editor/editor.main.nls.zh-cn.js"></script>


<!--  confirm -->
<link rel="stylesheet"
      href="formEngine/ui/confirm/dist/jquery-confirm.min.css?ver=<ss:ver>formEngine/ui/confirm/dist/jquery-confirm.min.css</ss:ver>">
<script src="formEngine/ui/confirm/dist/jquery-confirm.min.js?ver=<ss:ver>formEngine/ui/confirm/dist/jquery-confirm.min.js</ss:ver>"></script>

<script src="formEngine/globalscript/dialog.js?ver=<ss:ver>formEngine/globalscript/dialog.js</ss:ver>"></script>


<!-- 定制的一些功能  -->
<script src="js/app/scriptedit2.js?ver=<ss:ver>js/app/scriptedit2.js</ss:ver>"></script>


<script>

    var g_suggestions_globalscript = []; //全局函数的提示

    $(document).ready(function () {


        $(document).click( function(evt)
        {
            //在代码编辑区点击 ，则关闭大纲面板
            if( evt.target.className=='view-line')        $('#outlineContainer').css('display','none');

        });

        window.editor = monaco.editor.create(document.getElementById('editContainer'), {
            value: 'function ',
            language:  urlArgs.language||'javascript',
            fontFamily:'Consolas, Menlo, Monaco, Vera Mono',
            fontSize: "14px",

            scrollBeyondLastLine: true,
            theme: "vs" //皮肤设置  vs vs-dark hc-black
        });



        editor.addCommand(monaco.KeyMod.CtrlCmd | monaco.KeyCode.KEY_S, function () {
            save();
        });


        var docHome = 'doc';


        fetch('ui/monaco-editor/min/vs/themes/customize.json')
            .then(data => data.json())
            .then(data => {
                monaco.editor.defineTheme('customize', data);
                monaco.editor.setTheme('customize');
            });


        //加载函数帮助
        let docs=['Brick/doc', 'Cell/doc','ClientFunction','ColumnPropertyManage/doc','DataBuffer/doc',
            'DataSourceConfig/doc','DataStore/doc',
        'RowPropertyManage/doc','ServerFunction','WorkBook/doc','WorkSheet/doc'];

        for( var j=0;j<docs.length;j++) {
            fetch(docHome + "/repertory/library/object/" + docs[j] + "/api_data.json")
                .then(data => data.json())
                .then(data => {
                    for (var i = 0; i < data.length; i++) {
                        var one = data[i];
                        g_suggestions_globalscript.push(
                            {
                                label: one.name,
                                insertText: one.name,
                                kind: 2,
                                detail: one.name == one.title ? "" : one.title,
                                comment: one.description,
                                summary: one.description,
                                documentation: html2text(one.description)
                            }
                        );

                    }

                });
        }


        gs_lastScript= getStringFromURL("templateScript?side="+urlArgs.side+"&type=design&id="+urlArgs.id,"UTF-8");
        editor.setValue(gs_lastScript);
        


    });

    function html2text(html) {
        html = html || '';
        html = html.replace(/<\/p>/g, '</p><br>');  //把 </p>后插入一个br，下面统一换成 回车
        html = html.replace(/<br>/g, '回车');

        html = html.replace(/<(style|script|iframe)[^>]*?>[\s\S]+?<\/\1\s*>/gi, '').replace(/<[^>]+?>/g, '').replace(/\s+/g, ' ').replace(/ /g, ' ').replace(/>/g, ' ');
        html = html.replace(/回车/g, "\n");

        return html;

    }

    function insertContent(text) {

        let selection = editor.getSelection()
        let range = new monaco.Range(selection.startLineNumber, selection.startColumn, selection.endLineNumber, selection.endColumn)
        let id = {major: 1, minor: 1}
        let op = {identifier: id, range: range, text: text, forceMoveMarkers: true}
        editor.executeEdits(this.root, [op])
        editor.focus()

    }

    function formatScript() {
        editor.trigger('', 'editor.action.formatDocument');
    }




    var funcOutline = [];

    function outline() {

        funcOutline =[];
        var source = editor.getValue();

        var RE = /([/][/]@comment(\s)*[(](\s)*group(\s)*=(\s)*([A-Z_a-z0-9\u4e00-\u9fa5]*)(\s)*,(\s)*caption(\s)*=(\s)*([A-Z_a-z0-9\u4e00-\u9fa5]*)(\s)*[)](\s)*)*function(\s)*([A-Z_a-z0-9\u4e00-\u9fa5]+)(\s)*[(]/;


        while (true) {
            var m = RE.exec(source);
            console.dir(m);
            if (!m) break;
            var one = {};
            one.source = m[0];
            one.group = m[6];
            one.caption = m[11];
            one.func = m[15];
            one.index= funcOutline.length;
            funcOutline.push(one);

            source = source.substring(m.index + m[0].length);
        }

        //

        var funcGroup={};
        for( var i=0;i<funcOutline.length;i++)
        {
            var one=funcOutline[i];
            var group=one.group;

            var func= one.func;
            if (group==undefined || group=='' ) group='全局函数';

            if( funcGroup[group]==undefined)
            {
                funcGroup[group]=[];
            }
            funcGroup[group].push( one);

        }
        console.dir(funcGroup);

        var html=[];
        for( var g in funcGroup)
        {
            html.push("<div class='group'>");
            html.push(g);
            html.push("</div>");

            var fs= funcGroup[g];

            for( var fi =0;fi< fs.length; fi++)
            {
                var one= fs[fi];
                html.push("<a class='func'  href='javascript:jumpToFunc("+one.index+")'><b>");
                html.push( one.func);
                html.push( "</b>");

                if( one.caption) {
                    html.push("<span class='funcCaption'>&nbsp;");
                    html.push(one.caption);
                    html.push("</span>");

                }
                html.push("</a><br>");
            }

        }

        $('#outlineContainer').html( html.join(''));
        $('#outlineContainer').css("display","");
    }

    function jumpToFunc(n) {
        let one= funcOutline[n];
        if( !one) return;
          var modal= editor.getModel()
           let match  = modal.findMatches(one.source);
          if( match && match.length>0) {
              let range = match[0].range;
              editor.setSelection(range)
              //把选中的位置放到中间显示
              editor.revealRangeInCenter(range)
          }


    }

    function provideCompletionItems(model, position) {
        //自定义匹配逻辑....
        var textUntilPosition = model.getValueInRange({
            startLineNumber: position.lineNumber,
            startColumn: 1,
            endLineNumber: position.lineNumber,
            endColumn: position.column
        });


        if (textUntilPosition.charAt(textUntilPosition.length - 1) == '#') {
            return {
                suggestions: [
                    {
                        label: 'DataStore',
                        insertText: 'DataStore'
                    }, {
                        label: 'DataBuffer',
                        insertText: 'DataBuffer'
                    }, {
                        label: 'WorkBook',
                        insertText: 'WorkBook'
                    }, {
                        label: 'WorkSheet',
                        insertText: 'WorkSheet'
                    }, {
                        label: 'Cell',
                        insertText: 'Cell'
                    }
                ]
            };
        }
        //点方法调用
        if (textUntilPosition.charAt(textUntilPosition.length - 1) == '.') {
            //当是点时匹配自定义的方法 ...
            return {
                suggestions: [//该方法的子类方法，可通过点语法调用
                    {
                        label: 'Goods1()',
                        insertText: 'Goods1()'
                    }, {
                        label: 'Goods2()',
                        insertText: 'Goods2()'
                    }
                ]
            };

        } else {
            return {suggestions: g_suggestions_globalscript};
        }

    }


    //自定义监听输入编写语法/
    monaco.languages.registerCompletionItemProvider('javascript',
        {
            provideCompletionItems: provideCompletionItems,
            triggerCharacters: ['.',
                ':',
                '#'
            ] // 写触发提示的字符，可以有多个
        }
    );

    //悬停信息展示
    monaco.languages.registerHoverProvider('javascript', {
        provideHover: function (model, position) {

            var t = model.getValueInRange({
                startLineNumber: position.lineNumber,
                startColumn: 1,
                endLineNumber: position.lineNumber,
                endColumn: model.getLineMaxColumn(position.lineNumber)
            });

            return {
                range: new monaco.Range(1, 1, position.lineNumber, position.column), // model.getLineMaxColumn(model.getLineCount())),
                contents: [
                    {value: t},
                    {
                        value: (function () {
                            var ret = [];
                            for (var i = 0; i < 20; i++) {
                               // ret.push('+ 匿名函数可以直接访问到外层署名函数（Foo）中的变量（使用关键字var定义的），但不能访问外层署名函数的属性（使用关键字this定义的） ' + i);
                            }
                            return ret.join('\n')
                        })()
                    }
                ]
            }

        }
    });


</script>


<script>

    function addBreakPoint(line) {
        let model = editor.getModel()
        if (!model) return
        let value = {
            range: new monaco.Range(line, 1, line, 1),
            options: {isWholeLine: true, linesDecorationsClassName: 'breakpoints'}
        }
        model.deltaDecorations([], [value])
    }

    //删除断点，如果指定了line，删除指定行的断点，否则删除当前model里面的所有断点
    function removeBreakPoint(line) {
        let model = editor.getModel()
        if (!model) return
        let decorations
        let ids = []
        if (line !== undefined) {
            decorations = editor.getLineDecorations(line)
        } else {
            decorations = editor.getAllDecorations()
        }
        for (let decoration of decorations) {
            if (decoration.options.linesDecorationsClassName === 'breakpoints') {
                ids.push(decoration.id)
            }
        }
        if (ids && ids.length) {
            model.deltaDecorations(ids, [])
        }
    }

    //判断该行是否存在断点
    function hasBreakPoint(line) {
        let decorations = editor.getLineDecorations(line)
        for (let decoration of decorations) {
            if (decoration.options.linesDecorationsClassName === 'breakpoints') {
                return true
            }
        }
        return false
    }

</script>


<body>


<!-- 此处用了传统的三段式结构:Container代表整个容器，Header代表容器的上部，Content代表容器的中部也就是内容部分，Footer代表容器的底部 -->
<div id="Container">
    <div id="Header">
        <!-----  menu ---->
        <nav class="nav">
            <ul class="nav__menu">

                <c:if test="${param.side=='client' }">
                    <li class="nav__menu-item"><a><i class="fa fa-bars"></i> 表单事件</a>
                        <ul class="nav__submenu">
                            <li class="nav__submenu-item " onclick="scriptWizard('form',this);"><a>flowOpen 表单初始化完成</a>
                            </li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('form',this);"><a>newOpen 新增单据打开模板</a>
                            </li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('form', this);"><a>editOpen
                                编辑单据打开模板</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('form', this);"><a>viewOpen
                                查看单据打开模板</a></li>
                            <li class="nav__submenu-item " onclick="scriptWizard('form',this);"><a>uiInited
                                界面初始完成但数据尚未检索</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('form', this);"><a>afterOpen 打开之后</a>
                            </li>

                            <li class="nav__submenu-item  " onclick="scriptWizard('form', this);"><a>dialogOpen
                                当模板以对话框方式打开</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('form', this);"><a>dialogOnOK
                                对话框点击击确认时返回数据</a></li>

                            <li class="nav__submenu-item " onclick="scriptWizard('form',this);"><a>pageActive
                                工作台tab页面被激活时</a></li>
                            <li class="nav__submenu-item " onclick="scriptWizard('form',this);"><a>pageDeactive
                                工作台tab页面取消激活时</a></li>
                            <li class="nav__submenu-item " onclick="scriptWizard('form',this);"><a>pageClose
                                工作台tab页面在被关闭时</a></li>
                            
                            <li class="nav__submenu-item " onclick="scriptWizard('form', this);"><a>beforeSave 
                                单据保存前</a></li>
                       
                            <li class="nav__submenu-item " onclick="scriptWizard('form', this);"><a>beforeSubmitWork  
                                工作提交前</a></li>       
                                
                            <li class="nav__submenu-item " onclick="scriptWizard('form', this);"><a>afterSaveSuccessful
                                单据保存成功后</a></li>

                        </ul>
                    </li>
                    <li class="nav__menu-item"><a><i class="fa fa-database"></i> 数据源前端事件</a>
                        <ul class="nav__submenu">
                            <li class="nav__submenu-item  " onclick="scriptWizard('datastore',this);"><a>DataStoreItemChanged
                                值发生变化</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('datastore',this);"><a>DataStoreItemChangeAccpet
                                是否接受变化的值</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('datastore',this);"><a>computerChanged
                                计算列的值发生变化</a></li>

                            <li class="nav__submenu-item  " onclick="scriptWizard('datastore',this);"><a>DataStoreBeforeRetrieve
                                检索前</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('datastore',this);"><a>DataStoreRetrieveEnd
                                检索完成后</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('datastore',this);"><a>DataStoreRetrieveOnceMoreEnd
                                更多次的检索完成后</a></li>


                            <li class="nav__submenu-item  " onclick="scriptWizard('datastore',this);"><a>deleteRowPermit
                                是否允许删除某行</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('datastore',this);"><a>beforeDeleteRow
                                删除某行前</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('datastore',this);"><a>afterDeleteRow
                                删除某行后</a></li>
  <li class="nav__submenu-item  " onclick="scriptWizard('datastore',this);"><a>insertRowPermit
                                是否允许插入行</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('datastore',this);"><a>afterInsertRow
                                插入一行后</a></li>
                                <!-- 
                            <li class="nav__submenu-item  " onclick="scriptWizard('datastore',this);"><a>afterSort
                                排序完成后</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('datastore',this);"><a>afterFilter
                                过滤完成后</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('datastore',this);"><a>afterReset
                                清空后</a></li>
 -->
                            <li class="nav__submenu-item  " onclick="scriptWizard('datastore',this);"><a>validate
                                保存前的数据检验 </a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('datastore',this);"><a>sqlPreview
                                预览SQL语句</a></li>
                                <!--  
                            <li class="nav__submenu-item  " onclick="scriptWizard('datastore',this);"><a>autoCheckError
                                自动校验发生错误时</a></li>
 -->
                            <li class="nav__submenu-item  " onclick="scriptWizard('datastore',this);"><a>beforeGetValue
                                在获取某行某列什之前</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('datastore',this);"><a>onError
                                发生异常</a></li>
                          


                        </ul>
                    </li>


                    <li class="nav__menu-item"><a><i class="fa fa-coffee"></i> 单元格事件</a>
                        <ul class="nav__submenu">
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>cellClicked
                                单元格点击</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>cellDblClicked
                                单元格被双击</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>cellRightClicked
                                单元格被鼠标右键点击</a></li>

                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>cellFocusGained
                                单元格获得焦点</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>cellFocusLost
                                单元格失去焦点</a></li>

                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>cellValueChangeAccept
                                值是否允许改变</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>CellValueChanged
                                单元格的值已经改变</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>CellValueChangedByEdit
                                值因被编辑而改变</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>cellPaint
                                单元格自绘</a></li>

                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>isCellEditable
                                单元格是否允许编辑</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>beginEdit
                                单元格开始编辑</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>endEdit
                                单元格编辑结束</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>editFocusChanged
                                单元格编辑焦点发生变化</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>buildToolTip
                                定制单元格的气泡提示信息</a></li>


                        </ul>
                    </li>

                    <li class="nav__menu-item"><a><i class="fa fa-table"></i> 工作表事件</a>
                        <ul class="nav__submenu">
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>sheetNameChanged
                                工作表名称改变</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>afterNewSheet
                                新插入工作表后</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>sheetDeletePermit
                                工作表是否允许删除</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>sheetPrintPermit
                                工作表是否允许打印</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>afterSheetPrint
                                工作表打印之后</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>sheetActiveStateChanged
                                激活状态变化</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>onMouseMove
                                鼠标移动</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>currentBindRowChanged
                                当前焦点行改变</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>onDragDrop
                                拖拽进入</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>onScroll
                                发生卷滚</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>columnWidthChanged
                                某列宽度发生改变</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>rowHeightChanged
                                某行高度发生改变</a></li>

                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>loadMoreTipInfoWhenScrollToTop
                                划屏到顶部后显示的提示信息</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>loadMoreTipInfoWhenScrollToBottom
                                划屏到底部后显示的提示信息</a></li>

                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>loadMoreWhenScrollToTop
                                划屏到顶部后执行</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>loadMoreWhenScrollToBottom
                                划屏到底部后执行</a></li>


                        </ul>
                    </li>

                    <li class="nav__menu-item"><a><i class="fa fa-sticky-note"></i> 单据相关事件</a>
                        <ul class="nav__submenu">
                            <li class="nav__submenu-item  " onclick="scriptWizard('bill',this);"><a>buildBillSearchWhere
                                构建单据查询条件</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('bill',this);"><a>refreshRetrieveWhereDefine
                                构建单据列表刷新某行的查询条件</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('bill',this);"><a>isBillNeedToSave
                                单据是否需要保存</a></li>

                            <li class="nav__submenu-item  " onclick="scriptWizard('bill',this);"><a>newBillNoInScript
                                定制一个单据号</a></li>
  
  				 <li class="nav__submenu-item  " onclick="scriptWizard('bill',this);"><a>newPermit 是否允许新增单据</a></li>
				 <li class="nav__submenu-item  " onclick="scriptWizard('bill',this);"><a>viewPermit 是否允许查看单据</a></li>
				 <li class="nav__submenu-item  " onclick="scriptWizard('bill',this);"><a>editPermit 是否允许编辑单据</a></li>
				 
 
                        </ul>
                    </li>

                    <li class="nav__menu-item"><a><i class="fa fa-desktop"></i> 其它UI事件</a>
                        <ul class="nav__submenu">
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>VirtualButtonClicked
                                按钮被点击</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>cbXXX_onclick
                                某名称的按钮被点击</a></li>
                                <!-- 
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>contextMenuOnClick
                                右键菜单被点击</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>menuXXX_onClick
                                某个右键菜单被点击</a></li>
                                 -->
                                 
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>treeOnClick
                                树的某个节点被点击</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>treeOnCheck
                                多选树节点被选中/取消选中</a></li>

                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>error 发生错误</a>
                            </li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>loadPrintConfig
                                加载打印设置</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>savePrintConfig
                                保存打印设置</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>popupedOnOK
                                弹出工作表窗口点击确定</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('workbook',this);"><a>popupedOnCancel
                                弹出工作表窗口点击取消</a></li>

   <li style="height:1px;line-height:1px; background-color:#efefef;margin:2px;"></li>
                            <li class="nav__submenu-item " onclick="scriptWizard('other',this);"><a>getExportFileName
                                导出数据时自定义文件名</a></li>
                            <li class="nav__submenu-item " onclick="scriptWizard('other',this);"><a>getExportColumns
                                导出哪些字段</a></li>


                        </ul>
                    </li>

                </c:if>

                <c:if test="${param.side=='server'      }">
                    
                 <li class="nav__menu-item"><a><i class="fa fa-sticky-note"></i> 单据相关事件</a>
                        <ul class="nav__submenu">
                           
				   <li class="nav__submenu-item  " onclick="scriptWizard('bill',this);"><a>deletePermit 是否允许删除单据</a></li>

 
                  

                   <li style="color:#404040;"><strong>&nbsp;&nbsp;附件相关事件</strong></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('attachmentOnServer',this);"><a>attachmentDeletePermit
                                允许删除附件吗</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('attachmentOnServer',this);"><a>attachmentUploadPermit
                                允许上传附件吗</a></li>
                            <li class="nav__submenu-item  " onclick="scriptWizard('attachmentOnServer',this);"><a>attachmentRenamePermit
                                允许附件改名吗</a></li>

                        


                        </ul>
                    </li>
 
 
            <li class="nav__menu-item"><a><i class="fa fa-table"></i> 工作流服务端事件</a>
                    <ul class="nav__submenu">
                        <li class="nav__submenu-item  " onclick="scriptWizard('workflow',this);"><a>afterSubmitWork 工作提交后</a></li>
                       <li class="nav__submenu-item  " onclick="scriptWizard('workflow',this);"><a>untreadPermit 是否允许退回</a></li>
                         <li class="nav__submenu-item  " onclick="scriptWizard('workflow',this);"><a>flowWithdraw 工作被退回到某步骤后</a></li>
                                <li class="nav__submenu-item  " onclick="scriptWizard('workflow',this);"><a>beforeUnOverWork 工作取消结束前</a></li>
                                <li class="nav__submenu-item  " onclick="scriptWizard('workflow',this);"><a>afterUnOverWork 工作取消结束后</a></li>
                                <li class="nav__submenu-item  " onclick="scriptWizard('workflow',this);"><a>onWorkOver 工作结束时</a></li>
                                
                                                
                    </ul>
              </li>
                                

                </c:if>

 

                <li class="nav__menu-item"><a><i class="fa fa-book"></i> 函数参考</a>
                    <ul class="nav__submenu">

                        <li class="nav__submenu-item  "><a
                                href="function.jsp" target="_blank">服务端脚本函数参考</a>
                        </li>
                        <li class="nav__submenu-item  "><a
                                href="../doc/repertory/library/object/ClientFunction/index.html" target="_blank">客户端脚本函数参考</a>
                        </li>

                        <li class="nav__submenu-item  "><a
                                href="../doc/docview.jsp?path=F5ZGK4DFOJ2G64TZF5WGSYTSMFZHSL3EN5RS6MBQFYYDAMZO4WX3T2FRUHSY7AXIQCBS43LE"
                                target="_blank">对象参考</a></li>
                       

                    </ul>
                </li>

                <li class="nav__menu-item"><a><i class="fa fa-sign-in"></i> 插入</a>
                    <ul class="nav__submenu">
                       
                        <li class="nav__submenu-item  " onclick="insert_functionComment();"><a> 插入函数说明</a></li>

                    </ul>
                </li>

                <li class="nav__menu-item"><a href="javascript:syntaxCheck();"><i class="fa fa-bug"></i> 校验</a>
                </li>
                <li class="nav__menu-item"><a href="javascript:outline();"><i class="fa fa-tree"></i> 大纲</a>
                </li>
                <li class="nav__menu-item"><a href="javascript:cmd_format();"><i class="fa fa-align-right"></i> 排版</a>
                </li>

                <li class="nav__menu-item  "><a href="javascript:save();"><i class="fa fa-save "></i> 保存</a>
                </li>

 
            

            </ul>
        </nav>


        <!------end menu ------------->

    </div>

    <div id="Content">
        <div id="editContainer" style="position:relative; width:100%;height:100%;"></div>
    </div>

    <div id="Footer">
        <table width="100%" border=0 height="32">
            <tr>
                <td id="infoContainer" width="70%" style="padding:0;  padding-left:10px;"></td>
                <td id="infoContainer2" width="30%" style="padding:0;"></td>
            </tr>
        </table>


    </div>
</div>


<div id="outlineContainer" style="   position: fixed;
        right: 0;
        top: 33px;
        width:400px;
        height: 100%;
        line-height:16px;
        overflow-y: auto;
        display:none;
        font-size: 13px;
        opacity: 0.9;
        background-color: #efefef; ">

</div>
</body>

</html>


