<%@ page language="java" contentType="text/html; charset=UTF-8"    pageEncoding="UTF-8"%>
<%@ page  import="wiseoa.*" %>    
<%@ page  import="wiseoa.util.*" %>
<%@ page  import="wiseoa.mail.jstl.*" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>

<%
	 

/*

  1  使用URL参数定位显示指定车牌号
   
       gpsmap.jsp?action=dw&cph=2XRUENZZGA2TQ   直接使用URL参数显示指定车辆的定位 , 其中 cph 是将车牌号进行base32编码
        示例：    var cph=  ds.getString(0,"cph");
                 cph= base32Encode(cph);
                 url= "gpsmap.jsp?action=dw&cph="+cph;
                 openWindow( url);
       
   2  使用 URL参数显示指定车辆在指定时间段内的轨迹
   
     直接测试： gpsmap.jsp?action=gj&cph=2XRUENZZGA2TQ&xl=sss&rq1=2011.08.01 01:01&rq2=2011.10.01 01:01&step=2
     
    脚本中调用：
   
   var cph=  ds.getString(0,"cph");
   cph= base32Encode(cph);// 车牌号
   var xl="XXXD-DDSSSS-SSDSS-XXSXS" ; // 替换成预设线路的GGUID ,如果设置成空字符串，那么地图上将不显示预定线路
   var rq1='2011.08.01 01:01';  // 开始时间
   var rq2='2011.10.01 01:01';  //结束时间
   var step=2; // GPS数据取样间隔， 单位是分钟， step=2 表示每隔2分钟取样一个GPS坐标
   
   url= "gpsmap.jsp?action=gj&cph="+cph+"&xl="+xl+"&rq1="+rq1+"&rq2="+rq2+"&step="+step; 
   openWindow(url);
            
   

*/

%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head><meta http-equiv="X-UA-Compatible" content="IE=EmulateIE7" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>轨迹回放</title>

<script type="text/javascript">

	var src=''+document.location.href; 
	var key="";
	//alert( src);
	if( src.indexOf("192.168.1.102")>=0) 
	{
		key="37c59f22b64f109b79a8d1b0ce4dea327a66d2350495771aaba2cf68291029666d86813b649c682a";
	}else
	{
		key="7f53a4f76eb7eeaae272447617f75cdeb31b63fa95868741390b795ddc99dadf22b9853513e7c467";
	}
    
	//alert( key);
	//后的的 </ script>一定要分开写， 不然就出错，
	var url="<script type='text/javascript' src='http://app.mapabc.com/apis?&t=flashmap&v=2.4&key=" +key +"'></" +"script>" ;
    
	document.writeln(url);


</script>

     <script type="text/javascript" src="js/json.js"></script>
    <script type="text/javascript" src="js/jquery.js"></script>
    <script type="text/javascript" src="js/zrpc.js.jsp"></script>
    <script type="text/javascript" src="js/domutil.js"></script>
  
  
<script type="text/javascript">
var mapObj=null;
var currentCar="";

function  mapInit() {
	var mapoption = new MMapOptions();
	mapoption.toolbar = MConstants.ROUND; //设置地图初始化工具条，ROUND:新版圆工具条，DEFAULT(默认)、BLACK(备选)、ROUND(新版圆)、SMALL(小工具条)、MINI(迷你工具条)。   

	mapoption.overviewMap = MConstants.HIDE; //设置鹰眼地图的状态，SHOW:显示，HIDE:隐藏（默认）
	mapoption.scale = MConstants.SHOW; //设置地图初始化比例尺状态，SHOW:显示（默认），HIDE:隐藏。
	var level=12;
	var type="<c:out value="${param.type}"/>";
	if( type=='wtdw') level=9; //如果提供给委托单位查询多个车辆信息时，缩放级别要调小一点
	
	mapoption.zoom = level;//要加载的地图的缩放级别
	mapoption.center = new MLngLat(120.1184,30.2814);//要加载的地图的中心点经纬度坐标,和google的经纬度相反
	mapoption.language = MConstants.MAP_CN;//设置地图类型，MAP_CN:中文地图（默认），MAP_EN:英文地图
	mapoption.fullScreenButton = MConstants.HIDE;//设置是否显示全屏按钮，SHOW:显示（默认），HIDE:隐藏
	mapoption.centerCross = MConstants.SHOW;//设置是否在地图上显示中心十字,SHOW:显示（默认），HIDE:隐藏
	mapoption.toolbarPos=new MPoint(20,20); //设置工具条在地图上的显示位置
	mapObj = new MMap("map", mapoption); //地图初始化
}
var bounds;
var southWest ;
var northEast ;
var lngX;
var latY;
var lngSpan;
var latSpan;


//删除车 
function GPScarRemove(cph)
{
	mapObj.removeOverlayById (cph);
}

//根据当前车辆的经纬度信息，在地图上加点；
function GPScar( cars ) 
{
	
 	
	cars= JSON.parse(cars);
	
	var marks=[];
	for(var i=0;i<cars.length;i++)
	{
		var car=cars[i];
		//alert ( JSON.toString(car));
		
		
		 var cph= car.cph;
			 
	 
 
    var  markerOption = new MMarkerOptions();
	markerOption.imageUrl ="http://code.mapabc.com/images/car_03.png";
	markerOption.picAgent=false;
	
	var labelOption = new MLabelOptions();
	labelOption.hasBackground=true;//设置文字标签是否有背景，默认为false，即没有背景
	labelOption.hasBorder=true;//设置文字标签背景是否有边框，默认为false，即没有边框
	labelOption.backgroundColor=0xffff48;//设置文字标签的背景颜色
	labelOption.borderColor=0x000088;//设置文字标签的边框颜色
	labelOption.content="点的标注";//文字标签的显示内容
	//设置标注左上角相对于图片中下部的锚点。Label左上角与图片中下部重合时，记为像素坐标原点(0,0)。
	labelOption.labelPosition=new MPoint(-20,20);
	labelOption.content=cph; //文字信息
	
	markerOption.labelOption=labelOption;
	
	
	var tipOption = new MTipOptions();
	tipOption.title= cph+"详细情况";
	
	var carInfo="";
	var lngX=120.1184;//如果没有GPS数据，那么就放这个坐标
	var latY=30.2814;
	 
	var gps=JSON.parse( car.gps);
 
	if( gps.error!="")
	{
		carInfo= gps.error;	
	}else
	{
	     lngX= gps.data.jd;
	     latY= gps.data.wd;
	     
		carInfo="经度："+ gps.data.jd+"&nbsp;"+
					"纬度："+ gps.data.wd+"<br>"+
					"记录日期："+ gps.data.rq+"&nbsp;"+
					"时间："+ gps.data.sj+"<br>" + car.moreInfo;
	}
	
	 
	tipOption.content= carInfo ; //tip内容
	
	
	tipOption.hasShadow=true;
	tipOption.titleFontStyle.name="Arial";
	tipOption.titleFontStyle.size=12;
	tipOption.titleFontStyle.color= 0xffffff;
	tipOption.titleFontStyle.bold=true;
	tipOption.contentFontStyle.name="Arial";
	tipOption.contentFontStyle.size=13;
	tipOption.contentFontStyle.color= 0x000000 ;
	tipOption.contentFontStyle.bold=false;
	

 
	tipOption.tipType=MConstants.HTML_BUBBLE_TIP;
	tipOption.tipHeight=150;
	tipOption.tipWidth=260;

	

	markerOption.tipOption = tipOption;
	markerOption.canShowTip=true;
	markerOption.hasShadow=true;

	
	var marker = new MMarker(new MLngLat(lngX, latY),markerOption);
	marker.id=cph;
	currentCar =cph; 
	marks.push( marker);
	}
	
	mapObj.addOverlays(marks,true);
}



function addDefaultTrace( gps)
{
	var id="defaultTrace";
	
	mapObj.removeOverlayById (id);
	var lineArr =[];
		
	 
	for (var i = 0; i <gps.length; i++)
	{ 
		//通过addOverlay定位到屏幕上，然后再删除
		if( i==0) 
		{
			var marker = new MMarker(new MLngLat(parseFloat(gps[i].jd ),  parseFloat(gps[i].wd ) ) );
			marker.id="temp";
 			mapObj.addOverlay (marker,true);
			mapObj.removeOverlayById (marker.id);
		
		}
	
		lineArr.push(new MLngLat( parseFloat(gps[i].jd ),  parseFloat(gps[i].wd )));
	}

	var linest = new MLineStyle();
	linest.alpha = 1;
	linest.color = 0x0033FF  ;
	linest.thickness = 3;
	var lineopt  = new MLineOptions();
	lineopt.lineStyle = linest;
	lineopt.canShowTip = false;
	var PolylineAPI = new MPolyline(lineArr,lineopt);  //使用自定义的样式时用这个
	PolylineAPI.id = id;
	mapObj.addOverlay(PolylineAPI)	;
}

var lineArr ;
var  carID="realCar";
var  traceID="realTrace";

function addRealTrace( cph,gps)
{
	//根据gps轨迹信息传递
	//根据指定车辆的作业单路线轨迹作为标准图，然后将实际轨迹同时标注
	//具体回放时可以根据指定的时间抽样率进行gps信息的获取
 
	mapObj.removeOverlayById (carID);
	mapObj.removeOverlayById (traceID);
	
lineArr= new Array();
 
for (var i = 0; i <gps.length; i++)
{ 
	//通过addOverlay定位到屏幕上，然后再删除
	if( i==0) 
	{
		  var  markerOption = new MMarkerOptions();
			markerOption.imageUrl ="http://code.mapabc.com/images/car_03.png";
			markerOption.picAgent=false;
			
			var labelOption = new MLabelOptions();
			labelOption.hasBackground=true;//设置文字标签是否有背景，默认为false，即没有背景
			labelOption.hasBorder=true;//设置文字标签背景是否有边框，默认为false，即没有边框
			labelOption.backgroundColor=0xffff48;//设置文字标签的背景颜色
			labelOption.borderColor=0x000088;//设置文字标签的边框颜色
		 
			//设置标注左上角相对于图片中下部的锚点。Label左上角与图片中下部重合时，记为像素坐标原点(0,0)。
			labelOption.labelPosition=new MPoint(-20,20);
			labelOption.content=cph; //文字信息
			
			markerOption.labelOption=labelOption;
		var marker = new MMarker(new MLngLat(parseFloat(gps[i].jd ),  parseFloat(gps[i].wd ) ) ,markerOption );
		marker.id=carID;
		
		mapObj.addOverlay (marker,true);
 	
	}

	lineArr.push(new MLngLat( parseFloat(gps[i].jd ),  parseFloat(gps[i].wd )));
}

var linest = new MLineStyle();
linest.alpha = 1;
linest.color = 0xFF3300 ;
linest.thickness = 3;
var lineopt  = new MLineOptions();
lineopt.lineStyle = linest;
lineopt.canShowTip = false;
var PolylineAPI = new MPolyline(lineArr,lineopt);  //使用自定义的样式时用这个
PolylineAPI.id = traceID;
mapObj.addOverlay(PolylineAPI)	;
}
 

function startMove(){
	var arr=new Array();
	arr.push(carID);
	mapObj.setGPSFocus(MConstants.FOCUS,arr);
	mapObj.markerMoveAlong(carID,lineArr,2);
  	mapObj.startMoveAlong(carID,true);
}
function pauseMove(){
	mapObj.pauseMoveAlong(carID);//暂停移动marker
}
function stopMove(){
	mapObj.stopMoveAlong(carID);
}
</script>
</head>
<body   style="overflow:hidden; margin:0">
<div id="map" style="width:100%; height:500px;">
</div>
 
 <div style="display:none;">
<input type="button" onClick="javascript:GPScar();" value=" 1. 加点"/>
<input type="button" onClick="javascript:addLine_50();" value=" 2. 加路线"/>
<input type="button" onClick="javascript:startMove();" value="3. 开始移动"/>
<input type="button" onClick="javascript:pauseMove();" value="4. 暂停移动"/>
<input type="button" onClick="javascript:stopMove();" value="5. 停止移动"/>
 </div>
 

<script>
 

window.onresize= OnResize;
window.onload =OnLoad;



function OnLoad()
{
	
	mapInit();
	OnResize();
	
	var action="<c:out value="${param.action}"/>";
	if( action=="dw") //定位
	{
	 	var cph= "<c:out value="${param.cph}"/>";
	 	var ret= JSON.parse(runTask("BASE32DECODER", {input: cph })) ;
	    cph= ret.output;
	    
	    var c=[];
   		var one={};
   		one.cph=cph;
	    one.gps= runTask("GET_LAST_GPS_POSITION", {cph:cph});
	  	c.push(one);
	    GPScar( JSON.toString(c));
	     
	 
	}
	
	
	if( action=="gj")
	{
		var cph= "<c:out value="${param.cph}"/>";
	 	var ret= JSON.parse(runTask("BASE32DECODER", {input: cph })) ;
	    cph= ret.output;
	    
	    var rq1= "<c:out value="${param.rq1}"/>";
	    var rq2= "<c:out value="${param.rq2}"/>";
	    
	    var step= "<c:out value="${param.step}"/>";
	    if( step=='') step=2;
	    
	    var xl= "<c:out value="${param.xl}"/>";
	    
	    //如果指定了预设置线路，那么显示线路
	    if(xl!="")
	    { 
	    	var gps=runTask("GET_YSXL_GPS" , {gguid:xl});
	  	    gps=JSON.parse(gps);
	  	    if( gps.demo)
	  	    {
	  		    alert("运输线路的具体GPS坐标并未设置，所以现在显示的演示数据。");   
	  	    }
	  	    
	  	     addDefaultTrace(gps.gps);
	    }
	    
	 
	    
	    var p={cph:cph, rq1:rq1, rq2:rq2, step:step};
		 
	  	var gps=runTask("GET_TRACE_OF_CPH_ON_TIMERANGE" , p);
	  	gps=JSON.parse(gps);
	  	if( gps.length==0)
	  	{
	  		    alert("没有得到GPS坐标数据。无法显示");
	  		    return;
	  	}
	  	
	  	addRealTrace(cph,gps);
	  	
	  	startMove();
	    
	  	 	
	}
	
	
}

function OnResize()
{
	 
  try
  {
          //可视区的大小，如果是FireFox,要使用 window.innerHeight;
        var h = document.documentElement.offsetHeight;
 
  	 	document.getElementById('map').style.height=  (h-10)+"px" ;
	      
  }catch(err)
  {
                //alert ( err.description);
  }
 }
 
 

</script>
</body>
</html>
