// JavaScript Document

function startMove(obj,json,endFn){
	
		clearInterval(obj.timer);
		
		obj.timer = setInterval(function(){
			
			var bBtn = true;
			
			for(var attr in json){
				
				var iCur = 0;
			
				if(attr == 'opacity'){
					if(Math.round(parseFloat(getStyle(obj,attr))*100)==0){
					iCur = Math.round(parseFloat(getStyle(obj,attr))*100);
					
					}
					else{
						iCur = Math.round(parseFloat(getStyle(obj,attr))*100) || 100;
					}	
				}
				else{
					iCur = parseInt(getStyle(obj,attr)) || 0;
				}
				
				var iSpeed = (json[attr] - iCur)/8;
			iSpeed = iSpeed >0 ? Math.ceil(iSpeed) : Math.floor(iSpeed);
				if(iCur!=json[attr]){
					bBtn = false;
				}
				
				if(attr == 'opacity'){
					obj.style.filter = 'alpha(opacity=' +(iCur + iSpeed)+ ')';
					obj.style.opacity = (iCur + iSpeed)/100;
					
				}
				else{
					obj.style[attr] = iCur + iSpeed + 'px';
				}
				
				
			}
			
			if(bBtn){
				clearInterval(obj.timer);
				
				if(endFn){
					endFn.call(obj);
				}
			}
			
		},30);
	
	}
	
	
	function getStyle(obj,attr){
		if(obj.currentStyle){
			return obj.currentStyle[attr];
		}
		else{
			return getComputedStyle(obj,false)[attr];
		}
	}
	
//myAddEvent为元素添加事件,可以为相同元素添加多个相同事件
function myAddEvent(obj, sEvent, fn)
{
	//attachEvent支持IE下添加事件,格式obj.attachEvent(event,function);event带on,如onclick
	if(obj.attachEvent)
	{
		obj.attachEvent('on'+sEvent, fn);
	}
	else
	{
		//addEventListener支持Firefox、Chrome等W3C浏览器,格式addEventListener(event,obj,false),event不带on,如click,false为定值不用更改
		obj.addEventListener(sEvent, fn, false);
	}
}

//getStyle函数实现直接通过属性名称获取属性值
function getStyle(obj, attr)
{	
	//currentStyle支持IE浏览器获取元素CSS值，包括外链CSS文件或页面中嵌入的<style>属性等
	if(obj.currentStyle)
	{
		return obj.currentStyle[attr];
	}
	else
	{
		//Firefox、Chrome等W3C浏览器支持getComputedStyle获取元素style值,不是伪类则第二个参数设置null,非必须
		return getComputedStyle(obj, null)[attr];
	}
}

//getElementsByClassName函数用于通过class获取元素
function getElementsByClassName(tagName,className) //obj为目标class祖先元素,tagName为标签名,className为类名
{
      
    var tags = document.getElementsByTagName(tagName);//获取obj子节点中所有匹配标签的元素

    var tagArr = [];//用于返回类名为className的元素
     
    for(var i=0; i<tags.length; i++)
     
    {
         
        if(tags[i].className == className){
             
            tagArr[tagArr.length] = tags[i];//保存满足条件的元素
             
        }
         
    }
    return tagArr;
}

//setCookie函数用于创建cookie,接受三个参数,name为cookie名,value为cookie值,iDay为过期时间
function setCookie(name, value, iDay)
{
	var oDate=new Date();
	
	oDate.setDate(oDate.getDate()+iDay);
	
	document.cookie=name+'='+value+';expires='+oDate;
}

function getCookie(name)
{
	//'username=abc; password=123456; aaa=123; bbb=4r4er'
	var arr=document.cookie.split('; ');
	var i=0;
	
	//arr->['username=abc', 'password=123456', ...]
	
	for(i=0;i<arr.length;i++)
	{
		//arr2->['username', 'abc']
		var arr2=arr[i].split('=');
		
		if(arr2[0]==name)
		{
			return arr2[1];
		}
	}
	
	return '';
}

function removeCookie(name)
{
	setCookie(name, '1', -1);
}