<%@ page contentType="text/html;charset=UTF-8"%>
<%@ page import="java.util.*"%>
<%@ page import="wiseoa.*"%>
<%@ page import="wiseoa.util.*"%>
<%@ page import="wiseoa.mapshow.jstl.*"%>


<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>

<%@include file="rightverify.jsp"%>

<%
	MapShowHotPoint msh = new MapShowHotPoint(request,false);
	FF.pageContextSetAttribute(pageContext, "background",		msh.background);
	FF.pageContextSetAttribute(pageContext, "hotpoints",		msh.points);
	
%>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>加热点</title>
    <META http-equiv="pragma" content="no-cache">
    <META http-equiv="cache-control" content="no-cache">
    <META http-equiv="expires" content="0">

<LINK rel="stylesheet" type="text/css" href="css/normal.css">

<style>
body {
	width: 100%;
	height: 100%;
	overflow: hidden;
}

* {
	padding: 0;
	margin: 0;
}

.box {
	margin: 10px;
	position: relative;
	padding: 5px;
	background-color: #efefef;
	left: 300px;
	top: 0;
	width: 300px;
	height: 25px;
	z-index: 2;
}

.img_box {
	position: absolute;
	left: 0;
	top: 0;
	overflow: auto;
	z-index: 1;
	width: 100%;
	height: 100%
}

.img_box .maodian {
	position: absolute;
	padding: 5px 10px;
	border-right: 5px;
	background: #ff0000;
	filter: alpha(opacity = 60);
	-moz-opacity: 0.6;
	opacity: 0.6;
	top: 10px;
	left: 10px;
	color: #FFF;
	font-size: 12px;
	font-family: "宋体";
	cursor: pointer;
}

.maodian a {
	color: #FFF;
	text-decoration: none;
}
</style>


<script src="js/jquery1.10.js"></script>
<script type="text/javascript" src="js/domutil.js"></script>
<script type="text/javascript" src="js/jst.js?ver=5668072363"></script>
<script type="text/javascript" src="js/json.js"></script>
<script type="text/javascript" src="js/zrpc.js.jsp"></script>


<script>
	$(function()
	{
		var obj = null;//定义标签对象的全局变量，目的用于编辑
		$("#add").click(function()
		{//绑定添加按钮单击事件
			var title = $("input[name=title]").val();//取得标题内容
			if (title == '')
			{
				alert("必须输入标识");
				retur;
			}
			var link = '';
			var left = $(".img_box").scrollLeft()+10 ;
			var top=$(".img_box").scrollTop()+10; 
		    newHotPoint( left , top , title);
			readyToAdd();

		});

		
		function  newHotPoint( left , top , title)
		{
		
			var link = '';
			var html = "<p class='maodian'  style='left:"+left+"px; top:"+top+"px;'><a href='"+link+"'  >" + title + "</a></p>";//组装P标签
 			$(".img_box").append(html); //添加到img_box div中，即图片的后面
 		}
		
		
		$(".img_box").delegate(".maodian", "mousedown", function(e)
		{//绑定标签鼠标按下事件
			obj = $(this);//把当前标签对象赋值给变量
			if (obj.setCapture)
			{ //用于兼容非准浏览器
				obj.setCapture();
			}
			$("input[name=title]").val(obj.find("a").text());//把点中标签的内容加到标题文本框中

			setTimeout(function()
			{
				$("#add").css("display", "none");
				$("#show").css("display", "");
				$("#delete").css("display", "");
			}, 100);

			var _x = e.pageX - obj.offset().left;//取得鼠标到标签左边left的距离
			var _y = e.pageY - obj.offset().top; //取得鼠标到标签顶部top的距离
			var oWidth = $(this).outerWidth(); //取得标签的宽，包括padding
			var oHeight = $(this).outerHeight();//取得标签的高，包括padding
			var x = 0, y = 0; //定义移动的全局变量

			$(".img_box").bind("mousemove", function(e)
			{
				var img_position = $(".img_box").offset(); //取得图片的位置
				x = e.pageX - _x - img_position.left + +$(".img_box").scrollLeft();  //计算出移动的x值
				y = e.pageY - _y - img_position.top + $(".img_box").scrollTop(); //计算出移动的y值
				if (x < 0)
				{ //如果移动小于0，证明移到了图片外，应设为0
					x = 0;
				}
				else if (x > ($(".img_box img").width() - oWidth))
				{
					//如果移动大于图片的宽度减去标签的宽度，证明移到了图片外，应该设为可用的最大值
					x = $(".img_box img").width() - oWidth;
				}

				if (y < 0)
				{ //同上
					y = 0;
				}
				else if (y > ($(".img_box img").height() - oHeight))
				{
					y = $(".img_box img").height() - oHeight;
				}
				obj.css({
					"left" : x,
					"top" : y
				});
			});

			$(".img_box").bind("mouseup", function()
			{ //绑定鼠标左键弹起事件
				$('.img_box').unbind("mousemove"); //移动mousemove事件
				$(this).unbind("mouseup"); //移动mouseup事件
				if (obj.releaseCapture)
				{ //兼容非标准浏览器
					obj.releaseCapture();
				}

			});
			return false; //用于选中文字时取消浏览器的默认事件
		});

		$(".img_box").delegate(".maodian", "dblclick", function()
		{//绑定双击事件
			if (confirm("确信要删除吗 ？"))
				$(this).remove(); //删除当前标签
		})

		$("#show").click(function()
		{//绑定编辑按钮
			//更新内容到标签
			obj.find("a").text($("input[name=title]").val()).attr("href", '');
		})

		$("#delete").click(function()
		{//绑定编辑按钮

			if (confirm("确信要删除吗 ？"))
			{
				obj.remove(); //删除当前标签
				readyToAdd();
			}

		})

		$(".img_box").delegate("a", "click", function()
		{ //取消a标签的单击默认事件

			$("#add").css("display", "none");
			$("#show").css("display", "");
			$("#delete").css("display", "");

			return false;
		});

		$(".img_box").on("click", function()
		{ //取消a标签的单击默认事件

			readyToAdd();

		});

		function readyToAdd()
		{
			$("input[name=title]").val('');
			$("#add").css("display", "");
			$("#show").css("display", "none");
			$("#delete").css("display", "none");
		}
		
		
		$("#save").on("click", function()
				{ //取消a标签的单击默认事件

			 		var imgCoord=$(".img_box img").offset();
				
				    var ret=[];
					var  p= $('.maodian');
				    for( var i=0;i<p.length;i++)
				    {
				    		var a= $(p[i]).find('a');
				    		var coord= $(p[i]).offset();
				    		var one={ x:coord.left - imgCoord.left , y:coord.top - imgCoord.top , text: a.text()};
				    		ret.push(one);
				    }

					$rpc('wiseoa.mapshow.rpc.MapShowRPC', 'saveHotPointDefine', 
							{
						 	 
								 id: urlArg.id, 
								 hotpoint: ret 
							}, 
							function(result) 
							{
							 	var data = JSON.parse(result);
							 	if (data.success)
								{
										alert("保存成功");
								}else
								{
										alert( data.message);
								}
							    
							}); 
			 	 
					  
				}
		);
				    
	  
		var hotPoints=<c:out value="${hotpoints}"  escapeXml="false"/>;
		for( var i=0;i<hotPoints.length;i++)
		{
			newHotPoint( hotPoints[i].x , hotPoints[i].y , hotPoints[i].text);
		}

	});
</script>
<body scroll="no">

	<div class="img_box">
		<img src="<c:out value="${background}"/>">
	</div>



	<div class="box">
		&nbsp;标识：
		<input type="text" name="title" style="height: 20px;">

		<input type="button" value="添加标记" id="add">
		<input type="button" value="生效" id="show" style="display: none;">
		<input type="button" value="删除" id="delete" style="display: none;">
		<input type="button" value="保存" id="save">

	</div>



</body>

</html>

