<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ page import="wiseoa.*"%>
<%@ page import="wiseoa.util.*"%>
<%@ page import="wiseoa.mail.jstl.*"%>
<%@ page import="IM.server.*"%>
<%@ page import="wiseoa.flow.jstl.*"%>

<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>


<%
	request.setCharacterEncoding("UTF-8");
	FF.setResponseContentType(response);

	System_BaseInfo gInfo = System_BaseInfo.getInstance(request);
	FF.pageContextSetAttribute(pageContext, "logohtml", gInfo.getLogoHTML(0, true));
	FF.pageContextSetAttribute(pageContext, "globalconfig", gInfo.GlobalConfig);

	//待办工作
	FlowTodoType ftt = new FlowTodoType(request);
	FF.pageContextSetAttribute(pageContext, "flownodelist", ftt.flowNodeList);
	FF.pageContextSetAttribute(pageContext, "draftTypeCount", ftt.draftTypeCount);
	FF.pageContextSetAttribute(pageContext, "groupNodeList", ftt.groupNodeList);

	FF.pageContextSetAttribute(pageContext, "todoCount", ftt.todoCount);
	FF.pageContextSetAttribute(pageContext, "draftCount", ftt.draftCount);
	FF.pageContextSetAttribute(pageContext, "CountPerPage", 5);
%>

<!DOCTYPE html>
<html>
<head>
<title>待办工作导航</title>

<jsp:include page="global2.jsp?swipeout=1" flush="true" />
<jsp:include page="qa_toolbar2.jsp?work=active&v=1" flush="true" />

<style>

  .content-block-title {font-size:18px;}
   li {font-size:16px;}
  
   
</style>


</head>
<body>

	<div class="page " style="margin: 0; padding: 0;">

		<header class="bar bar-nav">
			<a class="button pull-left  external" style="border: 0"
				href='m-work-home.jsp'> <i class="fa fa-chevron-left "></i>
				<span>返回</span>
			</a>
			<h1 class="title"></h1>
		</header>

<div class="content">

		<!-- 待办 -->
		<c:forEach var="item" items="${groupNodeList}" varStatus="status">

			
				<div class="content-block-title">
					<c:out value="${item.groupname}" />
				</div>
				<div class="list-block">
					<ul>

						<c:forEach var="flowitem" items="${item.flowlist}"
							varStatus="flowstatus">
							<c:forEach var="nodeitem" items="${flowitem.nodelist}"
								varStatus="nodestatus">

								<li><a
									href="m-work-list.jsp?box=todo&fromgroupid=<c:out value="${item.groupid}"/>&flowid=<c:out value="${nodeitem.flowid}"/>&templateid=<c:out value="${nodeitem.templateid}"/>&nodeguid=<c:out value="${nodeitem.guid}"/>"
									class=" external item-link item-content">
										<div class="item-media">
											<i class="icon fa  fa-inbox fa-lg"></i>
										</div>
										<div class="item-inner">
											<div class="item-title">
												<c:out value="${flowitem.flowname}" />
												:
												<c:out value="${nodeitem.nodename}" />
											</div>
											<div class="item-after">
												<span class="badge "
													style='color: white; background-color: red;'> <c:out
														value="${nodeitem.wc}" />
												</span>
											</div>
										</div>
								</a></li>

							</c:forEach>

						</c:forEach>
						</ul>
	</div>
	
		</c:forEach>
		
	</div>
	</div>


</body>
</html>
