var temp=0;

var g_route=undefined;


function getRootPath() {
	var strFullPath = window.document.location.href;
	var strPath = window.document.location.pathname;
	if ('' == strPath || '/' == strPath) {
		return strFullPath;
	}
	var pos = strFullPath.indexOf(strPath);
	var prePath = strFullPath.substring(0, pos);
	var postPath = strPath.substring(0, strPath.substr(1).indexOf('/') + 1);
	if (postPath !==null && postPath!== "") {
		return (prePath + postPath + '/');
	} else {
		return (prePath + '/');
	}
}
var map;
var imagesPath = getRootPath() + '/image/';

$(function() {
	initMap();
	initTools();
	initMenu();
});


window.onload=loadRoute;

function loadRoute()
{
	var s=runTask("yxMapGetRoute",{id:g_id, table:g_table});
	showRoute(s);
}


function showRoute(s)
{ 
	if( s=='') return; 
	//alert(s);
	var p=JSON.parse(s);
	// 起点
	
	if(! p.marker) return; 
	
		var startIcon = new YxMap.Icon(imagesPath + "start.png", new YxMap.Size(42, 28),new YxMap.Pixel(-21,-28));
		var startMarker = new YxMap.Marker("startMarker", new YxMap.LonLat(p.marker.startMarker.lon ,p.marker.startMarker.lat), startIcon);
		map.addMarker(startMarker);
		map.startMarker = startMarker;
	 
		//途中点
		map.viaMarker=[];
		var viaMarkerConfig=p.marker.viaMarker;
		for( var i=0;i<viaMarkerConfig.length;i++)
		{  
			var index=viaMarkerConfig[i].index ;
			var id = viaMarkerConfig[i].id;  
		 
			var viaIcon = new YxMap.Icon(imagesPath + "via.png", new YxMap.Size(42, 28),new YxMap.Pixel(-21,-28));
		
			var viaMarker = new YxMap.Marker(id, new YxMap.LonLat( viaMarkerConfig[i].lon , viaMarkerConfig[i].lat)  ,viaIcon);
			viaMarker.$index=index;//增加一个index 属性
			viaMarker.$id=id;//增加一个ID属性
	 
		
			map.addMarker(viaMarker);
			map.viaMarker.push( viaMarker );
	 
		
			viaMarker.setTitle( buildTitle ( id, index , viaMarkerConfig[i].title) );
		}
		
	//终点
		
		var endIcon = new YxMap.Icon(imagesPath + "end.png", new YxMap.Size(42, 28),new YxMap.Pixel(-21,-28));
		var endMarker = new YxMap.Marker("endMarker", new YxMap.LonLat(p.marker.endMarker.lon ,p.marker.endMarker.lat), endIcon);
		map.addMarker(endMarker);
		map.endMarker = endMarker;
		
	//路径
		responseRouteSuccess( p.route);
		
		map.setZoomAndCenter(12, p.center );
		
		
		
		
}



/**
 * 地图操作
 * @type 
 */

	
function initMap(){
	YxMap.imgPath = 'resources/theme/default/images/';
	map = new YxMap.Map( 'map', {
		zoomLevel:11,
		minZoomLevel:3,
		maxZoomLevel:15
		
		
    });
	
	map.setZoomAndCenter(12, {lon:121.55761, lat:29.871388});
	
}
		
	
function initTools(){
	var 	zoomBox = new YxMap.Control.ZoomBox({title:"拉框"});
	var  zoomIn = new YxMap.Control.ZoomIn({title:"放大"});
	var	zoomOut = new YxMap.Control.ZoomOut({title:"缩小"});
	var	clear = new YxMap.Control.Clear({title:"清除"});
	var dragMarker = new YxMap.Control.DragMarker({title:"移动标记"});
 
	var selectFeature= new YxMap.Control.SelectFeature({title:"选择"});
	
	var dragRouteLine = new YxMap.Control.DragRouteLine({
		title:"路径编辑",
		removeOldRouteLine:true
	});
	
	
	var tools = [
	  
		zoomIn,
		zoomOut,
		dragMarker,
	 
		clear
		
    ];
	
	map.addTools(tools);
	dragRouteLine.on({
		onGetRouteStartViaEnd:function(object){
			var multiNav = object.start.lon +"_" + object.start.lat
				+"$" + object.via.lon +"_" + object.via.lat
				+"$" + object.end.lon +"_" + object.end.lat;
			var caltype = 1;
			requestRoute(multiNav,caltype);
			if(map.startMarker == null){
				var startIcon = new YxMap.Icon(imagesPath + "start.png", new YxMap.Size(42, 28),new YxMap.Pixel(-21,-28));
				var startMarker = new YxMap.Marker("startMarker",object.start,startIcon);
				map.addMarker(startMarker);
				map.startMarker = startMarker;
			}
	
			if(object.via != null){
				
				var viaIcon = new YxMap.Icon(imagesPath + "via.png", new YxMap.Size(42, 28),new YxMap.Pixel(-21,-28));
				var viaMarker = new YxMap.Marker("viaMarker",object.via,viaIcon);
				
				map.addMarker(viaMarker);
				map.viaMarker = viaMarker;
			}
			
			if(map.endMarker == null){
				var endIcon = new YxMap.Icon(imagesPath + "end.png", new YxMap.Size(42, 28),new YxMap.Pixel(-21,-28));
				var endMarker = new YxMap.Marker("endMarker",object.end,endIcon);
				map.addMarker(endMarker);
				map.endMarker = endMarker;
			}
		}
	});
}
	
function initMenu(){
	var contextMenu = map.getContextMenu();
	var menuItem1 = new YxMap.MenuItem(null,"获取经纬度");
	contextMenu.addItem(menuItem1);
	contextMenu.addSeparator();
	var menuItem2 = new YxMap.MenuItem(null,'以此为起点');
	contextMenu.addItem(menuItem2);
	contextMenu.addSeparator();
	
	var menuItem5 = new YxMap.MenuItem(null,'增加途中点');
	contextMenu.addItem(menuItem5);
	contextMenu.addSeparator();
	
    var menuItem3 = new YxMap.MenuItem(null,'以此为终点');
	contextMenu.addItem(menuItem3);
	contextMenu.addSeparator();
	
	 
	
	var menuItem4 = new YxMap.MenuItem(null,'清除所有');
	contextMenu.addItem(menuItem4);
	menuItem1.on({
	    clicked : function(o){ 
			alert(this.menu.lonlat);
		}
	});
	menuItem2.on({
		clicked : function(o){ 
			//一个地图只有一个起点
			var startMarker =map.getMarkerByID('startMarker');
			if(startMarker!=null){
				map.removeMarker(startMarker);
			}
			var startIcon = new YxMap.Icon(imagesPath + "start.png", new YxMap.Size(42, 28),new YxMap.Pixel(-21,-28));
			startMarker = new YxMap.Marker("startMarker",this.menu.lonlat,startIcon);
			
			map.addMarker(startMarker);
			map.startMarker = startMarker;

			doRequestRoute();
		}
	
	});
	menuItem3.on({
		clicked : function(o){ 
			//一个地图只有一个终点
			var endMarker =map.getMarkerByID('endMarker');
			if(endMarker!=null){
				map.removeMarker(endMarker);
			}
			var endIcon = new YxMap.Icon(imagesPath + "end.png", new YxMap.Size(42, 28),new YxMap.Pixel(-21,-28));
			endMarker = new YxMap.Marker("endMarker",this.menu.lonlat,endIcon);
			map.addMarker(endMarker);
			map.endMarker = endMarker;
			
			doRequestRoute();
		}
	
	});
	
	menuItem4.on({
		clicked : function(o){ 
			map.clearMarkers();
			map.clearFeatures();
			map.startMarker = null;
			map.viaMarkers =[];
			map.endMarker = null;
		}
	
	});
	
	 
	
	menuItem5.on({
		clicked : function(o){ 
		 
			if( !map.viaMarker)
			{
				map.viaMarker=[];
			}
			
			var index=map.viaMarker.length+1;
			var id=newGuid();  
			 
			var viaIcon = new YxMap.Icon(imagesPath + "via.png", new YxMap.Size(42, 28),new YxMap.Pixel(-21,-28));
			
			var viaMarker = new YxMap.Marker(id,this.menu.lonlat,viaIcon);
		  	viaMarker.$index=index;//增加一个index 属性
			viaMarker.$id=id;//增加一个ID属性
			//var popup= new YxMap.Popup("viaMarker_11" , this.menu.lonlat , new YxMap.Size(150, 150) , "title", "CONTENT" );
			 
			viaMarker.on(
					{
						clicked:function(o)
						{
				//			if(! map.controls[3].active )    alert("click");
						},
						rightclicked:function (o)
							{
					//			alert( "rightclick");
							} 
					});
			
			map.addMarker(viaMarker);
	 		map.viaMarker.push( viaMarker );
			
			
		//	map.addMarker(popup);
		//	popup.addToMarker( viaMarker);
			
			viaMarker.setTitle( buildTitle ( id, index) );
			 
			doRequestRoute();
			
		}
	
	});

	
}



function callback_addStartMaker(lon,lat)
{
	//一个地图只有一个起点
	var startMarker =map.getMarkerByID('startMarker');
	if(startMarker!=null){
		map.removeMarker(startMarker);
	}
	var startIcon = new YxMap.Icon(imagesPath + "start.png", new YxMap.Size(42, 28),new YxMap.Pixel(-21,-28));
	startMarker = new YxMap.Marker("startMarker",new YxMap.LonLat(lon,lat) ,startIcon);
	
	map.addMarker(startMarker);
	map.startMarker = startMarker;
	doRequestRoute();
}

function callback_addEndMaker(lon,lat)
{
	//一个地图只有一个终点
	var endMarker =map.getMarkerByID('endMarker');
	if(endMarker!=null){
		map.removeMarker(endMarker);
	}
	var endIcon = new YxMap.Icon(imagesPath + "end.png", new YxMap.Size(42, 28),new YxMap.Pixel(-21,-28));
	endMarker = new YxMap.Marker("endMarker",new YxMap.LonLat(lon,lat) ,endIcon);
	
	map.addMarker(endMarker);
	map.endMarker = endMarker;
	doRequestRoute();
}



function newGuid()
{
    var guid = "";
    for (var i = 1; i <= 32; i++){
      var n = Math.floor(Math.random()*16.0).toString(16);
      guid +=   n;
      if((i==8)||(i==12)||(i==16)||(i==20))
        guid += "-";
    }
    return guid;    
}

function buildTitle(id,index , title )
{
	var ret="";
	if( title==undefined) title="";
	 
	ret = "<table border=0 cellspacing=0 cellpading=0><tr><td style='border:1px solid #a0a0a0; background-color:blue;color:white;'    title='途中点顺序'>"+
	index+title+"</td>";
	
	if( g_table=='bi_wl_jclx')
	{ 
		  ret=ret+		"<td><img src='image/split_up.gif' title='顺序向前调'  viaid="+id+" style='cursor:hand' onclick='rebuildIndex( this,  -1 )' >"+
			"<br><img src='image/split_down.gif'  title='顺序向后调'   viaid="+id+" style='cursor:hand' onclick='rebuildIndex( this,  1 )'>"+
			"<td valign='top'><img src='image/ca.gif'  title='删除本途中点'  viaid="+id+" style='cursor:hand' onclick='deleteVia( this )' ></td>";
	}
	ret=ret+"</tr></table>";
	return ret;

}

//把某个途中点的顺序号设置成新的顺序号，并调整其它途中点的顺序号
function rebuildIndex(obj, delta)
{
	var id= obj.getAttribute("viaid");
	var marker=map.getMarkerByID( id);

	
	var oldIndex=marker.$index;
	var newIndex=marker.$index+delta;
	
	if( newIndex==0) return;
	if(newIndex>map.viaMarker.length) return; 
	
	
	var nextMarker =null; 
	for( var i=0;i<map.viaMarker.length;i++)
	{
		var m= map.viaMarker[i];
		if( m.$index==newIndex) 
		{
			nextMarker=m;
			break;
		} 
	}
	
	if( nextMarker!=null)
	{ 
		marker.$index=newIndex;
		marker.setTitle( buildTitle ( marker.$id,marker.$index) );
		nextMarker.$index=oldIndex;
		nextMarker.setTitle( buildTitle ( nextMarker.$id,nextMarker.$index) );
	 
	}
		 
	 
	doRequestRoute();
	 
}


function deleteVia(obj)
{
	var id= obj.getAttribute("viaid");
	if(!confirm("确信要删除本途中点吗")) return;
	
	var marker=map.getMarkerByID( id);
	var index= marker.$index;
	
	map.viaMarker.remove( marker);
	map.removeMarker(marker);
	
	for( var i=0;i<map.viaMarker.length;i++)
	{
		marker= map.viaMarker[i];
		if( marker.$index<=index) continue;
		marker.$index=marker.$index - 1;
		marker.setTitle( buildTitle ( marker.$id,marker.$index) );
	}
	 
	doRequestRoute();
	
	
}

function doRequestRoute() 
{ 
	if(map.startMarker ==null ) return ;
	if(map.endMarker==null) return;
	
	  
	var lonlat = map.startMarker.lonlat.lon +"_" + map.startMarker.lonlat.lat;
	
	if( map.viaMarker)
	{
		//按$index 途中点的顺序 号把坐标拼起来
		for( var j=0;j<map.viaMarker.length;j++)
		{ 
			for( var i=0;i<map.viaMarker.length;i++)
			{
				var marker=map.viaMarker[i];
				if( marker.$index !=j+1) continue;
				lonlat=lonlat+"$" + marker.lonlat.lon +"_" + marker.lonlat.lat;
			}
		}
	}
	
	if( map.endMarker!=null )  lonlat=lonlat  +"$" + map.endMarker.lonlat.lon +"_" + map.endMarker.lonlat.lat;
	
	var caltype = 1;
	requestRoute(lonlat,caltype);
}

function requestRoute(lonlat,caltype){
		var url = getRootPath()+"yxMapRoute.jsp?lonlat="+lonlat+"&caltype="+caltype;
		jQuery.getJSON(url,responseRouteSuccess);
}

function responseRouteSuccess(data){
	
	g_route=  data ;
	
	
	if(data.stat == "ok"){
		var style = {
			    strokeWidth: 6,
			    strokeOpacity: 0.5,
			    strokeColor: "red"
			}
		
		map.removeAllLines();//先清除
		map.clearFeatures();
		
		var routes = data.routes;
		var routeCnt = routes.length;
		var lines=[];
		for(var i=0;i<routeCnt;i++){
			var route = routes[i];
			var pointCnt = route.length;
			var lonlats=[];
			for(var j=0;j<pointCnt;j++){
				var point = route[j];
				lonlats.push(new YxMap.LonLat(point.lon,point.lat));
			}
			var routeID = "route_"+Date.parse(new Date());
			var route = new YxMap.Overlay.Line(lonlats,routeID,style);
			map.removeLineByID(routeID);
			lines.push(route)
	        
		}
		map.addLines(lines);
	}else{
		
	}
}

function getMarker(marker)
{
	var ret={};
	ret.id=marker.$id;
	ret.index=marker.$index;
	ret.lon =marker.getLonLat().lon;
	ret.lat =marker.getLonLat().lat;
	
	return ret;
	
}

function saveRoute()
{
	if( g_route==undefined) 
		{
		  alert("请先获取线路");
		  return;
		}
	var ret={};
	
	
	ret.startMarker=getMarker(map.startMarker);
	 
	if( !map.viaMarker)
	{
		map.viaMarker=[];
	}
	
	 	ret.viaMarker=[];
		for( var i=0;i<map.viaMarker.length;i++)
		{
			ret.viaMarker.push( getMarker(map.viaMarker[i]));
		}
	 
	ret.endMarker=getMarker(map.endMarker);
	//alert( JSON.toString(ret));
	//alert( gs_route);
	
	var ret=runTask("yxMapSaveRoute",{id:g_id,marker:ret, route:g_route});
	if( ret=="true")
		{
		alert("保存成功。 ");
		}else
			{
			  alert( "保存失败，原因是："+ret);
			}
	
}


/*
YxMap.DomHelper.onImageLoadError = function() {
    this.src = "resources/images/404.gif";
};
*/
var Browser = {
	IE_6:"MSIE6.0",
	getViewWidth:function(){
		return self.innerWidth||(document.documentElement.clientWidth||(document.body.clientWidth+4));//for IE:document.body.clientWidth
	},
	getViewHeight:function(){
		return (self.innerHeight-1)||(document.documentElement.clientHeight||(document.body.clientHeight+2));
	},
	/**
	 * 获取浏览器类型
	 * @return {String}
	 */
	getType:function () 
	{ 
	   var OsObject = ""; 
	   if(navigator.userAgent.indexOf("MSIE 6.0")>0) {
	        return "MSIE6.0"; 
	   } 
	   if(navigator.userAgent.indexOf("Firefox")>0){ 
	        return "Firefox"; 
	   } 
	   if(navigator.userAgent.indexOf("Safari")>0) { 
	        return "Safari"; 
	   }  
	   if(navigator.userAgent.indexOf("Camino")>0){ 
	        return "Camino"; 
	   } 
	   if(navigator.userAgent.indexOf("Gecko/")>0){ 
	        return "Gecko"; 
	   } 
	} 
};
 

Array.prototype.indexOf = function(val) {
    for (var i = 0; i < this.length; i++) {
        if (this[i] == val) return i;
    }
    return -1;
};
Array.prototype.remove = function(val) {
    var index = this.indexOf(val);
    if (index > -1) {
        this.splice(index, 1);
    }
};


