//定义一个全局变量判定是否原生支持showModalDialog方法
var has_showModalDialog = !!window.showModalDialog;
//当其不受支持时自定义window.showModalDialog
if(!has_showModalDialog){
	/* url传入被打开网页的地址
	 * dialogArguments传入子页面需要的参数和判断参数:
	 * 	windowName4Open传入被打开网页的名称;
	 * 	callback4Open传入子窗口返回returnValue时的回调;
	 * 	autoCallback4Open用于打开的网页判断callback4Open是否存在
	 * features子网页的样式*/
	window.showModalDialog = function(url,dialogArguments,features){
		//新窗口的名字。如果该名字的窗口已经存在，则再次调用时占用该窗口，不再新建窗口。如果省略，(浏览器会)默认_blank
		var name = dialogArguments.windowName4Open || '_blank';
		if(name=='_blank' && window.hasOpenWindow){
			//当窗口名为_blank时,再次调用不会占用未关闭的_blank子窗,需要手动避免弹出多个窗口
			//window.myNewWindow.focus();
			//return;
		}
		
		//因window.showmodaldialog 与 window.open 参数不一样，所以封装的时候用正则去格式化一下参数
		if(features)
			features = "modal=yes,"+features.replace(/(dialog)|(px)/ig,"").replace(/;/g,',').replace(/\:/g,"=");
		var left = (window.screen.width - parseInt(features.match(/width[\s]*=[\s]*([\d]+)/i)[1]))>>1;
		var top = (window.screen.height - parseInt(features.match(/height[\s]*=[\s]*([\d]+)/i)[1]))>>1;
		features+=',left='+left+',top='+top;//窗口居中
		//打开子页面
		window.myNewWindow = window.open(url,name,features);
		//定义自动返回returnValue
		if("function" === typeof dialogArguments.callback4Open /*其他条件*/){
			//如果不冲突的情况下通过劫持子窗returnValue,达到无需在子窗手动执行回调的目的
			dialogArguments.autoCallback4Open=true;
			Object.defineProperty(myNewWindow, 'returnValue', {
				get: function() {
					//不需要写成window.myNewWindow.returnValue就可以
					return returnValue;
				},
				set: function(value) {
					returnValue = value;
					//执行函数
					dialogArguments.callback4Open(value);
				}
			});
		}else{
			Object.defineProperty(myNewWindow, 'returnValue', {});
		}
		window.hasOpenWindow = true;
		if(dialogArguments){
			//open()不支持传递参数，通过这种方式向子页面传递参数，因为打开页面速度远远慢于本方法执行速度，因而子页面总能获得传递的参数,
			//也可在子窗load事件发生后使用myNewWindow.postMessage(dialogArguments,url),但在子窗还未load时监听可能无效,但它可以突破同源限制
			window.myNewWindow.dialogArguments=dialogArguments;
		}	
		//window.myNewWindow.moveTo(left,top);
	}
}
//打开模态框
function callSon(){
	url = 'son.html';
	var sonStyle="dialogWidth:500px;dialogHeight:450px;help:no;resizable:no;center:yes;scroll:yes;status:no";
	var param={val:document.getElementById("a").value?document.getElementById("a").value:"son"}
	//固定情况下这两个可以写死在showModalDialog，如果不想多次点击打开多个子页面，则不要给子页面命名
	param.windowName4Open='son';
	param.callback4Open=callSonChrome;
	var val = window.showModalDialog(url,param,sonStyle);
	//chrome下返回不执行afterCall，而是作为回调（callSonChrome），因为IE下showModalDialog是阻塞的可以直接afterCall，open则是异步的;
	if(!has_showModalDialog)
		return;	
	afterCall(val);
}
//为打开的子窗口定义方法，让打开的窗口关闭时通过window.opener赋值回来并执行
function callSonChrome(val){
	afterCall(val);
}
//获得模态框返回值后执行的业务方法
function afterCall(val){
	$("#content").html(val);
}


