/**
 * 
 *   知识库列表
 * 
 * 
 */

 
 
var $G= 
{
	 
	cm:null, //列定义
	ds:null , // 数据来源
	grid: null, //界面
	rightClick:null,

	init :function()
    {
 
	   
     // 数据源
     $G.ds = new Ext.data.Store(
     { 
    	proxy: new Ext.data.HttpProxy({url: 'zrpc.jsp' }),
         
        reader: new Ext.data.JsonReader(
        	{
	            root: 'datas',
	            totalProperty: 'count',
	            id: 'id'
	        },
	        [
	          
	         	{name: 'icon', mapping: 'icon'   },
	         	{name: 'isfolder', mapping: 'isfolder', type:'int'   },
	         	{name: 'isshared', mapping: 'isshared', type:'int'   },
	         	{name: 'onlyname', mapping: 'onlyname'  },
	         	{name: 'showname', mapping: 'showname'  },
	         	{name: 'fullname', mapping: 'fullname'  },
	            {name: 'path', mapping: 'path'   },
	            {name: 'filetype', mapping: 'filetype' },
	            {name: 'filesize', mapping: 'filesize'  , type:'int' },
	            {name: 'filesizetext', mapping: 'filesizetext'   },
	            
	            
                {name: 'modifydate', mapping: 'modifydate' , type: 'date' ,dateFormat:'Y-m-d h:i'} 	        
          
                
	        ]),

        // turn on remote sorting false
        remoteSort: false   
        
     
     
    }); 

  
   　
    // 列配置
    $G.cm = new Ext.grid.ColumnModel([
		    	
	 
		{
           id: 'onlyname', // id assigned so we can apply custom css (e.g. .x-grid-col-topic b { color:#333 })
           header: "名称",
           dataIndex: 'onlyname',
           width: 300,
           renderer: $G.renderName,
           sortable:true
        },
        {
           id: 'filetype', // id assigned so we can apply custom css (e.g. .x-grid-col-topic b { color:#333 })
           header: "类型",
           dataIndex: 'filetype',
           width: 50,
           renderer: $G.renderFileType,
           sortable:true
        },
         
        {
            id: 'filesize', // id assigned so we can apply custom css (e.g. .x-grid-col-topic b { color:#333 })
            header: "大小",
            dataIndex: 'filesize',
            width: 60,
            renderer: $G.renderFileSize,
            sortable:true
         },
         
        {
           id: 'modifydate',
           header: "修改时间",
           dataIndex: 'modifydate',
           width: 110,
           renderer: $G.renderModifyDate,
           sortable:true
        }]);

 
 

    // create the editor grid
    $G.grid = new Ext.grid.Grid('grid', {
        ds: $G.ds,
        cm: $G.cm,
        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
        enableColLock:false,
        loadMask: true
    });

    var grid=$G.grid;
    
    // render it
    grid.render();
    grid.on('rowdblclick', function(sm, index, record){  	 var pw=DomUtil.parentWindow(); pw.$G.edit() ;  } );
  
    grid.addListener('rowcontextmenu', rightClickFn);//右键菜单代码关键部分 
    
    $G.rightClick = new Ext.menu.Menu({ 
        id:'rightClickCont', 
        items: [ 
            { 
                //id: 'rMenu1', 
                handler: function(){ DomUtil.parentWindow().$G.Cut();},
            	pressed:true,
                text: '剪切'  
            }, 
            { 
                //id: 'rMenu2', 
                handler: function(){ DomUtil.parentWindow().$G.Copy();}, 
            	pressed:true,
                text: '复制'  
                 
            } 
             , 
            { 
                //id: 'rMenu2', 
                handler: function(){ DomUtil.parentWindow().$G.Paste();}, 
            	pressed:true,
                text: '粘贴'  
                 
            } , 
            { 
                //id: 'rMenu2', 
                handler: function(){ DomUtil.parentWindow().$G.Rename();}, 
            	pressed:true,
                text: '改名'  
                 
            } , 
            { 
                //id: 'rMenu2', 
                handler: function(){ DomUtil.parentWindow().$G.Delete();}, 
            	pressed:true,
                text: '删除'  
                 
            } , 
            { 
                //id: 'rMenu2', 
                handler: function(){ DomUtil.parentWindow().$G.Download();}, 
            	pressed:true,
                text: '下载'  
                 
            } 
             
             
            
        ] 
    }); 

    //右键菜单代码关键部分 
    function rightClickFn(grid,rowindex,e){ 
        e.preventDefault(); 
        $G.rightClick.showAt(e.getXY()); 
    } 

    


    var gridFoot = grid.getView().getFooterPanel(true);
 
     $G.retrieve( gPath , gFocus); //刷新出文件

      
     
    } ,  // end of  function init
    
    refresh:function( )
    {
        $G.retrieve(gPath );
    } , 
    
    retrieve:function ( path, focus)
    {
	     var param= new Object();
	     param.start=0;
	     param.limit=0;
	     param.path=path;
	     param.focus= focus;
	      
 
	     var jsonParamString= JSON.toString (  param );
	     
	    $G.ds.load({params:{ classname  :'wiseoa.netdisk.NetDisk', 
	                                              methodname    : 'getItemList' , 
	                                              parameter         : jsonParamString ,
	                                              start:0,
	                                              limit:99999999 
	                                        } ,  
	                          callback:  function ( )
	                                      { 
                                                  // 检索结束后，显示当前路径，如果有需要亮显的文件，那么亮显它	                                        	
	                                        	 var pw=DomUtil.parentWindow();
	                                        	 pw.setCurrentItem( $G.ds.reader.jsonData);
	                                        	 var focusRow= $G.ds.reader.jsonData.focusRow  ;
	                                        	 
	                                          	 if ( focusRow>=0)  $G.grid.getSelectionModel().selectRow( focusRow , true);
	                                        } 
	                         } );
    } ,
    
    
  
      
     
     //缺省的渲染
    renderDefault:function(value)
   	{
        return String.format('{0}', value);
    } , 
     
     
    renderFileType :function(value, p, record)
    {
    	if (  value=='kno' )   		return '<font color=red>※</font>文档';
    	if (  value=='wss' )   		return '<font color=blue>※</font>表格';
    	return value;
    } ,
    
    renderFileSize:function( value, p, record)
    {
    	 return  "<span  title='"+record.data['filesize']+"' >"+record.data['filesizetext']+"</span>"; 
    },
    
    
    renderName  :function(value, p, record)
    {
      
        if ( record.data['isfolder']==1)   	return "<img src='image/filetype/"+( record.data['isshared']==1?"shared":"") +"folder.gif'  align='absmiddle'>" +record.data['showname'];
	   
	    return "<img src='image/filetype/"+record.data['icon']+".gif'  alt='' align='absmiddle'>" + record.data['showname'] ;
    } ,
     
    renderModifyDate:function(value, p, r)
    {
    	 if ( ! value) return ""; 
    	 if ( typeof(value)=="string") return value;
        return String.format('{0}', value.dateFormat('Y.m.d h:i'));
    },
    
    renderUserName:function(value,p,record)
    {
        return   record.data['usershowname']  ;
    } 

    
    
    

} ; //  end of    gb
 
 
 
Ext.onReady( $G.init ); 
 

