 
 
$(document).ready(function() {

    	fullScreen();
    	
    	
    });
    
    
    $(window).on("resize" , function() {

    	fullScreen();
    	
    });
  
  


var margin = {
            left: 0,
            top: 0,
            right: 10,
            bottom: 10
        },
        width = $("#new_flashcontent").parent().width(),
        height = $("#new_flashcontent").parent().height(),

        bg_width = 2105,
        bg_height = 1005,
        ratio_init = width / bg_width;


    

    var zoom = d3.behavior.zoom()
        .scaleExtent([ratio_init, 3])
        .on("zoom", zoomed);

    var drag = d3.behavior.drag()
        .origin(function(d) {
            return d;
        })
        .on("dragstart", dragstarted)
        .on("drag", dragged)
        .on("dragend", dragended);

    var _svg = d3.select("#new_flashcontent").append("svg")
        .attr("width", width)
        .attr("height", height)
        .call(zoom)
         ;


    // 总容器
    var container = _svg.append("g");
    container
        .attr("class", "all")
        .append("image")
        .attr("xlink:href", background)
        .attr("x", "0")
        .attr("y", "0")
        .attr("width", bg_width)
        .attr("height", bg_height)
// .attr("transform", "translate(" + margin.left + "," + margin.top + ")scale(" + ratio_init + ")")
        
        ;
  
    
    var arrSort= mapShowData.legend;
    
    // 生成左侧面板数据
   
    $.each(arrSort, function(index, val) {
         $('#legendContainer').append(
           
            "<table border=0 style='width:100%;font-size:14px;'><tr  ><td style='border-bottom:1px dotted gray;'><img src='" + val.photo  
            + "' width='32'></td><td style='border-bottom:1px dotted gray;padding-left:10px;text-align:left;' align='left' >" +
              val.title + 
            "</td></tr></table>"
            );
    });
    
     

    // 放置位置点的集合
    var container_dots = container.append("g").attr("class", "dots");

    var arr = mapShowData.anchor;
    for( var i=0;i<arr.length;i++)
    	{
    	   var code= arr[i].code;
    	   var coord=hotPointMap[code];
    	   if( coord==undefined) coord={x:0, y:0};
    	   arr[i].x= coord.x;
    	   arr[i].y=coord.y;
    	   
    	
    	}

                
    // 所有点定义
    $.each(arr, function(index, val) {

        var container_ci = container_dots.append("g")
            .attr("class", "ci sort"+val.sort);

        // 负值绝对值越大 越向下
        var offset_x = 0, offset_y = 0;
        var RECT_W = 20,RECT_H = 42;

        // 定位小园点
        container_ci.append("circle").attr("cx", val.x+offset_x).attr("cy", val.y+offset_y);

        // 坐标点上的图片

        container_ci
            .append("image")
            .attr("xlink:href", arrSort[ val.legend].img )
            .attr("id", index)
            .attr("x", val.x-RECT_W/2+offset_x )
            .attr("y", val.y-RECT_H+2+offset_y )
            .attr("width", RECT_W)
            .attr("height", RECT_H)
           ;

        // 坐标点上的点击区
        
        container_ci
            .append("rect")
            .attr("id", val.sort)
            .attr("x", val.x-RECT_W/2+offset_x)
            .attr("y", val.y-RECT_H+2+offset_y)
            .attr("width", RECT_W)
            .attr("height", RECT_H)
            .on("click", function(e) {
                var index = this.id;
             //   console.log(index);
              
                $('.pop .tit').text( val.code);
                
                $('.pop .content').html( val.content );
                
               var  img= arrSort[ val.legend].photo || arrSort[ val.legend].img ;
               
               if( val.img||''!='' )  img= val.img; 
                $('.pop .picture').html( "<img src='"+  img+"'/>" );
             
                $('.pop').slideDown('200');
            })
            .on("mouseover", function(e) {
                TweenMax.to($(this).prev(), .1, {
                    y: "-=8",
                    repeat: 5,
                    yoyo: true
                });
                
                
                
                
            })
            .on("mouseout", function(e) {
                TweenMax.to($(this).prev(), .1, {y: "0"});
            }) ;
    });

    // 将画布调整到起始比率
    zoom.scale(ratio_init);
    zoom.event(_svg.transition().duration(200));


    function dottype(d) {
        d.x = +d.x;
        d.y = +d.y;
        d.id = +d.id;
        return d;
    }

    function zoomed() {
        $('.tip i').text((d3.event.scale).toFixed(2));
        container.attr("transform", "translate(" + d3.event.translate + ")scale(" + d3.event.scale + ")");
    }

    function dragstarted(d) {
        d3.event.sourceEvent.stopPropagation();
        d3.select(this).classed("dragging", true);
    }

    function dragged(d) {
        d3.select(this).attr("cx", d.x = d3.event.x).attr("cy", d.y = d3.event.y);
    }

    function dragended(d) {
        d3.select(this).classed("dragging", false);

    }

    // 分类面板
    $('.sort li').click(function(event) {
        var _li = $(this).attr("class");
        var obj = $("svg ." + _li + " image");
        TweenMax.to(obj, .1, {
            y: "+=-13",
            repeat: 5,
            yoyo: true
        });
    });

    // 分类面板收缩
   
    /*
    $('.side').click(function(event) {
        if($('.panel').hasClass('active'))
            {$('.panel').removeClass('active')}
        else{
            {$('.panel').addClass('active')}
        }
    });
*/
    
    // 弹窗
    $('.pop i').click(function(event) {
        $('.pop').slideUp().children('span').text("");
    });

    // 右上角的比例显示
    $('.tip i').text(ratio_init.toFixed(2));

    // 变尺寸 
    var _box = $(".box1");
    function fullScreen(event) 
    {
        
            _box.addClass('fullscreen');
            _w = $(window).innerWidth();
            _h = $(window).innerHeight();
           
 
        TweenMax.to( $('.box1'),0,{width:_w,height:_h,
                onComplete:function(){
                	 
                        box_resize(_w,_h);
                 
                	
                    }})
    }


     
    function box_resize(width,height) {
        

        // 变换画布
        /*width = $("#new_flashcontent").parent().width(),
        height = $("#new_flashcontent").parent().height();*/
        ratio_init = width / 2105;
        
        // 改变画布尺寸
        TweenMax.to($('svg'),.3,{width:width,height:height});

        // 改变位移和比例
        zoom.translate([0,0]).scale(ratio_init);
        zoom.event(_svg.transition().duration(200));

    }
    
    
     

