/**
 * 
 *   教学计划设置列表
 * 
 * 
 */

 
var $G= 
{
	 
	cm:null, //列定义
	ds:null , // 数据来源
	grid: null, //界面
	
	init :function()
    {
 
	   
     // 数据源
     $G.ds = new Ext.data.Store(
     { 
    	proxy: new Ext.data.HttpProxy({url: 'zrpc.jsp' }),
         
        reader: new Ext.data.JsonReader(
        	{
	            root: 'datas',
	            totalProperty: 'count',
	            id: 'id'
	        },
	        [
	            {name: 'id', mapping: 'id' , type:'int' },
	            {name: 'name', mapping: 'name' },
	            {name: 'summary', mapping: 'summary' },
	            {name: 'userid', mapping: 'userid'  },
                {name: 'disabled', mapping: 'disabled'  },
                {name: 'isvalidate', mapping: 'isvalidate' , type:'int' },
                {name: 'validatetesttip', mapping: 'validatetesttip'  },
                {name: 'usershowname', mapping: 'usershowname'  },
	            {name: 'createdate', mapping: 'createdate' , type: 'date' ,dateFormat:'Y-m-d h:i:s.0'},	        
                {name: 'isleaf', mapping: 'isleaf' , type: 'int' }          
                
	        ]),

        // turn on remote sorting false
        remoteSort: false
    }); 

  
   　
    // 列配置
    $G.cm = new Ext.grid.ColumnModel([
		    	
		{
		  id:'id',
		  header:'ID',
		  dataIndex:'id',
		  width:0,
		  hidden: true
		},
		{
           id: 'name', // id assigned so we can apply custom css (e.g. .x-grid-col-topic b { color:#333 })
           header: "教学计划名称",
           dataIndex: 'name',
           width: 300,
           renderer: $G.renderName,
           sortable:true
        },
        {
           id: 'userid', // id assigned so we can apply custom css (e.g. .x-grid-col-topic b { color:#333 })
           header: "创建者",
           dataIndex: 'userid',
           width: 70,
           renderer: $G.renderUserName,
           sortable:true
        },
         
        	{
           id: 'createdate',
           header: "创建时间",
           dataIndex: 'createdate',
           width: 100,
           renderer: $G.renderCreateDate,
           sortable:true
        } ,
        
         {
           id: 'isvalidate',
           header: "验证",
           dataIndex: 'isvalidate',
           width: 60,
           renderer: $G.renderIsvalidate,
           sortable:true
        }
        
        ]);

 
 

    // create the editor grid
    $G.grid = new Ext.grid.Grid('grid', {
        ds: $G.ds,
        cm: $G.cm,
        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
        enableColLock:false,
        loadMask: true
    });

    var grid=$G.grid;
    
    // render it
    grid.render();

    var gridFoot = grid.getView().getFooterPanel(true);

    // add a paging toolbar to the grid's footer
    var paging = new Ext.PagingToolbar(gridFoot, $G.ds, {
        beforePageText:'',
        afterPageText:'',
        pageSize: 99999999,
        displayInfo: true,
        displayMsg: '共{2}项',
        emptyMsg: "没有检索到符合条件的"
    });
    // add the detailed view button
    paging.add('-', {
        pressed: false,
        enableToggle:true,
        text: '查看详情',
        
        toggleHandler: $G.toggleDetails
    });
    
      //把父窗口的按钮禁用
 
    
        var $PG=  DomUtil.parentWindow().$G;  
        $PG.enableItemFunction( );
   

  
    
     $G.retrieve( giParentId );

    
     
    } ,  // end of  function init
    
    refresh:function( )
    {
        $G.retrieve(giParentId );
    } , 
    
    retrieve:function ( id)
    {
	     var param= new Object();
	     param.start=0;
	     param.limit=0;
	     param.id=id;
	     var jsonParamString= JSON.toString (  param );
	     
	    $G.ds.load({params:{ classname  :'educ.teachingplan.TeachingPlan', 
	                                              methodname    : 'getItemList' , 
	                                              parameter         : jsonParamString ,
	                                              start:0,
	                                              limit:99999999 
	                                        }});
    } ,
    
    
    toggleDetails:function (btn, pressed)
    {
        $G.cm.getColumnById('name').renderer = pressed ?   $G.renderNameRich : $G.renderName;
        $G.grid.getView().refresh();
    },
    
      
     
     //缺省的渲染
    renderDefault:function(value)
   	{
        return String.format('{0}', value);
    } , 
     
    renderIsvalidate:function (value)
    { 
        return  value==1?"通过":"";
    },
     
    renderNameRich :function(value, p, record)
    {
         if ( record.data['isleaf']==0)
        {
            return "<img src='image/folder14.gif' align='absmiddle'>"+value+'<br>'+record.data['summary'] ;
        }else
        {
            var s=record.data['validatetesttip'];
            if (s.length>0) s="<br><font color=red>"+s+"</font>";
            return String.format('{0}{1} <br><font color=#4848ff>{2}{3}</font>', (record.data['disabled']==1?'[<font color=red>禁用</font>]':''), value, record.data['summary'], s);
        }
    } ,
    
    renderName  :function(value, p, record)
    {
      
        if ( record.data['isleaf']==0)
        {
            return "<img src='image/folder14.gif' align='absmiddle'>"+value;
        }else
        {
            var s=record.data['validatetesttip'];
            if (s.length>0) s="<br><font color=red>"+s+"</font>";
            return (record.data['disabled']==1?'[<font color=red>禁用</font>]':'')+value+ s ;
        }
    } ,
     
    renderCreateDate:function(value, p, r)
    {
    	 if ( ! value) return ""; 
    	 if ( typeof(value)=="string") return value;
        return String.format('{0}', value.dateFormat('Y.m.d h:i'));
    },
    
    renderUserName:function(value,p,record)
    {
        return   record.data['usershowname']  ;
    } 


} ; //  end of    gb
 
 
 
Ext.onReady( $G.init ); 
 

