function getIframeDocument(el) 
{
    var oIframe = Ext.get('main').dom;
    var oDoc = oIframe.contentWindow || oIframe.contentDocument;
    if(oDoc.document) {
        oDoc = oDoc.document;
    }
    return oDoc;
}
   
$G =
 {
    currentTreeId:0,  //当前树结点的ID ，缺省定位在根目录结点上
    cb_addItem:null,
    cb_editItem:null,
    cb_deleteItem:null,
    
     init : function () 
     {
         
        var   northPanel ,   southPanel,  eastPanel,  westPanel, centerPanel;
 
        var mainLayout = new Ext.BorderLayout(document.body, {
            north: { 
                split: true, initialSize: 38 , maxSize:38 , minSize:38
            }, 
            south: { 
                split: false, initialSize: 20 , maxSize:20 , minSize:20
            }, 
            
             west: { 
                split: true, initialSize: 225, titlebar: true, collapsible: true
            }, 
            center: { titlebar: false}
        });
        mainLayout.beginUpdate();
        mainLayout.add('north', northPanel = new Ext.ContentPanel('north-div', { 
			        fitToFrame: true, closable: false 
			        }));
			   
    
        mainLayout.add('west', westPanel = new Ext.ContentPanel('west-div', 
			        { 
					fitToFrame: true, closable: false, title: "题库分类"
					}));
        mainLayout.add('center', centerPanel = new Ext.ContentPanel('center-div', { 
                    fitToFrame: true, autoScroll: true, resizeEl: 'main',   title: 'Content'
                    })); 
                    
         mainLayout.add('south', southPanel = new Ext.ContentPanel('south-div', { 
                    fitToFrame: true, closable: false 
                    }));     
   
	    //工具栏
		 var tb = new Ext.Toolbar('toolbar');
         tb.addButton( infoBar1= new Ext.Toolbar.TextItem('<img src="image/educ/librarylist.jpg">' )  );
         tb.addSeparator();
        
         tb.addButton(  new Ext.Toolbar.Button({text: '刷新', cls: 'x-btn-text-icon',icon:'image/refresh.gif', handler: $G.refreshWhole} )  );
         tb.addSeparator();
         
         /*
         tb.addButton( new Ext.Toolbar.Button({
                  text: '分类指标切换',
                  cls: 'x-btn-text-icon',
                  icon:'image/folderopened.gif',
                     menu : {items: [
                       {text: '切换到缺省分类',   handler: function() { }},
                       '-',
                       {text: '分类指标设置', cls: 'x-btn-text-icon',icon:'image/folderopened.gif',  handler: function(){}},
                       '-',
                      {text: '关闭菜单',    handler: function(){}}
                        ]}
               
        } )  );
     
         */
          
        //  tb.addSeparator(); 
         tb.addButton(  new Ext.Toolbar.Button({text: '新增下级分类',cls: 'x-btn-text-icon',icon:'image/expand.gif',   handler:  $G.newSub} )  );
         tb.addSeparator(); 
         tb.addButton(  new Ext.Toolbar.Button({text: '删除分类',cls: 'x-btn-text-icon',icon:'image/cancel.gif',   handler:  $G.deleteClass} )  );
         tb.addSeparator(); 
         tb.addButton(  new Ext.Toolbar.Button({text: '修改分类',cls: 'x-btn-text-icon',icon:'image/write3.gif',   handler:  $G.editClass} )  );
       
      
        mainLayout.endUpdate();
        $G.openUrl( 'edu_librarylist.jsp?id=0');
    }  , 

   /**
    * 新增加一个下级分类
    */
    newSub :function( item, p2,moreAction )
    {
         Ext.MessageBox.prompt('增加下级分类', '请输入分类的名称：', function(btn, text)
               {
				    if (btn == 'ok')
                    {
                          var ret = $rpc( 'educ.library.LibraryClass', 'addSub' , 
                                           {
                                             'pid'          :   $G.currentTreeId,
                                             'name'     :   text
                                           }
                                       );
                                       
			                if ( ret.success)
			                {
			                    if  ( moreAction!=undefined) 
                                {
                                    if ( moreAction!==undefined) moreAction();
                                }else
                                {
                                    alert( "成功创建分类。"); 
                                    $G.refreshWhole();
                                }
			                }else
			                {
			                    Ext.MessageBox.alert("提示", ret.message);
			                }
					   }
			   }
           );
               
    },          
    
    
    /**
    * 删除一个分类
    */
    deleteClass :function( )
    {
        if ($G.currentTreeId<=0) 
        {
            Ext.MessageBox.alert("提示","请先点击需要删除的分类");
            return;    
        }
        
         Ext.MessageBox.confirm("提示",'确信要删除该分类吗?', function(btn )
              {
                  if (btn != 'yes') return;
                     
	              var ret = $rpc( 'educ.library.LibraryClass', 'deleteClass' , 
	                               {
	                                 'id'          :   $G.currentTreeId 
	                               }
	                           );
	                           
	                if ( ret.success)
	                {
	                    alert( "成功删除。"); 
	                    $G.refreshWhole();
	                     
	                }else
	                {
	                    Ext.MessageBox.alert("提示", ret.message);
	                }
	          
               }
           );
               
    },          
    
     /**
    * 修改一个分类
    */
    editClass :function( )
    {
        if ($G.currentTreeId<=0) 
        {
            Ext.MessageBox.alert("提示","请先点击需要修改的分类");
            return;    
        }
        
        $G.disableItemFunction();
        $G.openUrl('edu_librarylistset_classedit.jsp?id='+  $G.currentTreeId );
    } ,
        
     
     
   
    
    disableItemFunction:function()
    {
        
    },
    
    enableItemFunction:function()
    {
        
    },
    
    
    /**
     * 刷新页面
     */
    refreshWhole:function( )
    {
        window.location.href=window.location.href;
    },

    doNothing:function  ()
    {
    	alert('aa');
    } ,
    
    //点击树结点后，打开列表
    gotourl:function( id)
    {
        $G.currentTreeId=id; 
        $G.refreshFullPath(id);
        var s=Ext.get('main').dom.src+'';
 
        if ( s.indexOf( 'edu_librarylist.jsp')>=0)
        {   
             try
             {//有时候会取不到这个对象
                var obj=Ext.get('main').dom.contentWindow;
                obj.retrieve( id);
             }catch(err)
             {
                $G.openUrl( 'edu_librarylist.jsp?pid='+id);
             }
        }else
        {
              $G.openUrl( 'edu_librarylist.jsp?pid='+id);
        }
        
        $G.enableItemFunction();
        
    } ,
    
    openUrl:function (url)
    {
        Ext.get('main').dom.src =url; 
    } , 
        
    /**
     * 注意是异步取完整路径
     */
   refreshFullPath:function (id)
   {
        $rpc( 'educ.library.LibraryClass', 'getPath' , 
                                   {
                                     'id'          :   $G.currentTreeId 
                                   },
                                   function( ret)
                                   {
                                       var  data=  JSON.parse(ret);
                                       $('#fullpath').html( data.path);                                    
                                   }
                 ) ;                   
    
   },
        
        
    nothing:null   // 无用的变量  
         
} ;

Ext.onReady ( $G.init ); 

