
var gds=null;
var ggrid=null;
var pPath=null;

Ext.onReady(function()
{
 
	    //工具栏
	 var tb = new Ext.Toolbar('toolbar');
     tb.addButton( new Ext.Toolbar.Button({text: '新增题库',  handler: newLibrary} )  );
     tb.addSeparator();
　tb.addButton( new Ext.Toolbar.Button({text: '删除题库',  handler: deleteLibrary } )  );
     tb.addSeparator();
     tb.addButton( new Ext.Toolbar.Button({text: '修改题库',  handler: editLibrary} )  );
     tb.addSeparator();    
    // tb.addButton( new Ext.Toolbar.Button({text: '关联课程',  handler: setCourse} )  );
   //  tb.addSeparator();    
     
     tb.addButton( new Ext.Toolbar.Button({text: '导出题库',  handler: exportWhole} )  );
     tb.addSeparator();    
     tb.addButton( new Ext.Toolbar.Button({text: '导入题目/库',  handler:  importItems} )  );
     tb.addSeparator();
     tb.addButton( new Ext.Toolbar.Button({text: '题库维护',  handler: libraryManage} )  );
     tb.addSeparator();    
     tb.addButton( new Ext.Toolbar.Button({text: '我的知识库',  handler: myFile} )  );
     tb.addSeparator();    
       
 
     AutoHeight.add('grid');
    
   
     
     //把编辑面板藏起来
     $('#dlg').css("display","none");
     
    // create the Data Store
    var ds = new Ext.data.Store(
    	{ 
    	proxy: new Ext.data.HttpProxy({url: 'zrpc.jsp' }),
         
        reader: new Ext.data.JsonReader(
        	{
	            root: 'datas',
	            totalProperty: 'count',
	            id: 'id'
	        },
	        [
	            {name: 'id', mapping: 'id'},
	            {name: 'name', mapping: 'name' },
	            {name: 'code', mapping: 'code' },
	            {name: 'ver', mapping: 'ver' },
	            {name: 'createdate', mapping: 'createdate' , type: 'date' ,dateFormat:'Y-m-d h:i:s.0'},
	            {name: 'summary', mapping: 'summary'},
	            {name: 'provider', mapping: 'provider'},
                {name: 'showname', mapping: 'showname'}
                
	            
	        ]),

        // turn on remote sorting
        remoteSort: true
    });

    
    
   //缺省的渲染
    function renderDefault(value)
   	{
        return String.format('{0}', value);
    }
    
    // pluggable renders
    function renderNameRich(value, p, record){
        return String.format('{0} <font color=#4848ff>{1}</font>', value, record.data['summary']);
    }
    
     
    function renderCreateDate(value, p, r)
    {
    	 if ( ! value) return ""; 
    	 if ( typeof(value)=="string") return value;
        return String.format('{0}', value.dateFormat('Y.m.d h:i'));
    }
    
    function renderUserName(value,p,record){
        return String.format('[{0}]{1}', value, record.data['showname']);
    }

    // the column model has information about grid columns
    // dataIndex maps the column to the specific data field in
    // the data store
    var cm = new Ext.grid.ColumnModel([
		    	
		{
		  id:'id',
		  header:'ID',
		  dataIndex:'id',
		  width:0,
		  hidden: true
		},
		{
           id: 'name', // id assigned so we can apply custom css (e.g. .x-grid-col-topic b { color:#333 })
           header: "题库名称",
           dataIndex: 'name',
           width: 270,
           renderer: renderDefault,
           css: 'white-space:normal;'
        },
        	{
        	id:'code',
           header: "代码",
           dataIndex: 'code',
           width: 50,
           renderer:renderDefault
        },{
        	id:'ver',
           header: "版本",
           dataIndex: 'ver',
           width: 40,
           renderer:renderDefault
        },
        	{
           id: 'provider',
           header: "提供者",
           dataIndex: 'provider',
           width: 70,
           renderer: renderDefault
        },
          {
           id: 'showname',
           header: "创建人",
           dataIndex: 'showname',
           width: 70,
           renderer: renderDefault
        },
        
        	{
           id: 'createdate',
           header: "创建时间",
           dataIndex: 'createdate',
           width:0,
          hidden: true,
           renderer: renderCreateDate
        }]);

    

    // create the editor grid
    var grid = new Ext.grid.Grid('grid', {
        ds: ds,
        cm: cm,
        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
        enableColLock:false,
        loadMask: true
    });

   ggrid=grid;
    // render it
    grid.render();

    var gridFoot = grid.getView().getFooterPanel(true);

    // add a paging toolbar to the grid's footer
    var paging = new Ext.PagingToolbar(gridFoot, ds, {
        pageSize: 25,
        displayInfo: true,
        displayMsg: '当前:{0} - {1}，共{2}',
        emptyMsg: "没有检索到符合条件的"
    });
    // add the detailed view button
    paging.add('-', {
        pressed: false,
        enableToggle:true,
        text: '查看详情',
        
        toggleHandler: toggleDetails
    });

    // trigger the data store load
    
    var param= new Object();
     param.start=0;
     param.limit=50;
     param.pid= gi_pid;
     var jsonParamString= JSON.toString (  param );
    
     gds=ds;
    ds.load({params:{ classname	:'educ.library.Librarylist', 
	                                          methodname	: 'getList' , 
	                                          parameter			: jsonParamString ,
	                                          start:0,
	                                          limit:param.limit 
	                                    }});

    function toggleDetails(btn, pressed){
        cm.getColumnById('name').renderer = pressed ? renderDefault : renderNameRich;
        grid.getView().refresh();
    }
    
    /**
     * 进入某个题库，进行管理
     */
    function libraryManage()
	{

 		var record=grid.getSelectionModel().getSelected() ;
 	 	if ( record==undefined)
 	 	{
 	 		Ext.MessageBox.alert("提示","请先选择一个题库"); 
 		    return ;
 	 	}
 	 	
 	 	var url= "edu_library.jsp?id="+record.data.id;
        var pw=DomUtil.parentWindow( );  
 	 	open( url );
 
 	
	}
 
});

//让Tree结点在点击后，直接调用以刷新数据
function  retrieve( pid)
{
    gi_pid=pid;
    pPath=null;
 
     var param= new Object();
     param.start=0;
     param.limit=50;
     param.pid= pid;
     var jsonParamString= JSON.toString (  param );
     
    gds.load({params:{ classname :'educ.library.Librarylist', 
                                              methodname    : 'getList' , 
                                              parameter         : jsonParamString ,
                                              start:0,
                                              limit:param.limit 
                                        }});
} 
    


// create the HelloWorld application (single instance)
var dlg = function()
	
		{
    // everything in this space is private and only accessible in the HelloWorld block
    
    // define some private variables
    var dialog ;
    
    // return a public interface
    return {
      
       
        getDialog:function()
        {
        	return dialog;
        },
        
 
  
 showDialog : function(initFunc, okHandler )
{
            if(!dialog)
           { // lazy initialize the dialog and only create it once
                dialog = new Ext.BasicDialog("dlg", { 
                        autoTabs:false,
                        width:500,
                        height:300,
                        shadow:true,
                        minWidth:300,
                        minHeight:250,
                        modal: true,
                        proxyDrag: true
                });
                
                if ( okHandler===undefined) okHandler= dialog.hide;
                
                 
                dialog.addKeyListener(27, dialog.hide, dialog);
                dialog.addButton('确定', okHandler, dialog);
                dialog.addButton('退出', dialog.hide, dialog);
            }
            
            
             Validator.clearAllTip($('#libraryform').get(0));
             initFunc();
             dialog.show( );
        }
    };
}();




// create the HelloWorld application (single instance)
var courseDlg = function()
    
    {
     
    // define some private variables
    var dialog ;
     
    return {
     hideDialog : function()
     {
        dialog.hide();   
     },
     
	showDialog : function( okHandler )
	{
            if(!dialog)
           { // lazy initialize the dialog and only create it once
                dialog = new Ext.BasicDialog("dlg-course", { 
                        autoTabs:false,
                        width:300,
                        height:240,
                        shadow:true,
                        minWidth:300,
                        minHeight:240,
                        modal: true,
                        proxyDrag: true
                });
                
                if ( okHandler==undefined) okHandler= dialog.hide;
                  
                dialog.addKeyListener(27, dialog.hide, dialog);
                dialog.addButton('确定', okHandler, dialog);
                dialog.addButton('退出', dialog.hide, dialog);
            }
      
             dialog.show( );
        }
    };
}();


var packageDlg = function()
    
    {
     
    // define some private variables
    var dialog ;
     
    return {
     hideDialog : function()
     {
        dialog.hide();   
     },
     
    showDialog : function( okHandler )
    {
            if(!dialog)
           { // lazy initialize the dialog and only create it once
                dialog = new Ext.BasicDialog("dlg-package", { 
                        autoTabs:false,
                        width:400,
                        height:240,
                        shadow:true,
                        minWidth:300,
                        minHeight:240,
                        modal: true,
                        proxyDrag: true
                });
                
                if ( okHandler==undefined) okHandler= dialog.hide;
                  
                dialog.addKeyListener(27, dialog.hide, dialog);
                dialog.addButton('确定', okHandler, dialog);
                dialog.addButton('退出', dialog.hide, dialog);
            }
      
             dialog.show( );
        }
    };
}();

  
/**
 * 新建一个题库
 */



function newLibrary( )
{
    
        dlg.showDialog(   
	        function()
	        {
		        
                $("#id").val("");
                 $("#code").get(0).disabled=false; 
                 
                  try
                {
                    var p=getParentPath();
                    var obj= $("#path");
                    if ( obj!=undefined) obj.get(0).innerHTML = p ;
                }catch(err)
                {
                    
                }
                
                $("#pid").val( gi_pid);
                
                $("#name").val("");
		        $("#code").val("");
		        $("#ver").val("1");
		        $("#provider").val("");
		        $("#copyright").val("");
		        $("#summary").val("");
	        } , 
	        onSave
            );
		
 }

 
function editLibrary( )
{
       var record=ggrid.getSelectionModel().getSelected() ;
        if ( record==undefined)
        {
            Ext.MessageBox.alert("提示","请先选择一个题库"); 
            return ;
        }
        
        var init=function(  )
        {
                $("#id").val( record.data.id);
                $("#name").val(record.data.name);
                $("#code").val(record.data.code);
                $("#code").get(0).disabled=true;
                try
                {
                    var p=getParentPath();
                    var obj= $("#path");
                    if ( obj!=undefined) obj.get(0).innerHTML = p ;
                }catch(err)
                {
                    
                }
                
                $("#pid").val( gi_pid);
                $("#ver").val(record.data.ver);
                $("#provider").val(record.data.provider);
                $("#copyright").val(record.data.copyright);
                $("#summary").val(record.data.summary);
             
        } ;
        
        dlg.showDialog(   
           init ,      onSave
            );
        
 }
 
 function onSave()
 {
      
                
            var b=Validator.Validate( $('#libraryform').get(0),1);
            if (!b) return ;
            
            var p=new Object();
            p.id=$('#id').val( );
            p.pid= $('#pid').val( );
            p.name=$('#name').val( );
            p.code=$('#code').val( );
           
           
            if ( p.id=="")
            {
	            if( ! confirm(  '题库编码一经保存将不允许修改，确定要保存吗?') ) return ; 
            }
                       
            p.ver=$('#ver').val( );
            p.provider=$('#provider').val( );
            p.copyright=$('#copyright').val( );
            p.summary=$('#summary').val( );
            var ps= JSON.toString(p);
            
            var ret=$rpc( 'educ.library.Librarylist', 'editLibrary' , ps);
            
            if ( ret.success)
            {
                
                Ext.MessageBox.alert("提示",'保存成功');
                dlg.getDialog().hide();
                refresh();
            }else
            {
                Ext.MessageBox.alert("提示",ret.message);
            }
 
 }
 
function refresh()
{
    retrieve( gi_pid);
}




function deleteLibrary()
{
    
         
        var record=ggrid.getSelectionModel().getSelected() ;
        if ( record==undefined)
        {
            Ext.MessageBox.alert("提示","请先选择一个题库"); 
            return ;
        }
        
        Ext.MessageBox.confirm('请确认', '确信要删除“'+record.data.name+'”题库吗?', 
            function( btn)
           { 
         
                if ( btn!='yes') return;
                
                var ret=$rpc( 'educ.library.Librarylist', 'deleteLibrary' , {id: record.data.id});
                
                if ( ret.success)
                {
                    
                    Ext.MessageBox.alert("提示",'在题库列表中成功删除了该题库名称，但题库中的题目并未真正删除。');
             
                    refresh();
                }else
                {
                    Ext.MessageBox.alert("提示",ret.message);
                }

            }
       );
 }
 
 
 function setCourse()
 {
    
      var record=ggrid.getSelectionModel().getSelected() ;
        if ( record==undefined)
        {
            Ext.MessageBox.alert("提示","请先选择一个题库"); 
            return ;
        }
 
    $('#libraryid').val( record.data.id);
    
    $.blockUI("正在获取所有课程列表....");
    $rpc('educ.teachingplan.TeachingPlan','getMyCourseList',  {  all:true   },
          function( ret)
          {
          
                var data= JSON.parse( ret);
                $.unblockUI();
                if (! data.success) 
                {
                    alert( data.message);
                    return;
                }
                 
                
                var html = TrimPath.processDOMTemplate("template",data);
           
                if ( html.length>0)
                {
                    $("#coursecontainer").html( html);
                }
                
                $.blockUI("正在获取关联的课程列表....");
                //调取当前题库对应的课程
                var ret=$rpc('educ.library.Librarylist','getLibraryCourse', {id:record.data.id});
                
                 $.unblockUI(); 
                 courseDlg.showDialog(   setCourseOnOk);
                if ( ret.success)
                {
                    
                     for( var i=0;i< ret.data.length;i++)
                     {
                        var rowdata= ret.data[i];
                      
                        var obj=    $('#coursecontainer #'+rowdata.courseid).get(0);
                      
                        obj.checked=true;
                 
                     }
           　
                }else
                {
                    alert( ret.message);
                }
              
                   
               
              
               
                
          }
      );
          
 
 }

 function setCourseOnOk()
 {
    
     var id=$('#libraryid').val();
     
    var courseids= $('#coursecontainer input[@class=courseid]');
    var ids=[];
    for(var i=0;i<courseids.length;i++)
    {
        if ( courseids[i].checked ) ids[ids.length]=courseids[i].id;
    }
    
    var ret=$rpc( 'educ.library.Librarylist', 'setLibraryCourse' , { id:id, 'ids':ids });
            
    if ( ret.success)
    {
        courseDlg.hideDialog();
        Ext.MessageBox.alert("提示",'保存成功');
         
    }else
    {
        Ext.MessageBox.alert("提示",ret.message);
    }
   
   
 }
  
 
 function exportWhole ()
    {
        var record=ggrid.getSelectionModel().getSelected() ;
        if ( record==undefined)
        {
            Ext.MessageBox.alert("提示","请先选择一个题库"); 
            return ;
        }
         
          
          Ext.MessageBox.confirm('请确认', '确信要将题库['+record.data.name+ ']整个导出吗?', 
           function( btn)
           { 
                 if ( btn!='yes') return;
                 $.blockUI('正在导出题库['+record.data.name+ ']....');
                 var ret = $rpc( 'educ.library.Library', 'exportItems' , 
                                           {
                                             'libraryId'        :   record.data.id ,
                                             'whole'            :   true   //表示不是全部导出
                                            }
                                       );
                $.unblockUI();
                Ext.MessageBox.alert("提示", ret.message);
                
            }
          );  
         
        
    }
    
    function  importItems ()
    {
            
        var record=ggrid.getSelectionModel().getSelected() ;
        if ( record==undefined)
        {
            Ext.MessageBox.alert("提示","请先选择一个题库"); 
            return ;
        }
 
      $('#libraryid').val( record.data.id);
    
      $.blockUI("正在获取题库包....");
      $rpc('educ.library.Librarylist','getPackageList',  { id:record.data.id   },
          function( ret)
          {
          
                var data= JSON.parse( ret);
                $.unblockUI();
                if (! data.success) 
                {
                    alert( data.message);
                    return;
                }
                 
               if ( data.count==0)
               {
                   Ext.MessageBox.alert("提示","请在知识库中创建一个名为“题库导入导出”的目录，并将导出的题库文件上传到该目录中"); 
                   return ;
                }
            
                var html = TrimPath.processDOMTemplate("template_package",data);
                if ( html.length>0)
                {
                    $("#packagecontainer").html( html);
                }
                
                packageDlg.showDialog(   selectPackageOnOk);
                
          }
      );
          
         
    } 
    
    
function selectPackageOnOk()
 {
    
    
    var record=ggrid.getSelectionModel().getSelected() ;
    var id=record.data.id; 
     
    var pkgs= $('#packagecontainer input[@class=packagename]');
    var packageName="";
    for(var i=0;i<pkgs.length;i++)
    {
        if ( pkgs[i].checked ) 
        {
            packageName = pkgs[i].value;
            break;
        }
    }
    
    if ( packageName=="")
    {
         Ext.MessageBox.alert("提示",'请选择一个题库包');
        return;    
    }
    
    Ext.MessageBox.confirm('请确认', '确信要将'+packageName+'导入到题库['+record.data.name+ ']中吗?', 
           function( btn)
           { 
                 if ( btn!='yes') return;
                 packageDlg.hideDialog();
                 $.blockUI('正在导入....');
                 var ret=$rpc( 'educ.library.Library', 'importItems' , { 'libraryId':id, 'package':packageName });
                 $.unblockUI();
			     Ext.MessageBox.alert("提示",ret.message);
	      }
     );
     
 }
 
 
 
 
 
/**
 * 重新设置PID
 */ 
function modifypid()
{
     $rpc( 'educ.library.LibraryClass', 'getClassTree' , 
                                   {
                                     'id'          :   -1,
                                     'where' :  ' isleaf=0' , 
                                     'forSelectLeaf' : false
                                   },
                                   function( ret)
                                   {
                                       var  data=  JSON.parse(ret);
                                       var pid=$('#pid').val( );
                             
                                       $('#pidcontainer').html( "<select id=pid name=pid class='textbox'>"+  data.html+"</select>");
                                       $('#pid').val( pid );
                                   }
                 ) ;               
    
}


 
 function myFile()
 {
    window.open( "myfile.jsp");
 }
 
 
 
 function getParentPath( )
 {
    if ( pPath!=null) return pPath;
     
    var p=gi_pid;
    if ( p=='') p=0;
    var data=   $rpc( 'educ.library.LibraryClass', 'getPath' , 
                                   {
                                     'id'          : p  
                                   } );
                                   
    pPath=data.path; 
    return pPath;
    
 }
 
 