/**
 * 
 *   题目的维护
 * 
 * 
 */

 
var $G= 
{
	tb:null, //工具栏
	cm:null, //列定义
	ds:null , // 数据来源
	grid: null, //界面
	
	init :function()
    {
 
		//新增题型菜单
		//工具栏
		$G.tb = new Ext.Toolbar('toolbar');
		var tb=$G.tb;
	         
    	 tb.addButton( new Ext.Toolbar.Button({
                  text: '新增题目',
                  cls: 'x-btn-text-icon',
                  icon:'image/icon_readmore.gif',
                     menu : {items: [
                        {text: '判断题', type:'PD', handler: $G.onNewItem},
                        {text: '判断改错题', type:'GC', handler: $G.onNewItem},
                         '-',
                        {text: '单选题', type:'DX', handler: $G.onNewItem},
                        {text: '多选题', type:'FX',handler: $G.onNewItem},
                        '-',
                        {text: '填空题', type:'TK',handler: $G.onNewItem},
                        {text: '演算题', type:'JS',handler: $G.onNewItem},

                        '-',
                        {text: '简答题', type:'JD',handler: $G.onNewItem},
                        {text: '名词解释',type:'MC', handler: $G.onNewItem},
                        {text: '论述题', type:'LS', handler: $G.onNewItem},
                        {text: '案例分析',type:'AL',  handler: $G.onNewItem} 
                        
                        ]}
               
        } )  );

    
       tb.addSeparator();   
   /*
       tb.addButton( new Ext.Toolbar.Button({
                  text: '修改题目',
                  cls: 'x-btn-text-icon',
                  icon:'image/edit4.gif',
                     menu : {items: [
                        {text: '修改题目主体', cmd:'body', handler: $G.onEditItem},
                        {text: '修改题目候选项',cmd:'select', handler: $G.onEditItem},
                        {text: '修改答案', cmd:'answer', handler: $G.onEditItem}
　       ]}
               
        } )  );
      */
     
     tb.addButton( new Ext.Toolbar.Button({text: '修改题目',cls: 'x-btn-text-icon',icon:'image/edit4.gif', cmd:'body', handler: $G.onEditItem} )  );
     tb.addSeparator();
      
     tb.addButton( new Ext.Toolbar.Button({text: '修改候选项',cls: 'x-btn-text-icon',icon:'image/collpesc.gif' ,cmd:'select', handler: $G.onEditItem} )  );
     tb.addSeparator();
     
     tb.addButton( new Ext.Toolbar.Button({text: '修改答案',cls: 'x-btn-text-icon',icon:'image/write5.gif' , cmd:'answer', handler: $G.onEditItem} )  );
     tb.addSeparator();
        
     
     tb.addButton( new Ext.Toolbar.Button({text: '删除题目',cls: 'x-btn-text-icon',icon:'image/cancel.gif' , handler: $G.onDeleteItem} )  );
     tb.addSeparator();
    
     tb.addButton( new Ext.Toolbar.Button({text: '导出选中的题目',  handler: $G.exportItems} )  );
     tb.addSeparator();    
     tb.addButton( new Ext.Toolbar.Button({text: '重建题号',  handler: $G.onRebuildNo} )  );
     tb.addSeparator();    
       
     tb.addButton( new Ext.Toolbar.Button({text: '刷新',  handler:$G.refreshWhole  } )  );
     
     tb.addSeparator();    
    
     tb.addButton( new Ext.Toolbar.Button({text: '返回', handler: function(){ window.location.href='edu_librarylistset.jsp;'} } )  );
     
     tb.addSeparator();    
     
     AutoHeight.add('grid');
     
     //把编辑面板藏起来
     $('#dlg').css("display","none");
     $('#candidateDialog').css("display","none");
     $('#candidateEditDialog').css("display","none");
     $('#answerDialog').css("display","none");
     
     
     // 数据源
     $G.ds = new Ext.data.Store(
     { 
    	proxy: new Ext.data.HttpProxy({url: 'zrpc.jsp' }),
         
        reader: new Ext.data.JsonReader(
        	{
	            root: 'datas',
	            totalProperty: 'count',
	            id: 'id'
	        },
	        [
	            {name: 'id', mapping: 'id'},
	            {name: 'textbody', mapping: 'textbody' },
	            {name: 'body', mapping: 'body' },
                {name: 'itemtype', mapping: 'itemtype' },
	            {name: 'knowledgepoint', mapping: 'knowledgepoint'  },
	            {name: 'difficulty', mapping: 'difficulty' , type:'int' },
	            {name: 'no', mapping: 'no',type:'int' },
	            {name: 'createdate', mapping: 'createdate' , type: 'date' ,dateFormat:'Y-m-d h:i:s.0'}	             
	        ]),

        // turn on remote sorting false
        remoteSort: false
    }); 

  
   　
    // 列配置
    $G.cm = new Ext.grid.ColumnModel([
		    	
		{
		  id:'id',
		  header:'ID',
		  dataIndex:'id',
		  width:0,
		  hidden: true
		},
		{
           id: 'no', // id assigned so we can apply custom css (e.g. .x-grid-col-topic b { color:#333 })
           header: "题号",
           dataIndex: 'no',
           width: 50,
           renderer: $G.renderDefault,
           sortable:true
        },
        {
           id: 'itemtype', // id assigned so we can apply custom css (e.g. .x-grid-col-topic b { color:#333 })
           header: "题型",
           dataIndex: 'itemtype',
           width: 70,
           renderer: $G.renderItemType,
           sortable:true
        },
        {
           id: 'difficulty', // id assigned so we can apply custom css (e.g. .x-grid-col-topic b { color:#333 })
           header: "难度",
           dataIndex: 'difficulty',
           width: 40,
           renderer: $G.renderDifficulty,
           sortable:true
           
        },
        	{
        	id:'textbody',
           header: "题目概述",
           dataIndex: 'textbody',
           width: 430,
           renderer:$G.renderDefault
        },  
        	{
           id: 'createdate',
           header: "创建时间",
           dataIndex: 'createdate',
           width: 100,
           renderer: $G.renderCreateDate,
           sortable:true
        }]);

 
 

    // create the editor grid
    $G.grid = new Ext.grid.Grid('grid', {
        ds: $G.ds,
        cm: $G.cm,
        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
        enableColLock:false,
        loadMask: true
    });

    var grid=$G.grid;
    
    // render it
    grid.render();

    var gridFoot = grid.getView().getFooterPanel(true);

    // add a paging toolbar to the grid's footer
    var paging = new Ext.PagingToolbar(gridFoot, $G.ds, {
         pageSize: 50,
        beforePageText:'页码',
        afterPageText : "/ {0}",
        displayInfo: true,
        displayMsg: '{0} - {1}，共{2}',
        emptyMsg: "无符合条件的数据"
    });
    
    
    // add the detailed view button
    /*
    paging.add('-', {
        pressed: false,
        enableToggle:true,
        text: '查看详情',
        
        toggleHandler: $G.toggleDetails
    });
*/

    paging.addText("关键字");
    var keyInput= new Ext.form.TextField ( {
        autoCreate: {tag: "input", type: "text", size: "10", autocomplete: "off" , id:"keys" , title:"输入关键字(多个关键字用空格分开)，按回车后过滤出题目主体，答案，知识点中含有任一关键字的题目"} 
    });
    
      
     paging.addField( keyInput);

     var  pcInput= new  Ext.form.TextField ( {
        autoCreate: {tag: "select",   style:"font-size:12px", autocomplete: "off" , id:"pc" , title:"每页显示行数"} 
    });
    
    paging.addText("，");
     paging.addField( pcInput);
     paging.addText("行/页，");
     
     var pcobj=$('#pc').get(0);
 
     var pcs =[ 20,50,100,250,500,1000];
     for( var i=0;i<pcs.length;i++) {   addPCtoObj(pcobj , pcs[i]  , pcs[i] ); }
     
     // 分页改变了
     pcobj.onchange=function()
     {
         paging.pageSize = parseInt(pcobj.value);
         $G.ds.load({ params:{  'start': 0, 'limit' : $('#pc').val() }});
     }
     
     pcobj.value=paging.pageSize;
     
     //题型
     var itemtype=new Ext.form.TextField ( {
        autoCreate: {tag: "select",   style:"font-size:12px", autocomplete: "off" , id:"it" , title:"题型过滤"} 
    });
     
     paging.addField( itemtype);
     itemtype= $('#it').get(0);
     addPCtoObj(itemtype , '' , "所有题型" ); 
      
     for( var i=0;i<EducUtil.cs_itemtype.length;i++)
     {  
          var  a=EducUtil.cs_itemtype[i].toUpperCase();
          var b= itemType2NameMap[ a ] ;
           addPCtoObj(itemtype , a , b ); 
    }
     
    itemtype.value=""; 
      // 题型改变了
     itemtype.onchange=function()
     {
　  $G.ds.load({ params:{  'start': 0, 'limit' : $('#pc').val() }});
     }
    
   
     //难度
     var dif=new Ext.form.TextField ( {
        autoCreate: {tag: "select",   style:"font-size:12px", autocomplete: "off" , id:"dif" , title:"难度过滤"} 
    });
     
     paging.addField( dif);
     dif= $('#dif').get(0);
     addPCtoObj(dif , '' , "所有难度" ); 
      
     for( var  p =1;p<=5;p++)
     {  
          
          var b= difficulty2NameMap[ p]; // 在　EducUtil.js中定义
           
           addPCtoObj(dif , p , b ); 
    }
     
    dif.value=""; 
      // 难度改变了
     dif.onchange=function()
     {
　  $G.ds.load({ params:{  'start': 0, 'limit' : $('#pc').val() }});
     }
     
     //ds.load会触发此事件，因此可以在此事件中准备更多的参数
     $G.ds.events['beforeload'].addListener( 
               function (scope , param)
                {
                     // 分页工具条会拼装一个 {params:{  'start': 0, 'limit' : this.pageSize}}的参数，
                    //因此请扩展 param.params，加上更多的参数 
                
                     param.params.libraryId= gsLibraryId;
                     param.params.id= '';  //由于 getList函数同时也用于得到某一个记录，所以当id=''时表示得到不指定Id的记录
                     var keys= $("#keys").val();
                     param.params.keys = keys;
                     param.params.itemtype = $('#it').val(); //题型
                     param.params.difficulty = $('#dif').val(); //题型
                     //在此前准备所需的RPC参数
                     var s=JSON.toString( param.params ); 
                     param.params.classname='educ.library.Library';  //rpc的类
                     param.params.methodname='getList'; // rpc的方法
                     param.params.parameter = s;  //rpc的参数
                 
                }
      );
      
    
      $G.ds.load({ params:{  'start': 0, 'limit' : $('#pc').val() }});
      
      $("#keys").get(0).onkeyup=function(  e)
      {
            e= (e==null?window.event :e);
            if (e.keyCode==13)    $G.ds.load({ params:{  'start': 0, 'limit' : $('#pc').val() }});
      }
       
      

    } ,  // end of  function init
    
    toggleDetails:function (btn, pressed)
    {
        $G.cm.getColumnById('textbody').renderer = pressed ?   $G.renderBodyRich : $G.renderDefault;
        $G.grid.getView().refresh();
    },
    
    //测试
    test: function () 
    {
       
        var record=$G.grid.getSelectionModel().getSelected() ;
        
        var d ={};
        d.no=123;
        d.textbody="test";
        CopyToExtRecord ( d, record); 
        
    } ,
    
    exportItems:function()
    {
         var n=$G.grid.getSelectionModel().getCount();
         if( n==0) 
         {
            Ext.MessageBox.alert("提示","请至少选择一道题目"); 
            return ;
         }
         
         var itemids=[ ];
         var s= $G.grid.getSelectionModel().getSelections();
         for ( var i=0;i<n;i++)
         {
            itemids[ itemids.length] = s[i].data.id ;
         }
         //alert ( JSON.toString( itemids)); 
          
         
          Ext.MessageBox.confirm('请确认', '确信要将选中的'+n+'道题目导出吗?', 
           function( btn)
           { 
                 if ( btn!='yes') return;
                 $.blockUI("正在导出题目....");
                 var ret = $rpc( 'educ.library.Library', 'exportItems' , 
                                           {
                                             'libraryId'        :   gsLibraryId ,
                                             'whole'            :   false , //表示不是全部导出
                                             'itemids'          :  itemids
                                           }
                                       );
                  $.unblockUI();
                  Ext.MessageBox.alert("提示", ret.message);
                
            }
          );  
         
        
    },
    
    
    
    /**
     * 刷新整个页面显示
     */
    refreshWhole:function ( )
    {
    	
    	history.go(0);
    }, 
    
    /**
     * 刷新某行 ,注意是使用异步刷新
     * @record ： record.data 记录的是一条记录的数据
     */
    refreshRetrieve:function ( d)
    {
         var ds=  $G.ds;
         var record= ds.getById( d.data.id);
         
         // 复制数据到记录集中
         CopyToExtRecord (d.data , record);  
    	     
    },
    
    /**
     * 追加某行到列表中
     * @record ： record.data 记录的是一条记录的数据 
     */
    appendRetrieve:function ( record)
    {
    	    
         var  dsRecord= new Ext.data.Record( record.data , record.data.id) ;
         $G.ds.add( dsRecord);  
         var index=$G.ds.indexOf( dsRecord);
         
         var sm=$G.grid.getSelectionModel( );
         sm.clearSelections();
         sm.selectRow(index);
         
    },
    
    
     /**
  * 新建一道题目
  */
     onNewItem:function (item)
     {
 
     	 var tt=  item.type ;
     	$('#itemid').val('');
     	$('#itemtype').val(tt);
  		$('#difficulty').val(2);
  		dlg.setBody('' );
 
  		dlg.showDialog();
 
      } , 
      
      /**
       * 重建题库中题目的序号
       */
     onRebuildNo:function ()
     {
     	
     	 Ext.MessageBox.confirm('请确认', '确信要按题目的创建时间重建题目序号吗?', 
	  	   function( btn)
	  	   { 
                  if ( btn!='yes') return;
     	         var ret = $rpc( 'educ.library.Library', 'rebuildNo' , 
	  		                               {
	  		                                 'libraryId' 		:	gsLibraryId 
	  		                               }
	  		                           );
				if ( ret.success)
				{
					alert( "成功重建题目序号。"); 
	  		  		$G.refreshWhole( );
				}else
				{
					Ext.MessageBox.alert("提示", ret.message);
				}
			}
		);	
     },
     
     /**
      * 删除一道题
      */
     onDeleteItem:function ( item)
     {
     	   
 	 	var cmd=   item.cmd ;
     	var record=$G.grid.getSelectionModel().getSelected() ;
 	 	if ( record==undefined)
 	 	{
 	 		Ext.MessageBox.alert("提示","请先选择一道题目"); 
 		    return ;
 	 	}
 	 	
	    Ext.MessageBox.confirm('请确认', '确信要删除吗?', 
	  	   function( btn)
	  	   { 
	  	 
	  	   	    if ( btn!='yes') return;
	  	   	    
	  	         var ret = $rpc( 'educ.library.Library', 'deleteItem' , 
	  		                               { 'id'						:	record.data.id, 
	  		                                 'libraryId' 		:	gsLibraryId
	  		                               }
	  		                           );
				if ( ret.success)
				{
	  		  		$G.ds.remove(  record);  // 从界面上删除该记录
				}else
				{
					Ext.MessageBox.alert("提示", ret.message);
				}
	  	   });
 	 	
     },
     
     /**
  * 修改一道题目
  */
     onEditItem:function (item)
     {
     	var cmd=   item.cmd ;
     	var record=$G.grid.getSelectionModel().getSelected() ;
 	 	if ( record==undefined)
 	 	{
 	 		Ext.MessageBox.alert("提示","请先选择一道题目"); 
 		    return ;
 	 	}
        
        if ($G.grid.getSelectionModel().getCount()>1 )
        {
            Ext.MessageBox.alert("提示","只能选择一道题目进行编辑"); 
            return ;
        }
 	 
 	 	if ( cmd=='body')  $G.onEditBody(record); //编辑题目主体部份
 	 	if ( cmd=='select')  $G.onEditSelect(record); //编辑题目主体部份
 	 	if ( cmd=='answer')  $G.onEditAnswer(record); //编辑题目的答案
 	 	 
     	
     },
     
     /**
      * 编辑题目的主体部份
      */
     onEditBody:function (record)
     {
        //把数据从网格中取出来填入到编辑窗口中
     	$('#itemid').val(record.data.id);
     	$('#itemtype').val(record.data.itemtype);
  		$('#difficulty').val(record.data.difficulty);
        $('#knowledgepoint').val(record.data.knowledgepoint);
        
  		dlg.setBody( record.data.body);
  		dlg.showDialog();
     },
    
     
     /**
      * 编辑题目的候选项
      */
     onEditSelect:function (record)
     {
     	var itemtype=record.data.itemtype;
     	if ( itemtype!='DX' &&itemtype!='FX'  )
     	{
     		Ext.MessageBox.alert("提示",'仅单选题和多选题允许进行候选项的设置' );
     		return;
     	}
     
       var  dialog = candidateDialog.getDialog(); 
       //设置变量
       candidateDialog.id=record.data.id;
       candidateDialog.libraryId=gsLibraryId ; 
       //清空内容
       $("#candidatepanel").html("");         
       dialog.show( );
       //调取题目的答案候选项
       candidateDialog.reloadList( ); 
     } ,
     
      /**
      * 编辑题目的答案
      */
     onEditAnswer:function (record)
     {
     	var itemtype=record.data.itemtype;
     	
      
     
       var  dialog = answerDialog.dialog; 
       //设置变量
       answerDialog.id=record.data.id;
       answerDialog.libraryId=gsLibraryId ;
       answerDialog.itemtype=itemtype; //题目类型
       dialog.show( );
       answerDialog.loadAnswer(); //调取答案和答案设置界面 
     } ,
     
     
     
     //缺省的渲染
    renderDefault:function(value)
   	{
        return String.format('{0}', value);
    } , 
    
    renderDifficulty:function(value)
   	{
         var dif= {
         	    "1":"简单",
	         	"2":"基础",
	         	"3":"中等",
	         	"4":"较难",
	         	"5":"极难"
	         	};
	         	
         return dif[value];
    } ,
    
    renderItemType:function(value)
   	{
   		
   		var tx={  "PD" :"判断题",
	         	 "GC":"判断改错题",
	         	 "DX":"单选题",
	         	 "FX":"多选题",
	         	"TK":"填空题", 
	         	"JS":"演算题",
	         	"JD":"简答题",
	         	"MC":"名词解释",
	         	"LS":"论述题",
	         	"AL":"案例分析"
   		  };
	         	
        return  tx[ value];
    } ,
    
    
     
    renderNameRich :function(value, p, record)
    {
        return String.format('{0} <font color=#4848ff>{1}</font>', value, record.data['summary']);
    } ,
    
     
    renderCreateDate:function(value, p, r)
    {
    	 if ( ! value) return ""; 
    	 if ( typeof(value)=="string") return value;
        return String.format('{0}', value.dateFormat('Y.m.d h:i'));
    },
    
    renderBodyRich:function(value,p,record)
    {
        return  '<table border=0 width="400"><tr><td>'+ record.data['body'] +'</td></tr></table>' ;
    } 


} ; //  end of    gb
 


// create the HelloWorld application (single instance)
var dlg = { 

     dialog:null  ,
     richEditInit : false ,
      
    init : function( )
    {
            if(!dlg.dialog)
           { // lazy initialize the dialog and only create it once
                dlg.dialog = new Ext.BasicDialog("dlg", { 
                        autoTabs:false,
                        width:580,
                        height:450,
                        shadow:true,
                        minWidth:300,
                        minHeight:250,
                        modal: true,
                        proxyDrag: true
                });
                
                  
                dlg.dialog.addKeyListener(27, dlg.dialog.hide, dlg.dialog);
    	        dlg.dialog.addButton('保存', dlg.onOk, dlg.dialog);
                dlg.dialog.addButton('保存并退出', dlg.onOkAndHide, dlg.dialog);
                dlg.dialog.addButton('退出', dlg.dialog.hide, dlg.dialog);
                
            } 
    },
    
 	showDialog: function( )
	{
	         Validator.clearAllTip($('#itemform').get(0));
             dlg.dialog.show( );
     } ,  // end of function 
       
     
     setBody : function(value)
     {
     		if ( !dlg.richEditInit)
     		{
     			$('#itembody').val( value);
		        var oFCKeditor ;
		        var p=document.location.pathname.lastIndexOf('/');
				var sBasePath = document.location.pathname.substring(0,p)+"/htmledit/" ;
				oFCKeditor  = new FCKeditor( 'itembody' ) ;
				oFCKeditor.Width="100%";
				oFCKeditor.Height="100%";
				oFCKeditor.ToolbarSet ="praxis";
				oFCKeditor.BasePath	= sBasePath ;
    			oFCKeditor.Value="<div style=\"font-size:14px\"> </div>"; 
 				oFCKeditor.ReplaceTextarea();
 	 			dlg.richEditInit=true;
 		 }else
 		 {
 		 	    setHTMLToFCKEditor( 'itembody' , value);
 		 }
     },
      
	/**
	 * 新建或编辑一个题目
	 */
	onOk: function ()
	{
		
		var ret=dlg.save();
		
		if ( ret.success)
		{
			$('itemid').val( ret.data.id); //取出ID回填
			Ext.MessageBox.alert("提示",'保存成功');
	 		if ( ret.isNew)
	 		{
	 			$G.appendRetrieve( ret);
	 		}else
	 		{
	 			$G.refreshRetrieve( ret);	
	 		}
	 		return true;
		}else
		{
			Ext.MessageBox.alert("提示",ret.message);
            return false;
		}
	
	},
	
    onOkAndHide:function( )
    {
        if ( ! dlg.onOk( )) return;
        dlg.dialog.hide();

    } ,
                
	/**
	 * 保存题目的主要信息，并返回是否保存成功
	 */
	save:function()
	{
		var ret={success:false,message:''};
		
		var b=Validator.Validate( $('#itemform').get(0),1);
		if (!b) return ret;
		
		var p=new Object();
		p.id=$('#itemid').val( );
		p.body=getHTMLFromFCKEditor( 'itembody'  );
		p.libraryId=gsLibraryId; 
		p.itemtype=$('#itemtype').val( );
		p.difficulty=$('#difficulty').val( );
        p.knowledgepoint=$('#knowledgepoint').val( );
	 
 
		ret=$rpc( 'educ.library.Library', 'editItem' , p);
		return ret;
		
	 
	}

   } ;//end of dlg object
   
 
var candidateDialog = { 

    dialog:null  ,
    id:'',
    libraryId: '' ,
          
 	getDialog: function( )
	{
		  
            if(!candidateDialog.dialog)
           {  
                candidateDialog.dialog = new Ext.BasicDialog("candidateDialog", { 
                        autoTabs:false,
                        width:650,
                        height:400,
                        shadow:true,
                        minWidth:300,
                        minHeight:250,
                        modal: true,
                        proxyDrag: true
                });
                
                var dialog=candidateDialog.dialog;
                
                dialog.addKeyListener(27,  dialog.hide, dialog);
                dialog.addButton('增加答案候选项',  candidateDialog.onNew, dialog);
    	        dialog.addButton('保存',  candidateDialog.onOk, dialog);
                dialog.addButton('退出',  dialog.hide,  dialog);
                
            }
            return candidateDialog.dialog;
      },
      
      /**
       * 按下保存后
       */
      onOK:function( )
      {
      	  alert ("ok");
      	 
      },
      
      onNew:function()
      {
	      	candidateDialog.onEdit( '' ); 
      },
      
      /**
       * 修改某项
       */
      onEdit:function( candidateId  )
      {
      	 	var  dialog = candidateEditDialog.getDialog(); 
	       //设置变量
	       candidateEditDialog.id=candidateDialog.id;
	       candidateEditDialog.libraryId=gsLibraryId ; 
	       
	       
	       $('#candidateId').val(candidateId );
	       
	       var content='';
	       if ( candidateId!='') 
	       {    //得到答案候选项的内容
	             var ret = $rpc( 'educ.library.Library', 'getCandidateItem' , 
      		                               { 'id'						:	candidateDialog.id, 
      		                                 'libraryId' 		:	candidateDialog.libraryId ,
      		                                 'candidateId'	:	candidateId
      		                               }
      		                           );
      		                           
      		    content= ret.item.content;                       
	       }
	       
	  
	      candidateEditDialog.setCandidateItem (content);
	      
	       dialog.show();
	      
 
      },
      
      /**
       * 删除指定的答案候选项
       */
      onDelete:function ( candidateId)
      {
      	   Ext.MessageBox.confirm('请确认', '确信要删除该项目吗?', 
      	   function( btn)
      	   { 
      	 
      	   	    if ( btn!='yes') return;
      	   	    
      	         var ret = $rpc( 'educ.library.Library', 'deleteCandidateItem' , 
      		                               { 'id'						:	candidateDialog.id, 
      		                                 'libraryId' 		:	candidateDialog.libraryId ,
      		                                 'candidateId'	:	candidateId
      		                               }
      		                           );
				if ( ret.success)
				{
      		  		candidateDialog.reloadList( );
				}else
				{
					Ext.MessageBox.alert("提示", ret.message);
				}
      	   });
      },
      
       /**
       * 删除指定的答案候选项
       */
      onMove:function ( candidateId, dir)
      {
  	        var ret = $rpc( 'educ.library.Library', 'moveCandidateItem' , 
  		                               { 'id'						:	candidateDialog.id, 
  		                                 'libraryId' 		:	candidateDialog.libraryId ,
  		                                 'candidateId'	:	candidateId,
  		                                 'dir'					:	dir
  		                               }
  		                           );
			if ( ret.success)
			{
  		  		candidateDialog.reloadList( );
			}else
			{
				Ext.MessageBox.alert("提示", ret.message);
			}
      	   
      },
      
      reloadList: function(  )
      {
		  	var data= $rpc( 'educ.library.Library', 'getCandidate' , 
		  		                               { 'id'					:	candidateDialog.id, 
		  		                                 'libraryId' 	:	candidateDialog.libraryId   
		  		                               }
		  		                           );
		    
		  	var html = TrimPath.processDOMTemplate("candidateTemplate", data);	                           
		   $("#candidatepanel").html( html );
		  	
      }
      
};



var candidateEditDialog = { 

    dialog:null  ,
    id:'',
    libraryId: '' ,
    richEditInit : false,
          
 	init: function( )
	{
		  
            if(!candidateEditDialog.dialog)
           {  
                candidateEditDialog.dialog = new Ext.BasicDialog("candidateEditDialog", { 
                        autoTabs:false,
                        width:580,
                        height:350,
                        shadow:true,
                        minWidth:300,
                        minHeight:250,
                        modal: true,
                        proxyDrag: true
                });
                
                var dialog=candidateEditDialog.dialog;
                
                dialog.addKeyListener(27,  dialog.hide, dialog);
               
    	        dialog.addButton('保存',  candidateEditDialog.onOK, dialog);
                dialog.addButton('退出',  dialog.hide,  dialog);
                
            }
            return candidateEditDialog.dialog;
      },
      
      getDialog:function()
      {
      	return candidateEditDialog.dialog;
      },
      
      /**
       * 把内容放到richEdit中编辑
       */
     setCandidateItem : function(value)
     {
     		if ( !candidateEditDialog.richEditInit)
     		{
     			$('#candidateItem').val( value);
		        var oFCKeditor ;
		        var p=document.location.pathname.lastIndexOf('/');
				var sBasePath = document.location.pathname.substring(0,p)+"/htmledit/" ;
				oFCKeditor  = new FCKeditor( 'candidateItem' ) ;
				oFCKeditor.Width="100%";
				oFCKeditor.Height="100%";
				oFCKeditor.ToolbarSet ="praxis";
				oFCKeditor.BasePath	= sBasePath ;
    			oFCKeditor.Value="<div style=\"font-size:14px\"> </div>"; 
 				oFCKeditor.ReplaceTextarea();
 	 			candidateEditDialog.richEditInit=true;
 		 }else
 		 {
 		 	    setHTMLToFCKEditor( 'candidateItem' , value);
 		 }
     },
     
      /**
       * 按下保存后
       */
      onOK:function( )
      {
      	  var s=getHTMLFromFCKEditor('candidateItem') ;
	 	 if ( s=='' ) 
	 	 {
	 	 	Ext.MessageBox.alert("提示","请输入内容");
	 	 	return;
	 	 }
 
		 ret=$rpc( 'educ.library.Library', 'editCandidateItem' , 
			                    {'id':candidateEditDialog.id ,
			                      'libraryId': candidateEditDialog.libraryId,
			                      'candidateId': $('#candidateId').val(),
			                      'content': s}　
			                 );
		 if ( ret.success) 
		 {
			$('#candidateId').val( ret.candidateId ) ;
			candidateEditDialog.getDialog().hide();
			candidateDialog.reloadList( );
		 }else
		 {
			Ext.MessageBox.alert("提示", ret.message);
		 }
		  
      }   // end of onOk
      
      　
};



var answerDialog = { 

    dialog:null  ,
    id:'',
    libraryId: '' ,
    itemtype:'', //题目类型
    flag:{ richEditInit:false },
    
 	init: function( )
	{
		  
            if(!answerDialog.dialog)
           {  
                answerDialog.dialog = new Ext.BasicDialog("answerDialog", { 
                        autoTabs:false,
                        width:650,
                        height:400,
                        shadow:true,
                        minWidth:300,
                        minHeight:250,
                        modal: true,
                        proxyDrag: true
                });
                
                var dialog=answerDialog.dialog;
                
                dialog.addKeyListener(27,  dialog.hide, dialog);
               
    	        dialog.addButton('保存',  answerDialog.onOK, dialog);
                dialog.addButton('退出',  dialog.hide,  dialog);
                
            }
            return answerDialog.dialog;
      },
      
      
  
      
      /**
       * 调取答案＋构造设置答案的界面
       */
      loadAnswer: function(  )
      {
      	    $("#answerpanel").html('');
      	    
      	    
		
		    
		   //调取设置的答案
		    var answer= $rpc( 'educ.library.Library', 'getAnswer' , 
		  		                               { 'id'					:	answerDialog.id, 
		  		                                 'libraryId' 	:	answerDialog.libraryId   
		  		                               }
		  		                           );
		  		                           
	 
		   if (  answerDialog.itemtype=='DX' ||answerDialog.itemtype=='FX'  || 
		          answerDialog.itemtype=='PD' ||  answerDialog.itemtype=='GC' )
		   {    
		  		 var data= $rpc( 'educ.library.Library', 'getCandidate' , 
		  		                               { 'id'					:	answerDialog.id, 
		  		                                 'libraryId' 	:	answerDialog.libraryId   
		  		                               }
		  		                           );
				  //不同的题目类型调取不同的设置答案的模板		                           
				  	var html = TrimPath.processDOMTemplate( answerDialog.itemtype + "AnswerTemplate", data);	                           
				   $("#answerpanel").html( html );
		   }	   
           
           if (answerDialog.itemtype=='TK' || answerDialog.itemtype=='JS'  )
           {
                    var html = TrimPath.processDOMTemplate(   "TKAnswerTemplate", data);                               
                   $("#answerpanel").html( html );
           }
           
		   //先把richEdit隐藏起来
		    answerDialog.setRichEditVisible(false);
		  		                           
		  		          
		  
                      
		   if ( answerDialog.itemtype=='DX')  answerDialog.loadAnswerDX ( answer);
		   if ( answerDialog.itemtype=='FX')  answerDialog.loadAnswerFX ( answer);
		   if ( answerDialog.itemtype=='PD')  answerDialog.loadAnswerPD ( answer);
		   if ( answerDialog.itemtype=='GC')  answerDialog.loadAnswerGC ( answer);
           if ( answerDialog.itemtype=='TK')  answerDialog.loadAnswerTK ( answer);
		   if ( answerDialog.itemtype=='JS')   answerDialog.loadAnswerJS ( answer);   
		   if ( answerDialog.itemtype=='JD')  answerDialog.loadAnswerCommon ( answer ,"请录入本简答题的答案","");
		   if ( answerDialog.itemtype=='MC')  answerDialog.loadAnswerCommon ( answer ,"请录入本名词解释的答案","");
		   if ( answerDialog.itemtype=='LS')  answerDialog.loadAnswerCommon ( answer ,"请录入本论述题的答案","");
		   if ( answerDialog.itemtype=='AL')  answerDialog.loadAnswerCommon ( answer ,"请录入本案例分析的答案","");
		   
		   
		   
	 	  	
      } ,
      
      /**
       * 调取单选题的答案
       */
      loadAnswerDX:function (answer)
      {
      	  answerDialog.setTip ("提示：单选题有且只能有一个答案选项");
      		var objs= document.getElementsByName("dxAnswer");
      		for ( var i=0;i< objs.length;i++)
      	   	{ 
      	   		var obj=objs[i];
      	   		if ( answer.answer==obj.value)  obj.checked=true;
	  	   	} 
      	   	
       
      } ,
      
        /**
       * 调取多选题的答案
       */
      loadAnswerFX:function (answer)
      {
      	
      	    answerDialog.setTip ("提示：多选题有一个或多个答案选项");
      		var objs= document.getElementsByName("fxAnswer");
      		
      		if ( answer.answer.length == undefined) return ;  //如果是单选题改成多选题，那么就会出现这种情况
      		
      		for ( var i=0;i< objs.length;i++)
      	   	{ 
      	   		var obj=objs[i];
      	   		for( var j=0;j<answer.answer.length;j++)
      	   		{
      	   			if ( answer.answer[j]==obj.value)  obj.checked=true;
      	   		}
	  	   	} 
      	   	 
      } , 
      
       /**
       * 调取判断题的答案
       */
      loadAnswerPD:function (answer)
      {
      	
      	    answerDialog.setTip ("提示：判断题只需要选择是[正确]还是[错误]");
      		var objs= document.getElementsByName("pdAnswer");
      		for ( var i=0;i< objs.length;i++)
      	   	{ 
      	   		var obj=objs[i];
      	   		if ( answer.answer==obj.value)  obj.checked=true;
	  	   	} 
      
      } ,
      
      buildTKanswerPanel:function(n , tk)
      {
            var html='<table border=0 width=100%>'; 
            var panel=  $("#tkanswerpanel");
            for ( var i=0;i<n;i++)
            { 
                html=html+( '<tr><td nowrap>第'+ (i+1)+'个空</td><td width=99%><input id=tkanswer  name=tkanswer  style="width:100%"></td></tr>');
                
             }
             html.html+( "</table>");
             panel.get(0).innerHTML="";
             panel.append( $(html));
             
             
             var inputs= document.getElementsByName("tkanswer");   
             for ( var i=0;i<inputs.length;i++)
            { 
                inputs[i].value= tk[i] || '';
             }  
      },
      
          /**
       * 调取填空题的答案
       */
      loadAnswerTK:function (answer)
      {
        
            answerDialog.setTip ("");
            var ac= document.getElementById("tkanswercount");
            // 当转换题目类型时，需要对answer进行类型检测
            if ( typeof(answer.answer )!="object" )  answer.answer={};
             if ( typeof(answer.answer.tk)=="undefined" )  answer.answer.tk=['' ];
           
            ac.value= answer.answer.tk.length;
            ac.onkeyup=function( event)
            {
                event=window.event || event; 
                if ( event.keyCode==13)
                {
                    var n= parseInt(ac.value);
                    if (  isNaN(n )) n=1;
                    answerDialog.buildTKanswerPanel ( n , answer.answer.tk);
                }
            }
           ac.onchange=ac.onkeyup;
            
           answerDialog.buildTKanswerPanel( answer.answer.tk.length , answer.answer.tk);
              
      } ,
      
      
      /**
       * 调取演算题的答案
       */
      loadAnswerJS:function (answer)
      { 
            //填空部份与填空题的处理方式相同
            answerDialog.loadAnswerTK (answer);
            // 演算过程
            
            answerDialog.setTip ( "");
            $('#richEditContainer').css("height", "275px");
           
            if ( answer.answer.reason ==undefined)      answer.answer.reason ="";
            answerDialog.setRichEditValue(  answer.answer.reason  ,"请输入演算过程：");
           
      },
      
      
      //答案窗口使用同一个FCKEditor来提供rich edit 
      setRichEditVisible: function(v)
      {
      		$('#richEditContainer').css("display", v?"":"none");
      		$('#answerRichEditTip').css("display", v?"":"none");
      		
      },
      
      setRichEditValue : function ( value , tip)
      { 
      		answerDialog.setRichEditVisible(true);
      		
      		if ( ! answerDialog.flag.richEditInit)
	  	    {
	   	   		$('#richEdit').val( value);
     	 	 	var oFCKeditor  ;
		        var p=document.location.pathname.lastIndexOf('/');
				var sBasePath = document.location.pathname.substring(0,p)+"/htmledit/" ;
				oFCKeditor  = new FCKeditor( 'richEdit' ) ;
				oFCKeditor.Width="100%";
				oFCKeditor.Height="100%";
				oFCKeditor.ToolbarSet ="praxis";
				oFCKeditor.BasePath	= sBasePath ;
    			oFCKeditor.Value="&nbsp;";
 				oFCKeditor.ReplaceTextarea();
	           answerDialog.flag.richEditInit=true;
	  	    }else
	  	    {
	  	    	setHTMLToFCKEditor( 'richEdit', value);
	  	    }
	  	    
	  	    $('#answerRichEditTip').html(tip );
	  	    
      } ,
      
      
      setTip : function (tip)
      {
      	    $('#answerSetTip').html(tip );
      } , 
      
      /**
       * 调取判断题改错的答案
       */
      loadAnswerGC:function (answerObj)
      {
      	   answerDialog.setTip ("提示：请输入判断依据");
      	   $('#richEditContainer').css("height", "210px"); 
      	   var answer= answerObj.answer; //注意，是一个对象
           if ( answer==undefined) answer={ };
           
	  	   if ( answer.answer ==undefined ) answer.answer="";
           if ( answer.reason==undefined) answer.reason=""; 
            
           var objs= document.getElementsByName("gcAnswer");
	  		for ( var i=0;i< objs.length;i++)
	  	   	{ 
	  	   		var obj=objs[i];
	  	   		if ( answer.answer  ==obj.value)  obj.checked=true;
	  	   	}
		
	  	   	answerDialog.setRichEditValue(  answer.reason , "请阐述理由：");
		   
      } ,
      
      
       /**
       * 所有需要进行大文本论述的题目的答案设置都用本函数
       */
      loadAnswerCommon:function (answer, title , tip)
      {
      	   answerDialog.setTip ( tip);
           
           $('#richEditContainer').css("height", "275px");
           
      	   if ( answer.answer ==undefined)
      	   {
	  	   	    answer.answer ="";
	  	   }
           if ( typeof ( answer.answer)!="string")  answer.answer="";
	  	 answerDialog.setRichEditValue(  answer.answer  ,title);
		   
      } ,
      
      
      /**
       * 按下保存后
       */
      onOK:function( )
      {
      	    var answer =null ;
      	    
       	    if ( answerDialog.itemtype=='DX') 	answer= answerDialog.onOK_DX ( );
      	    if ( answerDialog.itemtype=='FX') 	answer= answerDialog.onOK_FX ( );
      	    if ( answerDialog.itemtype=='PD') 	answer= answerDialog.onOK_PD ( );//判断
      	    if ( answerDialog.itemtype=='GC') 	answer= answerDialog.onOK_GC ( );//判断改错
            if ( answerDialog.itemtype=='TK')   answer= answerDialog.onOK_TK ( );//填空
            if ( answerDialog.itemtype=='JS')  	answer= answerDialog.onOK_JS ( );
            if ( answerDialog.itemtype=='JD')  	answer= answerDialog.onOK_Common ( );
		    if ( answerDialog.itemtype=='MC') 	answer= answerDialog.onOK_Common ( );
		    if ( answerDialog.itemtype=='LS')  	answer= answerDialog.onOK_Common ( );
		    if ( answerDialog.itemtype=='AL')  	answer= answerDialog.onOK_Common ( );
		   
      	    
      	    if ( answer==null) return;
      	    
      	    var ret=$rpc( 'educ.library.Library', 'setAnswer' , 
			                    {'id':answerDialog.id ,
			                      'libraryId': answerDialog.libraryId,
			                      'answer': answer 
			                     }　
			                 );
			                 
			 if ( ret.success) 
			 {
			     Ext.MessageBox.alert("提示", "设置成功。");
			 	 answerDialog.dialog.hide( );
			 }else
			 {
				 Ext.MessageBox.alert("提示", ret.message);
			 }
      	   
		  
      } ,  // end of onOk
      
      /**
       * 单选保存答案设置
       */
      onOK_DX:function( )
      {
      		var answer={ };
      		answer.answer='';
      		
      		var objs= document.getElementsByName("dxAnswer");
      		for ( var i=0;i< objs.length;i++)
      	   	{ 
      	   		var obj=objs[i];
      	   		if ( obj.checked)  answer.answer=obj.value;
	  
      	   	} 

      	   	if ( answer.answer=='')
	  	   	{
	  	   		Ext.MessageBox.alert("提示", "请选择答案");
	  	   		return  null;
	  	   	}
	  	   	
    	   return answer;
		  
      }  ,  // end of onOk_DX
      
       /**
       * 多选保存答案设置
       */
      onOK_FX:function( )
      {
      		var answer={ };
      		answer.answer=[];
      		var objs= document.getElementsByName("fxAnswer");
      		for ( var i=0;i< objs.length;i++)
      	   	{ 
      	   		var obj=objs[i];
      	   		if ( obj.checked)  answer.answer[answer.answer.length]=obj.value;
	  	   	} 
       
	  	   	if ( answer.answer.length==0)
	  	   	{
	  	   		Ext.MessageBox.alert("提示", "多选题至少需要有一个答案选项");
	  	   		return  null;
	  	   	}
    	   return answer;
		  
      }  ,  // end of onOk_DX
      
       /**
       * 判断保存答案设置
       */
      onOK_PD:function( )
      {
      		var answer={ };
      		answer.answer='';
      		
      		var objs= document.getElementsByName("pdAnswer");
      		for ( var i=0;i< objs.length;i++)
      	   	{ 
      	   		var obj=objs[i];
      	   		if ( obj.checked)  answer.answer=obj.value;
	  
      	   	} 

      	   	if ( answer.answer=='')
	  	   	{
	  	   		Ext.MessageBox.alert("提示", "请选择答案");
	  	   		return  null;
	  	   	}
	  	   	
    	   return answer;
		  
      }  ,  // end of onOk_DX
      
       /**
       * 判断改错保存答案设置
       */
      onOK_GC:function( )
      {
      		var answerObj={ };
            answerObj.answer={};
            var answer= answerObj.answer;
      	   
      		var objs= document.getElementsByName("gcAnswer");
      		for ( var i=0;i< objs.length;i++)
      	   	{ 
      	   		var obj=objs[i];
      	   		if ( obj.checked)  answer.answer  =obj.value;
      	   	} 
      	   	if ( answer.answer=='')
	  	   	{
	  	   		Ext.MessageBox.alert("提示", "请选择答案");
	  	   		return  null;
	  	   	}
	  	   	answer.reason= getHTMLFromFCKEditor('richEdit');
     	   return answerObj;
		  
      }  ,  // end of onOk_GC
      
      
       /**
       * 填空保存答案设置
       */
      onOK_TK:function( )
      {
            var answerObj={ };
            answerObj.answer={ };
            answerObj.answer.tk=[ ];
            var answer= answerObj.answer ;
           
            var objs= document.getElementsByName("tkanswer");
            for ( var i=0;i< objs.length;i++)
            { 
                var obj=objs[i];
                answer.tk[i]  =obj.value;
            } 
            
            if ( answer.tk.length==0)
            {
                Ext.MessageBox.alert("提示", "请至少设置一个填空的答案");
                return  null;
            }
            return answerObj;
          
      }  ,  // 
       
      /**
       * 演算保存答案设置
       */
      onOK_JS:function( )
      {
                  var answer= answerDialog.onOK_TK ( );
                  answer.answer.reason= answerDialog.onOK_Common ( ).answer;
         
                  return answer;
       },
            
 	   /**
       * 需要文字回答的题目的通用答案设置
       */
      onOK_Common:function( )
      {
      		var answer={ };
       	    answer.answer= getHTMLFromFCKEditor('richEdit');   
      	   	if ( answer.answer=='')
	  	   	{
	  	   		Ext.MessageBox.alert("提示", "请录入答案");
	  	   		return  null;
	  	   	}
	  	   	
     	   return answer;
		  
      }  ,  // end of onOk_Common

      
     nothing:''  //放在最后，避免增加一个函数后，最后多加一个逗号导致在IE里发生异常    　
};

 

function addPCtoObj( obj, v , t)
{
    var oOption = document.createElement("OPTION");
    obj.options.add(oOption);
    oOption.innerText = t;
    oOption.value = v;

}

Ext.onReady( $G.init );
Ext.onReady( dlg.init );
Ext.onReady( candidateEditDialog.init );
Ext.onReady( answerDialog.init );


 

