 /**
  * 策略编辑
  */
 
 
 $(document).ready(function()
 {
    //修改题目数量和分数后，重新计算合计
     $("input[@class='dotlinenumber']").bind('change' , calcuScore );
     // 修改名称后，同步标题显示
     $("#name").bind('keyup' , function(){  $('#v_name').html( $('#name').val());} );
    
     loadItem( $('#id').val() , $('#pid').val() ,$('#param_courseid').val() ); 
 }
 );
 
 
var cs_itemtype=[ 'pd' , 'dx', 'fx', 'tk', 'js', 'gc', 'mc', 'jd', 'ls', 'al'];
/**
 * 计算总题数和总分
 */
 function calcuScore()
 {
    //按题型汇总
    for(var  i=0;i< cs_itemtype.length;i++)
    {
      $NS ( cs_itemtype[i]);
    } 
    //按难度汇总
    for (var  i=0; i<6;i++)
    {
        $NSV( i);
    }
    //总计
    
    var n=$2N('n0')+$2N('n1')+$2N('n2')+$2N('n3')+$2N('n4')+$2N('n5');
    if ( n==0) n='';
    var s=$2N('s0')+$2N('s1')+$2N('s2')+$2N('s3')+$2N('s4')+$2N('s5');
    if ( s==0) s='';
     $('#n' ).val(  n );  
    $('#s' ).val(  s);  
    
      
 }
 
/**取出数据并转换成数字
 * 
 */
 function $2N(id)
 {
    try
    {
        var obj=document.getElementById(id);
        var s='';
        if ( obj.tagName.toLowerCase()=='input')
        {
            s=obj.value;
        }else
        {
            s=obj.innerText;
        }
        
        if ( s==undefined) s='';
	  
        var ret=null;
        
	    if ( s.indexOf('.')<0 )
        {
           ret= parseInt( s, 10);
        }else
        {
	            ret= parseFloat( s, 10);
        }
        if ( isNaN(ret) )  return 0;
        return ret;
    }catch(er)
    {
        return 0;
    }
 }
 
  
 /**
  *  合计某一类型题目的总题数和总分数 
  */
 function $NS( lx)
 {
 
    var n=   $2N(lx+'n0')+$2N(lx+'n1') +$2N(lx+'n2')+ $2N(lx+'n3')+ $2N(lx+'n4')+ $2N(lx+'n5');
    var s =  $2N(lx+'s0') +$2N(lx+'s1') +$2N(lx+'s2') +$2N(lx+'s3') +$2N(lx+'s4') +$2N(lx+'s5') ;
   
    if ( n==0)  n='';
    if ( s==0) s='';
    
    $('#'+lx+'n').val(  n );  
    $('#'+lx+'s').val(  s);  
 }
 
 /**
  * 合计某个难度的所有题目的数量和分数
  */
 function $NSV( index) 
 {
    var n=0;
     for( i=0;i< cs_itemtype.length;i++)
    {
         n=n+$2N( cs_itemtype[i]+'n'+index);
    } 
    if ( n==0) n='';
    
    var s=0;
     for( i=0;i< cs_itemtype.length;i++)
    {
         s=s+$2N( cs_itemtype[i]+'s'+index);
    } 
    if ( s==0) s='';
    
    $('#n'+index).val(  n );  
    $('#s'+index).val(   s ) ;  
 }
 
/**
 * 重新设置PID
 */ 
function modifypid()
{
     $rpc( 'educ.paper.PaperPolicy', 'getClassTree' , 
                                   {
                                     'id'          :   $('#id').val(),
                                     'where' :  ' isleaf=0' , 
                                     'forSelectLeaf' : false
                                   },
                                   function( ret)
                                   {
                                       var  data=  JSON.parse(ret);
                                       var pid=$('#pid').val( );
                                        
                                       $('#pidcontainer').html( "<select id=pid name=pid class='textbox'>"+  data.html+"</select>");
                                       $('#pid').val( pid );
                                   }
                 ) ;               
    
}
 
/**
 * 
 * 调取策略的配置 （使用异步方式）
 *  courseid是可选的，当是在设置一个试卷策略时，它没有数据，当是模拟测试时，它表示当前对哪门课进行模拟测试
 */    
function loadItem(id ,pid,courseid)
{
     $rpc( 'educ.paper.PaperPolicy', 'getItem' , 
                                   {
                                     'id'          :   id,
                                     'pid'       :   pid,
                                     'courseid':courseid
                                   },
                                   function( ret)
                                   {
                                       var  data=  JSON.parse(ret);
                                       applyItemConfigToUI( data.config);                     
                                   }
                 ) ;                   
}
 
/**
 * 把配置显示到界面上
 */
function applyItemConfigToUI( config)
{
	if ( $('#id').val( )==0) $('#id').val( config.id ) ;  //如果是新是模拟测试策略，那么把生成的ID回填到变量
    $('#guid').val( config.guid);
    $('#name').val( config.name);
    $('#path').html( config.path);
    $('#v_name').html( $('#name').val());
    $('#username').val( config.username);
    $('#createdate').val( config.createdate);
    $('#lastmodifydate').val( config.lastmodifydate);
    $('#summary').val( config.summary);
        
    $('#courseid').val( config.courseid);
   
    $('#coursename').html( config.coursename);
    if ( config.courseid>0) $('#cb_selectCourse').val("更换课程");
    
    $('#totalscore').val( config.totalscore);
    $('#passscore').val( config.passscore);
    $('#showorder').val( config.showorder);
    $('#disabled').get(0).checked=( config.disabled==1);
    //题库
    
    if (  config.librarylist)
    {
        for( var i=0;i<config.librarylist.length;i++)
        {
            addLibrary( config.librarylist[i] );
        }
    }
    
    $('#knowledgepoint').val( config.knowledgepoint);
    //题型
     if ( config.typeconfig)
     {
	     for ( var i=0;i<cs_itemtype.length;i++)
	     {
	        var it=cs_itemtype[i];
	        var tc=config.typeconfig[ it ]  ; //每种题型一个配置
	        if( tc==undefined) continue;
            for ( var j=0;j<6;j++)
            {
                $('#'+it+'n'+j).val(tc[ it+'n'+j] ); //类型为it ,难度为j 的题数
                $('#'+it+'s'+j).val( tc[ it+'s'+j] ); //类型为it ,难度为j 的分数
                //不区分题型，仅按难度的合计，放在这里，实际上是按每种题型都循环取了一次，除了浪费一点时间，
                //没有其它负作用        
                $('#'+'n'+j).val( tc[  'n'+j]  ); //类型为it ,难度为j 的题数
                $('#'+'s'+j).val( tc[  's'+j]  ); //类型为it ,难度为j 的分数
            }
            //按题型的合计
            $('#'+it+'n' ).val( tc[ it+'n' ] ); //类型为it ,难度为j 的题数
            $('#'+it+'s' ).val( tc[ it+'s' ] ); //类型为it ,难度为j 的分数
        }
        //总计
        $('#n' ).val(config.typeconfig[ 'n' ] ); //题数
        $('#s' ).val(config.typeconfig[ 's' ] ); //分数   
    }
    
          
    //排序设置
    if ( config.typeconfig.orderconfig!=undefined)
    {
        var oc=config.typeconfig.orderconfig;
        for ( var i=0;i<cs_itemtype.length;i++)
        {
            var it=cs_itemtype[i];
            try{ $('#order_'+it).val( oc[ it ] );   }catch( err) {}
        }
    }else
    {
        //缺省配置
        for ( var i=0;i<cs_itemtype.length;i++)
        {
            $('#order_'+cs_itemtype[i]).val( i +1);
        }
    }
    
    
    //2009.07.02 如果是临时测试，并且是直接点击课程进入的，那么不允许修改这些配置
    if(  parseInt( '0'+$('#param_courseid').val(),10)>0  ) 
    {
    	DisableAllEditableTag();
    	$('#beginSimulateTest').get(0).disabled=false; //仅把“开始测试”按钮亮起来	
    }
    
    
} 
 
//保存配置
function save( tip )
{
    if ( tip==undefined) tip=true;
	var config={ };
	config.id=$('#id').val( ); 
    config.pid=$('#pid').val( ) ; //上级的ID
    config.guid= $('#guid').val( );
	config.name=  $('#name').val( );
	config.username=$('#username').val( );
     
	config.summary=$('#summary').val( );

    config.courseid=$('#courseid').val( );
    if ( config.courseid==0) 
    {
        alert ("必须选择一门课程");
        t.showTab("tab_normal");
        return false;
    }
    
	config.totalscore=$('#totalscore').val( );
	config.passscore=$('#passscore').val( );
	config.showorder= $('#showorder').val( );
	config.disabled = $('#disabled').get(0).checked?1:0;
	config.knowledgepoint = $('#knowledgepoint').val( );
    
    //题库
    config.librarylist=[ ];
      
    var libs=$("select.libraryselect");
    var map={};
    for ( var i=0;i< libs.length;i++)
    {
        if ( map[libs[i].value]!=undefined) continue;
        map[libs[i].value]=1;
        
        config.librarylist[ config.librarylist.length] = libs[i].value;
    }
    
    if (  config.librarylist.length==0)
    {
           alert ("至少选择一个题库");
           t.showTab("tab_library");
           return false;
    }
    
    //题型
    config.typeconfig={ };
    for ( var i=0;i<cs_itemtype.length;i++)
    {
        var it=cs_itemtype[i];
        config.typeconfig[ it ] = { }; //每种题型一个配置
        var  tc =config.typeconfig[ it ];
        for ( var j =0 ; j<6;j++)
        {
            tc[ it+'n'+j] = $('#'+it+'n'+j).val( ); //类型为it ,难度为j 的题数
            tc[ it+'s'+j] = $('#'+it+'s'+j).val( ); //类型为it ,难度为j 的分数
           //不区分题型，仅按难度的合计，放在这里，实际上是按每种题型都循环取了一次，除了浪费一点时间，没有其它负作用        
            tc[  'n'+j] = $('#'+'n'+j).val( ); //类型为it ,难度为j 的题数
            tc[  's'+j] = $('#'+'s'+j).val( ); //类型为it ,难度为j 的分数
        }
        //按题型的合计
        tc[ it+'n' ] = $('#'+it+'n' ).val( ); //类型为it ,难度为j 的题数
        tc[ it+'s' ] = $('#'+it+'s' ).val( ); //类型为it ,难度为j 的分数
    }
    
     //总计
    config.typeconfig[ 'n' ] = $('#n' ).val( ); //题数
    config.typeconfig[ 's' ] = $('#s' ).val( ); //分数
　config.realtotalscore=$('#s' ).val( ); //分数  //再保存到realtotalscore中
    
    var tn=  parseInt(config.typeconfig[ 'n' ]);
    if( isNaN(tn) ) tn=0;
    if ( tn ==0)
    {
        alert("至少需要选择一种题型。");
        t.showTab("tab_itemtype");
        return false;
    }
    //排序
    config.typeconfig.orderconfig={ };
	for ( var i=0;i<cs_itemtype.length;i++)
	{
        var it=cs_itemtype[i];
        config.typeconfig.orderconfig[ it ] = $('#order_'+it).val(  );
	}
    
    //使用同步方式进行保存
    var ret=$rpc( 'educ.paper.PaperPolicy', 'editItem' , config );
    
    if ( ret.success)
    {
        if ( $('#id').val( )==0) $('#id').val( ret.id ) ;  //如果是新增加的策略，那么把ID回填到变量
    
        if (tip) alert( "保存成功。");
        return true;
        
    }else
    {
        alert(  ret.message);
        return false;
    }
    
                                    
}
 
/**
 * 添加一个库
 */
function addLibrary( libid )
{
    if  ( libid==undefined) libid='';
    var html= LS.getHTML( libid)
    $('#libraryContainer' ).append ( $(html));
     
}


/**
 * LS这个对象用来处理题库项的HTML代码
 */
var LS={ courseid:0};

LS.libraryData=null;

LS.getHTML=function( libID)
{
        var courseid=$('#courseid').val(  );
        if ( courseid==0)
        {
                alert("请先选择课程");
                 return "";   
         }
         
         if ( this.courseid!=courseid)  this.libraryData=null;
        this.courseid =courseid;  
        if ( this.libraryData==null)
        {
            var data= $rpc( 'educ.library.Librarylist', 'getAllLibraryNameAndIdList' , {courseid: courseid } );
            this.libraryData = data ;
        }
        this.libraryData.selectedId= libID;
        var html = TrimPath.processDOMTemplate("librarySelectTemplate", this.libraryData);                  
        return html;
}


/**
 * 选择课程
 */ 
function selectCourse()
{
     $rpc( 'educ.course.Course', 'getCourseListHTML' , 
                                   {
                                      
                                   },
                                   function( ret)
                                   {
                                       var  data=  JSON.parse(ret);
                                       var pid=$('#courseid').val( );
              
                                       $('#coursecontainer').html( "<select id=courseid name=courseid  >"+  data.html+"</select>");
                                       $('#courseid').val( pid );
                                       $('#cb_selectcourse').css("display","none");
                              
                                       
                                   }
                 ) ;               
    
}


function  beginSimulateTest()
{
     var totalminute= $('#totalminute').val( );
     if ( isNaN(totalminute))
     {
        alert ("请设置测试应试时间");
        return ;
     }
     
     if ( !save(false) )  return ; 
     var id=$('#id').val( );
     
     
     if ( id==0) return ;
     $.blockUI("正在组织试卷...");
     //生成一个测试的配置，并做好相关的数据，并打开测试界面
     // 测试与正式考试的区别就在于 examid=0的是测试
      $rpc( 'educ.exam.ExamSet', 'newSimuliteExam' , 
                                   {
                                      "paperpolicyid" : id , 
                                      "totalminute" :totalminute,
                                      "name": $('#name').val( ) 
                                    },
                                   function( ret)
                                   {
                                       $.unblockUI( );
                                       var  data=  JSON.parse(ret);
                                       if ( data.success)
                                       {
                                        var  examid=data.examid;
                                        window.location.href= "edu_exam_do.jsp?id="+examid+'&simulate=true' ;
                                       }else
                                       {
                                           alert ( data.message);
                                       }
                                        
                                   }
                 ) ;               
    
 
}
