/*******************************************************************************************************************************************
 * 　
 *  
 *  细节： 每个题目的选项都以 {题库ID}_{题目ID} 做 id , 并且在题目主体前有一个id=headof_{题库ID}_{题目ID}的对象
 *                　
 *
 *
 *
****************************************************************************************************************************************** */
 
 //全局对象
 $G={  currentItem:null           // 当前题目信息
　
         } ;
 
/**
 * 调取试卷及答卷纸
 */
$(document).ready(
function ()
{
 
    
    $.blockUI("正在加载练习历史...");
  
    $("#paperContainer").css("display","none");
    
    var initAction=  $('#action').val();
    var exerciseid=  $('#exerciseid').val();//需要进行定位的练习的ID，在日志中查看关联的练习时使用
    
    
     $rpc( 'educ.exercise.Exercise', 'getNavigate' , 
                                   {
                                     'id'          :   $('#id').val()
                                    },
                                   function( ret)
                                   {
                                       $("#paperContainer").css("display","");
                                       $.unblockUI();
  
                                       var  data=  JSON.parse(ret);
                                       //如果调取试卷不成功，或者不允许，那么直接警告，并把标记canSave 设置成false,禁止保存
                                       if ( !data.success)
                                       {
                                            alert (data.message);
                                            return;
                                       }
                                       
                                         //题目定位
                                        var navigate=$G.buildNavigateHTML( data.list);
                                        var pw=DomUtil.parentWindow( );
                                        pw.setNavigateHTML( navigate);    
                                    
                                        if ( initAction=='list' && data.list.length>0) 
                                        {
                                            if (exerciseid=='') exerciseid= data.list[0].id; 
                                            $G.jumpTo( exerciseid , false);
                                        }
                                     
                                        if ( initAction=='next') $G.onNext( false); 
                                        
                                        
                            }
                            
              );               
  
        
});

 

/**
 * 得到答卷纸 
 * 在练习中只有一道题，不需要答卷纸，但为了与考试使用相同的脚本进行统一处理，所以
 * 一道题也做成答案纸的格式，便于恢复用户答案
 */
$G.getAnswerPaper=function( )
{
    var answerPaper={ };
   if ( $G.currentItem==null)  return null;
    var item=$G.currentItem;  　
    var key= item.libraryid+"_"+item.itemid;
    var answer= AnswerUtil.buildAnswer(item,key);
    　 　　　 
    if ( answer!=null) //没有做答的题目不要记录
     {  
            var IT=item.itemtype.toUpperCase( );
            var answerInfo={ };
            answerInfo.itemtype=IT; //大写的类型
            answerInfo.libraryid=item.libraryid; // 记下来便于评卷
            answerInfo.itemid= item.itemid;
            answerInfo.answer = answer;
            answerPaper[key]=answerInfo;
         
        }else
        {
           return  null;
        }
      return answerPaper;    
    
}

$G.onShowAnswer =function( )
{
    if ( $G.currentItem==null) return ;
    var html="<br>&nbsp;【题号&nbsp;<font color=blue>"+$G.currentItem.no+"&nbsp;</font>答案提示】<br> "+AnswerUtil.buildStandardAnswerHTML( $G.currentItem ,  $G.currentItem.answer);
  
   setStandardAnswerHTML(html);
}

function setStandardAnswerHTML(html)
{
    var item=$G.currentItem;  　
    var key= item.libraryid+"_"+item.itemid;
     var obj=$('#'+key+'_answerContainer');
     obj.html(  html );
}
　
/**
 * 保存用户答卷
 */
$G.onSave=function( )
{
 
     //没有题目，不需要保存
    if ( ! $G.currentItem==null)  return true; 
    
    var answerPaper=$G.getAnswerPaper( );
    var s="";
    //未做答，不保存
    if ( answerPaper==null) 
    {
        if( !confirm ("本题尚未做答，确信不做答且继续吗。"))   return false ;
     
    }else
    { 
    
    	s=   JSON.toString( answerPaper) ;
    	if (  $G.currentItem.useranswer == s) 
    	{
    		//alert("未修改答案，不需要保存");
    		return  true; 
    	}
    }
    
   
    
    var data=$rpc( 'educ.exercise.Exercise', 'saveAnswerPaper' , 
                                   {
                                     'id'                           :   $('#id').val() , //练习配置的ID
                                     'exerciseid'           : $G.currentItem.id ,   // 练习的ID
                                     'answer'                  :   s   //答卷内容
                                    } );
                                    
                                          
     if ( data.success )
     {
        return true
     }else
     {
         alert ( data.message);
         return false;
     }
       
}

//用于定位题目的HTML
$G.buildNavigateHTML=function( list)
{
 
   // var tip="黑色题号表示是常规题目， 绿色显示的题号表示有批注的题目， 红色显示的题目表示需要重点复习的题目";  
            
     //  var navigate='<img src="image/help-16x16.gif" align="absmiddle" title="'+tip+'"><span class="asbutton" onclick="alert(\''+tip+'\');">颜色提示</span><hr size=1><div>';
        var navigate="<div>点击题号将打开该题目<br>";
       for( var i=0;i<list.length;i++) 
       {
            var item= list[i];
            var a='headof_'+item.libraryid+'_'+item.itemid;
            navigate+='<span id='+a+'  class=asbutton style="padding:0px; margin:0px;  font-size:11px;border:1px solid #e0e0ff;background-color:efefef; " onclick="jumpTo('+item.id+ ')" >'+item.no+"</span> ";//最后要留一个空格
       }
       navigate+='</div>';
       
       return navigate;                                   
}

/**
 *  练习下一题
 */
$G.onNext=function( needCheck   )
{
    
    if ( needCheck==undefined) needCheck=true;
    if ( needCheck)
    {
        var b=$G.onSave(); //先保存当前题目的用户答案
        if (! b) return ;
    }
    
    $.blockUI("正在随机抽取下一道题..."); 
    $rpc( 'educ.exercise.Exercise', 'getNext' , 
			               {
			                 'id'                           :   $('#id').val()   //练习的ID
			                },
			               function( ret)
			               {
                                $.unblockUI();          　
			                     var  data=  JSON.parse(ret);
                                 if ( data.success)
                                 {
    									var item=data.item;
                                        $G.currentItem= item;
                                        
										var a='headof_'+item.libraryid+'_'+item.itemid;
										var html = TrimPath.processDOMTemplate("template_item", item);
                                        // 如果有错，那么　html中包含错误信息　alert( html);
										$("#paper").html("");
                                        html="<br>"+html+"<br><br>";
                       
										$("#paper").append( $(html));
                                        //新的练习题不存在恢复练习答案的问题
                                        //题目定位
                                        var navigate=$G.buildNavigateHTML( data.list);
                                        var pw=DomUtil.parentWindow( );
                                        pw.setNavigateHTML( navigate);    
                                  
 
                                 }else
                                 {
                                     alert( data.message);
                                 }
                           }
              );
                                    
        //清除答案提示      
 
        setStandardAnswerHTML( "");    
}
 
 
              
            

//pd' , 'dx', 'fx', 'tk', 'js', 'gc', 'mc', 'jd', 'ls', 'al'];
$G.buildAnswer=function(item,key)
{
    var IT=item.itemtype.toUpperCase( );
 
    if( IT=='PD') return $G.buildAnswer_PD(item,key);
    if( IT=='DX') return $G.buildAnswer_DX(item,key);
    if( IT=='FX') return $G.buildAnswer_FX(item,key);
    
    alert ("buildAnswer不支持的类型"+IT);
    return null; 
      
}
 

$G.jumpTo=function( exerciseid , needCheck)
{
     if ( needCheck==undefined) needCheck=true;
     if( needCheck) 
     {
          var b=$G.onSave(); //先保存当前题目的用户答案
          if(!b) return ;
     }
     
    if ( needCheck==undefined) needCheck=true;
    $.blockUI("正在调取题目..."); 
   
    $rpc( 'educ.exercise.Exercise', 'getItem' , 
                           {
                             'id'                           :   $('#id').val() ,  //练习配置的ID
                             'exerciseid'         :  exerciseid         // 练习的ID  
                            },
                           function( ret)
                           {
                                $.unblockUI();          　
                                 var  data=  JSON.parse(ret);
                                 if ( data.success)
                                 {
	                                    var item=data.item;
	                                    $G.currentItem= item;
	                                    var a='headof_'+item.libraryid+'_'+item.itemid;
	                                    var html = TrimPath.processDOMTemplate("template_item", item);
	                                    // 如果有错，那么　html中包含错误信息　alert( html);
	                                    $("#paper").html("");
	                                    html="<br>"+html+"<br><br>";
	                                    $("#paper").append( $(html));
                                        
                                        //显示标准答案
                                        $G.onShowAnswer( );
	                                    //历史练习需要恢复练习答案
	                                    $.unblockUI();
		                                $.blockUI("正在加载您的回答...");
		                            
                                        
		                                  //重新调取答卷纸
		                                try
		                                {
		                                          var  s=item.answerpaper;
		                                          if ( s.length>0)
		                                          {
		                                              var answers= JSON.parse( s);
		                                              for ( var key  in  answers )
		                                              {
		                                                  var answer= answers[key]; //得到的是一个包含了更多信息的包，其中的useranswer才是考生的答案
		                                                  var flag=AnswerUtil.restoreAnswer( key , answer);
		                                               }
		                                        
		                                          }
		                                }catch(err)
		                                {
		                                   
		                                }
		                                 
                                        //调取评分信息
                                        try
                                        {
                                            
                                            var  evaltips=JSON.parse( item.evaltip );
                                            html="";
                                            if ( evaltips.length>0) 
                                            {
                                                var img="image/ok.gif";
                                                if ( item.rightpercent>0 && item.rightpercent<100.0) img="image/okhalf.gif"; 
                                                if (  item.rightpercent==0) img="image/cancel.gif"; 
                                                
                                                html= html+"<br><img src='"+img +"' > &nbsp;&nbsp;本题正确率：&nbsp;<font color=red>"+item.rightpercent+"%</font>&nbsp;";
	                                            for( var i=0;i<evaltips.length;i++)
	                                            {
                                                    
	                                                html=html+'<br>' +evaltips[i].teachername+"：&nbsp;"+ evaltips[i].tip;
	                                            }
	                                            html="<div style='color:green'>"+html+"</div><br><br>";
	                                          
                                                $("#paper").get(0).append( $(html));
                                            }
                                        }catch(err)
                                        {
                                            
                                        }
                                        
                                        try
                                        { 
                                        //学习日志情况：
                                        if( item.logcount !=undefined)
                                        {
                                              var logkey= item.libraryid+"_"+item.itemid;
                                               
                                               
                                            html=html+'<div>&nbsp;【本题的学习心得】&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';　
                                            if (item.logcount>0 )
                                            {
                                                html=html+"<span id="+logkey+"_getlistbutton>[<span class='asbutton' onclick='getLogs();'><img src='image/book_open.gif'  align='absmiddle'> 阅读 <font  color='red'>"+item.logcount+"</font> 篇学习心得</span>]</span>";
                                            }
                                            
                                             var now= new Date();
                                             var ty= now.getYear();
                                             if ( ty<1900) ty=ty+1900;
                                             var tm=  (now.getMonth()+1);
                                             var td= now.getDate();
      
                                            html=html+"&nbsp;&nbsp;&nbsp;&nbsp&nbsp;&nbsp;&nbsp;&nbsp;[<span class='asbutton'   onclick=' window.open(\"mylog_day_new.jsp?" +
                                                    "year="+ty+"&month="+tm+"&day="+td+"&class_id=-1&thirdrelation={exerciseid:"+ exerciseid+",id:"+$('#id').val()+"} \" ); '>" +
                                                            "<img src='image/write4.gif'  align='absmiddle'> 新的学习心得</span>]</div>";
                                            　
                                             
                                            html=html+"<div id="+  logkey +"_loglist></div>" //加一个容器放日志列表
                                            var logobj=$('#'+key+'_logContainer');
                                            logobj.html(  html  );
                                            logobj.get(0).style.display="";
                                        }
                                      
                                        }catch(err)
                                        {
                                            
                                        }
                                        
		                                $.unblockUI();
	                                                                          
 
                                 }else
                                 {
                                     alert( data.message);
                                 }
                           }
              );
                              
}

// 本函数在此无实际意义。在考试中，对题目做答后，会把题号的背景改变，
//但在练习中无此需要，此函数仅用来防止浏览器提示不存在此函数
$G.setNavigateFlag=function( )
{
    
}

 
function getLogs()
{
      // $G.currentItem= item;
      var exerciseid = $G.currentItem.id;
      var thirdrelation="{exerciseid:"+ exerciseid+",id:"+ $('#id').val() +"}" ;
       $.blockUI("正在调取题目..."); 
   
      $rpc( 'educ.exercise.Exercise', 'getItemLogs' , 
                           {
                             'id'                         :   $('#id').val() ,  //练习配置的ID
                             'exerciseid'        :  exerciseid  ,        // 练习的ID
                             'thirdrelation' : thirdrelation 
                            },
                           function( ret)
                           {
                                $.unblockUI();          　
                                 var  data=  JSON.parse(ret);
                                 if ( data.success)
                                 {
                                        var html="<div>";
                                        
                                      
                                        for( var i=0;i<data.logs.length ; i++)
                                        {
                                            html=html+"&nbsp;&nbsp;<img src='image/book_open.gif'  align='absmiddle'>&nbsp;<a href='mylog_day_view.jsp?id="+data.logs[i].id+"'  target='_blank'>"+data.logs[i].title +"</a><br>";
                                        }
                                        
                                        html=html+"</div>";
                                        
                                        var item=$G.currentItem;
                                        var logkey= item.libraryid+"_"+item.itemid;
                                             
                                        var logcontainkey= logkey +"_loglist";
                                        var container=$('#'+logcontainkey);
                                        container.html(  html);
                                       $('#'+logkey+'_getlistbutton').get(0).style.display="none";
                                        
                                 }
                            }
                            
                            );
                           
      
    
}
