 /**
  * 考试编辑
  */
 
 
window.onload= function()
 {
    
     // 修改名称后，同步标题显示
     $("#name").bind('keyup' , function(){  $('#v_name').html( $('#name').val());} );
    
     loadItem( $('#id').val() , $('#pid').val() ); 
     
     pushClient.init("edu_paper"); //注册接收服务端推送的 edu_paper类型的消息
     pushClient.onMessage=function(msg)
     {
            msg="<div>"+unescape( msg)+"</div>";
            var obj=$(msg);
            $('#div_log_geteratePaper' ).css('border', "1px solid #efefef");
            $('#div_log_geteratePaper' ).append ( obj);
            obj.get(0).scrollIntoView(false);
     };
     
 }
  
 
  
 
/**
 * 重新设置PID
 */ 
function modifypid()
{
     $rpc( 'educ.exam.ExamSet', 'getClassTree' , 
                                   {
                                     'id'          :   $('#id').val(),
                                     'where' :  ' isleaf=0' , 
                                     'forSelectLeaf' : false
                                   },
                                   function( ret)
                                   {
                                       var  data=  JSON.parse(ret);
                                       var pid=$('#pid').val( );
                                        
                                       $('#pidcontainer').html( "<select id=pid name=pid class='textbox'>"+  data.html+"</select>");
                                       $('#pid').val( pid );
                                   }
                 ) ;               
    
}


/**
 * 选择补考
 */ 
function modifybkid()
{
     $rpc( 'educ.exam.ExamSet', 'getClassTree' , 
                                   {
                                     'id'          :   $('#id').val(),
                                     'where' :  '' , 
                                     'forSelectLeaf' : true
                                   },
                                   function( ret)
                                   {
                                       var  data=  JSON.parse(ret);
                                       var oldid=$('#oldid').val( );
                                        
                                       $('#oldidcontainer').html( "<select id=oldid name=oldid class='textbox'>"+  data.html+"</select>");
                                       $('#oldid').val( oldid );
                                   }
                 ) ;               
    
}
/**
 * 选择出题策略
 */ 
function selectPaperPolicy()
{
     $rpc( 'educ.paper.PaperPolicy', 'getClassTree' , 
                                   {
                                      'id'                                 :   -1,
                                      'where'                         :   '',
                                      'forSelectLeaf'           :  true 
                                      
                                   },
                                   function( ret)
                                   {
                                       var  data=  JSON.parse(ret);
                                       var pid=$('#paperpolicyid').val( );
                                        
                                       $('#paperpolicycontainer').html( "<select id=paperpolicyid name=paperpolicyid  >"+  data.html+"</select>");
                                       $('#paperpolicyid').val( pid );
                                       $('#cb_selectPaperPolicy').get(0).disabled=true;
                                       $('#tip_selectPaperPolicy').css("display" ,"");
                                       
                                   }
                 ) ;               
    
}


 
/**
 * 
 * 调取考试的配置 （使用异步方式）
 */    
function loadItem(id ,pid)
{
    //$progress.show("正在调取数据...");
     $.blockUI( "正在调取数据...");
     
     $rpc( 'educ.exam.ExamSet', 'getItem' , 
                                   {
                                     'id'          :   id,
                                     'pid'       :   pid
                                   },
                                   function( ret)
                                   {
                                       var  data=  JSON.parse(ret);
                                       if (! data.success)
                                       {
                                            alert( data.message);
                                            return;
                                       }
                                       
                                       applyItemConfigToUI( data.config);
                                       //$progress.hide();
                                       $.unblockUI();
                                   }
                 ) ;                   
}
 
/**
 * 把配置显示到界面上
 */
function applyItemConfigToUI( config)
{
    $('#guid').val( config.guid);
    $('#name').val( config.name);
    $('#path').html( config.path);
    $('#v_name').html( $('#name').val());
    $('#username').val( config.username);
    $('#createdate').val( config.createdate);
    $('#lastmodifydate').val( config.lastmodifydate);
    $('#summary').val( config.summary);
    $('#showorder').val( config.showorder);
    $('#disabled').get(0).checked=( config.disabled==1);
   
    $('#totalminute').val( config.totalminute);
    $('#startdate_date').val( config.startdate_date);
    $('#startdate_hour').val( config.startdate_hour);
    $('#startdate_minute').val( config.startdate_minute);
    $('#enddate_date').val( config.enddate_date);
    $('#enddate_hour').val( config.enddate_hour);
    $('#enddate_minute').val( config.enddate_minute);
    $('#remindbeforedays').val(config.remindbeforedays);
     
    $('#paperpolicyid').val( config.paperpolicyid);
    $('#papercount').val( config.papercount);
    $('#paperpolicyfullname').html( config.paperpolicyfullname);
    //补考
    $('#bk').get(0).checked= ( config.bk==1);
    $('#bkfullname').html( config.bkfullname);
    $('#oldid').val( config.oldid);
     //防止舞弊
     $('#randlistsubject').get(0).checked =(config.randlistsubject==1) ;
     $('#randlistcandidate').get(0).checked=(config.randlistcandidate==1);
    
    
    setPaperHadGeneratedTip( config.paperHadGenerated );
    
    //考生选项
    $('#examinee_alluser').get(0).checked=( config.examinee_alluser==1);
    $('#examinee_allcourseuser').get(0).checked=( config.examinee_allcourseuser==1);
    $('#examinee_unpass').get(0).checked=( config.examinee_unpass==1);
    $('#examinee_unexam').get(0).checked=( config.examinee_unexam==1);
     //指定考生
    loadCustomRightWhat('examinee', config.examinee_config );
    //排除考生
    loadCustomRightWhat('exclude',config.examinee_excludeuser);
    
    //阅卷人
    $('#eval_courseteacher').get(0).checked= config.eval_courseteacher==1; 
    loadCustomRightWhat('eval', config.eval_config );
    
    
    //成绩转议
     
    var objs=document.getElementsByName ('showresult_escape');
    for( var i=0;i<objs.length;i++)
    {
        if ( objs[i].value==  config.showresult_escape)    objs[i].checked=true;
    }
    
    //转成对象
    config.result_escape_set = JSON.parse( config.result_escape_set );
    //如果不是数组，那么变成数组
    if ( typeof(config.result_escape_set)=="string")
    {
        config.result_escape_set =[];
    }
    
     for( var i=1;i<=config.result_escape_set.length;i++)
    {
      
        $('#escapedefine'+i+'_score1').val( config.result_escape_set[i-1].score1 );
        $('#escapedefine'+i+'_score2').val(config.result_escape_set[i-1].score2);
        $('#escapedefine'+i+'_result').val(config.result_escape_set[i-1].result);
     }
     
    
    //自动保存
    $('#autosaveafterminute').val( config.autosaveafterminute);
  
    
} 
 
function  setPaperHadGeneratedTip( paperHadGenerated)
{
    if (  paperHadGenerated)
    {
        $('#paperHadGenerated').html("<font color=red>已按上述策略生成试卷</font>");
    }else
    {
        $('#paperHadGenerated').html("<font color=red>尚未生成试卷</font>");
    }
}

//保存配置
/**
 * tip 是否需要提示
 * sync :是同步保存吗
 */
function save( tip ,sync)
{
    if ( sync==undefined) sync=true;// 缺省是同步保存
	var config={ };
    
    config.issimulate = 0 ; //表示是正式的考试设置
	config.id=$('#id').val( ); 
    config.pid=$('#pid').val( ) ; //上级的ID
    config.guid= $('#guid').val( );
	config.name=  $('#name').val( );
	config.username=$('#username').val( );
     
	config.summary=$('#summary').val( );
	config.showorder= $('#showorder').val( );
	config.disabled = $('#disabled').get(0).checked?1:0;
	 
    config.totalminute=$('#totalminute').val( );
    
    config.startdate_date=$('#startdate_date').val( );
    config.startdate_hour= $('#startdate_hour').val( );
    config.startdate_minute=$('#startdate_minute').val( );
    config.enddate_date=$('#enddate_date').val( );
    config.enddate_hour=$('#enddate_hour').val( );
    config.enddate_minute=$('#enddate_minute').val( );
    config.remindbeforedays=$('#remindbeforedays').val( );
    
    config.paperpolicyid=$('#paperpolicyid').val( );
    if ( config.paperpolicyid==0) 
    {
        alert ("必须选择一个生成试卷的策略(您可能选择了一个策略分类，而不是策略)");
        return;
    }
    config.papercount=$('#papercount').val( );
    
    config.bk=  $('#bk').get(0).checked?1:0;
    config.oldid=$('#oldid').val();
    if ( config.bk==1)
    {
        if ( config.oldid==0) 
        {
            alert("必须指定是针对哪场考试进行的补考。");
            return;
        }
    }
    
    //防止舞弊
    config.randlistsubject= $('#randlistsubject').get(0).checked? 1:0 ;
    config.randlistcandidate= $('#randlistcandidate').get(0).checked? 1:0 ;
      
    //考生选项
    config.examinee_alluser = $('#examinee_alluser').get(0).checked? 1:0 ;
    config.examinee_allcourseuser=$('#examinee_allcourseuser').get(0).checked?1:0;
    config.examinee_unpass=$('#examinee_unpass').get(0).checked? 1: 0 ;
    config.examinee_unexam=$('#examinee_unexam').get(0).checked?1:0;
    //指定考生
    config.examinee_config=buildExecutor('examinee');
  
    config.examinee_excludeuser=buildExecutor('exclude');
    //排除考生
    
    
    //阅卷人
    config.eval_courseteacher=  $('#eval_courseteacher').get(0).checked? 1:0 ;
    config.eval_config = buildExecutor('eval');
    
    // other
    
    
    // 展现方式
    var objs=document.getElementsByName ('showresult_escape');
    for( var i=0;i<objs.length;i++)
    {
        if ( objs[i].checked)  config.showresult_escape= objs[i].value;
    }
    
    config.result_escape_set=[ ];
    
    for( var i=1;i<=10;i++)
    {
        config.result_escape_set[i-1]={};
        config.result_escape_set[i-1].score1= $('#escapedefine'+i+'_score1').val();
        config.result_escape_set[i-1].score2= $('#escapedefine'+i+'_score2').val();
        config.result_escape_set[i-1].result= $('#escapedefine'+i+'_result').val();
     }
     
      
  
    // 自动保存
    config.autosaveafterminute = $('#autosaveafterminute').val( );
    
    
    //使用同步方式进行保存
    $.blockUI("保存中...");
    if ( sync) //同步方式的保存
    {
		    var ret=$rpc( 'educ.exam.ExamSet', 'editItem' , config );
		    $.unblockUI();
		    if ( ret.success)
		    {
		        if ( $('#id').val( )==0) $('#id').val( ret.id ) ;  //如果是新增加的考试，那么把ID回填到变量
		    
		        setPaperHadGeneratedTip( ret.paperHadGenerated );
		        
		        if ( tip==undefined) tip=true;
		        if (tip) alert( ret.message); 
		        return true;
		        
		    }else
		    {
		        alert(  ret.message);
		        return false;
		    }
     }else //异步方式的保存
     {
            $rpc( 'educ.exam.ExamSet', 'editItem' , config,  
                           function ( data)
                           {
                                var ret=JSON.parse(data);
					            $.unblockUI();
					            if ( ret.success)
					            {
					                if ( $('#id').val( )==0) $('#id').val( ret.id ) ;  //如果是新增加的考试，那么把ID回填到变量
					             
					                setPaperHadGeneratedTip( ret.paperHadGenerated );
					                
					                if ( tip==undefined) tip=true;
					                if (tip) alert( ret.message); 
					                return true;
					                
					            }else
					            {
					                alert(  ret.message);
					                return false;
					            }
                            }
                   );
                   return true;
     }
                                    
}
 
/**
 * 生成考试的试卷，生成前先同步保存 ,再用异步方式生成试卷，再异步保存
 */
function geteratePaper( )
{
    if (! save(false , true)) return ;
    $('#div_log_geteratePaper' ).css("display","");
    $('#div_log_geteratePaper' ).html(''); //清空日志
    $('#cb_getenatePaper').get(0).disabled=true;
    
    $rpc( 'educ.exam.ExamSet', 'generatePaper' , {'id' : $('#id').val( ) } , 
                     function(ret)
                     {
                          $('#cb_getenatePaper').get(0).disabled=false;
    
                          var  data=  JSON.parse(ret); 
                          if ( data.success)
                          {
                             setPaperHadGeneratedTip( true);
                             save(false, false) ; //以异步方式再保存一次，并且不要提示
                             alert ("试卷生成完毕");
                          }else
                          {
                            alert( data.message);
                          }
                     }
                     
               );
    
}

/**
 * 查看第no号试卷
 */
function viewPaper()
{
     var no= $('#viewpaperno').val( )  ;
     var paperCount=  $('#papercount').val( )  ;
     if ( no<0 || no >paperCount)
     {
        alert("请输入一个合法的数字（大于0并且不能大于试卷套数");
        return;
     }
     
     open("edu_examset_viewpaper.jsp?id="+$('#id').val( ) +"&paperno="+no)
     
}

/**
 * 添加一个库
 */
function addLibrary( libid )
{
    if  ( libid==undefined) libid='';
    var html= LS.getHTML( libid)
    $('#libraryContainer' ).append ( $(html));
     
}


/**
 * 生成考生列表
 */
function refreshExamineeList()
{
      //先同步保存
      if (! save(false , true)) return ;
      $.blockUI("正在刷新考生列表");
      $rpc( 'educ.exam.ExamSet', 'refreshExamineeList' , {'id' : $('#id').val( ) } , 
                     function(ret)
                     {
                          var  data=  JSON.parse(ret);
                          $.unblockUI( );
                          if ( data.success)
                          {
                             $progress.showDelay("考生列表刷新完成",2000);
                          }else
                          {
                            alert( data.message);
                          }
                     }
                     
               );
}


/**
 * LS这个对象用来处理题库项的HTML代码
 */
var LS={ };

LS.libraryData=null;

LS.getHTML=function( libID)
{
        if ( LS.libraryData==null)
        {
            var data= $rpc( 'educ.library.Librarylist', 'getAllLibraryNameAndIdList' );
            LS.libraryData = data ;
        }
        LS.libraryData.selectedId= libID;
        var html = TrimPath.processDOMTemplate("librarySelectTemplate", LS.libraryData);                  
        return html;
}

