function getIframeDocument(el) 
{
    var oIframe = Ext.get('main').dom;
    var oDoc = oIframe.contentWindow || oIframe.contentDocument;
    if(oDoc.document) {
        oDoc = oDoc.document;
    }
    return oDoc;
}
   
$G =
 {
    currentTreeId:0,  //当前树结点的ID ，缺省定位在根目录结点上
    cb_addItem:null,
    cb_editItem:null,
    cb_deleteItem:null,
    
     init : function () 
     {
         
        var   northPanel ,   southPanel,  eastPanel,  westPanel, centerPanel;
 
        var mainLayout = new Ext.BorderLayout(document.body, {
            north: { 
                split: true, initialSize: 38 , maxSize:38 , minSize:38
            }, 
            south: { 
                split: false, initialSize: 20 , maxSize:20 , minSize:20
            }, 
            
             west: { 
                split: true, initialSize: 235, titlebar: true, collapsible: true
            }, 
            center: { titlebar: false}
        });
        mainLayout.beginUpdate();
        mainLayout.add('north', northPanel = new Ext.ContentPanel('north-div', { 
			        fitToFrame: true, closable: false 
			        }));
			   
    
        mainLayout.add('west', westPanel = new Ext.ContentPanel('west-div', 
			        { 
					fitToFrame: true, closable: false, title: "考试分类"
					}));
        mainLayout.add('center', centerPanel = new Ext.ContentPanel('center-div', { 
                    fitToFrame: true, autoScroll: true, resizeEl: 'main',   title: 'Content'
                    })); 
                    
         mainLayout.add('south', southPanel = new Ext.ContentPanel('south-div', { 
                    fitToFrame: true, closable: false 
                    }));     
   
	    //工具栏
		 var tb = new Ext.Toolbar('toolbar');
         tb.addButton( infoBar1= new Ext.Toolbar.TextItem('<img src="image/educ/examset.jpg">' )  );
         tb.addSeparator();
        
         tb.addButton(  new Ext.Toolbar.Button({text: '刷新', cls: 'x-btn-text-icon',icon:'image/refresh.gif', handler: $G.refreshWhole} )  );
         tb.addSeparator();
		 tb.addButton(  new Ext.Toolbar.Button({text: '新增下级分类',cls: 'x-btn-text-icon',icon:'image/expand.gif',  handler: $G.newSub} )  );
		 tb.addSeparator();
		 tb.addButton( new Ext.Toolbar.Button({text: '删除分类', cls: 'x-btn-text-icon',icon:'image/cancel.gif' , handler:  $G.deleteClass} )  );
		 tb.addSeparator();
		 tb.addButton( new Ext.Toolbar.Button({text: '修改分类', cls: 'x-btn-text-icon',icon:'image/write3.gif',  handler:  $G.editClass} )  );
		 tb.addSeparator();
         
		 tb.addButton( $G.cb_addItem=new Ext.Toolbar.Button({text: '增加考试',cls: 'x-btn-text-icon',icon:'image/icon_readmore.gif',   handler:  $G.newItem} )  );
         tb.addSeparator();    
		 tb.addButton( $G.cb_deleteItem=new Ext.Toolbar.Button({text: '删除考试', cls: 'x-btn-text-icon',icon:'image/erase.gif' , handler:  $G.deleteItem} )  );
         tb.addSeparator();
         tb.addButton( $G.cb_editItem=new Ext.Toolbar.Button({text: '修改考试', cls: 'x-btn-text-icon',icon:'image/write5.gif',  handler:  $G.editItem} )  );
         tb.addSeparator();    
         
           
        mainLayout.endUpdate();
        $G.openUrl( 'edu_examset_list.jsp?id=0');
    }  , 

   /**
    * 新增加一个下级分类
    */
    newSub :function( )
    {
         Ext.MessageBox.prompt('增加下级分类', '请输入分类的名称：', function(btn, text)
               {
				    if (btn == 'ok')
                    {
                          var ret = $rpc( 'educ.exam.ExamSet', 'addSub' , 
                                           {
                                             'pid'          :   $G.currentTreeId,
                                             'name'     :   text
                                           }
                                       );
                                       
			                if ( ret.success)
			                {
			                    alert( "成功创建分类。"); 
                                $G.refreshWhole();
			                     
			                }else
			                {
			                    Ext.MessageBox.alert("提示", ret.message);
			                }
					   }
			   }
           );
               
    },          
    
    
    /**
    * 删除一个分类
    */
    deleteClass :function( )
    {
        if ($G.currentTreeId<=0) 
        {
            Ext.MessageBox.alert("提示","请先点击需要删除的分类");
            return;    
        }
        
         Ext.MessageBox.confirm("提示",'确信要删除该分类吗?', function(btn )
              {
                  if (btn != 'yes') return;
                     
	              var ret = $rpc( 'educ.exam.ExamSet', 'deleteClass' , 
	                               {
	                                 'id'          :   $G.currentTreeId 
	                               }
	                           );
	                           
	                if ( ret.success)
	                {
	                    alert( "成功删除。"); 
	                    $G.refreshWhole();
	                     
	                }else
	                {
	                    Ext.MessageBox.alert("提示", ret.message);
	                }
	          
               }
           );
               
    },          
    
     /**
    * 修改一个分类
    */
    editClass :function( )
    {
        if ($G.currentTreeId<=0) 
        {
            Ext.MessageBox.alert("提示","请先点击需要修改的分类");
            return;    
        }
        
        $G.disableItemFunction();
        $G.openUrl('edu_examset_classedit.jsp?id='+  $G.currentTreeId );
    } ,
        
    
    /**
    * 新增加一个考试
    */
    newItem :function( )
    {
         $G.disableItemFunction();
          $G.openUrl('edu_examset_edit.jsp?id=0&pid='+  $G.currentTreeId );
    },          
    
    
    /**
    * 修改考试
    */
    editItem :function( )
    {
       
        try
        {
	        var grid=Ext.get('main').dom.contentWindow.$G.grid;
	        var record= grid.getSelectionModel().getSelected() ;
	        if ( record==undefined)
	        {
	            Ext.MessageBox.alert("提示","请先选择一个考试"); 
	            return ;
	        }
	        $G.disableItemFunction();
	        $G.openUrl('edu_examset_edit.jsp?id='+record.id+'&pid='+  $G.currentTreeId );
        }catch(err)
        {
            Ext.MessageBox.alert("提示","当前状态下不允许执行该操作。"); 
        }
        
    },          
    
    /**
    * 删除考试
    */
    deleteItem :function( )
    {
       
        try
        {
            
            var grid=DomUtil.iframeWindow('main').$G.grid;
            var record= grid.getSelectionModel().getSelected() ;
            if ( record==undefined)
            {
                Ext.MessageBox.alert("提示","请先选择一个考试"); 
                return ;
            }
               
           Ext.MessageBox.confirm("提示",'确信要删除该考试吗?', function(btn )
              {
                  if (btn != 'yes') return;
                     
                  var ret = $rpc( 'educ.exam.ExamSet', 'deleteItem' , 
                                   {
                                     'id'          :   record.get("id") 
                                   }
                               );
                               
                    if ( ret.success)
                    {
                        alert( "成功删除。"); 
                        DomUtil.iframeWindow('main').$G.refresh();
                         
                    }else
                    {
                        Ext.MessageBox.alert("提示", ret.message);
                    }
              
               }
           );
           
        }catch(err)
        {
            Ext.MessageBox.alert("提示","当前状态下不允许执行该操作。"); 
        }
        
    },          
    
    
    disableItemFunction:function()
    {
        $G.cb_addItem.disable();
        $G.cb_editItem.disable();
        $G.cb_deleteItem.disable();
    },
    
    enableItemFunction:function()
    {
        $G.cb_addItem.enable();
        $G.cb_editItem.enable();
        $G.cb_deleteItem.enable();
    },
    
    
    /**
     * 刷新页面
     */
    refreshWhole:function( )
    {
        window.location.href=window.location.href;
    },

    doNothing:function  ()
    {
    	alert('aa');
    } ,
    
    //点击树结点后，打开列表
    gotourl:function( id)
    {
        $G.currentTreeId=id; 
        $G.refreshFullPath(id);
        var s=Ext.get('main').dom.src+'';
 
        if ( s.indexOf( 'edu_examset_list.jsp')>=0)
        {   
             try
             {//有时候会取不到这个对象
                var obj=Ext.get('main').dom.contentWindow.$G;
                obj.retrieve( id);
             }catch(err)
             {
                $G.openUrl( 'edu_examset_list.jsp?id='+id);
             }
        }else
        {
              $G.openUrl( 'edu_examset_list.jsp?id='+id);
        }
        
        $G.enableItemFunction();
        
    } ,
    
    openUrl:function (url)
    {
        Ext.get('main').dom.src =url; 
    } , 
        
    /**
     * 注意是异步取完整路径
     */
   refreshFullPath:function (id)
   {
        $rpc( 'educ.exam.ExamSet', 'getPath' , 
                                   {
                                     'id'          :   $G.currentTreeId 
                                   },
                                   function( ret)
                                   {
                                       var  data=  JSON.parse(ret);
                                       $('#fullpath').html( data.path);                                    
                                   }
                 ) ;                   
    
   },
        
        
    nothing:null   // 无用的变量  
         
} ;

Ext.onReady ( $G.init ); 

